/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.support.transition.TransitionImpl;
import android.support.transition.TransitionInterface;
import android.support.transition.TransitionInterfaceListener;
import android.support.transition.TransitionPort;
import android.support.transition.TransitionValues;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

class TransitionIcs
extends TransitionImpl {
    TransitionPort mTransition;
    TransitionInterface mExternalTransition;
    private CompatListener mCompatListener;

    TransitionIcs() {
    }

    @Override
    public void init(TransitionInterface external, Object internal) {
        this.mExternalTransition = external;
        this.mTransition = internal == null ? new TransitionWrapper(external) : (TransitionPort)internal;
    }

    @Override
    public TransitionImpl addListener(TransitionInterfaceListener listener) {
        if (this.mCompatListener == null) {
            this.mCompatListener = new CompatListener();
            this.mTransition.addListener(this.mCompatListener);
        }
        this.mCompatListener.addListener(listener);
        return this;
    }

    @Override
    public TransitionImpl removeListener(TransitionInterfaceListener listener) {
        if (this.mCompatListener == null) {
            return this;
        }
        this.mCompatListener.removeListener(listener);
        if (this.mCompatListener.isEmpty()) {
            this.mTransition.removeListener(this.mCompatListener);
            this.mCompatListener = null;
        }
        return this;
    }

    @Override
    public TransitionImpl addTarget(View target) {
        this.mTransition.addTarget(target);
        return this;
    }

    @Override
    public TransitionImpl addTarget(int targetId) {
        this.mTransition.addTarget(targetId);
        return this;
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.mTransition.captureEndValues(transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.mTransition.captureStartValues(transitionValues);
    }

    @Override
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        return this.mTransition.createAnimator(sceneRoot, startValues, endValues);
    }

    @Override
    public TransitionImpl excludeChildren(View target, boolean exclude) {
        this.mTransition.excludeChildren(target, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeChildren(int targetId, boolean exclude) {
        this.mTransition.excludeChildren(targetId, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeChildren(Class type, boolean exclude) {
        this.mTransition.excludeChildren(type, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeTarget(View target, boolean exclude) {
        this.mTransition.excludeTarget(target, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeTarget(int targetId, boolean exclude) {
        this.mTransition.excludeTarget(targetId, exclude);
        return this;
    }

    @Override
    public TransitionImpl excludeTarget(Class type, boolean exclude) {
        this.mTransition.excludeTarget(type, exclude);
        return this;
    }

    @Override
    public long getDuration() {
        return this.mTransition.getDuration();
    }

    @Override
    public TransitionImpl setDuration(long duration) {
        this.mTransition.setDuration(duration);
        return this;
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mTransition.getInterpolator();
    }

    @Override
    public TransitionImpl setInterpolator(TimeInterpolator interpolator) {
        this.mTransition.setInterpolator(interpolator);
        return this;
    }

    @Override
    public String getName() {
        return this.mTransition.getName();
    }

    @Override
    public long getStartDelay() {
        return this.mTransition.getStartDelay();
    }

    @Override
    public TransitionImpl setStartDelay(long startDelay) {
        this.mTransition.setStartDelay(startDelay);
        return this;
    }

    @Override
    public List<Integer> getTargetIds() {
        return this.mTransition.getTargetIds();
    }

    @Override
    public List<View> getTargets() {
        return this.mTransition.getTargets();
    }

    @Override
    public String[] getTransitionProperties() {
        return this.mTransition.getTransitionProperties();
    }

    @Override
    public TransitionValues getTransitionValues(View view, boolean start) {
        return this.mTransition.getTransitionValues(view, start);
    }

    @Override
    public TransitionImpl removeTarget(View target) {
        this.mTransition.removeTarget(target);
        return this;
    }

    @Override
    public TransitionImpl removeTarget(int targetId) {
        this.mTransition.removeTarget(targetId);
        return this;
    }

    public String toString() {
        return this.mTransition.toString();
    }

    private class CompatListener
    implements TransitionPort.TransitionListener {
        private final ArrayList<TransitionInterfaceListener> mListeners = new ArrayList();

        CompatListener() {
        }

        public void addListener(TransitionInterfaceListener listener) {
            this.mListeners.add(listener);
        }

        public void removeListener(TransitionInterfaceListener listener) {
            this.mListeners.remove(listener);
        }

        public boolean isEmpty() {
            return this.mListeners.isEmpty();
        }

        @Override
        public void onTransitionStart(TransitionPort transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionStart(TransitionIcs.this.mExternalTransition);
            }
        }

        @Override
        public void onTransitionEnd(TransitionPort transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionEnd(TransitionIcs.this.mExternalTransition);
            }
        }

        @Override
        public void onTransitionCancel(TransitionPort transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionCancel(TransitionIcs.this.mExternalTransition);
            }
        }

        @Override
        public void onTransitionPause(TransitionPort transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionPause(TransitionIcs.this.mExternalTransition);
            }
        }

        @Override
        public void onTransitionResume(TransitionPort transition) {
            for (TransitionInterfaceListener listener : this.mListeners) {
                listener.onTransitionResume(TransitionIcs.this.mExternalTransition);
            }
        }
    }

    private static class TransitionWrapper
    extends TransitionPort {
        private TransitionInterface mTransition;

        public TransitionWrapper(TransitionInterface transition) {
            this.mTransition = transition;
        }

        @Override
        public void captureStartValues(TransitionValues transitionValues) {
            this.mTransition.captureStartValues(transitionValues);
        }

        @Override
        public void captureEndValues(TransitionValues transitionValues) {
            this.mTransition.captureEndValues(transitionValues);
        }

        @Override
        public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
            return this.mTransition.createAnimator(sceneRoot, startValues, endValues);
        }
    }
}

