/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.TimeInterpolator;
import android.support.annotation.RestrictTo;
import android.support.transition.TransitionPort;
import android.support.transition.TransitionValues;
import android.support.transition.TransitionValuesMaps;
import android.util.AndroidRuntimeException;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

class TransitionSetPort
extends TransitionPort {
    public static final int ORDERING_TOGETHER = 0;
    public static final int ORDERING_SEQUENTIAL = 1;
    ArrayList<TransitionPort> mTransitions = new ArrayList();
    int mCurrentListeners;
    boolean mStarted = false;
    private boolean mPlayTogether = true;

    public int getOrdering() {
        return this.mPlayTogether ? 0 : 1;
    }

    public TransitionSetPort setOrdering(int ordering) {
        switch (ordering) {
            case 1: {
                this.mPlayTogether = false;
                break;
            }
            case 0: {
                this.mPlayTogether = true;
                break;
            }
            default: {
                throw new AndroidRuntimeException("Invalid parameter for TransitionSet ordering: " + ordering);
            }
        }
        return this;
    }

    public TransitionSetPort addTransition(TransitionPort transition) {
        if (transition != null) {
            this.mTransitions.add(transition);
            transition.mParent = this;
            if (this.mDuration >= 0L) {
                transition.setDuration(this.mDuration);
            }
        }
        return this;
    }

    @Override
    public TransitionSetPort setDuration(long duration) {
        super.setDuration(duration);
        if (this.mDuration >= 0L) {
            int numTransitions = this.mTransitions.size();
            for (int i = 0; i < numTransitions; ++i) {
                this.mTransitions.get(i).setDuration(duration);
            }
        }
        return this;
    }

    @Override
    public TransitionSetPort setStartDelay(long startDelay) {
        return (TransitionSetPort)super.setStartDelay(startDelay);
    }

    @Override
    public TransitionSetPort setInterpolator(TimeInterpolator interpolator) {
        return (TransitionSetPort)super.setInterpolator(interpolator);
    }

    @Override
    public TransitionSetPort addTarget(View target) {
        return (TransitionSetPort)super.addTarget(target);
    }

    @Override
    public TransitionSetPort addTarget(int targetId) {
        return (TransitionSetPort)super.addTarget(targetId);
    }

    @Override
    public TransitionSetPort addListener(TransitionPort.TransitionListener listener) {
        return (TransitionSetPort)super.addListener(listener);
    }

    @Override
    public TransitionSetPort removeTarget(int targetId) {
        return (TransitionSetPort)super.removeTarget(targetId);
    }

    @Override
    public TransitionSetPort removeTarget(View target) {
        return (TransitionSetPort)super.removeTarget(target);
    }

    @Override
    public TransitionSetPort removeListener(TransitionPort.TransitionListener listener) {
        return (TransitionSetPort)super.removeListener(listener);
    }

    public TransitionSetPort removeTransition(TransitionPort transition) {
        this.mTransitions.remove(transition);
        transition.mParent = null;
        return this;
    }

    private void setupStartEndListeners() {
        TransitionSetListener listener = new TransitionSetListener(this);
        for (TransitionPort childTransition : this.mTransitions) {
            childTransition.addListener(listener);
        }
        this.mCurrentListeners = this.mTransitions.size();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    protected void createAnimators(ViewGroup sceneRoot, TransitionValuesMaps startValues, TransitionValuesMaps endValues) {
        for (TransitionPort childTransition : this.mTransitions) {
            childTransition.createAnimators(sceneRoot, startValues, endValues);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    protected void runAnimators() {
        if (this.mTransitions.isEmpty()) {
            this.start();
            this.end();
            return;
        }
        this.setupStartEndListeners();
        if (!this.mPlayTogether) {
            for (int i = 1; i < this.mTransitions.size(); ++i) {
                TransitionPort previousTransition = this.mTransitions.get(i - 1);
                final TransitionPort nextTransition = this.mTransitions.get(i);
                previousTransition.addListener(new TransitionPort.TransitionListenerAdapter(){

                    @Override
                    public void onTransitionEnd(TransitionPort transition) {
                        nextTransition.runAnimators();
                        transition.removeListener(this);
                    }
                });
            }
            TransitionPort firstTransition = this.mTransitions.get(0);
            if (firstTransition != null) {
                firstTransition.runAnimators();
            }
        } else {
            for (TransitionPort childTransition : this.mTransitions) {
                childTransition.runAnimators();
            }
        }
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        int targetId = transitionValues.view.getId();
        if (this.isValidTarget(transitionValues.view, targetId)) {
            for (TransitionPort childTransition : this.mTransitions) {
                if (!childTransition.isValidTarget(transitionValues.view, targetId)) continue;
                childTransition.captureStartValues(transitionValues);
            }
        }
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        int targetId = transitionValues.view.getId();
        if (this.isValidTarget(transitionValues.view, targetId)) {
            for (TransitionPort childTransition : this.mTransitions) {
                if (!childTransition.isValidTarget(transitionValues.view, targetId)) continue;
                childTransition.captureEndValues(transitionValues);
            }
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public void pause(View sceneRoot) {
        super.pause(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).pause(sceneRoot);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    public void resume(View sceneRoot) {
        super.resume(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).resume(sceneRoot);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.GROUP_ID})
    protected void cancel() {
        super.cancel();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).cancel();
        }
    }

    @Override
    TransitionSetPort setSceneRoot(ViewGroup sceneRoot) {
        super.setSceneRoot(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setSceneRoot(sceneRoot);
        }
        return this;
    }

    @Override
    void setCanRemoveViews(boolean canRemoveViews) {
        super.setCanRemoveViews(canRemoveViews);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setCanRemoveViews(canRemoveViews);
        }
    }

    @Override
    String toString(String indent) {
        String result = super.toString(indent);
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            result = result + "\n" + this.mTransitions.get(i).toString(indent + "  ");
        }
        return result;
    }

    @Override
    public TransitionSetPort clone() {
        TransitionSetPort clone = (TransitionSetPort)super.clone();
        clone.mTransitions = new ArrayList();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            clone.addTransition(this.mTransitions.get(i).clone());
        }
        return clone;
    }

    static class TransitionSetListener
    extends TransitionPort.TransitionListenerAdapter {
        TransitionSetPort mTransitionSet;

        TransitionSetListener(TransitionSetPort transitionSet) {
            this.mTransitionSet = transitionSet;
        }

        @Override
        public void onTransitionStart(TransitionPort transition) {
            if (!this.mTransitionSet.mStarted) {
                this.mTransitionSet.start();
                this.mTransitionSet.mStarted = true;
            }
        }

        @Override
        public void onTransitionEnd(TransitionPort transition) {
            --this.mTransitionSet.mCurrentListeners;
            if (this.mTransitionSet.mCurrentListeners == 0) {
                this.mTransitionSet.mStarted = false;
                this.mTransitionSet.end();
            }
            transition.removeListener(this);
        }
    }
}

