/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.animation.ObjectAnimator;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.support.annotation.RequiresApi;
import android.support.transition.ObjectAnimatorUtilsImpl;
import android.util.Property;

@RequiresApi(value=14)
class ObjectAnimatorUtilsApi14
implements ObjectAnimatorUtilsImpl {
    ObjectAnimatorUtilsApi14() {
    }

    @Override
    public <T> ObjectAnimator ofInt(T target, String xPropertyName, String yPropertyName, Path path) {
        Class<?> hostType = target.getClass();
        Property px = Property.of(hostType, Integer.class, (String)xPropertyName);
        Property py = Property.of(hostType, Integer.class, (String)yPropertyName);
        return ObjectAnimator.ofFloat(target, new PathProperty(new CastIntegerProperty(px), new CastIntegerProperty(py), path), (float[])new float[]{0.0f, 1.0f});
    }

    @Override
    public <T> ObjectAnimator ofInt(T target, Property<T, Integer> xProperty, Property<T, Integer> yProperty, Path path) {
        return ObjectAnimator.ofFloat(target, new PathProperty(new CastIntegerProperty<T>(xProperty), new CastIntegerProperty<T>(yProperty), path), (float[])new float[]{0.0f, 1.0f});
    }

    @Override
    public <T> ObjectAnimator ofFloat(T target, Property<T, Float> xProperty, Property<T, Float> yProperty, Path path) {
        return ObjectAnimator.ofFloat(target, new PathProperty<T>(xProperty, yProperty, path), (float[])new float[0]);
    }

    private static class PathProperty<T>
    extends Property<T, Float> {
        private final PathMeasure mPathMeasure;
        private final float mPathLength;
        private final float[] mPosition = new float[2];
        private final Property<T, Float> mXProperty;
        private final Property<T, Float> mYProperty;
        private float mCurrentFraction;

        PathProperty(Property<T, Float> xProperty, Property<T, Float> yProperty, Path path) {
            super(Float.class, xProperty.getName() + "/" + yProperty.getName());
            this.mXProperty = xProperty;
            this.mYProperty = yProperty;
            this.mPathMeasure = new PathMeasure(path, false);
            this.mPathLength = this.mPathMeasure.getLength();
        }

        public Float get(T t) {
            return Float.valueOf(this.mCurrentFraction);
        }

        public void set(T view, Float fraction) {
            this.mCurrentFraction = fraction.floatValue();
            this.mPathMeasure.getPosTan(this.mPathLength * fraction.floatValue(), this.mPosition, null);
            this.mXProperty.set(view, (Object)Float.valueOf(this.mPosition[0]));
            this.mYProperty.set(view, (Object)Float.valueOf(this.mPosition[1]));
        }
    }

    private static class CastIntegerProperty<T>
    extends Property<T, Float> {
        private final Property<T, Integer> mProperty;

        CastIntegerProperty(Property<T, Integer> property) {
            super(Float.class, property.getName());
            this.mProperty = property;
        }

        public Float get(T object) {
            return Float.valueOf(((Integer)this.mProperty.get(object)).intValue());
        }

        public void set(T object, Float value) {
            this.mProperty.set(object, (Object)Math.round(value.floatValue()));
        }
    }
}

