/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics.crash;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public abstract class CrashReport {
    private final String productId;
    private final String version;
    private final Map<String, String> productData;
    private final String type;

    public CrashReport(String productId, String version, Map<String, String> productData, String type) {
        this.productId = productId;
        this.version = version;
        this.productData = productData;
        this.type = type;
    }

    public void serialize(MultipartEntityBuilder builder) {
        builder.addTextBody("type", this.type);
        if (this.productData != null) {
            this.productData.forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)builder).addTextBody(arg_0, arg_1));
        }
        this.serializeTo(builder);
    }

    public String getProductId() {
        return this.productId;
    }

    public String getVersion() {
        return this.version;
    }

    protected abstract void serializeTo(MultipartEntityBuilder var1);

    protected void overrideDefaultParameters(Map<String, String> parameters) {
    }

    public static abstract class BaseBuilder<T extends CrashReport, B extends BaseBuilder> {
        private String productId;
        private String version;
        private Map<String, String> productData;

        public B setProduct(String productId) {
            this.productId = productId;
            return this.getThis();
        }

        public B setVersion(String version) {
            this.version = version;
            return this.getThis();
        }

        public B addProductData(Map<String, String> kv) {
            if (this.productData == null) {
                this.productData = new HashMap<String, String>();
            }
            this.productData.putAll(kv);
            return this.getThis();
        }

        protected String getProductId() {
            return this.productId;
        }

        protected String getVersion() {
            return this.version;
        }

        protected Map<String, String> getProductData() {
            return this.productData;
        }

        protected abstract B getThis();

        public abstract T build();
    }
}

