/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettingsData;
import com.android.tools.analytics.WebServerDateProvider;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u00106\u001a\u00020\"H\u0003J\b\u00107\u001a\u00020\u0007H\u0007J\b\u00108\u001a\u000209H\u0002J\u001c\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020<2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010>H\u0007J\u0015\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\"H\u0000\u00a2\u0006\u0002\bAJ\u0010\u0010B\u001a\u00020\"2\u0006\u0010;\u001a\u00020<H\u0003J\b\u0010C\u001a\u000209H\u0007J\u0012\u0010D\u001a\u0002092\b\u0010@\u001a\u0004\u0018\u00010\"H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b#\u0010\u0002R*\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00108F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b&\u0010\u0002\u001a\u0004\b'\u0010\u0013\"\u0004\b(\u0010 R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u0002028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b3\u0010\u0002\u001a\u0004\b4\u00105\u00a8\u0006E"}, d2={"Lcom/android/tools/analytics/AnalyticsSettings;", "", "()V", "EPOCH", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "SALT_SKEW_NOT_INITIALIZED", "", "dateProvider", "Lcom/android/utils/DateProvider;", "dateProvider$annotations", "getDateProvider", "()Lcom/android/utils/DateProvider;", "setDateProvider", "(Lcom/android/utils/DateProvider;)V", "debugDisablePublishing", "", "debugDisablePublishing$annotations", "getDebugDisablePublishing", "()Z", "gate", "googlePlayDateProvider", "Lcom/android/tools/analytics/WebServerDateProvider;", "googlePlayDateProvider$annotations", "getGooglePlayDateProvider", "()Lcom/android/tools/analytics/WebServerDateProvider;", "setGooglePlayDateProvider", "(Lcom/android/tools/analytics/WebServerDateProvider;)V", "<set-?>", "initialized", "getInitialized", "setInitialized", "(Z)V", "instance", "Lcom/android/tools/analytics/AnalyticsSettingsData;", "instance$annotations", "value", "optedIn", "optedIn$annotations", "getOptedIn", "setOptedIn", "salt", "", "getSalt", "()[B", "settingsFile", "Ljava/io/File;", "getSettingsFile$shared", "()Ljava/io/File;", "userId", "", "userId$annotations", "getUserId", "()Ljava/lang/String;", "createNewAnalyticsSettingsData", "currentSaltSkew", "ensureInitialized", "", "initialize", "logger", "Lcom/android/utils/ILogger;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "isValid", "settings", "isValid$shared", "loadSettingsData", "saveSettings", "setInstanceForTest", "shared"})
public final class AnalyticsSettings {
    private static boolean initialized;
    public static final int SALT_SKEW_NOT_INITIALIZED = -1;
    @NotNull
    private static DateProvider dateProvider;
    private static final LocalDate EPOCH;
    private static final Object gate;
    private static AnalyticsSettingsData instance;
    @Nullable
    private static WebServerDateProvider googlePlayDateProvider;
    public static final AnalyticsSettings INSTANCE;

    public final boolean getInitialized() {
        return initialized;
    }

    private final void setInitialized(boolean bl) {
        initialized = bl;
    }

    @JvmStatic
    public static /* synthetic */ void userId$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String getUserId() {
        Object object = gate;
        synchronized (object) {
            INSTANCE.ensureInitialized();
            Object object2 = instance;
            if (object2 == null || (object2 = ((AnalyticsSettingsData)object2).getUserId()) == null) {
                object2 = "";
            }
            Object object3 = object2;
            return object3;
        }
    }

    @JvmStatic
    public static /* synthetic */ void optedIn$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean getOptedIn() {
        Object object = gate;
        synchronized (object) {
            INSTANCE.ensureInitialized();
            AnalyticsSettingsData analyticsSettingsData = instance;
            boolean bl = analyticsSettingsData != null ? analyticsSettingsData.getOptedIn() : false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setOptedIn(boolean value) {
        Object object = gate;
        synchronized (object) {
            AnalyticsSettingsData analyticsSettingsData;
            AnalyticsSettingsData analyticsSettingsData2 = instance;
            if (analyticsSettingsData2 != null) {
                AnalyticsSettingsData analyticsSettingsData3;
                AnalyticsSettingsData $receiver = analyticsSettingsData3 = analyticsSettingsData2;
                $receiver.setOptedIn(value);
                analyticsSettingsData = analyticsSettingsData3;
            } else {
                analyticsSettingsData = null;
            }
            AnalyticsSettingsData analyticsSettingsData4 = analyticsSettingsData;
        }
    }

    private final void ensureInitialized() {
        if (!initialized && Boolean.getBoolean("idea.is.internal")) {
            throw (Throwable)new RuntimeException("call to AnalyticsSettings before initialization");
        }
    }

    @JvmStatic
    public static /* synthetic */ void debugDisablePublishing$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean getDebugDisablePublishing() {
        Object object = gate;
        synchronized (object) {
            INSTANCE.ensureInitialized();
            AnalyticsSettingsData analyticsSettingsData = instance;
            boolean bl = analyticsSettingsData != null ? analyticsSettingsData.getDebugDisablePublishing() : false;
            return bl;
        }
    }

    @JvmStatic
    public static /* synthetic */ void dateProvider$annotations() {
    }

    @NotNull
    public static final DateProvider getDateProvider() {
        return dateProvider;
    }

    public static final void setDateProvider(@NotNull DateProvider dateProvider) {
        Intrinsics.checkParameterIsNotNull((Object)dateProvider, (String)"<set-?>");
        AnalyticsSettings.dateProvider = dateProvider;
    }

    @JvmStatic
    private static /* synthetic */ void instance$annotations() {
    }

    @JvmStatic
    public static final int currentSaltSkew() {
        Date date = dateProvider.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"dateProvider.now()");
        LocalDate now = LocalDate.from(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        long days = ChronoUnit.DAYS.between(EPOCH, now) + (long)3;
        return (int)(days / (long)28);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final AnalyticsSettingsData loadSettingsData(ILogger logger) throws IOException {
        File file = INSTANCE.getSettingsFile$shared();
        if (!file.exists()) {
            return AnalyticsSettings.createNewAnalyticsSettingsData();
        }
        FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
        try {
            AnalyticsSettingsData settings = null;
            AutoCloseable autoCloseable = channel.tryLock();
            Throwable throwable = null;
            try {
                FileLock it = (FileLock)autoCloseable;
                InputStream inputStream = Channels.newInputStream(channel);
                Gson gson = new GsonBuilder().create();
                Object object = gson.fromJson((Reader)new InputStreamReader(inputStream), AnalyticsSettingsData.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(InputStrea\u2026SettingsData::class.java)");
                settings = (AnalyticsSettingsData)object;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            AnalyticsSettingsData analyticsSettingsData = settings;
            if (analyticsSettingsData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (!INSTANCE.isValid$shared(analyticsSettingsData)) {
                return AnalyticsSettings.createNewAnalyticsSettingsData();
            }
            return settings;
        }
        catch (OverlappingFileLockException e) {
            logger.error((Throwable)e, "Unable to lock settings file %s", new Object[]{file.toString()});
        }
        catch (JsonParseException e) {
            logger.error((Throwable)e, "Unable to parse settings file %s", new Object[]{file.toString()});
        }
        AnalyticsSettingsData newSettings = new AnalyticsSettingsData();
        newSettings.setUserId(UUID.randomUUID().toString());
        return newSettings;
    }

    @JvmStatic
    private static final AnalyticsSettingsData createNewAnalyticsSettingsData() throws IOException {
        AnalyticsSettingsData settings = new AnalyticsSettingsData();
        File uidFile = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), "uid.txt").toFile();
        if (uidFile.exists()) {
            try {
                String uid = Files.readFirstLine((File)uidFile, (Charset)Charsets.UTF_8);
                settings.setUserId(uid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (settings.getUserId() == null) {
            settings.setUserId(UUID.randomUUID().toString());
        }
        settings.saveSettings();
        return settings;
    }

    @JvmStatic
    public static /* synthetic */ void googlePlayDateProvider$annotations() {
    }

    @Nullable
    public static final WebServerDateProvider getGooglePlayDateProvider() {
        return googlePlayDateProvider;
    }

    public static final void setGooglePlayDateProvider(@Nullable WebServerDateProvider webServerDateProvider) {
        googlePlayDateProvider = webServerDateProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull ILogger logger, @Nullable ScheduledExecutorService scheduler) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Object object = gate;
            synchronized (object) {
                if (instance != null) {
                    return;
                }
                initialized = true;
                instance = AnalyticsSettings.loadSettingsData(logger);
                Unit unit = Unit.INSTANCE;
            }
            ScheduledExecutorService scheduledExecutorService = scheduler;
            if (scheduledExecutorService == null) break block4;
            scheduledExecutorService.submit(new Runnable(logger){
                final /* synthetic */ ILogger $logger;

                public final void run() {
                    try {
                        WebServerDateProvider gp = new WebServerDateProvider(new URL("https://play.google.com/"));
                        AnalyticsSettings.setDateProvider(gp);
                        AnalyticsSettings.setGooglePlayDateProvider(gp);
                    }
                    catch (IOException e) {
                        this.$logger.error((Throwable)e, "Unable to get current time from Google's servers", new Object[0]);
                    }
                }
                {
                    this.$logger = iLogger;
                }
            });
        }
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void initialize$default(ILogger iLogger, ScheduledExecutorService scheduledExecutorService, int n, Object object) {
        if ((n & 2) != 0) {
            scheduledExecutorService = null;
        }
        AnalyticsSettings.initialize(iLogger, scheduledExecutorService);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initialize(@NotNull ILogger logger) {
        AnalyticsSettings.initialize$default(logger, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void setInstanceForTest(@Nullable AnalyticsSettingsData settings) {
        Object object = gate;
        synchronized (object) {
            instance = settings;
            initialized = instance != null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final File getSettingsFile$shared() {
        File file = Paths.get(AnalyticsPaths.getAndEnsureAndroidSettingsHome(), "analytics.settings").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Paths.get(AnalyticsPaths\u2026ytics.settings\").toFile()");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getSalt() throws IOException {
        Object object = gate;
        synchronized (object) {
            byte[] blob;
            AnalyticsSettingsData analyticsSettingsData;
            block6: {
                if (instance != null) break block6;
                byte[] byArray = new byte[]{};
                return byArray;
            }
            AnalyticsSettingsData data = analyticsSettingsData;
            int currentSaltSkew = AnalyticsSettings.currentSaltSkew();
            if (data.getSaltSkew() != currentSaltSkew) {
                data.setSaltSkew(currentSaltSkew);
                SecureRandom random = new SecureRandom();
                byte[] blob2 = new byte[24];
                random.nextBytes(blob2);
                data.setSaltValue(new BigInteger(blob2));
                AnalyticsSettings.saveSettings();
            }
            byte[] fullBlob = blob = data.getSaltValue().toByteArray();
            if (blob.length < 24) {
                fullBlob = new byte[24];
                System.arraycopy(blob, 0, fullBlob, 0, blob.length);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)fullBlob, (String)"fullBlob");
            byte[] byArray = fullBlob;
            return byArray;
        }
    }

    @JvmStatic
    public static final void saveSettings() throws IOException {
        block0: {
            INSTANCE.ensureInitialized();
            AnalyticsSettingsData analyticsSettingsData = instance;
            if (analyticsSettingsData == null) break block0;
            analyticsSettingsData.saveSettings();
        }
    }

    public final boolean isValid$shared(@NotNull AnalyticsSettingsData settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return settings.getUserId() != null && (settings.getSaltSkew() == -1 || settings.getSaltValue() != null);
    }

    private AnalyticsSettings() {
    }

    static {
        AnalyticsSettings analyticsSettings;
        INSTANCE = analyticsSettings = new AnalyticsSettings();
        DateProvider dateProvider = DateProvider.SYSTEM;
        Intrinsics.checkExpressionValueIsNotNull((Object)dateProvider, (String)"DateProvider.SYSTEM");
        AnalyticsSettings.dateProvider = dateProvider;
        EPOCH = LocalDate.ofEpochDay(0L);
        gate = new Object();
    }
}

