/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.Environment;
import com.android.tools.analytics.HostData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.GarbageCollectionStats;
import com.google.wireless.android.sdk.stats.JavaProcessStats;
import com.google.wireless.android.sdk.stats.JvmDetails;
import com.google.wireless.android.sdk.stats.ProductDetails;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001DB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010;\u001a\u00020%2\b\u0010<\u001a\u0004\u0018\u00010\u000eH\u0007J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020AH\u0003J\u0010\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0\u001a8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u0002\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010\u0002\u001a\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b/\u0010\u0002\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u00020%8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b3\u0010\u0002\u001a\u0004\b4\u0010(R\u001a\u00105\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b6\u0010\u0002\u001a\u0004\b7\u00101\u00a8\u0006E"}, d2={"Lcom/android/tools/analytics/CommonMetricsData;", "", "()V", "EMPTY_SIZE", "", "GIGABYTE", "", "INVALID_NUMBER", "INVALID_POSTFIX", "KILOBYTE", "MEGABYTE", "NO_DIGITS", "TERABYTE", "VM_OPTION_MAX_PERM_SIZE", "", "VM_OPTION_RESERVED_CODE_CACHE_SIZE", "VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB", "VM_OPTION_XMS", "VM_OPTION_XMX", "garbageCollectionStats", "", "Lcom/google/wireless/android/sdk/stats/GarbageCollectionStats;", "garbageCollectionStats$annotations", "getGarbageCollectionStats", "()Ljava/util/List;", "garbageCollectionStatsCache", "Ljava/util/HashMap;", "Lcom/android/tools/analytics/CommonMetricsData$GarbageCollectionStatsDiffs;", "garbageCollectionStatsCache$annotations", "getGarbageCollectionStatsCache", "()Ljava/util/HashMap;", "javaProcessStats", "Lcom/google/wireless/android/sdk/stats/JavaProcessStats;", "javaProcessStats$annotations", "getJavaProcessStats", "()Lcom/google/wireless/android/sdk/stats/JavaProcessStats;", "jvmArchitecture", "Lcom/google/wireless/android/sdk/stats/ProductDetails$CpuArchitecture;", "jvmArchitecture$annotations", "getJvmArchitecture", "()Lcom/google/wireless/android/sdk/stats/ProductDetails$CpuArchitecture;", "jvmDetails", "Lcom/google/wireless/android/sdk/stats/JvmDetails;", "jvmDetails$annotations", "getJvmDetails", "()Lcom/google/wireless/android/sdk/stats/JvmDetails;", "majorOsVersion", "majorOsVersion$annotations", "getMajorOsVersion", "()Ljava/lang/String;", "osArchitecture", "osArchitecture$annotations", "getOsArchitecture", "osName", "osName$annotations", "getOsName", "applicationBinaryInterfaceFromString", "Lcom/google/wireless/android/sdk/stats/DeviceInfo$ApplicationBinaryInterface;", "value", "cpuArchitectureFromString", "cpuArchitecture", "parseVmOption", "", "vmOption", "builder", "Lcom/google/wireless/android/sdk/stats/JvmDetails$Builder;", "parseVmOptionSize", "vmOptionSize", "GarbageCollectionStatsDiffs", "shared"})
public final class CommonMetricsData {
    @NotNull
    public static final String VM_OPTION_XMS = "-Xms";
    @NotNull
    public static final String VM_OPTION_XMX = "-Xmx";
    @NotNull
    public static final String VM_OPTION_MAX_PERM_SIZE = "-XX:MaxPermSize=";
    @NotNull
    public static final String VM_OPTION_RESERVED_CODE_CACHE_SIZE = "-XX:ReservedCodeCacheSize=";
    @NotNull
    public static final String VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB = "-XX:SoftRefLRUPolicyMSPerMB=";
    public static final long KILOBYTE = 1024L;
    public static final long MEGABYTE = 0x100000L;
    public static final long GIGABYTE = 0x40000000L;
    public static final long TERABYTE = 0x10000000000L;
    public static final int NO_DIGITS = -1;
    public static final int INVALID_POSTFIX = -2;
    public static final int INVALID_NUMBER = -3;
    public static final int EMPTY_SIZE = -4;
    @NotNull
    private static final HashMap<String, GarbageCollectionStatsDiffs> garbageCollectionStatsCache;
    public static final CommonMetricsData INSTANCE;

    @VisibleForTesting
    @JvmStatic
    public static /* synthetic */ void garbageCollectionStatsCache$annotations() {
    }

    @NotNull
    public static final HashMap<String, GarbageCollectionStatsDiffs> getGarbageCollectionStatsCache() {
        return garbageCollectionStatsCache;
    }

    @JvmStatic
    public static /* synthetic */ void osArchitecture$annotations() {
    }

    @NotNull
    public static final ProductDetails.CpuArchitecture getOsArchitecture() {
        ProductDetails.CpuArchitecture jvmArchitecture = CommonMetricsData.getJvmArchitecture();
        if (jvmArchitecture == ProductDetails.CpuArchitecture.X86) {
            String string;
            String string2 = System.getProperty("os.name");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.getProperty(\"os.name\")");
            String string3 = string = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            String os = string4;
            if (StringsKt.startsWith$default((String)os, (String)"win", (boolean)false, (int)2, null)) {
                String w6432 = Environment.Companion.getInstance().getVariable("PROCESSOR_ARCHITEW6432");
                if (w6432 != null && StringsKt.contains$default((CharSequence)w6432, (CharSequence)"64", (boolean)false, (int)2, null)) {
                    return ProductDetails.CpuArchitecture.X86_64;
                }
            } else if (StringsKt.startsWith$default((String)os, (String)"linux", (boolean)false, (int)2, null)) {
                String s = Environment.Companion.getInstance().getVariable("HOSTTYPE");
                return CommonMetricsData.cpuArchitectureFromString(s);
            }
        }
        return jvmArchitecture;
    }

    @JvmStatic
    public static /* synthetic */ void jvmArchitecture$annotations() {
    }

    @NotNull
    public static final ProductDetails.CpuArchitecture getJvmArchitecture() {
        String arch = System.getProperty("os.arch");
        return CommonMetricsData.cpuArchitectureFromString(arch);
    }

    @JvmStatic
    public static /* synthetic */ void osName$annotations() {
    }

    @NotNull
    public static final String getOsName() {
        CharSequence charSequence;
        String os = System.getProperty("os.name");
        if (os == null || (charSequence = (CharSequence)os).length() == 0) {
            return "unknown";
        }
        String string = os;
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        String string2 = string.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        String osLower = string2;
        if (StringsKt.startsWith$default((String)osLower, (String)"mac", (boolean)false, (int)2, null)) {
            os = "macosx";
        } else if (StringsKt.startsWith$default((String)osLower, (String)"win", (boolean)false, (int)2, null)) {
            os = "windows";
        } else if (StringsKt.startsWith$default((String)osLower, (String)"linux", (boolean)false, (int)2, null)) {
            os = "linux";
        } else if (os.length() > 32) {
            string = os;
            int n = 0;
            int n2 = 32;
            String string3 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            os = string3;
        }
        return os;
    }

    @JvmStatic
    public static /* synthetic */ void majorOsVersion$annotations() {
    }

    @Nullable
    public static final String getMajorOsVersion() {
        Matcher m;
        CharSequence charSequence;
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        String osVers = System.getProperty("os.version");
        if (osVers != null && (charSequence = (CharSequence)osVers).length() > 0 && (m = p.matcher(osVers)).matches()) {
            return m.group(1) + '.' + m.group(2);
        }
        return null;
    }

    @JvmStatic
    public static /* synthetic */ void jvmDetails$annotations() {
    }

    @NotNull
    public static final JvmDetails getJvmDetails() {
        RuntimeMXBean runtimeMXBean = HostData.getRuntimeBean();
        if (runtimeMXBean == null) {
            Intrinsics.throwNpe();
        }
        RuntimeMXBean runtime = runtimeMXBean;
        JvmDetails.Builder builder = JvmDetails.newBuilder().setName(Strings.nullToEmpty((String)runtime.getVmName())).setVendor(Strings.nullToEmpty((String)runtime.getVmVendor())).setVersion(Strings.nullToEmpty((String)runtime.getVmVersion()));
        Iterator<String> iterator = runtime.getInputArguments().iterator();
        while (iterator.hasNext()) {
            String vmOption;
            String string = vmOption = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"vmOption");
            JvmDetails.Builder builder2 = builder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
            CommonMetricsData.parseVmOption(string, builder2);
        }
        JvmDetails jvmDetails = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmDetails, (String)"builder.build()");
        return jvmDetails;
    }

    @JvmStatic
    public static /* synthetic */ void javaProcessStats$annotations() {
    }

    @NotNull
    public static final JavaProcessStats getJavaProcessStats() {
        MemoryMXBean memoryMXBean = HostData.getMemoryBean();
        if (memoryMXBean == null) {
            Intrinsics.throwNpe();
        }
        MemoryMXBean memoryBean2 = memoryMXBean;
        ClassLoadingMXBean classLoadingMXBean = HostData.getClassLoadingBean();
        if (classLoadingMXBean == null) {
            Intrinsics.throwNpe();
        }
        ClassLoadingMXBean classLoadingBean2 = classLoadingMXBean;
        JavaProcessStats.Builder builder = JavaProcessStats.newBuilder();
        MemoryUsage memoryUsage = memoryBean2.getHeapMemoryUsage();
        Intrinsics.checkExpressionValueIsNotNull((Object)memoryUsage, (String)"memoryBean.heapMemoryUsage");
        JavaProcessStats.Builder builder2 = builder.setHeapMemoryUsage(memoryUsage.getUsed());
        MemoryUsage memoryUsage2 = memoryBean2.getNonHeapMemoryUsage();
        Intrinsics.checkExpressionValueIsNotNull((Object)memoryUsage2, (String)"memoryBean.nonHeapMemoryUsage");
        JavaProcessStats.Builder builder3 = builder2.setNonHeapMemoryUsage(memoryUsage2.getUsed()).setLoadedClassCount(classLoadingBean2.getLoadedClassCount()).addAllGarbageCollectionStats((Iterable)CommonMetricsData.getGarbageCollectionStats());
        ThreadMXBean threadMXBean = HostData.getThreadBean();
        if (threadMXBean == null) {
            Intrinsics.throwNpe();
        }
        JavaProcessStats javaProcessStats = builder3.setThreadCount(threadMXBean.getThreadCount()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaProcessStats, (String)"JavaProcessStats.newBuil\u2026adCount)\n        .build()");
        return javaProcessStats;
    }

    @JvmStatic
    @VisibleForTesting
    public static /* synthetic */ void garbageCollectionStats$annotations() {
    }

    @NotNull
    public static final List<GarbageCollectionStats> getGarbageCollectionStats() {
        ArrayList<GarbageCollectionStats> stats = new ArrayList<GarbageCollectionStats>();
        List<GarbageCollectorMXBean> list = HostData.getGarbageCollectorBeans();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (GarbageCollectorMXBean gc : list) {
            String string;
            String name = gc.getName();
            GarbageCollectionStatsDiffs previous = garbageCollectionStatsCache.get(name);
            if (previous == null) {
                previous = new GarbageCollectionStatsDiffs();
            }
            GarbageCollectionStatsDiffs current = new GarbageCollectionStatsDiffs();
            current.setCollections(gc.getCollectionCount());
            long collectionsDiff = current.getCollections() - previous.getCollections();
            current.setTime(gc.getCollectionTime());
            long timeDiff = current.getTime() - previous.getTime();
            Map map = garbageCollectionStatsCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
            GarbageCollectionStatsDiffs garbageCollectionStatsDiffs = current;
            map.put(string, garbageCollectionStatsDiffs);
            stats.add(GarbageCollectionStats.newBuilder().setName(gc.getName()).setGcCollections(collectionsDiff).setGcTime(timeDiff).build());
        }
        return stats;
    }

    @JvmStatic
    @NotNull
    public static final ProductDetails.CpuArchitecture cpuArchitectureFromString(@Nullable String cpuArchitecture) {
        CharSequence charSequence;
        if (cpuArchitecture == null || (charSequence = (CharSequence)cpuArchitecture).length() == 0) {
            return ProductDetails.CpuArchitecture.UNKNOWN_CPU_ARCHITECTURE;
        }
        if (StringsKt.equals((String)cpuArchitecture, (String)"x86_64", (boolean)true) || StringsKt.equals((String)cpuArchitecture, (String)"ia64", (boolean)true) || StringsKt.equals((String)cpuArchitecture, (String)"amd64", (boolean)true)) {
            return ProductDetails.CpuArchitecture.X86_64;
        }
        if (StringsKt.equals((String)cpuArchitecture, (String)"x86", (boolean)true)) {
            return ProductDetails.CpuArchitecture.X86;
        }
        return cpuArchitecture.length() == 4 && cpuArchitecture.charAt(0) == 'i' && StringsKt.indexOf$default((CharSequence)cpuArchitecture, (String)"86", (int)0, (boolean)false, (int)6, null) == 2 ? ProductDetails.CpuArchitecture.X86 : ProductDetails.CpuArchitecture.UNKNOWN_CPU_ARCHITECTURE;
    }

    @JvmStatic
    @NotNull
    public static final DeviceInfo.ApplicationBinaryInterface applicationBinaryInterfaceFromString(@Nullable String value) {
        DeviceInfo.ApplicationBinaryInterface applicationBinaryInterface;
        if (value == null) {
            return DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
        }
        switch (value) {
            case "armeabi-v6j": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V6J;
                break;
            }
            case "armeabi-v6l": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V6L;
                break;
            }
            case "armeabi-v7a": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V7A;
                break;
            }
            case "armeabi": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARME_ABI;
                break;
            }
            case "arm64-v8a": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.ARM64_V8A_ABI;
                break;
            }
            case "mips": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.MIPS_ABI;
                break;
            }
            case "mips-r2": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.MIPS_R2_ABI;
                break;
            }
            case "x86": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.X86_ABI;
                break;
            }
            case "x86_64": {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.X86_64_ABI;
                break;
            }
            default: {
                applicationBinaryInterface = DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
            }
        }
        return applicationBinaryInterface;
    }

    @JvmStatic
    private static final void parseVmOption(String vmOption, JvmDetails.Builder builder) {
        String string;
        if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_XMS, (boolean)false, (int)2, null)) {
            string = vmOption;
            int n = VM_OPTION_XMS.length();
            JvmDetails.Builder builder2 = builder;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            builder2.setMinimumHeapSize(CommonMetricsData.parseVmOptionSize(string4));
        } else if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_XMX, (boolean)false, (int)2, null)) {
            string = vmOption;
            int n = VM_OPTION_XMX.length();
            JvmDetails.Builder builder3 = builder;
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String string7 = string6;
            builder3.setMaximumHeapSize(CommonMetricsData.parseVmOptionSize(string7));
        } else if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_MAX_PERM_SIZE, (boolean)false, (int)2, null)) {
            string = vmOption;
            int n = VM_OPTION_MAX_PERM_SIZE.length();
            JvmDetails.Builder builder4 = builder;
            String string8 = string;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            String string10 = string9;
            builder4.setMaximumPermanentSpaceSize(CommonMetricsData.parseVmOptionSize(string10));
        } else if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_RESERVED_CODE_CACHE_SIZE, (boolean)false, (int)2, null)) {
            string = vmOption;
            int n = VM_OPTION_RESERVED_CODE_CACHE_SIZE.length();
            JvmDetails.Builder builder5 = builder;
            String string11 = string;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
            String string13 = string12;
            builder5.setMaximumCodeCacheSize(CommonMetricsData.parseVmOptionSize(string13));
        } else if (StringsKt.startsWith$default((String)vmOption, (String)VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB, (boolean)false, (int)2, null)) {
            string = vmOption;
            int n = VM_OPTION_SOFT_REF_LRU_POLICY_MS_PER_MB.length();
            JvmDetails.Builder builder6 = builder;
            String string14 = string;
            if (string14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string15 = string14.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"(this as java.lang.String).substring(startIndex)");
            String string16 = string15;
            builder6.setSoftReferenceLruPolicy(CommonMetricsData.parseVmOptionSize(string16));
        }
        switch (vmOption) {
            case "-XX:+UseConcMarkSweepGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.CONCURRENT_MARK_SWEEP_GC);
                break;
            }
            case "-XX:+UseParallelGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.PARALLEL_GC);
                break;
            }
            case "-XX:+UseParallelOldGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.PARALLEL_OLD_GC);
                break;
            }
            case "-XX:+UseSerialGC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.SERIAL_GC);
                break;
            }
            case "-XX:+UseG1GC": {
                builder.setGarbageCollector(JvmDetails.GarbageCollector.SERIAL_GC);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @JvmStatic
    public static final long parseVmOptionSize(@NotNull String vmOptionSize) {
        Intrinsics.checkParameterIsNotNull((Object)vmOptionSize, (String)"vmOptionSize");
        if (Strings.isNullOrEmpty((String)vmOptionSize)) {
            return -4;
        }
        try {
            int n = 0;
            int n2 = vmOptionSize.length();
            while (n < n2) {
                void i;
                char c = vmOptionSize.charAt((int)i);
                if (!Character.isDigit(c)) {
                    long l;
                    if (i == false) {
                        return -1;
                    }
                    String string = vmOptionSize;
                    int n3 = 0;
                    String string2 = string.substring(n3, (int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String digits = string2;
                    long value = Long.parseLong(digits);
                    switch (c) {
                        case 'T': 
                        case 't': {
                            l = value * 0x10000000000L;
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            l = value * 0x40000000L;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            l = value * 0x100000L;
                            break;
                        }
                        case 'K': 
                        case 'k': {
                            l = value * 1024L;
                            break;
                        }
                        default: {
                            l = -2;
                        }
                    }
                    return l;
                }
                ++i;
            }
            return Long.parseLong(vmOptionSize);
        }
        catch (NumberFormatException e) {
            return -3;
        }
    }

    private CommonMetricsData() {
    }

    static {
        CommonMetricsData commonMetricsData;
        INSTANCE = commonMetricsData = new CommonMetricsData();
        garbageCollectionStatsCache = new HashMap();
    }

    @VisibleForTesting
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/android/tools/analytics/CommonMetricsData$GarbageCollectionStatsDiffs;", "", "()V", "collections", "", "getCollections", "()J", "setCollections", "(J)V", "time", "getTime", "setTime", "shared"})
    public static final class GarbageCollectionStatsDiffs {
        private volatile long collections;
        private volatile long time;

        public final long getCollections() {
            return this.collections;
        }

        public final void setCollections(long l) {
            this.collections = l;
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }
    }
}

