/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.JournalingUsageTracker;
import com.android.tools.analytics.NullUsageTracker;
import com.android.tools.analytics.UsageTrackerWriter;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010?\u001a\u00020@H\u0007J\u0010\u0010A\u001a\u0002092\u0006\u0010B\u001a\u00020CH\u0007J\u0010\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020FH\u0007J\u0018\u0010D\u001a\u00020@2\u0006\u0010G\u001a\u00020\"2\u0006\u0010E\u001a\u00020FH\u0007J\u0018\u0010'\u001a\u00020@2\u0006\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020JH\u0007J\u0010\u0010K\u001a\u0002092\u0006\u0010L\u001a\u000209H\u0007J \u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020\u00132\u0006\u0010O\u001a\u00020P2\u0006\u0010B\u001a\u00020CH\u0007R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R,\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"8\u0006@BX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b$\u0010\u0002\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010)\u001a\u00020*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010\u0002\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00100\u001a\u00020\"8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b1\u0010\u0002\u001a\u0004\b2\u0010&\"\u0004\b3\u0010(R&\u00104\u001a\u0004\u0018\u00010*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b5\u0010\u0002\u001a\u0004\b6\u0010-\"\u0004\b7\u0010/R\u0018\u00108\u001a\u0002098\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b:\u0010\u0002R\u001a\u0010;\u001a\u0002098GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b<\u0010\u0002\u001a\u0004\b=\u0010>\u00a8\u0006L"}, d2={"Lcom/android/tools/analytics/UsageTracker;", "", "()V", "dateProvider", "Lcom/android/utils/DateProvider;", "dateProvider$annotations", "getDateProvider", "()Lcom/android/utils/DateProvider;", "setDateProvider", "(Lcom/android/utils/DateProvider;)V", "gate", "ideBrand", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$IdeBrand;", "ideBrand$annotations", "getIdeBrand", "()Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$IdeBrand;", "setIdeBrand", "(Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$IdeBrand;)V", "ideaIsInternal", "", "ideaIsInternal$annotations", "getIdeaIsInternal", "()Z", "setIdeaIsInternal", "(Z)V", "isTesting", "maxJournalSize", "", "maxJournalSize$annotations", "getMaxJournalSize", "()I", "setMaxJournalSize", "(I)V", "<set-?>", "", "maxJournalTime", "maxJournalTime$annotations", "getMaxJournalTime", "()J", "setMaxJournalTime", "(J)V", "sessionId", "", "sessionId$annotations", "getSessionId", "()Ljava/lang/String;", "setSessionId", "(Ljava/lang/String;)V", "startTimeMs", "startTimeMs$annotations", "getStartTimeMs", "setStartTimeMs", "version", "version$annotations", "getVersion", "setVersion", "writer", "Lcom/android/tools/analytics/UsageTrackerWriter;", "writer$annotations", "writerForTest", "writerForTest$annotations", "getWriterForTest", "()Lcom/android/tools/analytics/UsageTrackerWriter;", "cleanAfterTesting", "", "initialize", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "log", "studioEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "eventTimeMs", "duration", "unit", "Ljava/util/concurrent/TimeUnit;", "setWriterForTest", "tracker", "updateSettingsAndTracker", "optIn", "logger", "Lcom/android/utils/ILogger;"})
public final class UsageTracker {
    private static final Object gate;
    @NotNull
    private static String sessionId;
    @NotNull
    private static DateProvider dateProvider;
    private static long startTimeMs;
    private static UsageTrackerWriter writer;
    private static boolean isTesting;
    private static int maxJournalSize;
    private static long maxJournalTime;
    @Nullable
    private static String version;
    private static boolean ideaIsInternal;
    @NotNull
    private static AndroidStudioEvent.IdeBrand ideBrand;
    public static final UsageTracker INSTANCE;

    @JvmStatic
    public static /* synthetic */ void sessionId$annotations() {
    }

    @NotNull
    public static final String getSessionId() {
        return sessionId;
    }

    public static final void setSessionId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        sessionId = string;
    }

    @JvmStatic
    public static /* synthetic */ void dateProvider$annotations() {
    }

    @NotNull
    public static final DateProvider getDateProvider() {
        return dateProvider;
    }

    public static final void setDateProvider(@NotNull DateProvider dateProvider) {
        Intrinsics.checkParameterIsNotNull((Object)dateProvider, (String)"<set-?>");
        UsageTracker.dateProvider = dateProvider;
    }

    @JvmStatic
    public static /* synthetic */ void startTimeMs$annotations() {
    }

    public static final long getStartTimeMs() {
        return startTimeMs;
    }

    public static final void setStartTimeMs(long l) {
        startTimeMs = l;
    }

    @JvmStatic
    private static /* synthetic */ void writer$annotations() {
    }

    @JvmStatic
    public static /* synthetic */ void maxJournalSize$annotations() {
    }

    public static final int getMaxJournalSize() {
        return maxJournalSize;
    }

    public static final void setMaxJournalSize(int n) {
        maxJournalSize = n;
    }

    @JvmStatic
    public static /* synthetic */ void maxJournalTime$annotations() {
    }

    public static final long getMaxJournalTime() {
        return maxJournalTime;
    }

    private static final void setMaxJournalTime(long l) {
        maxJournalTime = l;
    }

    @JvmStatic
    public static /* synthetic */ void version$annotations() {
    }

    @Nullable
    public static final String getVersion() {
        return version;
    }

    public static final void setVersion(@Nullable String string) {
        version = string;
    }

    @JvmStatic
    public static /* synthetic */ void ideaIsInternal$annotations() {
    }

    public static final boolean getIdeaIsInternal() {
        return ideaIsInternal;
    }

    public static final void setIdeaIsInternal(boolean bl) {
        ideaIsInternal = bl;
    }

    @JvmStatic
    public static /* synthetic */ void ideBrand$annotations() {
    }

    @NotNull
    public static final AndroidStudioEvent.IdeBrand getIdeBrand() {
        return ideBrand;
    }

    public static final void setIdeBrand(@NotNull AndroidStudioEvent.IdeBrand ideBrand) {
        Intrinsics.checkParameterIsNotNull((Object)ideBrand, (String)"<set-?>");
        UsageTracker.ideBrand = ideBrand;
    }

    @JvmStatic
    public static /* synthetic */ void writerForTest$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final UsageTrackerWriter getWriterForTest() {
        Object object = gate;
        synchronized (object) {
            UsageTrackerWriter usageTrackerWriter = writer;
            return usageTrackerWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void setMaxJournalTime(long duration, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Object object = gate;
        synchronized (object) {
            maxJournalTime = unit.toNanos(duration);
            writer.scheduleJournalTimeout(maxJournalTime);
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void log(@NotNull AndroidStudioEvent.Builder studioEvent) {
        Intrinsics.checkParameterIsNotNull((Object)studioEvent, (String)"studioEvent");
        Object object = gate;
        synchronized (object) {
            writer.logNow(studioEvent);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void log(long eventTimeMs, @NotNull AndroidStudioEvent.Builder studioEvent) {
        Intrinsics.checkParameterIsNotNull((Object)studioEvent, (String)"studioEvent");
        Object object = gate;
        synchronized (object) {
            writer.logAt(eventTimeMs, studioEvent);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @NotNull
    public static final UsageTrackerWriter initialize(@NotNull ScheduledExecutorService scheduler) {
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        Object object = gate;
        synchronized (object) {
            UsageTrackerWriter oldInstance = writer;
            if (AnalyticsSettings.getOptedIn()) {
                try {
                    Path path = Paths.get(AnalyticsPaths.getSpoolDirectory(), new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(AnalyticsPaths.spoolDirectory)");
                    writer = new JournalingUsageTracker(scheduler, path);
                }
                catch (RuntimeException ex) {
                    writer = NullUsageTracker.INSTANCE;
                    throw (Throwable)ex;
                }
            } else {
                writer = NullUsageTracker.INSTANCE;
            }
            try {
                oldInstance.close();
                return writer;
            }
            catch (Exception ex) {
                throw (Throwable)new RuntimeException("Unable to close usage tracker", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final UsageTrackerWriter setWriterForTest(@NotNull UsageTrackerWriter tracker) {
        Intrinsics.checkParameterIsNotNull((Object)tracker, (String)"tracker");
        Object object = gate;
        synchronized (object) {
            void var2_2;
            isTesting = true;
            UsageTrackerWriter old = writer;
            writer = tracker;
            Date date = dateProvider.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"dateProvider.now()");
            startTimeMs = date.getTime();
            void var4_3 = var2_2;
            return var4_3;
        }
    }

    @JvmStatic
    public static final void cleanAfterTesting() {
        isTesting = false;
        writer = NullUsageTracker.INSTANCE;
    }

    @JvmStatic
    public static final void updateSettingsAndTracker(boolean optIn, @NotNull ILogger logger, @NotNull ScheduledExecutorService scheduler) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        AnalyticsSettings.initialize((ILogger)logger);
        if (isTesting) {
            return;
        }
        if (optIn != AnalyticsSettings.getOptedIn()) {
            AnalyticsSettings.setOptedIn((boolean)optIn);
            try {
                AnalyticsSettings.INSTANCE.saveSettings();
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Unable to save analytics settings", new Object[0]);
            }
        }
        try {
            UsageTracker.initialize(scheduler);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to initialize analytics tracker", new Object[0]);
        }
    }

    private UsageTracker() {
    }

    static {
        UsageTracker usageTracker;
        INSTANCE = usageTracker = new UsageTracker();
        gate = new Object();
        sessionId = UUID.randomUUID().toString();
        DateProvider dateProvider = DateProvider.SYSTEM;
        Intrinsics.checkExpressionValueIsNotNull((Object)dateProvider, (String)"DateProvider.SYSTEM");
        UsageTracker.dateProvider = dateProvider;
        Date date = UsageTracker.dateProvider.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"dateProvider.now()");
        startTimeMs = date.getTime();
        writer = NullUsageTracker.INSTANCE;
        ideBrand = AndroidStudioEvent.IdeBrand.UNKNOWN_IDE_BRAND;
    }
}

