/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.utils.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001\u001dB#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J9\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J-\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0010\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/android/aaptcompiler/BlameLogger;", "Lcom/android/utils/ILogger;", "logger", "blameMap", "Lkotlin/Function1;", "Lcom/android/aaptcompiler/BlameLogger$Source;", "(Lcom/android/utils/ILogger;Lkotlin/jvm/functions/Function1;)V", "getBlameMap", "()Lkotlin/jvm/functions/Function1;", "getLogger", "()Lcom/android/utils/ILogger;", "error", "", "t", "", "msgFormat", "", "args", "", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "info", "(Ljava/lang/String;[Ljava/lang/Object;)V", "lifecycle", "quiet", "transformSources", "([Ljava/lang/Object;)[Ljava/lang/Object;", "verbose", "warning", "Source", "aaptcompiler"})
public final class BlameLogger
implements ILogger {
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Function1<Source, Source> blameMap;

    public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object[] objectArray = this.transformSources(args);
        this.logger.error(t, msgFormat, Arrays.copyOf(objectArray, objectArray.length));
    }

    public void warning(@NotNull String msgFormat, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)msgFormat, (String)"msgFormat");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object[] objectArray = this.transformSources(args);
        this.logger.warning(msgFormat, Arrays.copyOf(objectArray, objectArray.length));
    }

    public void info(@NotNull String msgFormat, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)msgFormat, (String)"msgFormat");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object[] objectArray = this.transformSources(args);
        this.logger.info(msgFormat, Arrays.copyOf(objectArray, objectArray.length));
    }

    public void lifecycle(@NotNull String msgFormat, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)msgFormat, (String)"msgFormat");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object[] objectArray = this.transformSources(args);
        this.logger.lifecycle(msgFormat, Arrays.copyOf(objectArray, objectArray.length));
    }

    public void quiet(@NotNull String msgFormat, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)msgFormat, (String)"msgFormat");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object[] objectArray = this.transformSources(args);
        this.logger.quiet(msgFormat, Arrays.copyOf(objectArray, objectArray.length));
    }

    public void verbose(@NotNull String msgFormat, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)msgFormat, (String)"msgFormat");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object[] objectArray = this.transformSources(args);
        this.logger.verbose(msgFormat, Arrays.copyOf(objectArray, objectArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] transformSources(Object[] args) {
        void $this$mapTo$iv$iv;
        Object[] $this$map$iv = args;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_14 = it instanceof Source ? this.blameMap.invoke((Object)it) : it;
            collection.add(var14_14);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
        if (objectArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray2;
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Function1<Source, Source> getBlameMap() {
        return this.blameMap;
    }

    public BlameLogger(@NotNull ILogger logger, @NotNull Function1<? super Source, Source> blameMap) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull(blameMap, (String)"blameMap");
        this.logger = logger;
        this.blameMap = blameMap;
    }

    public /* synthetic */ BlameLogger(ILogger iLogger, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(iLogger, (Function1<? super Source, Source>)function1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/android/aaptcompiler/BlameLogger$Source;", "", "file", "Ljava/io/File;", "line", "", "column", "(Ljava/io/File;II)V", "getColumn", "()I", "getFile", "()Ljava/io/File;", "getLine", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toSourceFilePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "toString", "", "Companion", "aaptcompiler"})
    public static final class Source {
        @NotNull
        private final File file;
        private final int line;
        private final int column;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String toString() {
            String result = this.file.getAbsolutePath();
            if (this.line != -1) {
                result = result + ':' + this.line;
                if (this.column != -1) {
                    result = result + ':' + this.column;
                }
            }
            String string = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result");
            return string;
        }

        @NotNull
        public final SourceFilePosition toSourceFilePosition() {
            return new SourceFilePosition(this.file, new SourcePosition(this.line, this.column, -1, this.line, this.column, -1));
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        public Source(@NotNull File file, int line, int column) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.file = file;
            this.line = line;
            this.column = column;
        }

        public /* synthetic */ Source(File file, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = -1;
            }
            if ((n3 & 4) != 0) {
                n2 = -1;
            }
            this(file, n, n2);
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        public final int component2() {
            return this.line;
        }

        public final int component3() {
            return this.column;
        }

        @NotNull
        public final Source copy(@NotNull File file, int line, int column) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return new Source(file, line, column);
        }

        public static /* synthetic */ Source copy$default(Source source, File file, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                file = source.file;
            }
            if ((n3 & 2) != 0) {
                n = source.line;
            }
            if ((n3 & 4) != 0) {
                n2 = source.column;
            }
            return source.copy(file, n, n2);
        }

        public int hashCode() {
            File file = this.file;
            return ((file != null ? ((Object)file).hashCode() : 0) * 31 + this.line) * 31 + this.column;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Source)) break block3;
                    Source source = (Source)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)source.file) || this.line != source.line || this.column != source.column) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/aaptcompiler/BlameLogger$Source$Companion;", "", "()V", "fromSourceFilePosition", "Lcom/android/aaptcompiler/BlameLogger$Source;", "filePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "aaptcompiler"})
        public static final class Companion {
            @NotNull
            public final Source fromSourceFilePosition(@NotNull SourceFilePosition filePosition) {
                Intrinsics.checkParameterIsNotNull((Object)filePosition, (String)"filePosition");
                SourceFile sourceFile = filePosition.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFile, (String)"filePosition.file");
                File file = sourceFile.getSourceFile();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                SourcePosition sourcePosition = filePosition.getPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition, (String)"filePosition.position");
                int n = sourcePosition.getStartLine();
                SourcePosition sourcePosition2 = filePosition.getPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition2, (String)"filePosition.position");
                return new Source(file, n, sourcePosition2.getStartColumn());
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

