/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.AaptResourceType;
import com.android.aaptcompiler.AaptResourceTypeKt;
import com.android.aaptcompiler.AllowNew;
import com.android.aaptcompiler.ArrayResource;
import com.android.aaptcompiler.AttributeResource;
import com.android.aaptcompiler.BasicString;
import com.android.aaptcompiler.BlameLogger;
import com.android.aaptcompiler.BlameLoggerKt;
import com.android.aaptcompiler.ConfigDescription;
import com.android.aaptcompiler.FlattenedXml;
import com.android.aaptcompiler.Id;
import com.android.aaptcompiler.Item;
import com.android.aaptcompiler.Macro;
import com.android.aaptcompiler.Overlayable;
import com.android.aaptcompiler.OverlayableItem;
import com.android.aaptcompiler.ParsedParentInfo;
import com.android.aaptcompiler.ParsedResource;
import com.android.aaptcompiler.Plural;
import com.android.aaptcompiler.RawString;
import com.android.aaptcompiler.Reference;
import com.android.aaptcompiler.ResourceName;
import com.android.aaptcompiler.ResourceTable;
import com.android.aaptcompiler.ResourceUtilsKt;
import com.android.aaptcompiler.Source;
import com.android.aaptcompiler.StringPool;
import com.android.aaptcompiler.Style;
import com.android.aaptcompiler.Styleable;
import com.android.aaptcompiler.StyledString;
import com.android.aaptcompiler.TableExtractor;
import com.android.aaptcompiler.TableExtractorKt;
import com.android.aaptcompiler.TableExtractorOptions;
import com.android.aaptcompiler.Value;
import com.android.aaptcompiler.Visibility;
import com.android.aaptcompiler.XmlStringBuilder;
import com.android.aaptcompiler.XmlUtilKt;
import com.android.aaptcompiler.android.ResValue;
import com.android.aaptcompiler.android.ResourceTypesKt;
import com.android.resources.ResourceVisibility;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010-\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010.\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u00102\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u0018H\u0002J \u00104\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u00105\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u00108\u001a\u00020+H\u0002J \u00109\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010:\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0002J \u0010;\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010<\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J2\u0010=\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010>\u001a\u0002002\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020+H\u0002J \u0010B\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001f\u0010C\u001a\u0004\u0018\u0001002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010D\u001a\u000200H\u0002\u00a2\u0006\u0002\u0010EJ \u0010F\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010G\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010H\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010I\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010J\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010K\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010L\u001a\u00020MH\u0002J \u0010N\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010O\u001a\u00020PH\u0002J \u0010Q\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010R\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J*\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u0002002\u0006\u0010U\u001a\u00020\u0018H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006V"}, d2={"Lcom/android/aaptcompiler/TableExtractor;", "", "table", "Lcom/android/aaptcompiler/ResourceTable;", "source", "Lcom/android/aaptcompiler/Source;", "config", "Lcom/android/aaptcompiler/ConfigDescription;", "options", "Lcom/android/aaptcompiler/TableExtractorOptions;", "logger", "Lcom/android/aaptcompiler/BlameLogger;", "(Lcom/android/aaptcompiler/ResourceTable;Lcom/android/aaptcompiler/Source;Lcom/android/aaptcompiler/ConfigDescription;Lcom/android/aaptcompiler/TableExtractorOptions;Lcom/android/aaptcompiler/BlameLogger;)V", "getConfig", "()Lcom/android/aaptcompiler/ConfigDescription;", "getLogger", "()Lcom/android/aaptcompiler/BlameLogger;", "getOptions", "()Lcom/android/aaptcompiler/TableExtractorOptions;", "getSource", "()Lcom/android/aaptcompiler/Source;", "getTable", "()Lcom/android/aaptcompiler/ResourceTable;", "addResourceToTable", "", "parsedResource", "Lcom/android/aaptcompiler/ParsedResource;", "extract", "inputFile", "Ljava/io/InputStream;", "extractResource", "element", "Ljavax/xml/stream/events/StartElement;", "eventReader", "Ljavax/xml/stream/XMLEventReader;", "extractResourceValues", "flattenXmlSubTree", "Lcom/android/aaptcompiler/FlattenedXml;", "startElement", "logError", "", "Lcom/android/aaptcompiler/BlameLogger$Source;", "message", "", "parseAddResource", "parseArray", "parseArrayImpl", "resourceFormat", "", "parseAttr", "parseAttrImpl", "isWeak", "parseConfigVarying", "parseDeclareStyleable", "parseEnumOrFlagItem", "Lcom/android/aaptcompiler/AttributeResource$Symbol;", "tag", "parseIntegerArray", "parseItem", "parseMacro", "parseOverlayable", "parseOverlayableItem", "policies", "overlayable", "Lcom/android/aaptcompiler/Overlayable;", "comment", "parsePlural", "parsePoliciesFromElement", "oldPolicies", "(Ljavax/xml/stream/events/StartElement;I)Ljava/lang/Integer;", "parsePublic", "parsePublicGroup", "parseString", "parseStringArray", "parseStyle", "parseStyleImpl", "type", "Lcom/android/aaptcompiler/AaptResourceType;", "parseStyleItem", "style", "Lcom/android/aaptcompiler/Style;", "parseSymbol", "parseSymbolImpl", "parseXml", "Lcom/android/aaptcompiler/Item;", "allowRawString", "aaptcompiler"})
public final class TableExtractor {
    @NotNull
    private final ResourceTable table;
    @NotNull
    private final Source source;
    @NotNull
    private final ConfigDescription config;
    @NotNull
    private final TableExtractorOptions options;
    @Nullable
    private final BlameLogger logger;

    public TableExtractor(@NotNull ResourceTable table, @NotNull Source source, @NotNull ConfigDescription config, @NotNull TableExtractorOptions options, @Nullable BlameLogger logger) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.table = table;
        this.source = source;
        this.config = config;
        this.options = options;
        this.logger = logger;
    }

    @NotNull
    public final ResourceTable getTable() {
        return this.table;
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    @NotNull
    public final ConfigDescription getConfig() {
        return this.config;
    }

    @NotNull
    public final TableExtractorOptions getOptions() {
        return this.options;
    }

    @Nullable
    public final BlameLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean extract(@NotNull InputStream inputFile) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        XMLEventReader eventReader = null;
        try {
            eventReader = XmlUtilKt.getXmlInputFactory().createXMLEventReader(inputFile);
            XMLEvent documentStart = eventReader.nextEvent();
            if (!documentStart.isStartDocument()) {
                this.logError(BlameLoggerKt.blameSource$default(this.source, null, null, 6, null), "Failed to find start of XML");
                boolean bl = false;
                return bl;
            }
            XMLEvent rootStart = null;
            while (eventReader.hasNext() && !(rootStart = eventReader.nextEvent()).isStartElement()) {
            }
            object = rootStart;
            if (object == null) {
                boolean bl = true;
                return bl;
            }
            QName rootName = rootStart.asStartElement().getName();
            if (rootName.getNamespaceURI() != null && !Intrinsics.areEqual((Object)rootName.getLocalPart(), (Object)"resources")) {
                this.logError(BlameLoggerKt.blameSource$default(this.source, null, null, 6, null), "Root xml element of resource table not labeled \"resources\"");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.extractResourceValues(eventReader);
            return bl;
        }
        catch (XMLStreamException xmlException) {
            Object object2 = xmlException.getMessage();
            if (!Intrinsics.areEqual(object2 == null ? null : Boolean.valueOf(StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)"Premature end of file.", (boolean)true)), (Object)true)) {
                object2 = this.logger;
                if (object2 != null) {
                    ((BlameLogger)object2).error("Failed to parse file", BlameLoggerKt.blameSource$default(this.source, null, null, 6, null), xmlException);
                }
                throw xmlException;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            object = eventReader;
            if (object != null) {
                object.close();
            }
        }
    }

    private final void logError(BlameLogger.Source source, String message) {
        BlameLogger blameLogger = this.logger;
        if (blameLogger != null) {
            BlameLogger.error$default(blameLogger, message, source, null, 4, null);
        }
    }

    private final boolean extractResourceValues(XMLEventReader eventReader) {
        boolean error = false;
        String comment = "";
        while (eventReader.hasNext()) {
            Object object;
            XMLEvent event = eventReader.nextEvent();
            if (event.getEventType() == 5) {
                if (event == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Comment");
                }
                object = ((Comment)event).getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event as Comment).text");
                boolean bl = false;
                comment = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                continue;
            }
            if (event.isCharacters()) {
                if (event.asCharacters().isWhiteSpace()) continue;
                object = event.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "%s plain text is not allowed here.");
                error = true;
                continue;
            }
            if (event.isEndElement()) break;
            if (!event.isStartElement()) {
                object = event.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), Intrinsics.stringPlus((String)"Unexpected element type: ", (Object)event.getEventType()));
                error = true;
            }
            StartElement element = event.asStartElement();
            QName elementName = element.getName();
            Object object2 = elementName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"elementName.namespaceURI");
            object2 = (CharSequence)object2;
            boolean bl = false;
            if (object2.length() > 0) {
                object2 = element.asStartElement();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element.asStartElement()");
                XmlUtilKt.walkToEndOfElement((StartElement)object2, eventReader);
                continue;
            }
            if (Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"skip") || Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"eat-comment")) {
                comment = "";
                object2 = element.asStartElement();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element.asStartElement()");
                XmlUtilKt.walkToEndOfElement((StartElement)object2, eventReader);
                continue;
            }
            ParsedResource parsedResource = new ParsedResource(this.config, this.source.withLine(element.getLocation().getLineNumber()), comment);
            comment = "";
            Attribute productName = element.getAttributeByName(new QName("product"));
            if (productName != null) {
                String string = productName.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"productName.value");
                parsedResource.setProductString(string);
            }
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
            if (!this.extractResource(element, eventReader, parsedResource)) {
                error = true;
            }
            if (this.addResourceToTable(parsedResource)) continue;
            error = true;
        }
        return !error;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean extractResource(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        block103: {
            block101: {
                block100: {
                    resourceTypeName = element.getName().getLocalPart();
                    resourceFormat = 0;
                    canBeItem = true;
                    canBeBag = true;
                    if (Intrinsics.areEqual((Object)resourceTypeName, (Object)"item")) {
                        canBeBag = false;
                        resourceFormat = 65535;
                        formatAttribute = element.getAttributeByName(new QName("format"));
                        if (formatAttribute != null) {
                            var9_9 = formatAttribute.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)var9_9, (String)"formatAttribute.value");
                            resourceFormat = TableExtractorKt.parseFormatNoEnumsOrFlags(var9_9);
                            if (resourceFormat == 0) {
                                this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Resource has an invalid format of " + formatAttribute.getValue() + '.');
                                XmlUtilKt.walkToEndOfElement(element, eventReader);
                                return false;
                            }
                        }
                        if ((typeAttribute = element.getAttributeByName(new QName("type"))) == null) {
                            this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<item> must have a 'type' attribute");
                            XmlUtilKt.walkToEndOfElement(element, eventReader);
                            return false;
                        }
                        resourceTypeName = typeAttribute.getValue();
                    } else if (Intrinsics.areEqual((Object)resourceTypeName, (Object)"bag")) {
                        canBeItem = false;
                        typeAttribute = element.getAttributeByName(new QName("type"));
                        if (typeAttribute == null) {
                            this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "<bag> must have a 'type' attribute");
                            XmlUtilKt.walkToEndOfElement(element, eventReader);
                            return false;
                        }
                    }
                    nameAttribute = element.getAttributeByName(new QName("name"));
                    if (!Intrinsics.areEqual((Object)resourceTypeName, (Object)"id")) break block100;
                    if (nameAttribute == null) {
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "" + '<' + element.getName() + "> is missing the 'name' attribute.");
                        XmlUtilKt.walkToEndOfElement(element, eventReader);
                        return false;
                    }
                    parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.ID, nameAttribute.getValue(), 1, null));
                    this.parseItem(element, eventReader, parsedResource, resourceFormat);
                    item /* !! */  = parsedResource.getValue();
                    if (!(item /* !! */  instanceof BasicString)) ** GOTO lbl-1000
                    var10_10 = ((BasicString)item /* !! */ ).getRef().value();
                    var11_12 = false;
                    if (var10_10.length() == 0) {
                        parsedResource.setValue(new Id());
                    } else if (item /* !! */  instanceof Reference && ((Reference)item /* !! */ ).getId() == null) {
                        parsedResource.setValue(new Id());
                    } else if (item /* !! */  instanceof Reference && ((Reference)item /* !! */ ).getName().getType() != AaptResourceType.ID || !(item /* !! */  instanceof Reference)) {
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "" + '<' + element.getName() + "> inner element must either be a resource reference or empty.");
                        return false;
                    }
                    return true;
                }
                if (!canBeItem) break block101;
                var10_11 = resourceTypeName;
                if (var10_11 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var10_11.hashCode()) {
                    case -826507106: {
                        if (var10_11.equals("drawable")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 95588145: {
                        if (var10_11.equals("dimen")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 3029738: {
                        if (var10_11.equals("bool")) {
                            tmp = 3;
                        }
                        break;
                    }
                    case 94842723: {
                        if (var10_11.equals("color")) {
                            tmp = 4;
                        }
                        break;
                    }
                    case -891985903: {
                        if (var10_11.equals("string")) {
                            tmp = 5;
                        }
                        break;
                    }
                    case 1958052158: {
                        if (var10_11.equals("integer")) {
                            tmp = 6;
                        }
                        break;
                    }
                    case -280905010: {
                        if (var10_11.equals("configVarying")) {
                            tmp = 7;
                        }
                        break;
                    }
                    case -1653751294: {
                        if (var10_11.equals("fraction")) {
                            tmp = 8;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        v0 = new Pair((Object)AaptResourceType.BOOL, (Object)8);
                        break;
                    }
                    case 4: {
                        v0 = new Pair((Object)AaptResourceType.COLOR, (Object)16);
                        break;
                    }
                    case 7: {
                        v0 = new Pair((Object)AaptResourceType.CONFIG_VARYING, (Object)65535);
                        break;
                    }
                    case 2: {
                        v0 = new Pair((Object)AaptResourceType.DIMEN, (Object)224);
                        break;
                    }
                    case 1: {
                        v0 = new Pair((Object)AaptResourceType.DRAWABLE, (Object)16);
                        break;
                    }
                    case 8: {
                        v0 = new Pair((Object)AaptResourceType.FRACTION, (Object)224);
                        break;
                    }
                    case 6: {
                        v0 = new Pair((Object)AaptResourceType.INTEGER, (Object)4);
                        break;
                    }
                    case 5: {
                        v0 = new Pair((Object)AaptResourceType.STRING, (Object)2);
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v0 = new Pair(null, (Object)65535);
                    }
                }
                item /* !! */  = v0;
                type = (AaptResourceType)item /* !! */ .component1();
                typeMask = ((Number)item /* !! */ .component2()).intValue();
                if (type != null) {
                    if (nameAttribute == null) {
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "" + '<' + element.getName() + "> is missing the 'name' attribute.");
                        XmlUtilKt.walkToEndOfElement(element, eventReader);
                        return false;
                    }
                    parsedResource.setName(new ResourceName("", type, nameAttribute.getValue()));
                    if (resourceFormat == 0) {
                        resourceFormat = typeMask;
                    }
                    return this.parseItem(element, eventReader, parsedResource, resourceFormat);
                }
            }
            if (!canBeBag) break block103;
            var10_11 = resourceTypeName;
            if (var10_11 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var10_11.hashCode()) {
                case 103652300: {
                    if (var10_11.equals("macro")) {
                        tmp = 1;
                    }
                    break;
                }
                case -887523944: {
                    if (var10_11.equals("symbol")) {
                        tmp = 2;
                    }
                    break;
                }
                case 2129240330: {
                    if (var10_11.equals("integer-array")) {
                        tmp = 3;
                    }
                    break;
                }
                case -475309713: {
                    if (var10_11.equals("plurals")) {
                        tmp = 4;
                    }
                    break;
                }
                case -406376022: {
                    if (var10_11.equals("overlayable")) {
                        tmp = 5;
                    }
                    break;
                }
                case -280905010: {
                    if (var10_11.equals("configVarying")) {
                        tmp = 6;
                    }
                    break;
                }
                case -1024600675: {
                    if (var10_11.equals("string-array")) {
                        tmp = 7;
                    }
                    break;
                }
                case 2080961466: {
                    if (var10_11.equals("add-resource")) {
                        tmp = 8;
                    }
                    break;
                }
                case -565605861: {
                    if (var10_11.equals("public-group")) {
                        tmp = 9;
                    }
                    break;
                }
                case -977423767: {
                    if (var10_11.equals("public")) {
                        tmp = 10;
                    }
                    break;
                }
                case 93090393: {
                    if (var10_11.equals("array")) {
                        tmp = 11;
                    }
                    break;
                }
                case 32828323: {
                    if (var10_11.equals("java-symbol")) {
                        tmp = 12;
                    }
                    break;
                }
                case 109780401: {
                    if (var10_11.equals("style")) {
                        tmp = 13;
                    }
                    break;
                }
                case 3004913: {
                    if (var10_11.equals("attr")) {
                        tmp = 14;
                    }
                    break;
                }
                case 1909939688: {
                    if (var10_11.equals("declare-styleable")) {
                        tmp = 15;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 8: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseAddResource((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 11: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseArray((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 14: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseAttr((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 6: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseConfigVarying((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 15: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseDeclareStyleable((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 3: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseIntegerArray((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 12: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseSymbol((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 1: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseMacro((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 5: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseOverlayable((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 4: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parsePlural((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 10: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parsePublic((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 9: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parsePublicGroup((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 7: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseStringArray((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 13: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseStyle((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                case 2: {
                    v1 = (KFunction)new Function3<StartElement, XMLEventReader, ParsedResource, Boolean>(this){

                        public final boolean invoke(@NotNull StartElement p0, @NotNull XMLEventReader p1, @NotNull ParsedResource p2) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            return TableExtractor.access$parseSymbol((TableExtractor)this.receiver, p0, p1, p2);
                        }
                    };
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v1 = parseBagMethod = null;
                }
            }
            if (parseBagMethod != null) {
                if (!Intrinsics.areEqual((Object)resourceTypeName, (Object)"public-group") && !Intrinsics.areEqual((Object)resourceTypeName, (Object)"overlayable")) {
                    if (nameAttribute == null) {
                        XmlUtilKt.walkToEndOfElement(element, eventReader);
                        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "" + '<' + element.getName() + "> is missing the 'name' attribute.");
                        return false;
                    }
                    parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, null, nameAttribute.getValue(), 3, null));
                }
                return (Boolean)((Function3)parseBagMethod).invoke((Object)element, (Object)eventReader, (Object)parsedResource);
            }
        }
        if (canBeItem) {
            var10_11 = resourceTypeName;
            Intrinsics.checkNotNullExpressionValue((Object)var10_11, (String)"resourceTypeName");
            parsedType = AaptResourceTypeKt.resourceTypeFromTag(var10_11);
            if (parsedType != null) {
                if (nameAttribute == null) {
                    this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "" + '<' + element.getName() + "> is missing the 'name' attribute.");
                    XmlUtilKt.walkToEndOfElement(element, eventReader);
                    return false;
                }
                parsedResource.setName(new ResourceName("", parsedType, nameAttribute.getValue()));
                parsedResource.setValue(this.parseXml(element, eventReader, 1, false));
                if (parsedResource.getValue() == null) {
                    this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid value for type '" + parsedType.getTagName() + "'. Expected a reference.");
                    return false;
                }
                return true;
            }
        }
        this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Unknown resource type '" + resourceTypeName + '\'');
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Item parseXml(StartElement element, XMLEventReader eventReader, int resourceFormat, boolean allowRawString) {
        FlattenedXml flattenedXml = this.flattenXmlSubTree(element, eventReader);
        if (!flattenedXml.getSuccess()) {
            return null;
        }
        Collection collection = flattenedXml.getStyleString().getSpans();
        boolean bl = false;
        if (!collection.isEmpty()) {
            return new StyledString(this.table.getStringPool().makeRef(flattenedXml.getStyleString(), new StringPool.Context(StringPool.Context.Priority.NORMAL.getPriority(), this.config)), flattenedXml.getUntranslatableSections());
        }
        Item processedItem2 = ResourceUtilsKt.tryParseItemForAttribute(flattenedXml.getRawString(), resourceFormat, (Function1<? super ResourceName, Boolean>)((Function1)new Function1<ResourceName, Boolean>(this){
            final /* synthetic */ TableExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull ResourceName it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Id id = new Id();
                id.setSource(this.this$0.getSource());
                return this.this$0.getTable().addResource(it, new ConfigDescription(null, 1, null), "", id);
            }
        }));
        if (processedItem2 != null) {
            if (processedItem2 instanceof Reference) {
                XmlUtilKt.resolvePackage(element, (Reference)processedItem2);
            }
            return processedItem2;
        }
        if ((resourceFormat & 2) != 0) {
            return new BasicString(this.table.getStringPool().makeRef(flattenedXml.getStyleString().getStr(), new StringPool.Context(0L, this.config, 1, null)), flattenedXml.getUntranslatableSections());
        }
        CharSequence charSequence = flattenedXml.getRawString();
        boolean bl2 = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
        bl2 = false;
        if (charSequence.length() == 0) {
            return ResourceUtilsKt.makeNull();
        }
        if (allowRawString) {
            int n;
            boolean bl3;
            int firstNonWrappingIndex;
            int n2;
            int n3;
            String raw2;
            block14: {
                int n4;
                Function1 isNotWrappingChar2;
                block13: {
                    String string2 = flattenedXml.getRawString();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    raw2 = string2;
                    boolean bl6 = false;
                    isNotWrappingChar2 = parseXml.raw.1.isNotWrappingChar.1.INSTANCE;
                    CharSequence $this$indexOfFirst$iv = raw2;
                    boolean $i$f$indexOfFirst = false;
                    n3 = 0;
                    n2 = $this$indexOfFirst$iv.length();
                    while (n3 < n2) {
                        void index$iv;
                        if (((Boolean)isNotWrappingChar2.invoke((Object)Character.valueOf($this$indexOfFirst$iv.charAt((int)index$iv)))).booleanValue()) {
                            n4 = index$iv;
                            break block13;
                        }
                        ++index$iv;
                    }
                    n4 = -1;
                }
                firstNonWrappingIndex = n4;
                CharSequence $this$indexOfLast$iv = raw2;
                boolean $i$f$indexOfLast = false;
                n2 = $this$indexOfLast$iv.length();
                --n2;
                bl3 = false;
                while (n2 >= 0) {
                    void index$iv;
                    if (((Boolean)isNotWrappingChar2.invoke((Object)Character.valueOf($this$indexOfLast$iv.charAt((int)index$iv)))).booleanValue()) {
                        n = index$iv;
                        break block14;
                    }
                    --index$iv;
                }
                n = -1;
            }
            int lastNonWrappingIndex = n;
            String string3 = raw2;
            n3 = firstNonWrappingIndex == -1 ? 0 : firstNonWrappingIndex;
            n2 = lastNonWrappingIndex == -1 ? 0 : lastNonWrappingIndex + 1;
            bl3 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n3, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String raw3 = StringsKt.removeSurrounding((String)string5, (CharSequence)"\"");
            return new RawString(this.table.getStringPool().makeRef(raw3, new StringPool.Context(0L, this.config, 1, null)));
        }
        return null;
    }

    private final boolean parseItem(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource, int resourceFormat) {
        if (resourceFormat == 2) {
            return this.parseString(element, eventReader, parsedResource);
        }
        parsedResource.setValue(this.parseXml(element, eventReader, resourceFormat, false));
        if (parsedResource.getValue() == null) {
            this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid <" + parsedResource.getName().getType().getTagName() + "> for given resource value.");
            return false;
        }
        return true;
    }

    private final boolean parseString(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        Item value;
        boolean formatted = true;
        Attribute formattedAttribute = element.getAttributeByName(new QName("formatted"));
        if (formattedAttribute != null) {
            String string = formattedAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formattedAttribute.value");
            Boolean maybeFormatted = ResourceUtilsKt.parseAsBool(string);
            if (maybeFormatted == null) {
                this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid value for the 'formatted' attribute. Was '" + formattedAttribute.getValue() + "', must be a boolean.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
            formatted = maybeFormatted;
        }
        boolean translatable = this.options.getTranslatable();
        Attribute translatableAttribute = element.getAttributeByName(new QName("translatable"));
        if (translatableAttribute != null) {
            String string = translatableAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translatableAttribute.value");
            Boolean maybeTranslatable = ResourceUtilsKt.parseAsBool(string);
            if (maybeTranslatable == null) {
                this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid value for 'translatable' attribute. Was '" + translatableAttribute.getValue() + "', must be a boolean.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
            translatable = maybeTranslatable;
        }
        if ((value = this.parseXml(element, eventReader, 2, false)) == null) {
            this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), parsedResource.getName() + " does not contain a valid string resource.");
            return false;
        }
        if (value instanceof BasicString) {
            value.setTranslatable(translatable);
            if (formatted && translatable && !ResourceUtilsKt.verifyJavaStringFormat(value.toString())) {
                String errorMsg = "Multiple substitutions specified in non-positional format of string resource " + parsedResource.getName() + ". Did you mean to add the formatted=\"false\" attribute?";
                if (this.options.getErrorOnPositionalArgs()) {
                    this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), errorMsg);
                    return false;
                }
                BlameLogger blameLogger = this.logger;
                if (blameLogger != null) {
                    blameLogger.warning(errorMsg, BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null));
                }
            }
        } else if (value instanceof StyledString) {
            value.setTranslatable(translatable);
        }
        parsedResource.setValue(value);
        return true;
    }

    private final AttributeResource.Symbol parseEnumOrFlagItem(StartElement element, XMLEventReader eventReader, String tag) {
        Source elementSource = this.source.withLine(element.getLocation().getLineNumber());
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        Attribute nameAttribute = element.getAttributeByName(new QName("name"));
        if (nameAttribute == null) {
            this.logError(BlameLoggerKt.blameSource$default(elementSource, null, null, 6, null), "No attribute 'name' found for tag <" + tag + ">.");
            return null;
        }
        Attribute valueAttribute = element.getAttributeByName(new QName("value"));
        if (valueAttribute == null) {
            this.logError(BlameLoggerKt.blameSource$default(elementSource, null, null, 6, null), "No attribute 'value' found for tag <" + tag + ">.");
            return null;
        }
        String string = valueAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueAttribute.value");
        ResValue resValue = ResourceTypesKt.stringToInt(string);
        if (resValue == null) {
            this.logError(BlameLoggerKt.blameSource$default(elementSource, null, null, 6, null), "Invalid value '" + resValue + "' for <" + tag + ">. Must be an integer.");
            return null;
        }
        Reference reference = new Reference(null, 1, null);
        reference.setName(new ResourceName("", AaptResourceType.ID, nameAttribute.getValue()));
        return new AttributeResource.Symbol(reference, resValue.getData(), resValue.getDataType().getByteValue());
    }

    private final boolean parseStyleItem(StartElement element, XMLEventReader eventReader, Style style) {
        Source itemSource = this.source.withLine(element.getLocation().getLineNumber());
        Attribute nameAttribute = element.getAttributeByName(new QName("name"));
        if (nameAttribute == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> must have a 'name' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        String string = nameAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameAttribute.value");
        Reference key = ResourceUtilsKt.parseXmlAttributeName(string);
        XmlUtilKt.resolvePackage(element, key);
        key.setSource(itemSource);
        Item xmlItem = this.parseXml(element, eventReader, 0, true);
        if (xmlItem == null) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Could not parse style item with name '" + nameAttribute.getValue() + "'.");
            return false;
        }
        style.getEntries().add(new Style.Entry(key, xmlItem));
        return true;
    }

    private final FlattenedXml flattenXmlSubTree(StartElement startElement, XMLEventReader eventReader) {
        Object element;
        int depth = 1;
        XmlStringBuilder builder = new XmlStringBuilder(false, 1, null);
        while (depth > 0) {
            String string;
            QName elementName;
            XMLEvent event = eventReader.nextEvent();
            if (event.isCharacters()) {
                String string2 = event.asCharacters().getData();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.asCharacters().data");
                builder.append(string2);
                continue;
            }
            if (event.isStartElement()) {
                element = event.asStartElement();
                elementName = element.getName();
                string = elementName.getNamespaceURI();
                if (Intrinsics.areEqual((Object)string, (Object)"")) {
                    StringBuilder spanName = new StringBuilder(elementName.getLocalPart());
                    Iterator<Attribute> attributes = element.getAttributes();
                    while (attributes.hasNext()) {
                        Attribute attribute = attributes.next();
                        if (attribute == null) {
                            throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Attribute");
                        }
                        Attribute attribute2 = attribute;
                        spanName.append(';' + attribute2.getName().getLocalPart() + '=' + attribute2.getValue());
                    }
                    String string3 = spanName.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"spanName.toString()");
                    builder.startSpan(string3);
                } else if (Intrinsics.areEqual((Object)string, (Object)"urn:oasis:names:tc:xliff:document:1.2")) {
                    if (Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"g")) {
                        builder.startUntranslatable();
                    }
                } else {
                    BlameLogger blameLogger = this.logger;
                    if (blameLogger != null) {
                        blameLogger.warning("Ignoring element '" + elementName + "' with unknown namespace '" + elementName.getNamespaceURI() + "'.", BlameLoggerKt.blameSource$default(this.source.withLine(element.getLocation().getLineNumber()), null, null, 6, null));
                    }
                }
                ++depth;
                continue;
            }
            if (!event.isEndElement()) continue;
            element = event.asEndElement();
            elementName = element.getName();
            --depth;
            string = elementName.getNamespaceURI();
            if (Intrinsics.areEqual((Object)string, (Object)"")) {
                if (depth == 0) continue;
                builder.endSpan();
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"urn:oasis:names:tc:xliff:document:1.2") || !Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"g")) continue;
            builder.endUntranslatable();
        }
        FlattenedXml flattenedXml = builder.getFlattenedXml();
        element = builder.getError();
        boolean bl = false;
        if (element.length() > 0) {
            String resourceName = startElement.getAttributeByName(new QName("name")).getValue();
            Location location = startElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"startElement.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "Failed to flatten XML for resource '" + resourceName + "' with error: " + builder.getError());
        }
        return flattenedXml;
    }

    private final boolean parseSymbol(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        Object object;
        boolean error = false;
        if (this.options.getVisibility() != null) {
            object = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "<java-symbol> and <symbol> tags are not supported with resource visibility.");
            error = true;
        }
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)new ConfigDescription(null, 1, null)) && (object = this.logger) != null) {
            String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            ((BlameLogger)object).warning(string, BlameLoggerKt.blameSource(this.source, location));
        }
        if (!this.parseSymbolImpl(element, eventReader, parsedResource)) {
            return false;
        }
        parsedResource.setVisibility(ResourceVisibility.PRIVATE);
        return !error;
    }

    private final boolean parseMacro(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.MACRO, null, 5, null));
        ConfigDescription defaultConfig = new ConfigDescription(null, 1, null);
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)defaultConfig)) {
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<macro> tags cannot be declared in configurations other than the default configuration");
            return false;
        }
        FlattenedXml flattenedXml = this.flattenXmlSubTree(element, eventReader);
        if (!flattenedXml.getSuccess()) {
            return false;
        }
        parsedResource.setValue(new Macro(flattenedXml.getRawString(), flattenedXml.getStyleString(), flattenedXml.getUntranslatableSections(), null, 8, null));
        return true;
    }

    private final boolean parseAddResource(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        if (this.parseSymbolImpl(element, eventReader, parsedResource)) {
            parsedResource.setVisibility(ResourceVisibility.UNDEFINED);
            parsedResource.setAllowNew(true);
            return true;
        }
        return false;
    }

    private final boolean parseSymbolImpl(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        Attribute typeAttribute = element.getAttributeByName(new QName("type"));
        if (typeAttribute == null) {
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "" + '<' + element.getName() + "> must have a 'type' attribute.");
            return false;
        }
        Object object = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeAttribute.value");
        AaptResourceType parsedType = AaptResourceTypeKt.resourceTypeFromTag((String)object);
        if (parsedType == null) {
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            object = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "Invalid resource type '" + typeAttribute.getValue() + "' in <" + element.getName() + "> resource.");
            return false;
        }
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, parsedType, null, 5, null));
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        return true;
    }

    private final boolean parseAttr(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseAttrImpl(element, eventReader, parsedResource, false);
    }

    private final boolean parseAttrImpl(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource, boolean isWeak) {
        Object object;
        Object maxString;
        Object minRes;
        boolean bl;
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.ATTR, null, 5, null));
        ConfigDescription defaultConfig = new ConfigDescription(null, 1, null);
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)defaultConfig)) {
            Unit unit;
            BlameLogger blameLogger = this.logger;
            if (blameLogger == null) {
                unit = null;
            } else {
                String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
                unit = Unit.INSTANCE;
            }
            parsedResource.setConfig(defaultConfig);
        }
        int typeMask = 0;
        Attribute formatAttribute = element.getAttributeByName(new QName("format"));
        if (formatAttribute != null) {
            Object object2 = formatAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"formatAttribute.value");
            typeMask = TableExtractorKt.parseFormatAttribute((String)object2);
            if (typeMask == 0) {
                object2 = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object2), "Invalid attribute format '" + formatAttribute.getValue() + '\'');
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
        }
        Integer min = null;
        Integer max = null;
        Attribute minAttribute = element.getAttributeByName(new QName("min"));
        Attribute maxAttribute = element.getAttributeByName(new QName("max"));
        if (minAttribute != null) {
            CharSequence charSequence = minAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"minAttribute.value");
            bl = false;
            String minString = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            charSequence = minString;
            bl = false;
            if (charSequence.length() > 0 && (minRes = ResourceTypesKt.stringToInt(minString)) != null) {
                min = ((ResValue)minRes).getData();
            }
            if (min == null) {
                minRes = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)minRes, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)minRes), "Invalid 'min' value '" + minString + "'. Integer value required.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
        }
        if (maxAttribute != null) {
            Object maxRes;
            minRes = maxAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)minRes, (String)"maxAttribute.value");
            bl = false;
            maxString = ((Object)StringsKt.trim((CharSequence)((CharSequence)minRes))).toString();
            minRes = (CharSequence)maxString;
            bl = false;
            if (minRes.length() > 0 && (maxRes = ResourceTypesKt.stringToInt((String)maxString)) != null) {
                max = ((ResValue)maxRes).getData();
            }
            if (max == null) {
                maxRes = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)maxRes, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)maxRes), "Invalid 'max' value '" + (String)maxString + "'. Integer value required.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
        }
        if ((min != null || max != null) && (typeMask & 4) == 0) {
            maxString = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)maxString, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, (Location)maxString), "'min' and 'max' attributes can only be used with format='integer' on <" + element.getName() + "> resource");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        boolean maxRes = false;
        Map symbolMap = new LinkedHashMap();
        String comment = "";
        boolean error = false;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.getEventType() == 5) {
                if (event == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Comment");
                }
                object = ((Comment)event).getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event as Comment).text");
                boolean bl2 = false;
                comment = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                continue;
            }
            if (event.isEndElement()) break;
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            Source childSource = this.source.withLine(event.getLocation().getLineNumber());
            QName childName = childElement.getName();
            CharSequence charSequence = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"childName.namespaceURI");
            charSequence = charSequence;
            boolean bl3 = false;
            if (charSequence.length() == 0 && (Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"flag") || Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"enum"))) {
                Object object3;
                boolean itemError = false;
                String string = childName.getLocalPart();
                if (Intrinsics.areEqual((Object)string, (Object)"enum")) {
                    if ((typeMask & 0x20000) != 0) {
                        object3 = childElement.getLocation();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"childElement.location");
                        this.logError(BlameLoggerKt.blameSource(this.source, (Location)object3), "Cannot define both <enum> and <flag> under the same <" + element.getName() + "> resource.");
                        error = true;
                        itemError = true;
                    }
                    typeMask |= 0x10000;
                } else if (Intrinsics.areEqual((Object)string, (Object)"flag")) {
                    if ((typeMask & 0x10000) != 0) {
                        object3 = childElement.getLocation();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"childElement.location");
                        this.logError(BlameLoggerKt.blameSource(this.source, (Location)object3), "Cannot define both <enum> and <flag> under the same <" + element.getName() + "> resource.");
                        error = true;
                        itemError = true;
                    }
                    typeMask |= 0x20000;
                }
                if (itemError) continue;
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                object3 = childName.getLocalPart();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"childName.localPart");
                AttributeResource.Symbol symbol = this.parseEnumOrFlagItem(childElement, eventReader, (String)object3);
                if (symbol != null) {
                    ParsedResource childResource = new ParsedResource(defaultConfig, childSource, "");
                    childResource.setName(symbol.getSymbol().getName());
                    childResource.setValue(new Id());
                    parsedResource.getChildren().add(childResource);
                    symbol.getSymbol().setComment(comment);
                    symbol.getSymbol().setSource(childSource);
                    String symbolName = symbol.getSymbol().getName().toString();
                    Map map = symbolMap;
                    boolean bl4 = false;
                    Object object4 = map;
                    boolean bl5 = false;
                    if (object4.containsKey(symbolName)) {
                        Object object5;
                        Object object6;
                        object4 = this.logger;
                        BlameLogger.Source source = object4 == null ? null : ((BlameLogger)object4).getOriginalSource(BlameLoggerKt.blameSource$default(symbol.getSymbol().getSource(), null, null, 6, null));
                        BlameLogger.Source newSource = source == null ? BlameLoggerKt.blameSource$default(symbol.getSymbol().getSource(), null, null, 6, null) : source;
                        Object object7 = this.logger;
                        if (object7 == null) {
                            object6 = null;
                        } else {
                            AttributeResource.Symbol symbol2 = (AttributeResource.Symbol)symbolMap.get(symbolName);
                            Intrinsics.checkNotNull((Object)symbol2);
                            object6 = object4 = ((BlameLogger)object7).getOriginalSource(BlameLoggerKt.blameSource$default(symbol2.getSymbol().getSource(), null, null, 6, null));
                        }
                        if (object4 == null) {
                            object7 = (AttributeResource.Symbol)symbolMap.get(symbolName);
                            Intrinsics.checkNotNull((Object)object7);
                            object5 = BlameLoggerKt.blameSource$default(((AttributeResource.Symbol)object7).getSymbol().getSource(), null, null, 6, null);
                        } else {
                            object5 = object4;
                        }
                        Object previousSource = object5;
                        String errorMsg = "Duplicate symbol '" + symbolName + "' defined here: " + newSource + " and here: " + previousSource;
                        this.logError(BlameLoggerKt.blameSource$default(symbol.getSymbol().getSource(), null, null, 6, null), errorMsg);
                        error = true;
                    }
                    map = symbolMap;
                    bl4 = false;
                    map.put(symbolName, symbol);
                } else {
                    error = true;
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
                if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                    this.logError(BlameLoggerKt.blameSource$default(childSource, null, null, 6, null), "Unrecognized tag <" + childName + "> of child element of <" + element.getName() + ">.");
                    error = true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.walkToEndOfElement(childElement, eventReader);
            }
            comment = "";
        }
        if (error) {
            return false;
        }
        AttributeResource resource = new AttributeResource(typeMask == 0 ? 65535 : typeMask, null, 2, null);
        resource.setWeak(isWeak);
        resource.getSymbols().addAll(symbolMap.values());
        object = min;
        resource.setMinInt(object == null ? Integer.MIN_VALUE : (Integer)object);
        object = max;
        resource.setMaxInt(object == null ? Integer.MAX_VALUE : (Integer)object);
        parsedResource.setValue(resource);
        return true;
    }

    private final boolean parseArray(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        int resourceFormat = 65535;
        Attribute formatAttribute = element.getAttributeByName(new QName("format"));
        if (formatAttribute != null) {
            Object object = formatAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"formatAttribute.value");
            resourceFormat = TableExtractorKt.parseFormatNoEnumsOrFlags((String)object);
            if (resourceFormat == 0) {
                object = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "Invalid format value: '" + formatAttribute.getValue() + "'.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
        }
        return this.parseArrayImpl(element, eventReader, parsedResource, resourceFormat);
    }

    private final boolean parseIntegerArray(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseArrayImpl(element, eventReader, parsedResource, 4);
    }

    private final boolean parseStringArray(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseArrayImpl(element, eventReader, parsedResource, 2);
    }

    private final boolean parseArrayImpl(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource, int resourceFormat) {
        XMLEvent event;
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.ARRAY, null, 5, null));
        ArrayResource array = new ArrayResource();
        boolean translatable = this.options.getTranslatable();
        Attribute translatableAttribute = element.getAttributeByName(new QName("translatable"));
        if (translatableAttribute != null) {
            String string = translatableAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translatableAttribute.value");
            Boolean translatableValue = ResourceUtilsKt.parseAsBool(string);
            if (translatableValue == null) {
                this.logError(BlameLoggerKt.blameSource$default(parsedResource.getSource(), null, null, 6, null), "Invalid value for 'translatable' attribute. Must be a boolean.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
            translatable = translatableValue;
        }
        array.setTranslatable(translatable);
        boolean error = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            Source childSource = this.source.withLine(childElement.getLocation().getLineNumber());
            QName childName = childElement.getName();
            CharSequence charSequence = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"childName.namespaceURI");
            charSequence = charSequence;
            boolean bl = false;
            if (charSequence.length() == 0 && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"item")) {
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                Item childItem = this.parseXml(childElement, eventReader, resourceFormat, false);
                if (childItem != null) {
                    childItem.setSource(childSource);
                    array.getElements().add(childItem);
                    continue;
                }
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location), "Could not parse array item.");
                error = true;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                this.logError(BlameLoggerKt.blameSource$default(childSource, null, null, 6, null), "Unknown tag <" + childName + "> in <" + element.getName() + "> resource.");
                error = true;
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
            XmlUtilKt.walkToEndOfElement(childElement, eventReader);
        }
        if (error) {
            return false;
        }
        parsedResource.setValue(array);
        return true;
    }

    private final boolean parseConfigVarying(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseStyleImpl(element, eventReader, parsedResource, AaptResourceType.CONFIG_VARYING);
    }

    private final boolean parseStyle(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return this.parseStyleImpl(element, eventReader, parsedResource, AaptResourceType.STYLE);
    }

    private final boolean parseStyleImpl(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource, AaptResourceType type) {
        XMLEvent event;
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, type, null, 5, null));
        Style style = new Style();
        Attribute parentAttribute = element.getAttributeByName(new QName("parent"));
        if (parentAttribute != null) {
            CharSequence charSequence = parentAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"parentAttribute.value");
            charSequence = charSequence;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Object object = parentAttribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parentAttribute.value");
                ParsedParentInfo parseResult = ResourceUtilsKt.parseStyleParentReference((String)object);
                if (parseResult.getParent() == null) {
                    object = element.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), parseResult.getErrorString());
                    XmlUtilKt.walkToEndOfElement(element, eventReader);
                    return false;
                }
                style.setParent(parseResult.getParent());
                object = style.getParent();
                Intrinsics.checkNotNull((Object)object);
                XmlUtilKt.resolvePackage(element, (Reference)object);
            }
        } else {
            String string = parsedResource.getName().getEntry();
            Intrinsics.checkNotNull((Object)string);
            String styleName = string;
            int marker = StringsKt.lastIndexOf$default((CharSequence)styleName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (marker != -1) {
                style.setParentInferred(true);
                String string2 = styleName;
                int n = 0;
                boolean bl = false;
                String string3 = string2.substring(n, marker);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                style.setParent(new Reference(new ResourceName("", AaptResourceType.STYLE, string3)));
            }
        }
        boolean error = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            QName childName = childElement.getName();
            Object object = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"childName.namespaceURI");
            object = (CharSequence)object;
            boolean bl = false;
            if (object.length() == 0 && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"item")) {
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                if (this.parseStyleItem(childElement, eventReader, style)) continue;
                error = true;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                object = childElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"childElement.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "Unrecognized child element <" + childName + "> of <" + element.getName() + "> resource.");
                error = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
            XmlUtilKt.walkToEndOfElement(childElement, eventReader);
        }
        if (error) {
            return false;
        }
        parsedResource.setValue(style);
        return true;
    }

    private final boolean parseDeclareStyleable(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.STYLEABLE, null, 5, null));
        parsedResource.setVisibility(ResourceVisibility.PUBLIC);
        ConfigDescription defaultConfig = new ConfigDescription(null, 1, null);
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)defaultConfig)) {
            BlameLogger blameLogger = this.logger;
            if (blameLogger != null) {
                String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
                Location location = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
            }
            parsedResource.setConfig(defaultConfig);
        }
        Styleable styleable = new Styleable();
        String comment = "";
        boolean error = false;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.getEventType() == 5) {
                if (event == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Comment");
                }
                String string = ((Comment)event).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event as Comment).text");
                boolean bl = false;
                comment = ((Object)StringsKt.trim((CharSequence)string)).toString();
                continue;
            }
            if (event.isEndElement()) break;
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            QName childName = childElement.getName();
            Source itemSource = this.source.withLine(childElement.getLocation().getLineNumber());
            CharSequence charSequence = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"childName.namespaceURI");
            charSequence = charSequence;
            boolean bl = false;
            if (charSequence.length() == 0 && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"attr")) {
                Attribute nameAttribute = childElement.getAttributeByName(new QName("name"));
                if (nameAttribute == null) {
                    this.logError(BlameLoggerKt.blameSource$default(itemSource, null, null, 6, null), "<attr> tag must have a 'name' attribute.");
                    error = true;
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    continue;
                }
                String string = nameAttribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameAttribute.value");
                Reference nameReference = ResourceUtilsKt.parseXmlAttributeName(string);
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.resolvePackage(childElement, nameReference);
                ParsedResource childResource = new ParsedResource(defaultConfig, itemSource, comment);
                childResource.setName(nameReference.getName());
                if (!this.parseAttrImpl(childElement, eventReader, childResource, true)) {
                    error = true;
                    continue;
                }
                nameReference.setComment(childResource.getComment());
                nameReference.setSource(itemSource);
                styleable.getEntries().add(nameReference);
                parsedResource.getChildren().add(childResource);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
                if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                    this.logError(BlameLoggerKt.blameSource$default(itemSource, null, null, 6, null), "Unknown tag of <" + childName + "> in <" + element.getName() + "> resource.");
                    error = true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.walkToEndOfElement(childElement, eventReader);
            }
            comment = "";
        }
        if (error) {
            return false;
        }
        parsedResource.setValue(styleable);
        return true;
    }

    private final boolean parseOverlayable(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        String string;
        Attribute nameAttribute;
        Location location;
        BlameLogger blameLogger;
        ConfigDescription defaultConfig = new ConfigDescription(null, 1, null);
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)defaultConfig) && (blameLogger = this.logger) != null) {
            String string2 = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
            location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            blameLogger.warning(string2, BlameLoggerKt.blameSource(this.source, location));
        }
        if ((nameAttribute = element.getAttributeByName(new QName(null, "name"))) == null) {
            location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<overlayable> tag must have a 'name' attribute");
            return false;
        }
        Attribute actorAttribute = element.getAttributeByName(new QName(null, "actor"));
        if (actorAttribute != null) {
            Object object = actorAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"actorAttribute.value");
            if (!StringsKt.startsWith$default((String)object, (String)"overlay://", (boolean)false, (int)2, null)) {
                object = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "<overlayable> tag has a 'actor' attribute: '" + actorAttribute.getValue() + "'. Value must use the schema: overlay://.");
                return false;
            }
        }
        Object object = nameAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nameAttribute.value");
        String string3 = object;
        object = actorAttribute;
        Overlayable overlayable = new Overlayable(string3, object == null ? "" : ((string = object.getValue()) == null ? "" : string), this.source);
        boolean error = false;
        String comment = "";
        int currentPolicies = 0;
        int depth = 1;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isEndElement()) {
                if (--depth == 0) break;
                currentPolicies = 0;
                continue;
            }
            if (event.getEventType() == 5) {
                if (event == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Comment");
                }
                String string4 = ((Comment)event).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"event as Comment).text");
                boolean bl = false;
                comment = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                continue;
            }
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            QName childName = childElement.getName();
            if (Intrinsics.areEqual((Object)childName.getNamespaceURI(), (Object)"") && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"item")) {
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                ParsedResource childResource = this.parseOverlayableItem(childElement, eventReader, currentPolicies, overlayable, comment);
                comment = "";
                if (childResource == null) {
                    error = true;
                    continue;
                }
                parsedResource.getChildren().add(childResource);
                continue;
            }
            if (Intrinsics.areEqual((Object)childName.getNamespaceURI(), (Object)"") && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"policy")) {
                ++depth;
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                Integer newPolicy = this.parsePoliciesFromElement(childElement, currentPolicies);
                if (newPolicy == null) {
                    error = true;
                    currentPolicies = 0;
                } else {
                    currentPolicies = newPolicy;
                }
                comment = "";
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                Location location2 = childElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"childElement.location");
                this.logError(BlameLoggerKt.blameSource(this.source, location2), "Unrecognized tag '" + childName + "' within an <overlayable> resource.");
                error = true;
                continue;
            }
            comment = "";
        }
        return !error;
    }

    private final ParsedResource parseOverlayableItem(StartElement element, XMLEventReader eventReader, int policies, Overlayable overlayable, String comment) {
        Attribute typeAttribute;
        Attribute nameAttribute;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    Object object;
                    block8: {
                        if (policies == 0) {
                            Location location = element.getLocation();
                            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                            this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> within an <overlayable> must be inside a <policy> block.");
                            XmlUtilKt.walkToEndOfElement(element, eventReader);
                            return null;
                        }
                        nameAttribute = element.getAttributeByName(new QName(null, "name"));
                        if (nameAttribute == null) break block8;
                        object = nameAttribute.getValue();
                        boolean bl2 = false;
                        bl = false;
                        if (!(object == null || object.length() == 0)) break block9;
                    }
                    object = element.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "<item> within an <overlayable> must have a 'name' attribute.");
                    XmlUtilKt.walkToEndOfElement(element, eventReader);
                    return null;
                }
                typeAttribute = element.getAttributeByName(new QName(null, "type"));
                if (typeAttribute == null) break block10;
                CharSequence charSequence = typeAttribute.getValue();
                bl = false;
                boolean bl3 = false;
                if (!(charSequence == null || charSequence.length() == 0)) break block11;
            }
            Location location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> within an <overlayable> must have a 'type' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return null;
        }
        Object object = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeAttribute.value");
        AaptResourceType type = AaptResourceTypeKt.resourceTypeFromTag((String)object);
        if (type == null) {
            object = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "Invalid resource type '" + typeAttribute.getValue() + "' in <item> in <overlayable> resource.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return null;
        }
        OverlayableItem overlayableItem = new OverlayableItem(overlayable, policies, comment, this.source.withLine(element.getLocation().getLineNumber()));
        ParsedResource childResource = new ParsedResource();
        childResource.setName(ResourceName.copy$default(childResource.getName(), null, type, nameAttribute.getValue(), 1, null));
        childResource.setOverlayableItem(overlayableItem);
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        return childResource;
    }

    private final Integer parsePoliciesFromElement(StartElement element, int oldPolicies) {
        Attribute typeAttribute;
        block34: {
            Object object;
            block33: {
                if (oldPolicies != 0) {
                    Location location = element.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "Policy blocks should not be nested recursively.");
                    return null;
                }
                typeAttribute = element.getAttributeByName(new QName(null, "type"));
                if (typeAttribute == null) break block33;
                object = typeAttribute.getValue();
                boolean bl = false;
                boolean bl2 = false;
                if (!(object == null || object.length() == 0)) break block34;
            }
            object = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "<policy> must have a 'type' attribute.");
            return null;
        }
        int newPolicy = 0;
        Object object = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeAttribute.value");
        CharSequence charSequence = (CharSequence)object;
        object = new char[1];
        object[0] = 124;
        for (String string : StringsKt.split$default((CharSequence)charSequence, (char[])object, (boolean)false, (int)0, (int)6, null)) {
            int n;
            Object object2 = string;
            boolean bl = false;
            String string2 = object2;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            switch (((Object)StringsKt.trim((CharSequence)string2)).toString()) {
                case "odm": {
                    n = 32;
                    break;
                }
                case "oem": {
                    n = 64;
                    break;
                }
                case "product": {
                    n = 8;
                    break;
                }
                case "public": {
                    n = 1;
                    break;
                }
                case "signature": {
                    n = 16;
                    break;
                }
                case "system": {
                    n = 2;
                    break;
                }
                case "vendor": {
                    n = 4;
                    break;
                }
                default: {
                    object2 = element.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element.location");
                    BlameLogger.Source source = BlameLoggerKt.blameSource(this.source, (Location)object2);
                    object2 = string;
                    bl = false;
                    Object object3 = object2;
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    this.logError(source, "<policy> has unsupported type '" + ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString() + "'.");
                    return null;
                }
            }
            newPolicy |= n;
        }
        return newPolicy;
    }

    private final boolean parsePlural(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        XMLEvent event;
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, AaptResourceType.PLURALS, null, 5, null));
        Plural plural = new Plural();
        boolean error = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            Object object;
            QName childName;
            StartElement childElement;
            block28: {
                Plural.Type pluralType;
                if (!event.isStartElement()) continue;
                childElement = event.asStartElement();
                childName = childElement.getName();
                object = childName.getNamespaceURI();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"childName.namespaceURI");
                object = (CharSequence)object;
                boolean bl = false;
                if (!(object.length() == 0) || !Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"item")) break block28;
                Attribute quantityAttribute = childElement.getAttributeByName(new QName("quantity"));
                if (quantityAttribute == null) {
                    Location location = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> in <plurals> are required to have the 'quantity' attribute.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                String string = quantityAttribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quantityAttribute.value");
                boolean bl2 = false;
                String trimmedQuantity = ((Object)StringsKt.trim((CharSequence)string)).toString();
                switch (trimmedQuantity) {
                    case "zero": {
                        Plural.Type type = Plural.Type.ZERO;
                        break;
                    }
                    case "one": {
                        Plural.Type type = Plural.Type.ONE;
                        break;
                    }
                    case "two": {
                        Plural.Type type = Plural.Type.TWO;
                        break;
                    }
                    case "few": {
                        Plural.Type type = Plural.Type.FEW;
                        break;
                    }
                    case "many": {
                        Plural.Type type = Plural.Type.MANY;
                        break;
                    }
                    case "other": {
                        Plural.Type type = Plural.Type.OTHER;
                        break;
                    }
                    default: {
                        Plural.Type type = pluralType = null;
                    }
                }
                if (pluralType == null) {
                    Object object2 = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, (Location)object2), "Unrecognized quantity value '" + trimmedQuantity + "' specified in <item> in <plurals> resource.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                int pluralIndex = pluralType.ordinal();
                if (plural.getValues()[pluralIndex] != null) {
                    Location location = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location), "<item> has quantity '" + trimmedQuantity + "' which has already been specified in <plurals> resource '" + element.getName() + '\'');
                    error = true;
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    continue;
                }
                Item[] itemArray = plural.getValues();
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                itemArray[pluralIndex] = this.parseXml(childElement, eventReader, 2, false);
                if (plural.getValues()[pluralIndex] != null) continue;
                error = true;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                object = childElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"childElement.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "Unrecognized tag '" + childName + "' within an <plurals> resource.");
                error = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
            XmlUtilKt.walkToEndOfElement(childElement, eventReader);
        }
        if (error) {
            return false;
        }
        parsedResource.setValue(plural);
        return true;
    }

    private final boolean parsePublic(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        Attribute typeAttribute;
        Location location;
        BlameLogger blameLogger;
        if (this.options.getVisibility() != null) {
            Location location2 = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location2), "<public> tag not allowed with --visibility flag.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)new ConfigDescription(null, 1, null)) && (blameLogger = this.logger) != null) {
            String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
            location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
        }
        if ((typeAttribute = element.getAttributeByName(new QName("type"))) == null) {
            location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<public> must have a 'type' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        Object object = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeAttribute.value");
        AaptResourceType parsedType = AaptResourceTypeKt.resourceTypeFromTag((String)object);
        if (parsedType == null) {
            object = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "Invalid resource type '" + typeAttribute.getValue() + "' in <public> resource.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        parsedResource.setName(ResourceName.copy$default(parsedResource.getName(), null, parsedType, null, 5, null));
        Attribute idAttribute = element.getAttributeByName(new QName("id"));
        if (idAttribute != null) {
            Object object2 = idAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"idAttribute.value");
            Integer id = ResourceUtilsKt.parseResourceId((String)object2);
            if (id == null) {
                object2 = element.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object2), "Invalid resource Id '" + idAttribute.getValue() + "' in <public> resource.");
                XmlUtilKt.walkToEndOfElement(element, eventReader);
                return false;
            }
            parsedResource.setResourceId(id);
        }
        if (parsedType == AaptResourceType.ID) {
            parsedResource.setValue(new Id());
        }
        parsedResource.setVisibility(ResourceVisibility.PUBLIC);
        XmlUtilKt.walkToEndOfElement(element, eventReader);
        return true;
    }

    private final boolean parsePublicGroup(StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        XMLEvent event;
        Attribute typeAttribute;
        Location location;
        BlameLogger blameLogger;
        if (this.options.getVisibility() != null) {
            Location location2 = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location2), "<public-group> tag not allowed with --visibility flag.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        if (!Intrinsics.areEqual((Object)parsedResource.getConfig(), (Object)new ConfigDescription(null, 1, null)) && (blameLogger = this.logger) != null) {
            String string = "Ignoring configuration '" + parsedResource.getConfig() + "' for <" + element.getName() + "> tag.";
            location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            blameLogger.warning(string, BlameLoggerKt.blameSource(this.source, location));
        }
        if ((typeAttribute = element.getAttributeByName(new QName("type"))) == null) {
            location = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location), "<public-group> must have a 'type' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        Object object = typeAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeAttribute.value");
        AaptResourceType parsedType = AaptResourceTypeKt.resourceTypeFromTag((String)object);
        if (parsedType == null) {
            object = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, (Location)object), "Invalid resource type '" + typeAttribute.getValue() + "' in <public-group>.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        Attribute idAttribute = element.getAttributeByName(new QName("first-id"));
        if (idAttribute == null) {
            Location location3 = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, location3), "<public-group> must have a 'first-id' attribute.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        Object object2 = idAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"idAttribute.value");
        Integer idVal = ResourceUtilsKt.parseResourceId((String)object2);
        if (idVal == null) {
            object2 = element.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element.location");
            this.logError(BlameLoggerKt.blameSource(this.source, (Location)object2), "Invalid resource ID '" + idAttribute.getValue() + "' in <public-group>. Integer expected.");
            XmlUtilKt.walkToEndOfElement(element, eventReader);
            return false;
        }
        Integer childId = idVal;
        String comment = "";
        boolean error = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            if (event.getEventType() == 5) {
                if (event == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.xml.stream.events.Comment");
                }
                String string = ((Comment)event).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event as Comment).text");
                comment = string;
                continue;
            }
            if (!event.isStartElement()) continue;
            StartElement childElement = event.asStartElement();
            QName childName = childElement.getName();
            Source itemSource = this.source.withLine(childElement.getLocation().getLineNumber());
            Object object3 = childName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"childName.namespaceURI");
            object3 = (CharSequence)object3;
            boolean bl = false;
            if (object3.length() == 0 && Intrinsics.areEqual((Object)childName.getLocalPart(), (Object)"public")) {
                Attribute nameAttribute = childElement.getAttributeByName(new QName("name"));
                if (nameAttribute == null) {
                    Location location4 = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location4), "<public> must have a 'name' attribute.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                Attribute childIdAttribute = childElement.getAttributeByName(new QName("id"));
                if (childIdAttribute != null) {
                    Location location5 = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location5, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location5), "'id' attribute is not allowed on <public> tags within a <public-group>.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                Attribute childTypeAttribute = childElement.getAttributeByName(new QName("type"));
                if (childTypeAttribute != null) {
                    Location location6 = childElement.getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)location6, (String)"childElement.location");
                    this.logError(BlameLoggerKt.blameSource(this.source, location6), "'type' attribute is not allowed on <public> tags within a <public-group>.");
                    Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                    XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                    error = true;
                    continue;
                }
                ParsedResource childResource = new ParsedResource(new ConfigDescription(null, 1, null), itemSource, comment);
                childResource.setName(new ResourceName("", parsedType, nameAttribute.getValue()));
                childResource.setResourceId(childId);
                childResource.setVisibility(ResourceVisibility.PUBLIC);
                parsedResource.getChildren().add(childResource);
                childId = childId + 1;
                Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
                XmlUtilKt.walkToEndOfElement(childElement, eventReader);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childName, (String)"childName");
            if (!TableExtractorKt.shouldIgnoreElement(childName)) {
                object3 = childElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"childElement.location");
                this.logError(BlameLoggerKt.blameSource(this.source, (Location)object3), "Unrecognized tag '" + childName + "' within an <public-group> resource.");
                error = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childElement, (String)"childElement");
            XmlUtilKt.walkToEndOfElement(childElement, eventReader);
        }
        return !error;
    }

    private final boolean addResourceToTable(ParsedResource parsedResource) {
        OverlayableItem overlayableItem;
        if (parsedResource.getVisibility() != ResourceVisibility.UNDEFINED) {
            Visibility visibility = new Visibility(parsedResource.getSource(), parsedResource.getComment(), parsedResource.getVisibility());
            if (!this.table.setVisibilityWithId(parsedResource.getName(), visibility, parsedResource.getResourceId())) {
                return false;
            }
        }
        if (parsedResource.getAllowNew()) {
            AllowNew allowNew = new AllowNew(parsedResource.getSource(), parsedResource.getComment());
            if (!this.table.setAllowNew(parsedResource.getName(), allowNew)) {
                return false;
            }
        }
        if ((overlayableItem = parsedResource.getOverlayableItem()) != null && !this.table.setOverlayable(parsedResource.getName(), overlayableItem)) {
            return false;
        }
        Value resource = parsedResource.getValue();
        if (resource != null) {
            resource.setComment(parsedResource.getComment());
            resource.setSource(parsedResource.getSource());
            if (!this.table.addResourceWithId(parsedResource.getName(), parsedResource.getResourceId(), parsedResource.getConfig(), parsedResource.getProductString(), resource)) {
                return false;
            }
        }
        boolean error = false;
        for (ParsedResource child : parsedResource.getChildren()) {
            error = error || !this.addResourceToTable(child);
        }
        return !error;
    }

    public static final /* synthetic */ boolean access$parseAddResource(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseAddResource(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseArray(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseArray(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseAttr(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseAttr(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseConfigVarying(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseConfigVarying(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseDeclareStyleable(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseDeclareStyleable(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseIntegerArray(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseIntegerArray(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseSymbol(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseSymbol(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseMacro(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseMacro(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseOverlayable(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseOverlayable(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parsePlural(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parsePlural(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parsePublic(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parsePublic(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parsePublicGroup(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parsePublicGroup(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseStringArray(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseStringArray(element, eventReader, parsedResource);
    }

    public static final /* synthetic */ boolean access$parseStyle(TableExtractor $this, StartElement element, XMLEventReader eventReader, ParsedResource parsedResource) {
        return $this.parseStyle(element, eventReader, parsedResource);
    }
}

