/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.PseudoMethodAccent;
import com.android.aaptcompiler.PseudoMethodBidi;
import com.android.aaptcompiler.PseudoMethodImpl;
import com.android.aaptcompiler.PseudoMethodNone;
import com.android.aaptcompiler.android.UtilKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/android/aaptcompiler/Pseudolocalizer;", "", "method", "Lcom/android/aaptcompiler/Pseudolocalizer$Method;", "(Lcom/android/aaptcompiler/Pseudolocalizer$Method;)V", "implementation", "Lcom/android/aaptcompiler/PseudoMethodImpl;", "<set-?>", "", "lastDepth", "getLastDepth", "()I", "end", "", "setMethod", "", "start", "text", "originalText", "Method", "aaptcompiler"})
public final class Pseudolocalizer {
    @NotNull
    private PseudoMethodImpl implementation;
    private int lastDepth;

    public Pseudolocalizer(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.implementation = method.getMethod();
    }

    public final int getLastDepth() {
        return this.lastDepth;
    }

    public final void setMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        this.implementation = method.getMethod();
    }

    @NotNull
    public final String start() {
        return this.implementation.start();
    }

    @NotNull
    public final String end() {
        return this.implementation.end();
    }

    @NotNull
    public final String text(@NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        StringBuilder out = new StringBuilder();
        int depth = this.lastDepth;
        int lastPos = 0;
        int pos = 0;
        int size = originalText.length();
        boolean escaped = false;
        while (pos < size) {
            char currentChar = originalText.charAt(pos);
            if (escaped) {
                escaped = false;
                ++pos;
                continue;
            }
            if (currentChar == '\'') {
                escaped = true;
                ++pos;
                continue;
            }
            if (currentChar == '{') {
                ++depth;
            } else if (currentChar == '}' && UtilKt.isTruthy(depth)) {
                --depth;
            }
            if (this.lastDepth != depth || pos == size - 1) {
                int chunkSize;
                boolean pseudo = this.lastDepth % 2 == 0;
                int nextPos = pos;
                if (!pseudo || depth == this.lastDepth) {
                    ++nextPos;
                }
                if (UtilKt.isTruthy(chunkSize = nextPos - lastPos)) {
                    String chunk;
                    Intrinsics.checkNotNullExpressionValue((Object)originalText.substring(lastPos, nextPos), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (pseudo) {
                        chunk = this.implementation.text(chunk);
                    } else if (originalText.charAt(lastPos) == '{' && originalText.charAt(nextPos - 1) == '}') {
                        chunk = this.implementation.placeholder(chunk);
                    }
                    out.append(chunk);
                }
                if (pseudo && depth < this.lastDepth) {
                    out.append(this.implementation.end());
                } else if (!pseudo && depth > this.lastDepth) {
                    out.append(this.implementation.start());
                }
                lastPos = nextPos;
                this.lastDepth = depth;
            }
            ++pos;
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/aaptcompiler/Pseudolocalizer$Method;", "", "(Ljava/lang/String;I)V", "getMethod", "Lcom/android/aaptcompiler/PseudoMethodImpl;", "NONE", "ACCENT", "BIDI", "aaptcompiler"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method NONE = new Method();
        public static final /* enum */ Method ACCENT = new Method();
        public static final /* enum */ Method BIDI = new Method();
        private static final /* synthetic */ Method[] $VALUES;

        @NotNull
        public final PseudoMethodImpl getMethod() {
            PseudoMethodImpl pseudoMethodImpl;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    pseudoMethodImpl = PseudoMethodNone.INSTANCE;
                    break;
                }
                case 2: {
                    pseudoMethodImpl = new PseudoMethodAccent();
                    break;
                }
                case 3: {
                    pseudoMethodImpl = PseudoMethodBidi.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pseudoMethodImpl;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        static {
            $VALUES = methodArray = new Method[]{Method.NONE, Method.ACCENT, Method.BIDI};
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Method.values().length];
                nArray[Method.NONE.ordinal()] = 1;
                nArray[Method.ACCENT.ordinal()] = 2;
                nArray[Method.BIDI.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

