/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aapt.Resources;
import com.android.aaptcompiler.AaptResourceType;
import com.android.aaptcompiler.AaptResourceTypeKt;
import com.android.aaptcompiler.BlameLogger;
import com.android.aaptcompiler.BlameLoggerKt;
import com.android.aaptcompiler.Container;
import com.android.aaptcompiler.PseudolocaleGenerator;
import com.android.aaptcompiler.Reference;
import com.android.aaptcompiler.ResourceCompilationException;
import com.android.aaptcompiler.ResourceCompiler;
import com.android.aaptcompiler.ResourceCompilerOptions;
import com.android.aaptcompiler.ResourceEntry;
import com.android.aaptcompiler.ResourceFile;
import com.android.aaptcompiler.ResourceGroup;
import com.android.aaptcompiler.ResourceName;
import com.android.aaptcompiler.ResourcePathData;
import com.android.aaptcompiler.ResourcePathDataKt;
import com.android.aaptcompiler.ResourceTable;
import com.android.aaptcompiler.ResourceTablePackage;
import com.android.aaptcompiler.SourcedResourceName;
import com.android.aaptcompiler.TableExtractor;
import com.android.aaptcompiler.TableExtractorOptions;
import com.android.aaptcompiler.XmlProcessor;
import com.android.aaptcompiler.XmlResource;
import com.android.aaptcompiler.proto.ProtoSerializeKt;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007\u001a*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a*\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a&\u0010\u0015\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a(\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a*\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a6\u0010\u0018\u001a \u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"PATCH_9_EXTENSION", "", "PNG_EXTENSION", "RESOURCE_TABLE_EXTENSION", "VALUES_DIRECTORY_PREFIX", "XML_EXTENSION", "canCompileResourceInJvm", "", "file", "Ljava/io/File;", "requirePngCrunching", "compileFile", "", "pathData", "Lcom/android/aaptcompiler/ResourcePathData;", "outputDirectory", "options", "Lcom/android/aaptcompiler/ResourceCompilerOptions;", "logger", "Lcom/android/aaptcompiler/BlameLogger;", "compilePng", "compileResource", "compileTable", "compileXml", "getCompileMethod", "Lkotlin/Function4;", "getVisibility", "Lcom/android/resources/ResourceVisibility;", "values", "", "Lcom/android/aaptcompiler/ResourceEntry;", "type", "Lcom/android/aaptcompiler/AaptResourceType;", "aaptcompiler"})
@JvmName(name="ResourceCompiler")
public final class ResourceCompiler {
    @NotNull
    private static final String VALUES_DIRECTORY_PREFIX = "values";
    @NotNull
    private static final String XML_EXTENSION = "xml";
    @NotNull
    private static final String RESOURCE_TABLE_EXTENSION = "arsc";
    @NotNull
    private static final String PATCH_9_EXTENSION = "9.png";
    @NotNull
    private static final String PNG_EXTENSION = "png";

    public static final boolean canCompileResourceInJvm(@NotNull File file, boolean requirePngCrunching) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isHidden()) {
            return true;
        }
        ResourcePathData pathData = ResourcePathDataKt.extractPathData$default(file, null, 2, null);
        if (Intrinsics.areEqual((Object)pathData.getResourceDirectory(), (Object)VALUES_DIRECTORY_PREFIX) && Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
            return true;
        }
        ResourceType resourceType = ResourceType.fromFolderName((String)pathData.getResourceDirectory());
        if (resourceType == null) {
            return false;
        }
        ResourceType type = resourceType;
        if (type != ResourceType.RAW) {
            if (Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
                return true;
            }
            if (StringsKt.endsWith$default((String)pathData.getExtension(), (String)PNG_EXTENSION, (boolean)false, (int)2, null)) {
                return !Intrinsics.areEqual((Object)pathData.getExtension(), (Object)PATCH_9_EXTENSION) && !requirePngCrunching;
            }
        }
        return true;
    }

    public static final void compileResource(@NotNull File file, @NotNull File outputDirectory, @NotNull ResourceCompilerOptions options, @NotNull BlameLogger logger) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (file.isHidden()) {
            BlameLogger.warning$default(logger, "Omitting file " + file.getAbsolutePath() + " because it is hidden.", null, 2, null);
            return;
        }
        String string = options.getSourcePath();
        if (string == null) {
            string = file.getAbsolutePath();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"options.sourcePath ?: file.absolutePath");
        ResourcePathData pathData = ResourcePathDataKt.extractPathData(file, string);
        Function4<ResourcePathData, File, ResourceCompilerOptions, BlameLogger, Unit> compileFunction = ResourceCompiler.getCompileMethod(pathData, logger);
        try {
            compileFunction.invoke((Object)pathData, (Object)outputDirectory, (Object)options, (Object)logger);
        }
        catch (Exception e) {
            logger.info("Failed to compile file", BlameLoggerKt.blameSource$default(pathData.getSource(), null, null, 6, null));
            String message = "Resource compilation failed (" + e.getMessage() + ". Cause: " + e.getCause() + "). Check logs for more details.";
            throw new ResourceCompilationException(message, e);
        }
    }

    private static final Function4<ResourcePathData, File, ResourceCompilerOptions, BlameLogger, Unit> getCompileMethod(ResourcePathData pathData, BlameLogger logger) {
        if (Intrinsics.areEqual((Object)pathData.getResourceDirectory(), (Object)VALUES_DIRECTORY_PREFIX) && Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
            pathData.setExtension(RESOURCE_TABLE_EXTENSION);
            return getCompileMethod.1.INSTANCE;
        }
        ResourceType type = ResourceType.fromFolderName((String)pathData.getResourceDirectory());
        if (type == null) {
            String errorMsg = "Invalid resource type '" + pathData.getResourceDirectory() + "' for file " + pathData.getFile().getAbsolutePath();
            BlameLogger.warning$default(logger, errorMsg, null, 2, null);
            throw new IllegalStateException(errorMsg.toString());
        }
        if (type != ResourceType.RAW) {
            if (Intrinsics.areEqual((Object)pathData.getExtension(), (Object)XML_EXTENSION)) {
                return getCompileMethod.2.INSTANCE;
            }
            if (StringsKt.endsWith$default((String)pathData.getExtension(), (String)PNG_EXTENSION, (boolean)false, (int)2, null)) {
                return getCompileMethod.3.INSTANCE;
            }
        }
        return getCompileMethod.4.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void compileTable(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        BlameLogger.info$default(logger, "Compiling XML table " + pathData.getFile().getAbsolutePath() + " to " + outputFile, null, 2, null);
        ResourceTable table = new ResourceTable(false, logger, 1, null);
        TableExtractorOptions extractorOptions = new TableExtractorOptions(!StringsKt.contains$default((CharSequence)pathData.getName(), (CharSequence)"donottranslate", (boolean)false, (int)2, null), !options.getLegacyMode(), options.getVisibility());
        TableExtractor tableExtractor = new TableExtractor(table, pathData.getSource(), pathData.getConfig(), extractorOptions, logger);
        Closeable closeable = new FileInputStream(pathData.getFile());
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            try {
                tableExtractor.extract(it);
            }
            catch (Exception e) {
                throw new ResourceCompilationException("Failed to compile values resource file " + pathData.getFile(), e);
            }
            if (options.getPseudolocalize() && extractorOptions.getTranslatable()) {
                new PseudolocaleGenerator().consume(table);
            }
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ResourceTable.createPackage$default(table, "", (byte)0, 2, null);
        table.sort();
        Container container = new Container(new FileOutputStream(outputFile), 1);
        Resources.ResourceTable pbTable = ProtoSerializeKt.serializeTableToPb$default(table, null, 2, null);
        container.addResTableEntry(pbTable);
        if (options.getPartialRFile() != null) {
            StringBuilder builder = new StringBuilder();
            Iterable $this$forEach$iv = table.getPackages$aaptcompiler();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceTablePackage pkg = (ResourceTablePackage)element$iv;
                boolean bl = false;
                if (((CharSequence)pkg.getName()).length() == 0) {
                    Iterable $this$forEach$iv2 = pkg.getGroups$aaptcompiler();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        ResourceGroup group = (ResourceGroup)element$iv2;
                        boolean bl2 = false;
                        if (group.getType() == AaptResourceType.MACRO) continue;
                        String javaType = group.getType() == AaptResourceType.STYLEABLE ? "int[]" : "int";
                        Map $this$forEach$iv3 = group.getEntries$aaptcompiler();
                        boolean $i$f$forEach3 = false;
                        Iterator iterator = $this$forEach$iv3.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv3;
                            Map.Entry entry = element$iv3 = iterator.next();
                            boolean bl3 = false;
                            Collection<ResourceEntry> collection = ((SortedMap)entry.getValue()).values();
                            Intrinsics.checkNotNullExpressionValue(collection, (String)"entry.value.values");
                            ResourceVisibility visibility = ResourceCompiler.getVisibility(collection, group.getType());
                            StringBuilder stringBuilder = builder.append(visibility.getName() + " " + javaType + " " + group.getType().getTagName() + " " + entry.getKey());
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                            StringsKt.appendln((StringBuilder)stringBuilder);
                            if (group.getType() != AaptResourceType.STYLEABLE) continue;
                            Iterable $this$forEach$iv4 = group.getStyleable$aaptcompiler(entry).getEntries();
                            boolean $i$f$forEach4 = false;
                            for (Object element$iv4 : $this$forEach$iv4) {
                                Reference it = (Reference)element$iv4;
                                boolean bl4 = false;
                                CharSequence charSequence = it.getName().getPck();
                                String childPackage = !(charSequence == null || charSequence.length() == 0) ? "_" + it.getName().getPck() : "";
                                StringBuilder stringBuilder2 = builder.append("public int styleable " + entry.getKey() + childPackage + "_" + it.getName().getEntry());
                                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                                StringsKt.appendln((StringBuilder)stringBuilder2);
                            }
                        }
                    }
                }
                FileUtils.writeToFile((File)options.getPartialRFile(), (String)builder.toString());
            }
        }
    }

    private static final ResourceVisibility getVisibility(Collection<ResourceEntry> values, AaptResourceType type) {
        if (type == AaptResourceType.STYLEABLE) {
            return ResourceVisibility.PUBLIC;
        }
        boolean foundPublic = false;
        boolean foundPrivate = false;
        Iterable $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceEntry it = (ResourceEntry)element$iv;
            boolean bl = false;
            if (it.getVisibility().getLevel() == ResourceVisibility.PUBLIC) {
                foundPublic = true;
                continue;
            }
            if (it.getVisibility().getLevel() != ResourceVisibility.PRIVATE) continue;
            foundPrivate = true;
        }
        if (foundPublic && foundPrivate) {
            throw new IllegalStateException(("Resource cannot be both public and private: " + type.getTagName() + " " + ((ResourceEntry)CollectionsKt.first((Iterable)values)).getName()).toString());
        }
        if (foundPublic) {
            return ResourceVisibility.PUBLIC;
        }
        if (foundPrivate) {
            return ResourceVisibility.PRIVATE;
        }
        return ResourceVisibility.PRIVATE_XML_ONLY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void compileFile(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        BlameLogger blameLogger = logger;
        if (blameLogger != null) {
            BlameLogger.info$default(blameLogger, "Compiling file " + pathData.getFile().getAbsolutePath() + " to " + outputFile, null, 2, null);
        }
        Closeable closeable = new FileInputStream(pathData.getFile());
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            AaptResourceType aaptResourceType = AaptResourceTypeKt.resourceTypeFromTag(pathData.getResourceDirectory());
            Intrinsics.checkNotNull((Object)((Object)aaptResourceType));
            ResourceFile resourceFile = new ResourceFile(new ResourceName("", aaptResourceType, pathData.getName()), pathData.getConfig(), pathData.getSource(), ResourceFile.Type.Unknown, null, 16, null);
            Container container = new Container(new FileOutputStream(outputFile), 1);
            container.addFileEntry(it, resourceFile);
            if (options.getPartialRFile() != null) {
                AaptResourceType aaptResourceType2 = pathData.getType();
                Intrinsics.checkNotNull((Object)((Object)aaptResourceType2));
                String partialR = "default int " + aaptResourceType2.getTagName() + " " + pathData.getName();
                FileUtils.writeToFile((File)options.getPartialRFile(), (String)partialR);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void compileXml(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        File outputFile = new File(outputDirectory, pathData.getIntermediateContainerFilename());
        BlameLogger blameLogger = logger;
        if (blameLogger != null) {
            BlameLogger.info$default(blameLogger, "Compiling xml file " + pathData.getFile().getAbsolutePath() + " to " + outputFile, null, 2, null);
        }
        AaptResourceType aaptResourceType = pathData.getType();
        Intrinsics.checkNotNull((Object)((Object)aaptResourceType));
        ResourceFile fileToProcess = new ResourceFile(new ResourceName("", aaptResourceType, pathData.getName()), pathData.getConfig(), pathData.getSource(), ResourceFile.Type.ProtoXml, null, 16, null);
        Closeable closeable = new FileInputStream(pathData.getFile());
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            XmlProcessor xmlProcessor = new XmlProcessor(pathData.getSource(), logger);
            try {
                xmlProcessor.process(fileToProcess, it);
            }
            catch (Exception e) {
                BlameLogger blameLogger2 = logger;
                throw new ResourceCompilationException("Failed to compile resource file: " + (blameLogger2 != null ? blameLogger2.getOutputSource$aaptcompiler(BlameLoggerKt.blameSource$default(pathData.getSource(), null, null, 6, null)) : null), e);
            }
            Container container = new Container(new FileOutputStream(outputFile), xmlProcessor.getXmlResources().size());
            for (XmlResource resource : xmlProcessor.getXmlResources()) {
                container.addXmlEntry(resource);
            }
            if (options.getPartialRFile() != null) {
                StringBuilder builder = new StringBuilder();
                StringBuilder stringBuilder = builder.append("default int " + pathData.getType().getTagName() + " " + pathData.getName());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                Iterable $this$forEach$iv = fileToProcess.getExportedSymbols();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SourcedResourceName id = (SourcedResourceName)element$iv;
                    boolean bl2 = false;
                    StringBuilder stringBuilder2 = builder.append("default int id " + id.getName().getEntry());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder2);
                }
                FileUtils.writeToFile((File)options.getPartialRFile(), (String)builder.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void compilePng(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        BlameLogger blameLogger = logger;
        if (blameLogger != null) {
            BlameLogger.info$default(blameLogger, "Compiling image file " + pathData.getFile().getAbsolutePath(), null, 2, null);
        }
        if (Intrinsics.areEqual((Object)pathData.getExtension(), (Object)PATCH_9_EXTENSION)) {
            throw new IllegalStateException("Patch 9 PNG processing is not supported with the JVM Android resource compiler.".toString());
        }
        if (options.getRequirePngCrunching()) {
            throw new IllegalStateException("PNG crunching is not supported with the JVM Android resource compiler.".toString());
        }
        ResourceCompiler.compileFile(pathData, outputDirectory, options, logger);
    }

    public static final /* synthetic */ void access$compileTable(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        ResourceCompiler.compileTable(pathData, outputDirectory, options, logger);
    }

    public static final /* synthetic */ void access$compileXml(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        ResourceCompiler.compileXml(pathData, outputDirectory, options, logger);
    }

    public static final /* synthetic */ void access$compilePng(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        ResourceCompiler.compilePng(pathData, outputDirectory, options, logger);
    }

    public static final /* synthetic */ void access$compileFile(ResourcePathData pathData, File outputDirectory, ResourceCompilerOptions options, BlameLogger logger) {
        ResourceCompiler.compileFile(pathData, outputDirectory, options, logger);
    }
}

