/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler.android;

import com.android.aaptcompiler.FloatParsingKt;
import com.android.aaptcompiler.android.ResValue;
import com.android.aaptcompiler.android.UnitEntry;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"unitSuffixes", "", "Lcom/android/aaptcompiler/android/UnitEntry;", "parseHex", "", "codePoint", "parseUnitType", "string", "", "stringToFloat", "Lcom/android/aaptcompiler/android/ResValue;", "stringToInt", "aaptcompiler"})
public final class ResourceTypesKt {
    @NotNull
    private static final List<UnitEntry> unitSuffixes;

    public static final int parseHex(int codePoint) {
        int n;
        block1: {
            int n2;
            block0: {
                n2 = codePoint;
                boolean bl = 48 <= n2 ? n2 < 58 : false;
                if (!bl) break block0;
                n = codePoint - 48;
                break block1;
            }
            n = (65 <= n2 ? n2 < 71 : false) ? codePoint - 65 + 10 : ((97 <= n2 ? n2 < 103 : false) ? codePoint - 97 + 10 : -1);
        }
        return n;
    }

    @Nullable
    public static final ResValue stringToInt(@NotNull String string) {
        boolean isNegative;
        long value;
        int index;
        int codePointCount;
        String trimmedString;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                trimmedString = ((Object)StringsKt.trimStart((CharSequence)string)).toString();
                if (((CharSequence)trimmedString).length() == 0) {
                    return null;
                }
                codePointCount = trimmedString.codePointCount(0, trimmedString.length());
                index = 0;
                value = 0L;
                isNegative = false;
                if (trimmedString.codePointAt(0) == 45) {
                    ++index;
                    isNegative = true;
                }
                if (codePointCount == index) break block14;
                int n = trimmedString.codePointAt(index);
                if (48 <= n ? n < 58 : false) break block15;
            }
            return null;
        }
        boolean isHex = false;
        if (codePointCount >= index + 2 && trimmedString.codePointAt(index) == 48 && trimmedString.codePointAt(index + 1) == 120) {
            isHex = true;
            index += 2;
            if (isNegative) {
                return null;
            }
            if (index == codePointCount) {
                return null;
            }
            while (index < codePointCount) {
                int hexValue = ResourceTypesKt.parseHex(trimmedString.codePointAt(index));
                if (hexValue == -1) {
                    return null;
                }
                ++index;
                if ((value = (value << 4) + (long)hexValue) <= 0xFFFFFFFFL) continue;
                return null;
            }
        } else {
            isHex = false;
            while (index < codePointCount) {
                int codePoint = trimmedString.codePointAt(index);
                if (!(48 <= codePoint ? codePoint < 58 : false)) {
                    return null;
                }
                ++index;
                int decValue = codePoint - 48;
                value = value * (long)10 + (long)decValue;
                boolean bl = isNegative ? -value < Integer.MIN_VALUE : value > Integer.MAX_VALUE;
                boolean outOfBounds = bl;
                if (!outOfBounds) continue;
                return null;
            }
        }
        if (isNegative) {
            value = -value;
        }
        return new ResValue(isHex ? ResValue.DataType.INT_HEX : ResValue.DataType.INT_DEC, (int)value, 0, 4, null);
    }

    private static final UnitEntry parseUnitType(String string) {
        for (UnitEntry entry : unitSuffixes) {
            if (!StringsKt.endsWith$default((String)string, (String)entry.getName(), (boolean)false, (int)2, null)) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    public static final ResValue stringToFloat(@NotNull String string) {
        int suffixIndex;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String trimmedString = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (((CharSequence)trimmedString).length() == 0 || trimmedString.length() > 128) {
            return null;
        }
        UnitEntry entry = ResourceTypesKt.parseUnitType(trimmedString);
        int n = suffixIndex = entry != null ? StringsKt.lastIndexOf$default((CharSequence)trimmedString, (String)entry.getName(), (int)0, (boolean)false, (int)6, null) : trimmedString.length();
        if (suffixIndex == 0 || Character.isWhitespace(trimmedString.codePointAt(suffixIndex - 1))) {
            return null;
        }
        String string2 = trimmedString.substring(0, suffixIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        Object stringToParse = string2;
        Object object = entry;
        if (ResourceTypesKt.parseHex(object != null && (object = ((UnitEntry)object).getName()) != null ? ((String)object).codePointAt(0) : 0) != -1 && StringsKt.contains((CharSequence)trimmedString, (CharSequence)"0x", (boolean)true) && !StringsKt.contains$default((CharSequence)((CharSequence)stringToParse), (char)'p', (boolean)false, (int)2, null)) {
            return null;
        }
        Float parsedValue = FloatParsingKt.parseFloat((String)stringToParse);
        if (parsedValue == null) {
            if (StringsKt.contains((CharSequence)((CharSequence)stringToParse), (CharSequence)"0x", (boolean)true) && !StringsKt.contains((CharSequence)((CharSequence)stringToParse), (char)'p', (boolean)true)) {
                stringToParse = (String)stringToParse + "p0";
            }
            Float f = parsedValue = StringsKt.toFloatOrNull((String)stringToParse);
            if (f != null) {
                f.floatValue();
            } else {
                return null;
            }
        }
        if (entry != null) {
            boolean negative;
            boolean bl = negative = (parsedValue = Float.valueOf(parsedValue.floatValue() * entry.getScale())).floatValue() < 0.0f;
            if (negative) {
                parsedValue = Float.valueOf(-parsedValue.floatValue());
            }
            long bits = (long)(parsedValue.floatValue() * (float)0x800000 + 0.5f);
            Pair pair = (bits & 0x7FFFFFL) == 0L ? new Pair((Object)0, (Object)23) : ((bits & 0xFFFFFFFFFF800000L) == 0L ? new Pair((Object)3, (Object)0) : ((bits & Integer.MIN_VALUE) == 0L ? new Pair((Object)2, (Object)8) : ((bits & 0xFFFFFF8000000000L) == 0L ? new Pair((Object)1, (Object)16) : new Pair((Object)0, (Object)23))));
            int radix = ((Number)pair.component1()).intValue();
            int shift = ((Number)pair.component2()).intValue();
            int mantissa = (int)(bits >>> shift) & 0xFFFFFF;
            if (negative) {
                mantissa = -mantissa & 0xFFFFFF;
            }
            int dataValue = entry.getUnitValue() << 0 | radix << 4 | mantissa << 8;
            return new ResValue(entry.getDataType(), dataValue, 0, 4, null);
        }
        return new ResValue(ResValue.DataType.FLOAT, Float.floatToRawIntBits(parsedValue.floatValue()), 0, 4, null);
    }

    static {
        Object[] objectArray = new UnitEntry[]{new UnitEntry("px", ResValue.DataType.DIMENSION, 0, 0.0f, 8, null), new UnitEntry("dip", ResValue.DataType.DIMENSION, 1, 0.0f, 8, null), new UnitEntry("dp", ResValue.DataType.DIMENSION, 1, 0.0f, 8, null), new UnitEntry("sp", ResValue.DataType.DIMENSION, 2, 0.0f, 8, null), new UnitEntry("pt", ResValue.DataType.DIMENSION, 3, 0.0f, 8, null), new UnitEntry("in", ResValue.DataType.DIMENSION, 4, 0.0f, 8, null), new UnitEntry("mm", ResValue.DataType.DIMENSION, 5, 0.0f, 8, null), new UnitEntry("%", ResValue.DataType.FRACTION, 0, 0.01f), new UnitEntry("%p", ResValue.DataType.FRACTION, 1, 0.01f)};
        unitSuffixes = CollectionsKt.listOf((Object[])objectArray);
    }
}

