/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import android.aapt.pb.internal.ResourcesInternal;
import com.android.aapt.Resources;
import com.android.aaptcompiler.ResourceFile;
import com.android.aaptcompiler.XmlResource;
import com.android.aaptcompiler.proto.ProtoSerializeKt;
import com.google.protobuf.CodedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/aaptcompiler/Container;", "", "output", "Ljava/io/OutputStream;", "totalEntryCount", "", "<init>", "(Ljava/io/OutputStream;I)V", "getOutput", "()Ljava/io/OutputStream;", "getTotalEntryCount", "()I", "currentEntryCount", "addResTableEntry", "", "table", "Lcom/android/aapt/Resources$ResourceTable;", "addFileEntry", "input", "Ljava/io/InputStream;", "file", "Lcom/android/aaptcompiler/ResourceFile;", "addXmlEntry", "resource", "Lcom/android/aaptcompiler/XmlResource;", "addFileEntryImpl", "content", "", "writePadding", "padding", "codedOut", "Lcom/google/protobuf/CodedOutputStream;", "closeIfFinished", "EntryType", "Companion", "aaptcompiler"})
public final class Container {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputStream output;
    private final int totalEntryCount;
    private int currentEntryCount;
    public static final int FORMAT_MAGIC = 1414545729;
    public static final int FORMAT_VERSION = 1;
    public static final int RES_FILE_ENTRY_HEADER_SIZE = 12;

    public Container(@NotNull OutputStream output, int totalEntryCount) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
        this.totalEntryCount = totalEntryCount;
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)this.output);
        codedOut.writeFixed32NoTag(1414545729);
        codedOut.writeFixed32NoTag(1);
        codedOut.writeFixed32NoTag(this.totalEntryCount);
        codedOut.flush();
    }

    @NotNull
    public final OutputStream getOutput() {
        return this.output;
    }

    public final int getTotalEntryCount() {
        return this.totalEntryCount;
    }

    public final void addResTableEntry(@NotNull Resources.ResourceTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (this.currentEntryCount >= this.totalEntryCount) {
            throw new IllegalStateException("Too many entries being serialized.".toString());
        }
        ++this.currentEntryCount;
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)this.output);
        codedOut.writeFixed32NoTag(EntryType.RES_TABLE.getValue());
        int size = table.getSerializedSize();
        int padding = (4 - size % 4) % 4;
        codedOut.writeFixed64NoTag((long)size);
        table.writeTo(codedOut);
        Intrinsics.checkNotNull((Object)codedOut);
        this.writePadding(padding, codedOut);
        codedOut.flush();
        this.closeIfFinished();
    }

    public final void addFileEntry(@NotNull InputStream input, @NotNull ResourceFile file) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.addFileEntryImpl(ByteStreamsKt.readBytes((InputStream)input), file);
    }

    public final void addXmlEntry(@NotNull XmlResource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        byte[] byArray = resource.getXmlProto().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        this.addFileEntryImpl(byArray, resource.getFile());
    }

    private final void addFileEntryImpl(byte[] content, ResourceFile file) {
        if (this.currentEntryCount >= this.totalEntryCount) {
            throw new IllegalStateException("Too many entries being serialized.".toString());
        }
        ++this.currentEntryCount;
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)this.output);
        codedOut.writeFixed32NoTag(EntryType.RES_FILE.getValue());
        ResourcesInternal.CompiledFile compiledFile = ProtoSerializeKt.serializeCompiledFileToPb(file);
        int headerSize = compiledFile.getSerializedSize();
        int headerPadding = (4 - headerSize % 4) % 4;
        int dataSize = content.length;
        int dataPadding = (4 - dataSize % 4) % 4;
        long totalSize = 12L + (long)headerSize + (long)headerPadding + (long)dataSize + (long)dataPadding;
        codedOut.writeFixed64NoTag(totalSize);
        codedOut.writeFixed32NoTag(headerSize);
        codedOut.writeFixed64NoTag((long)dataSize);
        compiledFile.writeTo(codedOut);
        Intrinsics.checkNotNull((Object)codedOut);
        this.writePadding(headerPadding, codedOut);
        codedOut.write(content, 0, dataSize);
        this.writePadding(dataPadding, codedOut);
        codedOut.flush();
        this.closeIfFinished();
    }

    private final void writePadding(int padding, CodedOutputStream codedOut) {
        int i = 1;
        if (i <= padding) {
            while (true) {
                codedOut.writeRawByte((byte)0);
                if (i == padding) break;
                ++i;
            }
        }
    }

    private final void closeIfFinished() {
        if (this.currentEntryCount == this.totalEntryCount) {
            this.output.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/aaptcompiler/Container$Companion;", "", "<init>", "()V", "FORMAT_MAGIC", "", "FORMAT_VERSION", "RES_FILE_ENTRY_HEADER_SIZE", "aaptcompiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/aaptcompiler/Container$EntryType;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "getValue", "()I", "RES_TABLE", "RES_FILE", "aaptcompiler"})
    public static final class EntryType
    extends Enum<EntryType> {
        private final int value;
        public static final /* enum */ EntryType RES_TABLE = new EntryType(0);
        public static final /* enum */ EntryType RES_FILE = new EntryType(1);
        private static final /* synthetic */ EntryType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private EntryType(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static EntryType[] values() {
            return (EntryType[])$VALUES.clone();
        }

        public static EntryType valueOf(String value) {
            return Enum.valueOf(EntryType.class, value);
        }

        @NotNull
        public static EnumEntries<EntryType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = entryTypeArray = new EntryType[]{EntryType.RES_TABLE, EntryType.RES_FILE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

