/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.asn1.ber;

public abstract class BerEncoding {
    public static final int ID_FLAG_CONSTRUCTED_ENCODING = 32;
    public static final int TAG_CLASS_UNIVERSAL = 0;
    public static final int TAG_CLASS_APPLICATION = 1;
    public static final int TAG_CLASS_CONTEXT_SPECIFIC = 2;
    public static final int TAG_CLASS_PRIVATE = 3;
    public static final int TAG_NUMBER_INTEGER = 2;
    public static final int TAG_NUMBER_OCTET_STRING = 4;
    public static final int TAG_NUMBER_NULL = 5;
    public static final int TAG_NUMBER_OBJECT_IDENTIFIER = 6;
    public static final int TAG_NUMBER_SEQUENCE = 16;
    public static final int TAG_NUMBER_SET = 17;

    private BerEncoding() {
    }

    public static String tagNumberToString(int tagNumber) {
        switch (tagNumber) {
            case 2: {
                return "INTEGER";
            }
            case 4: {
                return "OCTET STRING";
            }
            case 5: {
                return "NULL";
            }
            case 6: {
                return "OBJECT IDENTIFIER";
            }
            case 16: {
                return "SEQUENCE";
            }
            case 17: {
                return "SET";
            }
        }
        return "0x" + Integer.toHexString(tagNumber);
    }

    public static boolean isConstructed(byte firstIdentifierByte) {
        return (firstIdentifierByte & 0x20) != 0;
    }

    public static int getTagClass(byte firstIdentifierByte) {
        return (firstIdentifierByte & 0xFF) >> 6;
    }

    public static int getTagNumber(byte firstIdentifierByte) {
        return firstIdentifierByte & 0x1F;
    }
}

