/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v1;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.jar.ManifestParser;
import com.android.apksig.internal.util.InclusiveIntRange;
import com.android.apksig.internal.util.MessageDigestSink;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public abstract class V1SchemeVerifier {
    private static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final String[] JB_MR2_AND_NEWER_DIGEST_ALGS = new String[]{"SHA-512", "SHA-384", "SHA-256", "SHA-1"};
    private static final Map<String, String> UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL = new HashMap<String, String>(8);
    private static final Map<String, Integer> MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST;

    private V1SchemeVerifier() {
    }

    public static Result verify(DataSource apk, ApkUtils.ZipSections apkSections, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds, int minSdkVersion, int maxSdkVersion) throws IOException, ApkFormatException, NoSuchAlgorithmException {
        if (minSdkVersion > maxSdkVersion) {
            throw new IllegalArgumentException("minSdkVersion (" + minSdkVersion + ") > maxSdkVersion (" + maxSdkVersion + ")");
        }
        Result result = new Result();
        List<CentralDirectoryRecord> cdRecords = V1SchemeVerifier.parseZipCentralDirectory(apk, apkSections);
        Set<String> cdEntryNames = V1SchemeVerifier.checkForDuplicateEntries(cdRecords, result);
        if (result.containsErrors()) {
            return result;
        }
        Signers.verify(apk, apkSections.getZipCentralDirectoryOffset(), cdRecords, cdEntryNames, supportedApkSigSchemeNames, foundApkSigSchemeIds, minSdkVersion, maxSdkVersion, result);
        return result;
    }

    private static Set<String> checkForDuplicateEntries(List<CentralDirectoryRecord> cdRecords, Result result) {
        HashSet<String> cdEntryNames = new HashSet<String>(cdRecords.size());
        HashSet<String> duplicateCdEntryNames = null;
        for (CentralDirectoryRecord cdRecord : cdRecords) {
            String entryName = cdRecord.getName();
            if (cdEntryNames.add(entryName)) continue;
            if (duplicateCdEntryNames == null) {
                duplicateCdEntryNames = new HashSet<String>();
            }
            if (!duplicateCdEntryNames.add(entryName)) continue;
            result.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_ZIP_ENTRY, new Object[]{entryName});
        }
        return cdEntryNames;
    }

    private static Collection<NamedDigest> getDigestsToVerify(ManifestParser.Section section, String digestAttrSuffix, int minSdkVersion, int maxSdkVersion) {
        Base64.Decoder base64Decoder = Base64.getDecoder();
        ArrayList<NamedDigest> result = new ArrayList<NamedDigest>(1);
        if (minSdkVersion < 18) {
            String algs = section.getAttributeValue("Digest-Algorithms");
            if (algs == null) {
                algs = "SHA SHA1";
            }
            StringTokenizer tokens = new StringTokenizer(algs);
            while (tokens.hasMoreTokens()) {
                String alg = tokens.nextToken();
                String attrName = alg + digestAttrSuffix;
                String digestBase64 = section.getAttributeValue(attrName);
                if (digestBase64 == null || (alg = V1SchemeVerifier.getCanonicalJcaMessageDigestAlgorithm(alg)) == null || V1SchemeVerifier.getMinSdkVersionFromWhichSupportedInManifestOrSignatureFile(alg) > minSdkVersion) continue;
                result.add(new NamedDigest(alg, base64Decoder.decode(digestBase64)));
                break;
            }
            if (result.isEmpty()) {
                return result;
            }
        }
        if (maxSdkVersion >= 18) {
            for (String alg : JB_MR2_AND_NEWER_DIGEST_ALGS) {
                String attrName = V1SchemeVerifier.getJarDigestAttributeName(alg, digestAttrSuffix);
                String digestBase64 = section.getAttributeValue(attrName);
                if (digestBase64 == null) continue;
                byte[] digest = base64Decoder.decode(digestBase64);
                byte[] digestInResult = V1SchemeVerifier.getDigest(result, alg);
                if (digestInResult != null && Arrays.equals(digestInResult, digest)) break;
                result.add(new NamedDigest(alg, digest));
                break;
            }
        }
        return result;
    }

    private static String getCanonicalJcaMessageDigestAlgorithm(String algorithm) {
        return UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.get(algorithm.toUpperCase(Locale.US));
    }

    public static int getMinSdkVersionFromWhichSupportedInManifestOrSignatureFile(String jcaAlgorithmName) {
        Integer result = MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.get(jcaAlgorithmName.toUpperCase(Locale.US));
        return result != null ? result : Integer.MAX_VALUE;
    }

    private static String getJarDigestAttributeName(String jcaDigestAlgorithm, String attrNameSuffix) {
        if ("SHA-1".equalsIgnoreCase(jcaDigestAlgorithm)) {
            return "SHA1" + attrNameSuffix;
        }
        return jcaDigestAlgorithm + attrNameSuffix;
    }

    private static byte[] getDigest(Collection<NamedDigest> digests, String jcaDigestAlgorithm) {
        for (NamedDigest digest : digests) {
            if (!digest.jcaDigestAlgorithm.equalsIgnoreCase(jcaDigestAlgorithm)) continue;
            return digest.digest;
        }
        return null;
    }

    public static List<CentralDirectoryRecord> parseZipCentralDirectory(DataSource apk, ApkUtils.ZipSections apkSections) throws IOException, ApkFormatException {
        long cdSizeBytes = apkSections.getZipCentralDirectorySizeBytes();
        if (cdSizeBytes > Integer.MAX_VALUE) {
            throw new ApkFormatException("ZIP Central Directory too large: " + cdSizeBytes);
        }
        long cdOffset = apkSections.getZipCentralDirectoryOffset();
        ByteBuffer cd = apk.getByteBuffer(cdOffset, (int)cdSizeBytes);
        cd.order(ByteOrder.LITTLE_ENDIAN);
        int expectedCdRecordCount = apkSections.getZipCentralDirectoryRecordCount();
        ArrayList<CentralDirectoryRecord> cdRecords = new ArrayList<CentralDirectoryRecord>(expectedCdRecordCount);
        for (int i = 0; i < expectedCdRecordCount; ++i) {
            CentralDirectoryRecord cdRecord;
            int offsetInsideCd = cd.position();
            try {
                cdRecord = CentralDirectoryRecord.getRecord(cd);
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP Central Directory record #" + (i + 1) + " at file offset " + (cdOffset + (long)offsetInsideCd), e);
            }
            String entryName = cdRecord.getName();
            if (entryName.endsWith("/")) continue;
            cdRecords.add(cdRecord);
        }
        return cdRecords;
    }

    private static boolean isJarEntryDigestNeededInManifest(String entryName) {
        if (entryName.startsWith("META-INF/")) {
            return false;
        }
        return !entryName.endsWith("/");
    }

    private static Set<Signer> verifyJarEntriesAgainstManifestAndSigners(DataSource apk, long cdOffsetInApk, Collection<CentralDirectoryRecord> cdRecords, Map<String, ManifestParser.Section> entryNameToManifestSection, List<Signer> signers, int minSdkVersion, int maxSdkVersion, Result result) throws ApkFormatException, IOException, NoSuchAlgorithmException {
        ArrayList<CentralDirectoryRecord> cdRecordsSortedByLocalFileHeaderOffset = new ArrayList<CentralDirectoryRecord>(cdRecords);
        Collections.sort(cdRecordsSortedByLocalFileHeaderOffset, CentralDirectoryRecord.BY_LOCAL_FILE_HEADER_OFFSET_COMPARATOR);
        HashSet<String> manifestEntryNamesMissingFromApk = new HashSet<String>(entryNameToManifestSection.keySet());
        ArrayList<Signer> firstSignedEntrySigners = null;
        String firstSignedEntryName = null;
        for (CentralDirectoryRecord cdRecord : cdRecordsSortedByLocalFileHeaderOffset) {
            int i;
            String entryName = cdRecord.getName();
            manifestEntryNamesMissingFromApk.remove(entryName);
            if (!V1SchemeVerifier.isJarEntryDigestNeededInManifest(entryName)) continue;
            ManifestParser.Section manifestSection = entryNameToManifestSection.get(entryName);
            if (manifestSection == null) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST, new Object[]{entryName});
                continue;
            }
            ArrayList<Signer> entrySigners = new ArrayList<Signer>(signers.size());
            for (Signer signer : signers) {
                if (!signer.getSigFileEntryNames().contains(entryName)) continue;
                entrySigners.add(signer);
            }
            if (entrySigners.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_NOT_SIGNED, new Object[]{entryName});
                continue;
            }
            if (firstSignedEntrySigners == null) {
                firstSignedEntrySigners = entrySigners;
                firstSignedEntryName = entryName;
            } else if (!entrySigners.equals(firstSignedEntrySigners)) {
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_SIGNERS_MISMATCH, new Object[]{firstSignedEntryName, V1SchemeVerifier.getSignerNames(firstSignedEntrySigners), entryName, V1SchemeVerifier.getSignerNames(entrySigners)});
                continue;
            }
            ArrayList<NamedDigest> expectedDigests = new ArrayList<NamedDigest>(V1SchemeVerifier.getDigestsToVerify(manifestSection, "-Digest", minSdkVersion, maxSdkVersion));
            if (expectedDigests.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST, new Object[]{entryName});
                continue;
            }
            MessageDigest[] mds = new MessageDigest[expectedDigests.size()];
            for (i = 0; i < expectedDigests.size(); ++i) {
                mds[i] = V1SchemeVerifier.getMessageDigest(((NamedDigest)expectedDigests.get(i)).jcaDigestAlgorithm);
            }
            try {
                LocalFileRecord.outputUncompressedData(apk, cdRecord, cdOffsetInApk, new MessageDigestSink(mds));
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + entryName, e);
            }
            catch (IOException e) {
                throw new IOException("Failed to read entry: " + entryName, e);
            }
            for (i = 0; i < expectedDigests.size(); ++i) {
                NamedDigest expectedDigest = (NamedDigest)expectedDigests.get(i);
                byte[] actualDigest = mds[i].digest();
                if (Arrays.equals(expectedDigest.digest, actualDigest)) continue;
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY, new Object[]{entryName, expectedDigest.jcaDigestAlgorithm, MANIFEST_ENTRY_NAME, Base64.getEncoder().encodeToString(actualDigest), Base64.getEncoder().encodeToString(expectedDigest.digest)});
            }
        }
        if (firstSignedEntrySigners == null) {
            result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNED_ZIP_ENTRIES, new Object[0]);
            return Collections.emptySet();
        }
        return new HashSet<Signer>(firstSignedEntrySigners);
    }

    private static List<String> getSignerNames(List<Signer> signers) {
        if (signers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(signers.size());
        for (Signer signer : signers) {
            result.add(signer.getName());
        }
        return result;
    }

    private static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithm);
    }

    private static byte[] digest(String algorithm, byte[] data, int offset, int length) throws NoSuchAlgorithmException {
        MessageDigest md = V1SchemeVerifier.getMessageDigest(algorithm);
        md.update(data, offset, length);
        return md.digest();
    }

    private static byte[] digest(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        return V1SchemeVerifier.getMessageDigest(algorithm).digest(data);
    }

    static {
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("MD5", "MD5");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA1", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-1", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-256", "SHA-256");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-384", "SHA-384");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-512", "SHA-512");
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST = new HashMap<String, Integer>(5);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("MD5", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-1", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-256", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-384", 9);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-512", 9);
    }

    public static class Result {
        public boolean verified;
        public final List<SignerInfo> signers = new ArrayList<SignerInfo>();
        public final List<SignerInfo> ignoredSigners = new ArrayList<SignerInfo>();
        private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
        private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

        private boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            for (SignerInfo signer : this.signers) {
                if (!signer.containsErrors()) continue;
                return true;
            }
            return false;
        }

        private void addError(ApkVerifier.Issue msg, Object ... parameters) {
            this.mErrors.add(new ApkVerifier.IssueWithParams(msg, parameters));
        }

        private void addWarning(ApkVerifier.Issue msg, Object ... parameters) {
            this.mWarnings.add(new ApkVerifier.IssueWithParams(msg, parameters));
        }

        public List<ApkVerifier.IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<ApkVerifier.IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        public static class SignerInfo {
            public final String name;
            public final String signatureFileName;
            public final String signatureBlockFileName;
            public final List<X509Certificate> certChain = new ArrayList<X509Certificate>();
            private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
            private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

            private SignerInfo(String name, String signatureBlockFileName, String signatureFileName) {
                this.name = name;
                this.signatureBlockFileName = signatureBlockFileName;
                this.signatureFileName = signatureFileName;
            }

            private boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            private void addError(ApkVerifier.Issue msg, Object ... parameters) {
                this.mErrors.add(new ApkVerifier.IssueWithParams(msg, parameters));
            }

            private void addWarning(ApkVerifier.Issue msg, Object ... parameters) {
                this.mWarnings.add(new ApkVerifier.IssueWithParams(msg, parameters));
            }

            public List<ApkVerifier.IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<ApkVerifier.IssueWithParams> getWarnings() {
                return this.mWarnings;
            }
        }
    }

    private static class NamedDigest {
        private final String jcaDigestAlgorithm;
        private final byte[] digest;

        private NamedDigest(String jcaDigestAlgorithm, byte[] digest) {
            this.jcaDigestAlgorithm = jcaDigestAlgorithm;
            this.digest = digest;
        }
    }

    private static class Signer {
        private final String mName;
        private final Result.SignerInfo mResult;
        private final CentralDirectoryRecord mSignatureFileEntry;
        private final CentralDirectoryRecord mSignatureBlockEntry;
        private boolean mIgnored;
        private byte[] mSigFileBytes;
        private Set<String> mSigFileEntryNames;
        private static final String OID_DIGEST_MD5 = "1.2.840.113549.2.5";
        private static final String OID_DIGEST_SHA1 = "1.3.14.3.2.26";
        private static final String OID_DIGEST_SHA224 = "2.16.840.1.101.3.4.2.4";
        private static final String OID_DIGEST_SHA256 = "2.16.840.1.101.3.4.2.1";
        private static final String OID_DIGEST_SHA384 = "2.16.840.1.101.3.4.2.2";
        private static final String OID_DIGEST_SHA512 = "2.16.840.1.101.3.4.2.3";
        private static final String OID_SIG_RSA = "1.2.840.113549.1.1.1";
        private static final String OID_SIG_MD5_WITH_RSA = "1.2.840.113549.1.1.4";
        private static final String OID_SIG_SHA1_WITH_RSA = "1.2.840.113549.1.1.5";
        private static final String OID_SIG_SHA224_WITH_RSA = "1.2.840.113549.1.1.14";
        private static final String OID_SIG_SHA256_WITH_RSA = "1.2.840.113549.1.1.11";
        private static final String OID_SIG_SHA384_WITH_RSA = "1.2.840.113549.1.1.12";
        private static final String OID_SIG_SHA512_WITH_RSA = "1.2.840.113549.1.1.13";
        private static final String OID_SIG_DSA = "1.2.840.10040.4.1";
        private static final String OID_SIG_SHA1_WITH_DSA = "1.2.840.10040.4.3";
        private static final String OID_SIG_SHA224_WITH_DSA = "2.16.840.1.101.3.4.3.1";
        private static final String OID_SIG_SHA256_WITH_DSA = "2.16.840.1.101.3.4.3.2";
        private static final String OID_SIG_EC_PUBLIC_KEY = "1.2.840.10045.2.1";
        private static final String OID_SIG_SHA1_WITH_ECDSA = "1.2.840.10045.4.1";
        private static final String OID_SIG_SHA224_WITH_ECDSA = "1.2.840.10045.4.3.1";
        private static final String OID_SIG_SHA256_WITH_ECDSA = "1.2.840.10045.4.3.2";
        private static final String OID_SIG_SHA384_WITH_ECDSA = "1.2.840.10045.4.3.3";
        private static final String OID_SIG_SHA512_WITH_ECDSA = "1.2.840.10045.4.3.4";
        private static final Map<String, List<InclusiveIntRange>> SUPPORTED_SIG_ALG_OIDS = new HashMap<String, List<InclusiveIntRange>>();

        private Signer(String name, CentralDirectoryRecord sigBlockEntry, CentralDirectoryRecord sigFileEntry, Result.SignerInfo result) {
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_RSA, InclusiveIntRange.from(0));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_RSA, InclusiveIntRange.from(0));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.from(0));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_RSA, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_RSA, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_DSA, InclusiveIntRange.from(0));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.from(9));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_DSA, InclusiveIntRange.from(22));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_DSA, InclusiveIntRange.from(22));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_EC_PUBLIC_KEY, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_EC_PUBLIC_KEY, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_EC_PUBLIC_KEY, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_EC_PUBLIC_KEY, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_EC_PUBLIC_KEY, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.from(21));
            this.mName = name;
            this.mResult = result;
            this.mSignatureBlockEntry = sigBlockEntry;
            this.mSignatureFileEntry = sigFileEntry;
        }

        public String getName() {
            return this.mName;
        }

        public String getSignatureFileEntryName() {
            return this.mSignatureFileEntry.getName();
        }

        public String getSignatureBlockEntryName() {
            return this.mSignatureBlockEntry.getName();
        }

        void setIgnored() {
            this.mIgnored = true;
        }

        public boolean isIgnored() {
            return this.mIgnored;
        }

        public Set<String> getSigFileEntryNames() {
            return this.mSigFileEntryNames;
        }

        public Result.SignerInfo getResult() {
            return this.mResult;
        }

        public void verifySigBlockAgainstSigFile(DataSource apk, long cdStartOffset, int minSdkVersion, int maxSdkVersion) throws IOException, ApkFormatException, NoSuchAlgorithmException {
            ArrayList<X509Certificate> certChain;
            PKCS7 sigBlock;
            byte[] sigBlockBytes;
            try {
                sigBlockBytes = LocalFileRecord.getUncompressedData(apk, this.mSignatureBlockEntry, cdStartOffset);
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + this.mSignatureBlockEntry.getName(), e);
            }
            try {
                this.mSigFileBytes = LocalFileRecord.getUncompressedData(apk, this.mSignatureFileEntry, cdStartOffset);
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + this.mSignatureFileEntry.getName(), e);
            }
            try {
                sigBlock = new PKCS7(sigBlockBytes);
            }
            catch (IOException e) {
                if (e.getCause() instanceof CertificateException) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MALFORMED_CERTIFICATE, new Object[]{this.mSignatureBlockEntry.getName(), e});
                } else {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_PARSE_EXCEPTION, new Object[]{this.mSignatureBlockEntry.getName(), e});
                }
                return;
            }
            SignerInfo[] unverifiedSignerInfos = sigBlock.getSignerInfos();
            if (unverifiedSignerInfos == null || unverifiedSignerInfos.length == 0) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNERS, new Object[]{this.mSignatureBlockEntry.getName()});
                return;
            }
            SignerInfo verifiedSignerInfo = null;
            if (unverifiedSignerInfos != null && unverifiedSignerInfos.length > 0) {
                for (int i = 0; i < unverifiedSignerInfos.length; ++i) {
                    List<InclusiveIntRange> apiLevelsWhereDigestAndSigAlgorithmSupported;
                    SignerInfo unverifiedSignerInfo = unverifiedSignerInfos[i];
                    String digestAlgorithmOid = unverifiedSignerInfo.getDigestAlgorithmId().getOID().toString();
                    String signatureAlgorithmOid = unverifiedSignerInfo.getDigestEncryptionAlgorithmId().getOID().toString();
                    InclusiveIntRange desiredApiLevels = InclusiveIntRange.fromTo(minSdkVersion, maxSdkVersion);
                    List<InclusiveIntRange> apiLevelsWhereDigestAlgorithmNotSupported = desiredApiLevels.getValuesNotIn(apiLevelsWhereDigestAndSigAlgorithmSupported = this.getSigAlgSupportedApiLevels(digestAlgorithmOid, signatureAlgorithmOid));
                    if (!apiLevelsWhereDigestAlgorithmNotSupported.isEmpty()) {
                        this.mResult.addError(ApkVerifier.Issue.JAR_SIG_UNSUPPORTED_SIG_ALG, new Object[]{this.mSignatureBlockEntry.getName(), digestAlgorithmOid, signatureAlgorithmOid, String.valueOf(apiLevelsWhereDigestAlgorithmNotSupported)});
                        return;
                    }
                    try {
                        verifiedSignerInfo = sigBlock.verify(unverifiedSignerInfo, this.mSigFileBytes);
                    }
                    catch (SignatureException e) {
                        this.mResult.addError(ApkVerifier.Issue.JAR_SIG_VERIFY_EXCEPTION, new Object[]{this.mSignatureBlockEntry.getName(), this.mSignatureFileEntry.getName(), e});
                        return;
                    }
                    if (verifiedSignerInfo != null) break;
                    if (minSdkVersion >= 24) continue;
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_DID_NOT_VERIFY, new Object[]{this.mSignatureBlockEntry.getName(), this.mSignatureFileEntry.getName()});
                    return;
                }
            }
            if (verifiedSignerInfo == null) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNERS, new Object[]{this.mSignatureBlockEntry.getName()});
                return;
            }
            try {
                certChain = verifiedSignerInfo.getCertificateChain(sigBlock);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to obtain cert chain from " + this.mSignatureBlockEntry.getName(), e);
            }
            if (certChain == null || certChain.isEmpty()) {
                throw new RuntimeException("Verified SignerInfo does not have a certificate chain");
            }
            this.mResult.certChain.clear();
            this.mResult.certChain.addAll(certChain);
        }

        private static void addSupportedSigAlg(String digestAlgorithmOid, String signatureAlgorithmOid, InclusiveIntRange ... supportedApiLevels) {
            SUPPORTED_SIG_ALG_OIDS.put(digestAlgorithmOid + "with" + signatureAlgorithmOid, Arrays.asList(supportedApiLevels));
        }

        private List<InclusiveIntRange> getSigAlgSupportedApiLevels(String digestAlgorithmOid, String signatureAlgorithmOid) {
            List<InclusiveIntRange> result = SUPPORTED_SIG_ALG_OIDS.get(digestAlgorithmOid + "with" + signatureAlgorithmOid);
            return result != null ? result : Collections.emptyList();
        }

        public void verifySigFileAgainstManifest(byte[] manifestBytes, ManifestParser.Section manifestMainSection, Map<String, ManifestParser.Section> entryNameToManifestSection, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds, int minSdkVersion, int maxSdkVersion) throws NoSuchAlgorithmException {
            ManifestParser sf = new ManifestParser(this.mSigFileBytes);
            ManifestParser.Section sfMainSection = sf.readSection();
            if (sfMainSection.getAttributeValue(Attributes.Name.SIGNATURE_VERSION) == null) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MISSING_VERSION_ATTR_IN_SIG_FILE, new Object[]{this.mSignatureFileEntry.getName()});
                this.setIgnored();
                return;
            }
            if (maxSdkVersion >= 24) {
                this.checkForStrippedApkSignatures(sfMainSection, supportedApkSigSchemeNames, foundApkSigSchemeIds);
                if (this.mResult.containsErrors()) {
                    return;
                }
            }
            boolean createdBySigntool = false;
            String createdBy = sfMainSection.getAttributeValue("Created-By");
            if (createdBy != null) {
                createdBySigntool = createdBy.indexOf("signtool") != -1;
            }
            boolean manifestDigestVerified = this.verifyManifestDigest(sfMainSection, createdBySigntool, manifestBytes, minSdkVersion, maxSdkVersion);
            if (!createdBySigntool) {
                this.verifyManifestMainSectionDigest(sfMainSection, manifestMainSection, manifestBytes, minSdkVersion, maxSdkVersion);
            }
            if (this.mResult.containsErrors()) {
                return;
            }
            List<ManifestParser.Section> sfSections = sf.readAllSections();
            HashSet<String> sfEntryNames = new HashSet<String>(sfSections.size());
            int sfSectionNumber = 0;
            for (ManifestParser.Section sfSection : sfSections) {
                ++sfSectionNumber;
                String entryName = sfSection.getName();
                if (entryName == null) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_UNNNAMED_SIG_FILE_SECTION, new Object[]{this.mSignatureFileEntry.getName(), sfSectionNumber});
                    this.setIgnored();
                    return;
                }
                if (!sfEntryNames.add(entryName)) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_SIG_FILE_SECTION, new Object[]{this.mSignatureFileEntry.getName(), entryName});
                    this.setIgnored();
                    return;
                }
                if (manifestDigestVerified) continue;
                ManifestParser.Section manifestSection = entryNameToManifestSection.get(entryName);
                if (manifestSection == null) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE, new Object[]{entryName, this.mSignatureFileEntry.getName()});
                    this.setIgnored();
                    continue;
                }
                this.verifyManifestIndividualSectionDigest(sfSection, createdBySigntool, manifestSection, manifestBytes, minSdkVersion, maxSdkVersion);
            }
            this.mSigFileEntryNames = sfEntryNames;
        }

        private boolean verifyManifestDigest(ManifestParser.Section sfMainSection, boolean createdBySigntool, byte[] manifestBytes, int minSdkVersion, int maxSdkVersion) throws NoSuchAlgorithmException {
            boolean digestFound;
            Collection expectedDigests = V1SchemeVerifier.getDigestsToVerify(sfMainSection, createdBySigntool ? "-Digest" : "-Digest-Manifest", minSdkVersion, maxSdkVersion);
            boolean bl = digestFound = !expectedDigests.isEmpty();
            if (!digestFound) {
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_NO_MANIFEST_DIGEST_IN_SIG_FILE, new Object[]{this.mSignatureFileEntry.getName()});
                return false;
            }
            boolean verified = true;
            for (NamedDigest expectedDigest : expectedDigests) {
                String jcaDigestAlgorithm = expectedDigest.jcaDigestAlgorithm;
                byte[] actual = V1SchemeVerifier.digest(jcaDigestAlgorithm, manifestBytes);
                byte[] expected = expectedDigest.digest;
                if (Arrays.equals(expected, actual)) continue;
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY, new Object[]{V1SchemeVerifier.MANIFEST_ENTRY_NAME, jcaDigestAlgorithm, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(actual), Base64.getEncoder().encodeToString(expected)});
                verified = false;
            }
            return verified;
        }

        private void verifyManifestMainSectionDigest(ManifestParser.Section sfMainSection, ManifestParser.Section manifestMainSection, byte[] manifestBytes, int minSdkVersion, int maxSdkVersion) throws NoSuchAlgorithmException {
            Collection expectedDigests = V1SchemeVerifier.getDigestsToVerify(sfMainSection, "-Digest-Manifest-Main-Attributes", minSdkVersion, maxSdkVersion);
            if (expectedDigests.isEmpty()) {
                return;
            }
            for (NamedDigest expectedDigest : expectedDigests) {
                String jcaDigestAlgorithm = expectedDigest.jcaDigestAlgorithm;
                byte[] actual = V1SchemeVerifier.digest(jcaDigestAlgorithm, manifestBytes, manifestMainSection.getStartOffset(), manifestMainSection.getSizeBytes());
                byte[] expected = expectedDigest.digest;
                if (Arrays.equals(expected, actual)) continue;
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MANIFEST_MAIN_SECTION_DIGEST_DID_NOT_VERIFY, new Object[]{jcaDigestAlgorithm, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(actual), Base64.getEncoder().encodeToString(expected)});
            }
        }

        private void verifyManifestIndividualSectionDigest(ManifestParser.Section sfIndividualSection, boolean createdBySigntool, ManifestParser.Section manifestIndividualSection, byte[] manifestBytes, int minSdkVersion, int maxSdkVersion) throws NoSuchAlgorithmException {
            int sectionEndIndex;
            String entryName = sfIndividualSection.getName();
            Collection expectedDigests = V1SchemeVerifier.getDigestsToVerify(sfIndividualSection, "-Digest", minSdkVersion, maxSdkVersion);
            if (expectedDigests.isEmpty()) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE, new Object[]{entryName, this.mSignatureFileEntry.getName()});
                return;
            }
            int sectionStartIndex = manifestIndividualSection.getStartOffset();
            int sectionSizeBytes = manifestIndividualSection.getSizeBytes();
            if (createdBySigntool && manifestBytes[(sectionEndIndex = sectionStartIndex + sectionSizeBytes) - 1] == 10 && manifestBytes[sectionEndIndex - 2] == 10) {
                --sectionSizeBytes;
            }
            for (NamedDigest expectedDigest : expectedDigests) {
                String jcaDigestAlgorithm = expectedDigest.jcaDigestAlgorithm;
                byte[] actual = V1SchemeVerifier.digest(jcaDigestAlgorithm, manifestBytes, sectionStartIndex, sectionSizeBytes);
                byte[] expected = expectedDigest.digest;
                if (Arrays.equals(expected, actual)) continue;
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MANIFEST_SECTION_DIGEST_DID_NOT_VERIFY, new Object[]{entryName, jcaDigestAlgorithm, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(actual), Base64.getEncoder().encodeToString(expected)});
            }
        }

        private void checkForStrippedApkSignatures(ManifestParser.Section sfMainSection, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds) {
            int id;
            String signedWithApkSchemes = sfMainSection.getAttributeValue("X-Android-APK-Signed");
            if (signedWithApkSchemes == null) {
                if (!foundApkSigSchemeIds.isEmpty()) {
                    this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_NO_APK_SIG_STRIP_PROTECTION, new Object[]{this.mSignatureFileEntry.getName()});
                }
                return;
            }
            if (supportedApkSigSchemeNames.isEmpty()) {
                return;
            }
            Set<Integer> supportedApkSigSchemeIds = supportedApkSigSchemeNames.keySet();
            HashSet<Integer> supportedExpectedApkSigSchemeIds = new HashSet<Integer>(1);
            StringTokenizer tokenizer = new StringTokenizer(signedWithApkSchemes, ",");
            while (tokenizer.hasMoreTokens()) {
                String idText = tokenizer.nextToken().trim();
                if (idText.isEmpty()) continue;
                try {
                    id = Integer.parseInt(idText);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (supportedApkSigSchemeIds.contains(id)) {
                    supportedExpectedApkSigSchemeIds.add(id);
                    continue;
                }
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_UNKNOWN_APK_SIG_SCHEME_ID, new Object[]{this.mSignatureFileEntry.getName(), id});
            }
            Iterator iterator = supportedExpectedApkSigSchemeIds.iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                if (foundApkSigSchemeIds.contains(id)) continue;
                String apkSigSchemeName = supportedApkSigSchemeNames.get(id);
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MISSING_APK_SIG_REFERENCED, new Object[]{this.mSignatureFileEntry.getName(), id, apkSigSchemeName});
            }
        }
    }

    private static class Signers {
        private Signers() {
        }

        private static void verify(DataSource apk, long cdStartOffset, List<CentralDirectoryRecord> cdRecords, Set<String> cdEntryNames, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds, int minSdkVersion, int maxSdkVersion, Result result) throws ApkFormatException, IOException, NoSuchAlgorithmException {
            byte[] manifestBytes;
            CentralDirectoryRecord manifestEntry = null;
            HashMap<String, CentralDirectoryRecord> sigFileEntries = new HashMap<String, CentralDirectoryRecord>(1);
            ArrayList<CentralDirectoryRecord> sigBlockEntries = new ArrayList<CentralDirectoryRecord>(1);
            for (CentralDirectoryRecord cdRecord : cdRecords) {
                String entryName = cdRecord.getName();
                if (!entryName.startsWith("META-INF/")) continue;
                if (manifestEntry == null && V1SchemeVerifier.MANIFEST_ENTRY_NAME.equals(entryName)) {
                    manifestEntry = cdRecord;
                    continue;
                }
                if (entryName.endsWith(".SF")) {
                    sigFileEntries.put(entryName, cdRecord);
                    continue;
                }
                if (!entryName.endsWith(".RSA") && !entryName.endsWith(".DSA") && !entryName.endsWith(".EC")) continue;
                sigBlockEntries.add(cdRecord);
            }
            if (manifestEntry == null) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_MANIFEST, new Object[0]);
                return;
            }
            try {
                manifestBytes = LocalFileRecord.getUncompressedData(apk, manifestEntry, cdStartOffset);
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + manifestEntry.getName(), e);
            }
            HashMap<String, ManifestParser.Section> entryNameToManifestSection = null;
            ManifestParser manifest = new ManifestParser(manifestBytes);
            ManifestParser.Section manifestMainSection = manifest.readSection();
            List<ManifestParser.Section> manifestIndividualSections = manifest.readAllSections();
            entryNameToManifestSection = new HashMap<String, ManifestParser.Section>(manifestIndividualSections.size());
            int manifestSectionNumber = 0;
            for (ManifestParser.Section section : manifestIndividualSections) {
                ++manifestSectionNumber;
                String string = section.getName();
                if (string == null) {
                    result.addError(ApkVerifier.Issue.JAR_SIG_UNNNAMED_MANIFEST_SECTION, new Object[]{manifestSectionNumber});
                    continue;
                }
                if (entryNameToManifestSection.put(string, section) != null) {
                    result.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_MANIFEST_SECTION, new Object[]{string});
                    continue;
                }
                if (cdEntryNames.contains(string)) continue;
                result.addError(ApkVerifier.Issue.JAR_SIG_MISSING_ZIP_ENTRY_REFERENCED_IN_MANIFEST, new Object[]{string});
            }
            if (result.containsErrors()) {
                return;
            }
            ArrayList<Signer> signers = new ArrayList<Signer>(sigBlockEntries.size());
            for (CentralDirectoryRecord centralDirectoryRecord : sigBlockEntries) {
                String sigBlockEntryName = centralDirectoryRecord.getName();
                int extensionDelimiterIndex = sigBlockEntryName.lastIndexOf(46);
                if (extensionDelimiterIndex == -1) {
                    throw new RuntimeException("Signature block file name does not contain extension: " + sigBlockEntryName);
                }
                String sigFileEntryName = sigBlockEntryName.substring(0, extensionDelimiterIndex) + ".SF";
                CentralDirectoryRecord sigFileEntry = (CentralDirectoryRecord)sigFileEntries.get(sigFileEntryName);
                if (sigFileEntry == null) {
                    result.addWarning(ApkVerifier.Issue.JAR_SIG_MISSING_FILE, new Object[]{sigBlockEntryName, sigFileEntryName});
                    continue;
                }
                String signerName = sigBlockEntryName.substring("META-INF/".length());
                Result.SignerInfo signerInfo = new Result.SignerInfo(signerName, sigBlockEntryName, sigFileEntry.getName());
                Signer signer = new Signer(signerName, centralDirectoryRecord, sigFileEntry, signerInfo);
                signers.add(signer);
            }
            if (signers.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNATURES, new Object[0]);
                return;
            }
            for (Signer signer : signers) {
                signer.verifySigBlockAgainstSigFile(apk, cdStartOffset, minSdkVersion, maxSdkVersion);
                if (!signer.getResult().containsErrors()) continue;
                result.signers.add(signer.getResult());
            }
            if (result.containsErrors()) {
                return;
            }
            ArrayList<Signer> arrayList = new ArrayList<Signer>(signers.size());
            for (Signer signer : signers) {
                signer.verifySigFileAgainstManifest(manifestBytes, manifestMainSection, entryNameToManifestSection, supportedApkSigSchemeNames, foundApkSigSchemeIds, minSdkVersion, maxSdkVersion);
                if (signer.isIgnored()) {
                    result.ignoredSigners.add(signer.getResult());
                    continue;
                }
                if (signer.getResult().containsErrors()) {
                    result.signers.add(signer.getResult());
                    continue;
                }
                arrayList.add(signer);
            }
            if (result.containsErrors()) {
                return;
            }
            signers = arrayList;
            if (signers.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNATURES, new Object[0]);
                return;
            }
            Set set = V1SchemeVerifier.verifyJarEntriesAgainstManifestAndSigners(apk, cdStartOffset, cdRecords, entryNameToManifestSection, signers, minSdkVersion, maxSdkVersion, result);
            if (result.containsErrors()) {
                return;
            }
            HashSet<String> signatureEntryNames = new HashSet<String>(1 + result.signers.size() * 2);
            signatureEntryNames.add(manifestEntry.getName());
            for (Signer signer : set) {
                signatureEntryNames.add(signer.getSignatureBlockEntryName());
                signatureEntryNames.add(signer.getSignatureFileEntryName());
            }
            for (CentralDirectoryRecord cdRecord : cdRecords) {
                String entryName = cdRecord.getName();
                if (!entryName.startsWith("META-INF/") || entryName.endsWith("/") || signatureEntryNames.contains(entryName)) continue;
                result.addWarning(ApkVerifier.Issue.JAR_SIG_UNPROTECTED_ZIP_ENTRY, new Object[]{entryName});
            }
            for (Signer signer : signers) {
                if (set.contains(signer)) {
                    result.signers.add(signer.getResult());
                    continue;
                }
                result.ignoredSigners.add(signer.getResult());
            }
            result.verified = true;
        }
    }
}

