/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v4;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;

public class V4Signature {
    public static final int CURRENT_VERSION = 2;
    public static final int HASHING_ALGORITHM_SHA256 = 1;
    public static final byte LOG2_BLOCK_SIZE_4096_BYTES = 12;
    public static final int MAX_SIGNING_INFOS_SIZE = 7168;
    public final int version;
    public final byte[] hashingInfo;
    public final byte[] signingInfos;

    V4Signature(int version, byte[] hashingInfo, byte[] signingInfos) {
        this.version = version;
        this.hashingInfo = hashingInfo;
        this.signingInfos = signingInfos;
    }

    static V4Signature readFrom(InputStream stream) throws IOException {
        int version = V4Signature.readIntLE(stream);
        if (version != 2) {
            throw new IOException("Invalid signature version.");
        }
        byte[] hashingInfo = V4Signature.readBytes(stream);
        byte[] signingInfo = V4Signature.readBytes(stream);
        return new V4Signature(version, hashingInfo, signingInfo);
    }

    public void writeTo(OutputStream stream) throws IOException {
        V4Signature.writeIntLE(stream, this.version);
        V4Signature.writeBytes(stream, this.hashingInfo);
        V4Signature.writeBytes(stream, this.signingInfos);
    }

    static byte[] getSignedData(long fileSize, HashingInfo hashingInfo, SigningInfo signingInfo) {
        int size = 17 + V4Signature.bytesSize(hashingInfo.salt) + V4Signature.bytesSize(hashingInfo.rawRootHash) + V4Signature.bytesSize(signingInfo.apkDigest) + V4Signature.bytesSize(signingInfo.certificate) + V4Signature.bytesSize(signingInfo.additionalData);
        ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(size);
        buffer.putLong(fileSize);
        buffer.putInt(hashingInfo.hashAlgorithm);
        buffer.put(hashingInfo.log2BlockSize);
        V4Signature.writeBytes(buffer, hashingInfo.salt);
        V4Signature.writeBytes(buffer, hashingInfo.rawRootHash);
        V4Signature.writeBytes(buffer, signingInfo.apkDigest);
        V4Signature.writeBytes(buffer, signingInfo.certificate);
        V4Signature.writeBytes(buffer, signingInfo.additionalData);
        return buffer.array();
    }

    static int bytesSize(byte[] bytes) {
        return 4 + (bytes == null ? 0 : bytes.length);
    }

    static void readFully(InputStream stream, byte[] buffer) throws IOException {
        int count;
        int len = buffer.length;
        for (int n = 0; n < len; n += count) {
            count = stream.read(buffer, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    static int readIntLE(InputStream stream) throws IOException {
        byte[] buffer = new byte[4];
        V4Signature.readFully(stream, buffer);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    static void writeIntLE(OutputStream stream, int v) throws IOException {
        byte[] buffer = ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putInt(v).array();
        stream.write(buffer);
    }

    static byte[] readBytes(InputStream stream) throws IOException {
        try {
            int size = V4Signature.readIntLE(stream);
            byte[] bytes = new byte[size];
            V4Signature.readFully(stream, bytes);
            return bytes;
        }
        catch (EOFException ignored) {
            return null;
        }
    }

    static byte[] readBytes(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() < 4) {
            throw new EOFException();
        }
        int size = buffer.getInt();
        if (buffer.remaining() < size) {
            throw new EOFException();
        }
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return bytes;
    }

    static void writeBytes(OutputStream stream, byte[] bytes) throws IOException {
        if (bytes == null) {
            V4Signature.writeIntLE(stream, 0);
            return;
        }
        V4Signature.writeIntLE(stream, bytes.length);
        stream.write(bytes);
    }

    static void writeBytes(ByteBuffer buffer, byte[] bytes) {
        if (bytes == null) {
            buffer.putInt(0);
            return;
        }
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    public static class SigningInfos {
        public final SigningInfo signingInfo;
        public final SigningInfoBlock[] signingInfoBlocks;

        public SigningInfos(SigningInfo signingInfo) {
            this.signingInfo = signingInfo;
            this.signingInfoBlocks = new SigningInfoBlock[0];
        }

        public SigningInfos(SigningInfo signingInfo, SigningInfoBlock ... signingInfoBlocks) {
            this.signingInfo = signingInfo;
            this.signingInfoBlocks = signingInfoBlocks;
        }

        public static SigningInfos fromByteArray(byte[] bytes) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            SigningInfo signingInfo = SigningInfo.fromByteBuffer(buffer);
            if (!buffer.hasRemaining()) {
                return new SigningInfos(signingInfo);
            }
            ArrayList<SigningInfoBlock> signingInfoBlocks = new ArrayList<SigningInfoBlock>(1);
            while (buffer.hasRemaining()) {
                signingInfoBlocks.add(SigningInfoBlock.fromByteBuffer(buffer));
            }
            return new SigningInfos(signingInfo, signingInfoBlocks.toArray(new SigningInfoBlock[signingInfoBlocks.size()]));
        }

        byte[] toByteArray() {
            byte[][] arrays = new byte[1 + this.signingInfoBlocks.length][];
            arrays[0] = this.signingInfo.toByteArray();
            int size = arrays[0].length;
            int isize = this.signingInfoBlocks.length;
            for (int i = 0; i < isize; ++i) {
                arrays[i + 1] = this.signingInfoBlocks[i].toByteArray();
                size += arrays[i + 1].length;
            }
            if (size > 7168) {
                throw new IllegalArgumentException("Combined SigningInfos length exceeded limit of 7K: " + size);
            }
            byte[] result = Arrays.copyOf(arrays[0], size);
            int offset = arrays[0].length;
            int isize2 = this.signingInfoBlocks.length;
            for (int i = 0; i < isize2; ++i) {
                System.arraycopy(arrays[i + 1], 0, result, offset, arrays[i + 1].length);
                offset += arrays[i + 1].length;
            }
            return result;
        }
    }

    public static class SigningInfoBlock {
        public final int blockId;
        public final byte[] signingInfo;

        public SigningInfoBlock(int blockId, byte[] signingInfo) {
            this.blockId = blockId;
            this.signingInfo = signingInfo;
        }

        static SigningInfoBlock fromByteBuffer(ByteBuffer buffer) throws IOException {
            int blockId = buffer.getInt();
            byte[] signingInfo = V4Signature.readBytes(buffer);
            return new SigningInfoBlock(blockId, signingInfo);
        }

        byte[] toByteArray() {
            int size = 4 + V4Signature.bytesSize(this.signingInfo);
            ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.blockId);
            V4Signature.writeBytes(buffer, this.signingInfo);
            return buffer.array();
        }
    }

    public static class SigningInfo {
        public final byte[] apkDigest;
        public final byte[] certificate;
        public final byte[] additionalData;
        public final byte[] publicKey;
        public final int signatureAlgorithmId;
        public final byte[] signature;

        SigningInfo(byte[] apkDigest, byte[] certificate, byte[] additionalData, byte[] publicKey, int signatureAlgorithmId, byte[] signature) {
            this.apkDigest = apkDigest;
            this.certificate = certificate;
            this.additionalData = additionalData;
            this.publicKey = publicKey;
            this.signatureAlgorithmId = signatureAlgorithmId;
            this.signature = signature;
        }

        static SigningInfo fromByteArray(byte[] bytes) throws IOException {
            return SigningInfo.fromByteBuffer(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
        }

        static SigningInfo fromByteBuffer(ByteBuffer buffer) throws IOException {
            byte[] apkDigest = V4Signature.readBytes(buffer);
            byte[] certificate = V4Signature.readBytes(buffer);
            byte[] additionalData = V4Signature.readBytes(buffer);
            byte[] publicKey = V4Signature.readBytes(buffer);
            int signatureAlgorithmId = buffer.getInt();
            byte[] signature = V4Signature.readBytes(buffer);
            return new SigningInfo(apkDigest, certificate, additionalData, publicKey, signatureAlgorithmId, signature);
        }

        byte[] toByteArray() {
            int size = V4Signature.bytesSize(this.apkDigest) + V4Signature.bytesSize(this.certificate) + V4Signature.bytesSize(this.additionalData) + V4Signature.bytesSize(this.publicKey) + 4 + V4Signature.bytesSize(this.signature);
            ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            V4Signature.writeBytes(buffer, this.apkDigest);
            V4Signature.writeBytes(buffer, this.certificate);
            V4Signature.writeBytes(buffer, this.additionalData);
            V4Signature.writeBytes(buffer, this.publicKey);
            buffer.putInt(this.signatureAlgorithmId);
            V4Signature.writeBytes(buffer, this.signature);
            return buffer.array();
        }
    }

    public static class HashingInfo {
        public final int hashAlgorithm;
        public final byte log2BlockSize;
        public final byte[] salt;
        public final byte[] rawRootHash;

        HashingInfo(int hashAlgorithm, byte log2BlockSize, byte[] salt, byte[] rawRootHash) {
            this.hashAlgorithm = hashAlgorithm;
            this.log2BlockSize = log2BlockSize;
            this.salt = salt;
            this.rawRootHash = rawRootHash;
        }

        static HashingInfo fromByteArray(byte[] bytes) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            int hashAlgorithm = buffer.getInt();
            byte log2BlockSize = buffer.get();
            byte[] salt = V4Signature.readBytes(buffer);
            byte[] rawRootHash = V4Signature.readBytes(buffer);
            return new HashingInfo(hashAlgorithm, log2BlockSize, salt, rawRootHash);
        }

        byte[] toByteArray() {
            int size = 5 + V4Signature.bytesSize(this.salt) + V4Signature.bytesSize(this.rawRootHash);
            ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.hashAlgorithm);
            buffer.put(this.log2BlockSize);
            V4Signature.writeBytes(buffer, this.salt);
            V4Signature.writeBytes(buffer, this.rawRootHash);
            return buffer.array();
        }
    }
}

