/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v1;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.asn1.Asn1BerParser;
import com.android.apksig.internal.asn1.Asn1Class;
import com.android.apksig.internal.asn1.Asn1DecodingException;
import com.android.apksig.internal.asn1.Asn1Field;
import com.android.apksig.internal.asn1.Asn1OpaqueObject;
import com.android.apksig.internal.asn1.Asn1Type;
import com.android.apksig.internal.jar.ManifestParser;
import com.android.apksig.internal.oid.OidConstants;
import com.android.apksig.internal.pkcs7.AlgorithmIdentifier;
import com.android.apksig.internal.pkcs7.Attribute;
import com.android.apksig.internal.pkcs7.ContentInfo;
import com.android.apksig.internal.pkcs7.Pkcs7DecodingException;
import com.android.apksig.internal.pkcs7.SignedData;
import com.android.apksig.internal.pkcs7.SignerInfo;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.InclusiveIntRange;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.x509.Certificate;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSinks;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;

public abstract class V1SchemeVerifier {
    private static final String[] JB_MR2_AND_NEWER_DIGEST_ALGS = new String[]{"SHA-512", "SHA-384", "SHA-256", "SHA-1"};
    private static final Map<String, String> UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL = new HashMap<String, String>(8);
    private static final Map<String, Integer> MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST;

    private V1SchemeVerifier() {
    }

    public static Result verify(DataSource apk, ApkUtils.ZipSections apkSections, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds, int minSdkVersion, int maxSdkVersion) throws IOException, ApkFormatException, NoSuchAlgorithmException {
        if (minSdkVersion > maxSdkVersion) {
            throw new IllegalArgumentException("minSdkVersion (" + minSdkVersion + ") > maxSdkVersion (" + maxSdkVersion + ")");
        }
        Result result = new Result();
        List<CentralDirectoryRecord> cdRecords = V1SchemeVerifier.parseZipCentralDirectory(apk, apkSections);
        Set<String> cdEntryNames = V1SchemeVerifier.checkForDuplicateEntries(cdRecords, result);
        if (result.containsErrors()) {
            return result;
        }
        Signers.verify(apk, apkSections.getZipCentralDirectoryOffset(), cdRecords, cdEntryNames, supportedApkSigSchemeNames, foundApkSigSchemeIds, minSdkVersion, maxSdkVersion, result);
        return result;
    }

    private static Set<String> checkForDuplicateEntries(List<CentralDirectoryRecord> cdRecords, Result result) {
        HashSet<String> cdEntryNames = new HashSet<String>(cdRecords.size());
        HashSet<String> duplicateCdEntryNames = null;
        for (CentralDirectoryRecord cdRecord : cdRecords) {
            String entryName = cdRecord.getName();
            if (cdEntryNames.add(entryName)) continue;
            if (duplicateCdEntryNames == null) {
                duplicateCdEntryNames = new HashSet<String>();
            }
            if (!duplicateCdEntryNames.add(entryName)) continue;
            result.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_ZIP_ENTRY, new Object[]{entryName});
        }
        return cdEntryNames;
    }

    public static Pair<ManifestParser.Section, Map<String, ManifestParser.Section>> parseManifest(byte[] manifestBytes, Set<String> cdEntryNames, Result result) {
        ManifestParser manifest = new ManifestParser(manifestBytes);
        ManifestParser.Section manifestMainSection = manifest.readSection();
        List<ManifestParser.Section> manifestIndividualSections = manifest.readAllSections();
        HashMap<String, ManifestParser.Section> entryNameToManifestSection = new HashMap<String, ManifestParser.Section>(manifestIndividualSections.size());
        int manifestSectionNumber = 0;
        for (ManifestParser.Section manifestSection : manifestIndividualSections) {
            ++manifestSectionNumber;
            String entryName = manifestSection.getName();
            if (entryName == null) {
                result.addError(ApkVerifier.Issue.JAR_SIG_UNNNAMED_MANIFEST_SECTION, new Object[]{manifestSectionNumber});
                continue;
            }
            if (entryNameToManifestSection.put(entryName, manifestSection) != null) {
                result.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_MANIFEST_SECTION, new Object[]{entryName});
                continue;
            }
            if (cdEntryNames.contains(entryName)) continue;
            result.addError(ApkVerifier.Issue.JAR_SIG_MISSING_ZIP_ENTRY_REFERENCED_IN_MANIFEST, new Object[]{entryName});
        }
        return Pair.of(manifestMainSection, entryNameToManifestSection);
    }

    public static Collection<NamedDigest> getDigestsToVerify(ManifestParser.Section section, String digestAttrSuffix, int minSdkVersion, int maxSdkVersion) {
        Base64.Decoder base64Decoder = Base64.getDecoder();
        ArrayList<NamedDigest> result = new ArrayList<NamedDigest>(1);
        if (minSdkVersion < 18) {
            String algs = section.getAttributeValue("Digest-Algorithms");
            if (algs == null) {
                algs = "SHA SHA1";
            }
            StringTokenizer tokens = new StringTokenizer(algs);
            while (tokens.hasMoreTokens()) {
                String alg = tokens.nextToken();
                String attrName = alg + digestAttrSuffix;
                String digestBase64 = section.getAttributeValue(attrName);
                if (digestBase64 == null || (alg = V1SchemeVerifier.getCanonicalJcaMessageDigestAlgorithm(alg)) == null || V1SchemeVerifier.getMinSdkVersionFromWhichSupportedInManifestOrSignatureFile(alg) > minSdkVersion) continue;
                result.add(new NamedDigest(alg, base64Decoder.decode(digestBase64)));
                break;
            }
            if (result.isEmpty()) {
                return result;
            }
        }
        if (maxSdkVersion >= 18) {
            for (String alg : JB_MR2_AND_NEWER_DIGEST_ALGS) {
                String attrName = V1SchemeVerifier.getJarDigestAttributeName(alg, digestAttrSuffix);
                String digestBase64 = section.getAttributeValue(attrName);
                if (digestBase64 == null) continue;
                byte[] digest = base64Decoder.decode(digestBase64);
                byte[] digestInResult = V1SchemeVerifier.getDigest(result, alg);
                if (digestInResult != null && Arrays.equals(digestInResult, digest)) break;
                result.add(new NamedDigest(alg, digest));
                break;
            }
        }
        return result;
    }

    private static String getCanonicalJcaMessageDigestAlgorithm(String algorithm) {
        return UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.get(algorithm.toUpperCase(Locale.US));
    }

    public static int getMinSdkVersionFromWhichSupportedInManifestOrSignatureFile(String jcaAlgorithmName) {
        Integer result = MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.get(jcaAlgorithmName.toUpperCase(Locale.US));
        return result != null ? result : Integer.MAX_VALUE;
    }

    private static String getJarDigestAttributeName(String jcaDigestAlgorithm, String attrNameSuffix) {
        if ("SHA-1".equalsIgnoreCase(jcaDigestAlgorithm)) {
            return "SHA1" + attrNameSuffix;
        }
        return jcaDigestAlgorithm + attrNameSuffix;
    }

    private static byte[] getDigest(Collection<NamedDigest> digests, String jcaDigestAlgorithm) {
        for (NamedDigest digest : digests) {
            if (!digest.jcaDigestAlgorithm.equalsIgnoreCase(jcaDigestAlgorithm)) continue;
            return digest.digest;
        }
        return null;
    }

    public static List<CentralDirectoryRecord> parseZipCentralDirectory(DataSource apk, ApkUtils.ZipSections apkSections) throws IOException, ApkFormatException {
        return ZipUtils.parseZipCentralDirectory(apk, apkSections);
    }

    private static boolean isJarEntryDigestNeededInManifest(String entryName) {
        if (entryName.startsWith("META-INF/")) {
            return false;
        }
        return !entryName.endsWith("/");
    }

    private static Set<Signer> verifyJarEntriesAgainstManifestAndSigners(DataSource apk, long cdOffsetInApk, Collection<CentralDirectoryRecord> cdRecords, Map<String, ManifestParser.Section> entryNameToManifestSection, List<Signer> signers, int minSdkVersion, int maxSdkVersion, Result result) throws ApkFormatException, IOException, NoSuchAlgorithmException {
        ArrayList<CentralDirectoryRecord> cdRecordsSortedByLocalFileHeaderOffset = new ArrayList<CentralDirectoryRecord>(cdRecords);
        Collections.sort(cdRecordsSortedByLocalFileHeaderOffset, CentralDirectoryRecord.BY_LOCAL_FILE_HEADER_OFFSET_COMPARATOR);
        ArrayList<Signer> firstSignedEntrySigners = null;
        String firstSignedEntryName = null;
        for (CentralDirectoryRecord cdRecord : cdRecordsSortedByLocalFileHeaderOffset) {
            int i;
            String entryName = cdRecord.getName();
            if (!V1SchemeVerifier.isJarEntryDigestNeededInManifest(entryName)) continue;
            ManifestParser.Section manifestSection = entryNameToManifestSection.get(entryName);
            if (manifestSection == null) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST, new Object[]{entryName});
                continue;
            }
            ArrayList<Signer> entrySigners = new ArrayList<Signer>(signers.size());
            for (Signer signer : signers) {
                if (!signer.getSigFileEntryNames().contains(entryName)) continue;
                entrySigners.add(signer);
            }
            if (entrySigners.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_NOT_SIGNED, new Object[]{entryName});
                continue;
            }
            if (firstSignedEntrySigners == null) {
                firstSignedEntrySigners = entrySigners;
                firstSignedEntryName = entryName;
            } else if (!entrySigners.equals(firstSignedEntrySigners)) {
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_SIGNERS_MISMATCH, new Object[]{firstSignedEntryName, V1SchemeVerifier.getSignerNames(firstSignedEntrySigners), entryName, V1SchemeVerifier.getSignerNames(entrySigners)});
                continue;
            }
            ArrayList<NamedDigest> expectedDigests = new ArrayList<NamedDigest>(V1SchemeVerifier.getDigestsToVerify(manifestSection, "-Digest", minSdkVersion, maxSdkVersion));
            if (expectedDigests.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST, new Object[]{entryName});
                continue;
            }
            MessageDigest[] mds = new MessageDigest[expectedDigests.size()];
            for (i = 0; i < expectedDigests.size(); ++i) {
                mds[i] = V1SchemeVerifier.getMessageDigest(((NamedDigest)expectedDigests.get((int)i)).jcaDigestAlgorithm);
            }
            try {
                LocalFileRecord.outputUncompressedData(apk, cdRecord, cdOffsetInApk, DataSinks.asDataSink(mds));
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + entryName, e);
            }
            catch (IOException e) {
                throw new IOException("Failed to read entry: " + entryName, e);
            }
            for (i = 0; i < expectedDigests.size(); ++i) {
                NamedDigest expectedDigest = (NamedDigest)expectedDigests.get(i);
                byte[] actualDigest = mds[i].digest();
                if (Arrays.equals(expectedDigest.digest, actualDigest)) continue;
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY, new Object[]{entryName, expectedDigest.jcaDigestAlgorithm, "META-INF/MANIFEST.MF", Base64.getEncoder().encodeToString(actualDigest), Base64.getEncoder().encodeToString(expectedDigest.digest)});
            }
        }
        if (firstSignedEntrySigners == null) {
            result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNED_ZIP_ENTRIES, new Object[0]);
            return Collections.emptySet();
        }
        return new HashSet<Signer>(firstSignedEntrySigners);
    }

    private static List<String> getSignerNames(List<Signer> signers) {
        if (signers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(signers.size());
        for (Signer signer : signers) {
            result.add(signer.getName());
        }
        return result;
    }

    private static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithm);
    }

    private static byte[] digest(String algorithm, byte[] data, int offset, int length) throws NoSuchAlgorithmException {
        MessageDigest md = V1SchemeVerifier.getMessageDigest(algorithm);
        md.update(data, offset, length);
        return md.digest();
    }

    private static byte[] digest(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        return V1SchemeVerifier.getMessageDigest(algorithm).digest(data);
    }

    static {
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("MD5", "MD5");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA1", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-1", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-256", "SHA-256");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-384", "SHA-384");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-512", "SHA-512");
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST = new HashMap<String, Integer>(5);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("MD5", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-1", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-256", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-384", 9);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-512", 9);
    }

    public static class Result {
        public boolean verified;
        public final List<SignerInfo> signers = new ArrayList<SignerInfo>();
        public final List<SignerInfo> ignoredSigners = new ArrayList<SignerInfo>();
        private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
        private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

        private boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            for (SignerInfo signer : this.signers) {
                if (!signer.containsErrors()) continue;
                return true;
            }
            return false;
        }

        private void addError(ApkVerifier.Issue msg, Object ... parameters) {
            this.mErrors.add(new ApkVerifier.IssueWithParams(msg, parameters));
        }

        private void addWarning(ApkVerifier.Issue msg, Object ... parameters) {
            this.mWarnings.add(new ApkVerifier.IssueWithParams(msg, parameters));
        }

        public List<ApkVerifier.IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<ApkVerifier.IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        public static class SignerInfo {
            public final String name;
            public final String signatureFileName;
            public final String signatureBlockFileName;
            public final List<X509Certificate> certChain = new ArrayList<X509Certificate>();
            private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
            private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

            private SignerInfo(String name, String signatureBlockFileName, String signatureFileName) {
                this.name = name;
                this.signatureBlockFileName = signatureBlockFileName;
                this.signatureFileName = signatureFileName;
            }

            private boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            private void addError(ApkVerifier.Issue msg, Object ... parameters) {
                this.mErrors.add(new ApkVerifier.IssueWithParams(msg, parameters));
            }

            private void addWarning(ApkVerifier.Issue msg, Object ... parameters) {
                this.mWarnings.add(new ApkVerifier.IssueWithParams(msg, parameters));
            }

            public List<ApkVerifier.IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<ApkVerifier.IssueWithParams> getWarnings() {
                return this.mWarnings;
            }
        }
    }

    private static class Signers {
        private Signers() {
        }

        private static void verify(DataSource apk, long cdStartOffset, List<CentralDirectoryRecord> cdRecords, Set<String> cdEntryNames, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds, int minSdkVersion, int maxSdkVersion, Result result) throws ApkFormatException, IOException, NoSuchAlgorithmException {
            byte[] manifestBytes;
            CentralDirectoryRecord manifestEntry = null;
            HashMap<String, CentralDirectoryRecord> sigFileEntries = new HashMap<String, CentralDirectoryRecord>(1);
            ArrayList<CentralDirectoryRecord> sigBlockEntries = new ArrayList<CentralDirectoryRecord>(1);
            for (CentralDirectoryRecord cdRecord : cdRecords) {
                String entryName = cdRecord.getName();
                if (!entryName.startsWith("META-INF/")) continue;
                if (manifestEntry == null && "META-INF/MANIFEST.MF".equals(entryName)) {
                    manifestEntry = cdRecord;
                    continue;
                }
                if (entryName.endsWith(".SF")) {
                    sigFileEntries.put(entryName, cdRecord);
                    continue;
                }
                if (!entryName.endsWith(".RSA") && !entryName.endsWith(".DSA") && !entryName.endsWith(".EC")) continue;
                sigBlockEntries.add(cdRecord);
            }
            if (manifestEntry == null) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_MANIFEST, new Object[0]);
                return;
            }
            try {
                manifestBytes = LocalFileRecord.getUncompressedData(apk, manifestEntry, cdStartOffset);
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + manifestEntry.getName(), e);
            }
            Pair<ManifestParser.Section, Map<String, ManifestParser.Section>> manifestSections = V1SchemeVerifier.parseManifest(manifestBytes, cdEntryNames, result);
            if (result.containsErrors()) {
                return;
            }
            ManifestParser.Section manifestMainSection = manifestSections.getFirst();
            Map<String, ManifestParser.Section> entryNameToManifestSection = manifestSections.getSecond();
            ArrayList<Signer> signers = new ArrayList<Signer>(sigBlockEntries.size());
            for (CentralDirectoryRecord centralDirectoryRecord : sigBlockEntries) {
                String sigBlockEntryName = centralDirectoryRecord.getName();
                int extensionDelimiterIndex = sigBlockEntryName.lastIndexOf(46);
                if (extensionDelimiterIndex == -1) {
                    throw new RuntimeException("Signature block file name does not contain extension: " + sigBlockEntryName);
                }
                String sigFileEntryName = sigBlockEntryName.substring(0, extensionDelimiterIndex) + ".SF";
                CentralDirectoryRecord sigFileEntry = (CentralDirectoryRecord)sigFileEntries.get(sigFileEntryName);
                if (sigFileEntry == null) {
                    result.addWarning(ApkVerifier.Issue.JAR_SIG_MISSING_FILE, new Object[]{sigBlockEntryName, sigFileEntryName});
                    continue;
                }
                String signerName = sigBlockEntryName.substring("META-INF/".length());
                Result.SignerInfo signerInfo = new Result.SignerInfo(signerName, sigBlockEntryName, sigFileEntry.getName());
                Signer signer = new Signer(signerName, centralDirectoryRecord, sigFileEntry, signerInfo);
                signers.add(signer);
            }
            if (signers.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNATURES, new Object[0]);
                return;
            }
            if (signers.size() > 10) {
                result.addError(ApkVerifier.Issue.JAR_SIG_MAX_SIGNATURES_EXCEEDED, new Object[]{10, signers.size()});
                return;
            }
            for (Signer signer : signers) {
                signer.verifySigBlockAgainstSigFile(apk, cdStartOffset, minSdkVersion, maxSdkVersion);
                if (!signer.getResult().containsErrors()) continue;
                result.signers.add(signer.getResult());
            }
            if (result.containsErrors()) {
                return;
            }
            ArrayList<Signer> remainingSigners = new ArrayList<Signer>(signers.size());
            for (Signer signer : signers) {
                signer.verifySigFileAgainstManifest(manifestBytes, manifestMainSection, entryNameToManifestSection, supportedApkSigSchemeNames, foundApkSigSchemeIds, minSdkVersion, maxSdkVersion);
                if (signer.isIgnored()) {
                    result.ignoredSigners.add(signer.getResult());
                    continue;
                }
                if (signer.getResult().containsErrors()) {
                    result.signers.add(signer.getResult());
                    continue;
                }
                remainingSigners.add(signer);
            }
            if (result.containsErrors()) {
                return;
            }
            signers = remainingSigners;
            if (signers.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNATURES, new Object[0]);
                return;
            }
            Set set = V1SchemeVerifier.verifyJarEntriesAgainstManifestAndSigners(apk, cdStartOffset, cdRecords, entryNameToManifestSection, signers, minSdkVersion, maxSdkVersion, result);
            if (result.containsErrors()) {
                return;
            }
            HashSet<String> signatureEntryNames = new HashSet<String>(1 + result.signers.size() * 2);
            signatureEntryNames.add(manifestEntry.getName());
            for (Signer signer : set) {
                signatureEntryNames.add(signer.getSignatureBlockEntryName());
                signatureEntryNames.add(signer.getSignatureFileEntryName());
            }
            for (CentralDirectoryRecord cdRecord : cdRecords) {
                String entryName = cdRecord.getName();
                if (!entryName.startsWith("META-INF/") || entryName.endsWith("/") || signatureEntryNames.contains(entryName)) continue;
                result.addWarning(ApkVerifier.Issue.JAR_SIG_UNPROTECTED_ZIP_ENTRY, new Object[]{entryName});
            }
            for (Signer signer : signers) {
                if (set.contains(signer)) {
                    result.signers.add(signer.getResult());
                    continue;
                }
                result.ignoredSigners.add(signer.getResult());
            }
            result.verified = true;
        }
    }

    public static class NamedDigest {
        public final String jcaDigestAlgorithm;
        public final byte[] digest;

        private NamedDigest(String jcaDigestAlgorithm, byte[] digest) {
            this.jcaDigestAlgorithm = jcaDigestAlgorithm;
            this.digest = digest;
        }
    }

    static class Signer {
        private final String mName;
        private final Result.SignerInfo mResult;
        private final CentralDirectoryRecord mSignatureFileEntry;
        private final CentralDirectoryRecord mSignatureBlockEntry;
        private boolean mIgnored;
        private byte[] mSigFileBytes;
        private Set<String> mSigFileEntryNames;

        private Signer(String name, CentralDirectoryRecord sigBlockEntry, CentralDirectoryRecord sigFileEntry, Result.SignerInfo result) {
            this.mName = name;
            this.mResult = result;
            this.mSignatureBlockEntry = sigBlockEntry;
            this.mSignatureFileEntry = sigFileEntry;
        }

        public String getName() {
            return this.mName;
        }

        public String getSignatureFileEntryName() {
            return this.mSignatureFileEntry.getName();
        }

        public String getSignatureBlockEntryName() {
            return this.mSignatureBlockEntry.getName();
        }

        void setIgnored() {
            this.mIgnored = true;
        }

        public boolean isIgnored() {
            return this.mIgnored;
        }

        public Set<String> getSigFileEntryNames() {
            return this.mSigFileEntryNames;
        }

        public Result.SignerInfo getResult() {
            return this.mResult;
        }

        public void verifySigBlockAgainstSigFile(DataSource apk, long cdStartOffset, int minSdkVersion, int maxSdkVersion) throws IOException, ApkFormatException, NoSuchAlgorithmException {
            SignedData signedData;
            byte[] sigBlockBytes;
            try {
                sigBlockBytes = LocalFileRecord.getUncompressedData(apk, this.mSignatureBlockEntry, cdStartOffset);
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + this.mSignatureBlockEntry.getName(), e);
            }
            try {
                this.mSigFileBytes = LocalFileRecord.getUncompressedData(apk, this.mSignatureFileEntry, cdStartOffset);
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + this.mSignatureFileEntry.getName(), e);
            }
            try {
                ContentInfo contentInfo = Asn1BerParser.parse(ByteBuffer.wrap(sigBlockBytes), ContentInfo.class);
                if (!"1.2.840.113549.1.7.2".equals(contentInfo.contentType)) {
                    throw new Asn1DecodingException("Unsupported ContentInfo.contentType: " + contentInfo.contentType);
                }
                signedData = Asn1BerParser.parse(contentInfo.content.getEncoded(), SignedData.class);
            }
            catch (Asn1DecodingException e) {
                e.printStackTrace();
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_PARSE_EXCEPTION, new Object[]{this.mSignatureBlockEntry.getName(), e});
                return;
            }
            if (signedData.signerInfos.isEmpty()) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNERS, new Object[]{this.mSignatureBlockEntry.getName()});
                return;
            }
            SignerInfo firstVerifiedSignerInfo = null;
            X509Certificate firstVerifiedSignerInfoSigningCertificate = null;
            List<SignerInfo> unverifiedSignerInfosToTry = minSdkVersion < 24 ? Collections.singletonList(signedData.signerInfos.get(0)) : signedData.signerInfos;
            List<X509Certificate> signedDataCertificates = null;
            for (SignerInfo unverifiedSignerInfo : unverifiedSignerInfosToTry) {
                if (signedDataCertificates == null) {
                    try {
                        signedDataCertificates = Certificate.parseCertificates(signedData.certificates);
                    }
                    catch (CertificateException e) {
                        this.mResult.addError(ApkVerifier.Issue.JAR_SIG_PARSE_EXCEPTION, new Object[]{this.mSignatureBlockEntry.getName(), e});
                        return;
                    }
                }
                try {
                    X509Certificate signingCertificate = this.verifySignerInfoAgainstSigFile(signedData, signedDataCertificates, unverifiedSignerInfo, this.mSigFileBytes, minSdkVersion, maxSdkVersion);
                    if (this.mResult.containsErrors()) {
                        return;
                    }
                    if (signingCertificate == null || firstVerifiedSignerInfo != null) continue;
                    firstVerifiedSignerInfo = unverifiedSignerInfo;
                    firstVerifiedSignerInfoSigningCertificate = signingCertificate;
                }
                catch (Pkcs7DecodingException e) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_PARSE_EXCEPTION, new Object[]{this.mSignatureBlockEntry.getName(), e});
                    return;
                }
                catch (InvalidKeyException | SignatureException e) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_VERIFY_EXCEPTION, new Object[]{this.mSignatureBlockEntry.getName(), this.mSignatureFileEntry.getName(), e});
                    return;
                }
            }
            if (firstVerifiedSignerInfo == null) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_DID_NOT_VERIFY, new Object[]{this.mSignatureBlockEntry.getName(), this.mSignatureFileEntry.getName()});
                return;
            }
            List<X509Certificate> signingCertChain = Signer.getCertificateChain(signedDataCertificates, firstVerifiedSignerInfoSigningCertificate);
            this.mResult.certChain.clear();
            this.mResult.certChain.addAll(signingCertChain);
        }

        private X509Certificate verifySignerInfoAgainstSigFile(SignedData signedData, Collection<X509Certificate> signedDataCertificates, SignerInfo signerInfo, byte[] signatureFile, int minSdkVersion, int maxSdkVersion) throws Pkcs7DecodingException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
            List<InclusiveIntRange> apiLevelsWhereDigestAndSigAlgorithmSupported;
            String digestAlgorithmOid = signerInfo.digestAlgorithm.algorithm;
            String signatureAlgorithmOid = signerInfo.signatureAlgorithm.algorithm;
            InclusiveIntRange desiredApiLevels = InclusiveIntRange.fromTo(minSdkVersion, maxSdkVersion);
            List<InclusiveIntRange> apiLevelsWhereDigestAlgorithmNotSupported = desiredApiLevels.getValuesNotIn(apiLevelsWhereDigestAndSigAlgorithmSupported = OidConstants.getSigAlgSupportedApiLevels(digestAlgorithmOid, signatureAlgorithmOid));
            if (!apiLevelsWhereDigestAlgorithmNotSupported.isEmpty()) {
                String signatureAlgorithmUserFriendly;
                String digestAlgorithmUserFriendly = OidConstants.OidToUserFriendlyNameMapper.getUserFriendlyNameForOid(digestAlgorithmOid);
                if (digestAlgorithmUserFriendly == null) {
                    digestAlgorithmUserFriendly = digestAlgorithmOid;
                }
                if ((signatureAlgorithmUserFriendly = OidConstants.OidToUserFriendlyNameMapper.getUserFriendlyNameForOid(signatureAlgorithmOid)) == null) {
                    signatureAlgorithmUserFriendly = signatureAlgorithmOid;
                }
                StringBuilder apiLevelsUserFriendly = new StringBuilder();
                for (InclusiveIntRange range : apiLevelsWhereDigestAlgorithmNotSupported) {
                    if (apiLevelsUserFriendly.length() > 0) {
                        apiLevelsUserFriendly.append(", ");
                    }
                    if (range.getMin() == range.getMax()) {
                        apiLevelsUserFriendly.append(String.valueOf(range.getMin()));
                        continue;
                    }
                    if (range.getMax() == Integer.MAX_VALUE) {
                        apiLevelsUserFriendly.append(range.getMin() + "+");
                        continue;
                    }
                    apiLevelsUserFriendly.append(range.getMin() + "-" + range.getMax());
                }
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_UNSUPPORTED_SIG_ALG, new Object[]{this.mSignatureBlockEntry.getName(), digestAlgorithmOid, signatureAlgorithmOid, apiLevelsUserFriendly.toString(), digestAlgorithmUserFriendly, signatureAlgorithmUserFriendly});
                return null;
            }
            X509Certificate signingCertificate = Certificate.findCertificate(signedDataCertificates, signerInfo.sid);
            if (signingCertificate == null) {
                throw new SignatureException("Signing certificate referenced in SignerInfo not found in SignedData");
            }
            if (signingCertificate.hasUnsupportedCriticalExtension()) {
                throw new SignatureException("Signing certificate has unsupported critical extensions");
            }
            boolean[] keyUsageExtension = signingCertificate.getKeyUsage();
            if (keyUsageExtension != null) {
                boolean nonRepudiation;
                boolean digitalSignature = keyUsageExtension.length >= 1 && keyUsageExtension[0];
                boolean bl = nonRepudiation = keyUsageExtension.length >= 2 && keyUsageExtension[1];
                if (!digitalSignature && !nonRepudiation) {
                    throw new SignatureException("Signing certificate not authorized for use in digital signatures: keyUsage extension missing digitalSignature and nonRepudiation");
                }
            }
            String jcaSignatureAlgorithm = AlgorithmIdentifier.getJcaSignatureAlgorithm(digestAlgorithmOid, signatureAlgorithmOid);
            Signature s = Signature.getInstance(jcaSignatureAlgorithm);
            PublicKey publicKey = signingCertificate.getPublicKey();
            try {
                s.initVerify(publicKey);
            }
            catch (InvalidKeyException e) {
                try {
                    byte[] encodedPublicKey = ApkSigningBlockUtils.encodePublicKey(publicKey);
                    publicKey = KeyFactory.getInstance(publicKey.getAlgorithm()).generatePublic(new X509EncodedKeySpec(encodedPublicKey));
                }
                catch (InvalidKeySpecException ikse) {
                    throw e;
                }
                s = Signature.getInstance(jcaSignatureAlgorithm);
                s.initVerify(publicKey);
            }
            if (signerInfo.signedAttrs != null) {
                if (minSdkVersion < 19) {
                    throw new SignatureException("APKs with Signed Attributes broken on platforms with API Level < 19");
                }
                try {
                    byte[] expectedSignatureFileDigest;
                    List<Attribute> signedAttributes = Asn1BerParser.parseImplicitSetOf(signerInfo.signedAttrs.getEncoded(), Attribute.class);
                    SignedAttributes signedAttrs = new SignedAttributes(signedAttributes);
                    if (maxSdkVersion >= 24) {
                        String contentType = signedAttrs.getSingleObjectIdentifierValue("1.2.840.113549.1.9.3");
                        if (contentType == null) {
                            throw new SignatureException("No Content Type in signed attributes");
                        }
                        if (!contentType.equals(signedData.encapContentInfo.contentType)) {
                            return null;
                        }
                    }
                    if ((expectedSignatureFileDigest = signedAttrs.getSingleOctetStringValue("1.2.840.113549.1.9.4")) == null) {
                        throw new SignatureException("No content digest in signed attributes");
                    }
                    byte[] actualSignatureFileDigest = MessageDigest.getInstance(AlgorithmIdentifier.getJcaDigestAlgorithm(digestAlgorithmOid)).digest(signatureFile);
                    if (!Arrays.equals(expectedSignatureFileDigest, actualSignatureFileDigest)) {
                        return null;
                    }
                }
                catch (Asn1DecodingException e) {
                    throw new SignatureException("Failed to parse signed attributes", e);
                }
                ByteBuffer signedAttrsOriginalEncoding = signerInfo.signedAttrs.getEncoded();
                s.update((byte)49);
                signedAttrsOriginalEncoding.position(1);
                s.update(signedAttrsOriginalEncoding);
            } else {
                s.update(signatureFile);
            }
            byte[] sigBytes = ByteBufferUtils.toByteArray(signerInfo.signature.slice());
            if (!s.verify(sigBytes)) {
                return null;
            }
            return signingCertificate;
        }

        public static List<X509Certificate> getCertificateChain(List<X509Certificate> certs, X509Certificate leaf) {
            ArrayList<X509Certificate> unusedCerts = new ArrayList<X509Certificate>(certs);
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(1);
            result.add(leaf);
            unusedCerts.remove(leaf);
            X509Certificate root = leaf;
            while (!root.getSubjectDN().equals(root.getIssuerDN())) {
                Principal targetDn = root.getIssuerDN();
                boolean issuerFound = false;
                for (int i = 0; i < unusedCerts.size(); ++i) {
                    X509Certificate unusedCert = (X509Certificate)unusedCerts.get(i);
                    if (!targetDn.equals(unusedCert.getSubjectDN())) continue;
                    issuerFound = true;
                    unusedCerts.remove(i);
                    result.add(unusedCert);
                    root = unusedCert;
                    break;
                }
                if (issuerFound) continue;
                break;
            }
            return result;
        }

        public void verifySigFileAgainstManifest(byte[] manifestBytes, ManifestParser.Section manifestMainSection, Map<String, ManifestParser.Section> entryNameToManifestSection, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds, int minSdkVersion, int maxSdkVersion) throws NoSuchAlgorithmException {
            ManifestParser sf = new ManifestParser(this.mSigFileBytes);
            ManifestParser.Section sfMainSection = sf.readSection();
            if (sfMainSection.getAttributeValue(Attributes.Name.SIGNATURE_VERSION) == null) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MISSING_VERSION_ATTR_IN_SIG_FILE, new Object[]{this.mSignatureFileEntry.getName()});
                this.setIgnored();
                return;
            }
            if (maxSdkVersion >= 24) {
                this.checkForStrippedApkSignatures(sfMainSection, supportedApkSigSchemeNames, foundApkSigSchemeIds);
                if (this.mResult.containsErrors()) {
                    return;
                }
            }
            boolean createdBySigntool = false;
            String createdBy = sfMainSection.getAttributeValue("Created-By");
            if (createdBy != null) {
                createdBySigntool = createdBy.indexOf("signtool") != -1;
            }
            boolean manifestDigestVerified = this.verifyManifestDigest(sfMainSection, createdBySigntool, manifestBytes, minSdkVersion, maxSdkVersion);
            if (!createdBySigntool) {
                this.verifyManifestMainSectionDigest(sfMainSection, manifestMainSection, manifestBytes, minSdkVersion, maxSdkVersion);
            }
            if (this.mResult.containsErrors()) {
                return;
            }
            List<ManifestParser.Section> sfSections = sf.readAllSections();
            HashSet<String> sfEntryNames = new HashSet<String>(sfSections.size());
            int sfSectionNumber = 0;
            for (ManifestParser.Section sfSection : sfSections) {
                ++sfSectionNumber;
                String entryName = sfSection.getName();
                if (entryName == null) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_UNNNAMED_SIG_FILE_SECTION, new Object[]{this.mSignatureFileEntry.getName(), sfSectionNumber});
                    this.setIgnored();
                    return;
                }
                if (!sfEntryNames.add(entryName)) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_SIG_FILE_SECTION, new Object[]{this.mSignatureFileEntry.getName(), entryName});
                    this.setIgnored();
                    return;
                }
                if (manifestDigestVerified) continue;
                ManifestParser.Section manifestSection = entryNameToManifestSection.get(entryName);
                if (manifestSection == null) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE, new Object[]{entryName, this.mSignatureFileEntry.getName()});
                    this.setIgnored();
                    continue;
                }
                this.verifyManifestIndividualSectionDigest(sfSection, createdBySigntool, manifestSection, manifestBytes, minSdkVersion, maxSdkVersion);
            }
            this.mSigFileEntryNames = sfEntryNames;
        }

        private boolean verifyManifestDigest(ManifestParser.Section sfMainSection, boolean createdBySigntool, byte[] manifestBytes, int minSdkVersion, int maxSdkVersion) throws NoSuchAlgorithmException {
            boolean digestFound;
            Collection<NamedDigest> expectedDigests = V1SchemeVerifier.getDigestsToVerify(sfMainSection, createdBySigntool ? "-Digest" : "-Digest-Manifest", minSdkVersion, maxSdkVersion);
            boolean bl = digestFound = !expectedDigests.isEmpty();
            if (!digestFound) {
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_NO_MANIFEST_DIGEST_IN_SIG_FILE, new Object[]{this.mSignatureFileEntry.getName()});
                return false;
            }
            boolean verified = true;
            for (NamedDigest expectedDigest : expectedDigests) {
                byte[] expected = expectedDigest.digest;
                String jcaDigestAlgorithm = expectedDigest.jcaDigestAlgorithm;
                byte[] actual = V1SchemeVerifier.digest(jcaDigestAlgorithm, manifestBytes);
                if (Arrays.equals(expected, actual)) continue;
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY, new Object[]{"META-INF/MANIFEST.MF", jcaDigestAlgorithm, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(actual), Base64.getEncoder().encodeToString(expected)});
                verified = false;
            }
            return verified;
        }

        private void verifyManifestMainSectionDigest(ManifestParser.Section sfMainSection, ManifestParser.Section manifestMainSection, byte[] manifestBytes, int minSdkVersion, int maxSdkVersion) throws NoSuchAlgorithmException {
            Collection<NamedDigest> expectedDigests = V1SchemeVerifier.getDigestsToVerify(sfMainSection, "-Digest-Manifest-Main-Attributes", minSdkVersion, maxSdkVersion);
            if (expectedDigests.isEmpty()) {
                return;
            }
            for (NamedDigest expectedDigest : expectedDigests) {
                byte[] expected = expectedDigest.digest;
                String jcaDigestAlgorithm = expectedDigest.jcaDigestAlgorithm;
                byte[] actual = V1SchemeVerifier.digest(jcaDigestAlgorithm, manifestBytes, manifestMainSection.getStartOffset(), manifestMainSection.getSizeBytes());
                if (Arrays.equals(expected, actual)) continue;
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MANIFEST_MAIN_SECTION_DIGEST_DID_NOT_VERIFY, new Object[]{jcaDigestAlgorithm, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(actual), Base64.getEncoder().encodeToString(expected)});
            }
        }

        private void verifyManifestIndividualSectionDigest(ManifestParser.Section sfIndividualSection, boolean createdBySigntool, ManifestParser.Section manifestIndividualSection, byte[] manifestBytes, int minSdkVersion, int maxSdkVersion) throws NoSuchAlgorithmException {
            int sectionEndIndex;
            String entryName = sfIndividualSection.getName();
            Collection<NamedDigest> expectedDigests = V1SchemeVerifier.getDigestsToVerify(sfIndividualSection, "-Digest", minSdkVersion, maxSdkVersion);
            if (expectedDigests.isEmpty()) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE, new Object[]{entryName, this.mSignatureFileEntry.getName()});
                return;
            }
            int sectionStartIndex = manifestIndividualSection.getStartOffset();
            int sectionSizeBytes = manifestIndividualSection.getSizeBytes();
            if (createdBySigntool && manifestBytes[(sectionEndIndex = sectionStartIndex + sectionSizeBytes) - 1] == 10 && manifestBytes[sectionEndIndex - 2] == 10) {
                --sectionSizeBytes;
            }
            for (NamedDigest expectedDigest : expectedDigests) {
                byte[] expected = expectedDigest.digest;
                String jcaDigestAlgorithm = expectedDigest.jcaDigestAlgorithm;
                byte[] actual = V1SchemeVerifier.digest(jcaDigestAlgorithm, manifestBytes, sectionStartIndex, sectionSizeBytes);
                if (Arrays.equals(expected, actual)) continue;
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MANIFEST_SECTION_DIGEST_DID_NOT_VERIFY, new Object[]{entryName, jcaDigestAlgorithm, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(actual), Base64.getEncoder().encodeToString(expected)});
            }
        }

        private void checkForStrippedApkSignatures(ManifestParser.Section sfMainSection, Map<Integer, String> supportedApkSigSchemeNames, Set<Integer> foundApkSigSchemeIds) {
            int id;
            String signedWithApkSchemes = sfMainSection.getAttributeValue("X-Android-APK-Signed");
            if (signedWithApkSchemes == null) {
                if (!foundApkSigSchemeIds.isEmpty()) {
                    this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_NO_APK_SIG_STRIP_PROTECTION, new Object[]{this.mSignatureFileEntry.getName()});
                }
                return;
            }
            if (supportedApkSigSchemeNames.isEmpty()) {
                return;
            }
            Set<Integer> supportedApkSigSchemeIds = supportedApkSigSchemeNames.keySet();
            HashSet<Integer> supportedExpectedApkSigSchemeIds = new HashSet<Integer>(1);
            StringTokenizer tokenizer = new StringTokenizer(signedWithApkSchemes, ",");
            while (tokenizer.hasMoreTokens()) {
                String idText = tokenizer.nextToken().trim();
                if (idText.isEmpty()) continue;
                try {
                    id = Integer.parseInt(idText);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (supportedApkSigSchemeIds.contains(id)) {
                    supportedExpectedApkSigSchemeIds.add(id);
                    continue;
                }
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_UNKNOWN_APK_SIG_SCHEME_ID, new Object[]{this.mSignatureFileEntry.getName(), id});
            }
            Iterator iterator = supportedExpectedApkSigSchemeIds.iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                if (foundApkSigSchemeIds.contains(id)) continue;
                String apkSigSchemeName = supportedApkSigSchemeNames.get(id);
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MISSING_APK_SIG_REFERENCED, new Object[]{this.mSignatureFileEntry.getName(), id, apkSigSchemeName});
            }
        }
    }

    @Asn1Class(type=Asn1Type.CHOICE)
    public static class ObjectIdentifierChoice {
        @Asn1Field(type=Asn1Type.OBJECT_IDENTIFIER)
        public String value;
    }

    @Asn1Class(type=Asn1Type.CHOICE)
    public static class OctetStringChoice {
        @Asn1Field(type=Asn1Type.OCTET_STRING)
        public byte[] value;
    }

    private static class SignedAttributes {
        private Map<String, List<Asn1OpaqueObject>> mAttrs;

        public SignedAttributes(Collection<Attribute> attrs) throws Pkcs7DecodingException {
            HashMap<String, List<Asn1OpaqueObject>> result = new HashMap<String, List<Asn1OpaqueObject>>(attrs.size());
            for (Attribute attr : attrs) {
                if (result.put(attr.attrType, attr.attrValues) == null) continue;
                throw new Pkcs7DecodingException("Duplicate signed attribute: " + attr.attrType);
            }
            this.mAttrs = result;
        }

        private Asn1OpaqueObject getSingleValue(String attrOid) throws Pkcs7DecodingException {
            List<Asn1OpaqueObject> values = this.mAttrs.get(attrOid);
            if (values == null || values.isEmpty()) {
                return null;
            }
            if (values.size() > 1) {
                throw new Pkcs7DecodingException("Attribute " + attrOid + " has multiple values");
            }
            return values.get(0);
        }

        public String getSingleObjectIdentifierValue(String attrOid) throws Pkcs7DecodingException {
            Asn1OpaqueObject value = this.getSingleValue(attrOid);
            if (value == null) {
                return null;
            }
            try {
                return Asn1BerParser.parse((ByteBuffer)value.getEncoded(), ObjectIdentifierChoice.class).value;
            }
            catch (Asn1DecodingException e) {
                throw new Pkcs7DecodingException("Failed to decode OBJECT IDENTIFIER", e);
            }
        }

        public byte[] getSingleOctetStringValue(String attrOid) throws Pkcs7DecodingException {
            Asn1OpaqueObject value = this.getSingleValue(attrOid);
            if (value == null) {
                return null;
            }
            try {
                return Asn1BerParser.parse((ByteBuffer)value.getEncoded(), OctetStringChoice.class).value;
            }
            catch (Asn1DecodingException e) {
                throw new Pkcs7DecodingException("Failed to decode OBJECT IDENTIFIER", e);
            }
        }
    }
}

