/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zfile;

import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.ZFiles;
import com.android.tools.build.apkzlib.zip.AlignmentRule;
import com.android.tools.build.apkzlib.zip.AlignmentRules;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ApkZFileCreator
implements ApkCreator {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final AlignmentRule SO_RULE = AlignmentRules.constantForSuffix(".so", 4096);
    @Nonnull
    private final ZFile zip;
    private boolean closed;
    @Nonnull
    private final Predicate<String> noCompressPredicate;

    ApkZFileCreator(@Nonnull ApkCreatorFactory.CreationData creationData, @Nonnull ZFileOptions options) throws IOException {
        switch (creationData.getNativeLibrariesPackagingMode()) {
            case COMPRESSED: {
                this.noCompressPredicate = creationData.getNoCompressPredicate();
                break;
            }
            case UNCOMPRESSED_AND_ALIGNED: {
                this.noCompressPredicate = creationData.getNoCompressPredicate().or(name -> name.endsWith(NATIVE_LIBRARIES_SUFFIX));
                options.setAlignmentRule(AlignmentRules.compose(SO_RULE, options.getAlignmentRule()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.zip = ZFiles.apk(creationData.getApkPath(), options, creationData.getPrivateKey(), creationData.getCertificate(), creationData.isV1SigningEnabled(), creationData.isV2SigningEnabled(), creationData.getBuiltBy(), creationData.getCreatedBy(), creationData.getMinSdkVersion());
        this.closed = false;
    }

    @Override
    public void writeZip(@Nonnull File zip, @Nullable Function<String, String> transform, @Nullable Predicate<String> isIgnored) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed == true");
        Preconditions.checkArgument((boolean)zip.isFile(), (Object)"!zip.isFile()");
        try (Closer closer = Closer.create();){
            ZFile toMerge = (ZFile)closer.register((Closeable)new ZFile(zip));
            Predicate<String> ignorePredicate = isIgnored == null ? s -> false : isIgnored;
            Predicate<String> noMergePredicate = ignorePredicate.or(this.noCompressPredicate);
            this.zip.mergeFrom(toMerge, noMergePredicate);
            for (StoredEntry toMergeEntry : toMerge.entries()) {
                String path = toMergeEntry.getCentralDirectoryHeader().getName();
                if (!this.noCompressPredicate.test(path) || ignorePredicate.test(path)) continue;
                InputStream ignoredData = toMergeEntry.open();
                Throwable throwable = null;
                try {
                    this.zip.add(path, ignoredData, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignoredData == null) continue;
                    if (throwable != null) {
                        try {
                            ignoredData.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignoredData.close();
                }
            }
        }
    }

    @Override
    public void writeFile(@Nonnull File inputFile, @Nonnull String apkPath) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed == true");
        boolean mayCompress = !this.noCompressPredicate.test(apkPath);
        try (Closer closer = Closer.create();){
            FileInputStream inputFileStream = (FileInputStream)closer.register((Closeable)new FileInputStream(inputFile));
            this.zip.add(apkPath, inputFileStream, mayCompress);
        }
    }

    @Override
    public void deleteFile(@Nonnull String apkPath) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed == true");
        StoredEntry entry = this.zip.get(apkPath);
        if (entry != null) {
            entry.delete();
        }
    }

    @Override
    public boolean hasPendingChangesWithWait() throws IOException {
        return this.zip.hasPendingChangesWithWait();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.zip.close();
        this.closed = true;
    }
}

