/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zip;

import com.android.tools.build.apkzlib.utils.CachedFileContents;
import com.android.tools.build.apkzlib.utils.IOExceptionFunction;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.android.tools.build.apkzlib.zip.AlignmentRule;
import com.android.tools.build.apkzlib.zip.CentralDirectory;
import com.android.tools.build.apkzlib.zip.CentralDirectoryHeader;
import com.android.tools.build.apkzlib.zip.CentralDirectoryHeaderCompressInfo;
import com.android.tools.build.apkzlib.zip.CompressionMethod;
import com.android.tools.build.apkzlib.zip.CompressionResult;
import com.android.tools.build.apkzlib.zip.Compressor;
import com.android.tools.build.apkzlib.zip.DataDescriptorType;
import com.android.tools.build.apkzlib.zip.EncodeUtils;
import com.android.tools.build.apkzlib.zip.Eocd;
import com.android.tools.build.apkzlib.zip.ExtraField;
import com.android.tools.build.apkzlib.zip.FileUseMap;
import com.android.tools.build.apkzlib.zip.FileUseMapEntry;
import com.android.tools.build.apkzlib.zip.GPFlags;
import com.android.tools.build.apkzlib.zip.InflaterByteSource;
import com.android.tools.build.apkzlib.zip.LazyDelegateByteSource;
import com.android.tools.build.apkzlib.zip.ProcessedAndRawByteSources;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.VerifyLog;
import com.android.tools.build.apkzlib.zip.ZFileExtension;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import com.android.tools.build.apkzlib.zip.ZipFileState;
import com.android.tools.build.apkzlib.zip.compress.Zip64NotSupportedException;
import com.android.tools.build.apkzlib.zip.utils.ByteTracker;
import com.android.tools.build.apkzlib.zip.utils.CloseableByteSource;
import com.android.tools.build.apkzlib.zip.utils.CloseableDelegateByteSource;
import com.android.tools.build.apkzlib.zip.utils.LittleEndianUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ZFile
implements Closeable {
    public static final char SEPARATOR = '/';
    private static final int MIN_EOCD_SIZE = 22;
    private static final int ZIP64_EOCD_LOCATOR_SIZE = 20;
    private static final int MAX_EOCD_COMMENT_SIZE = 65535;
    private static final int LAST_BYTES_TO_READ = 65557;
    private static final int ZIP64_EOCD_LOCATOR_SIGNATURE = 117853008;
    private static final byte[] EOCD_SIGNATURE = new byte[]{6, 5, 75, 80};
    private static final int IO_BUFFER_SIZE = 0x100000;
    private static final int MAXIMUM_EXTENSION_CYCLE_COUNT = 10;
    private static final int MINIMUM_EXTRA_FIELD_SIZE = 6;
    private static final int MAX_LOCAL_EXTRA_FIELD_CONTENTS_SIZE = Short.MAX_VALUE;
    @Nonnull
    private final File file;
    @Nullable
    private RandomAccessFile raf;
    @Nonnull
    private final FileUseMap map;
    @Nullable
    private FileUseMapEntry<Eocd> eocdEntry;
    @Nullable
    private FileUseMapEntry<CentralDirectory> directoryEntry;
    @Nonnull
    private final Map<String, FileUseMapEntry<StoredEntry>> entries;
    @Nonnull
    private final List<StoredEntry> uncompressedEntries;
    @Nonnull
    private ZipFileState state;
    private boolean dirty;
    @Nullable
    private CachedFileContents<Object> closedControl;
    @Nonnull
    private final AlignmentRule alignmentRule;
    @Nonnull
    private final List<ZFileExtension> extensions;
    @Nonnull
    private final List<IOExceptionRunnable> toRun;
    private boolean isNotifying;
    private long extraDirectoryOffset;
    private boolean noTimestamps;
    @Nonnull
    private Compressor compressor;
    @Nonnull
    private final ByteTracker tracker;
    private boolean coverEmptySpaceUsingExtraField;
    private boolean autoSortFiles;
    @Nonnull
    private final Supplier<VerifyLog> verifyLogFactory;
    @Nonnull
    private final VerifyLog verifyLog;
    @Nullable
    private byte[] eocdComment;
    private boolean readOnly;

    public ZFile(@Nonnull File file) throws IOException {
        this(file, new ZFileOptions());
    }

    public ZFile(@Nonnull File file, @Nonnull ZFileOptions options) throws IOException {
        this(file, options, false);
    }

    public ZFile(@Nonnull File file, @Nonnull ZFileOptions options, boolean readOnly) throws IOException {
        this.file = file;
        this.map = new FileUseMap(0L, options.getCoverEmptySpaceUsingExtraField() ? 6 : 0);
        this.readOnly = readOnly;
        this.dirty = false;
        this.closedControl = null;
        this.alignmentRule = options.getAlignmentRule();
        this.extensions = Lists.newArrayList();
        this.toRun = Lists.newArrayList();
        this.noTimestamps = options.getNoTimestamps();
        this.tracker = options.getTracker();
        this.compressor = options.getCompressor();
        this.coverEmptySpaceUsingExtraField = options.getCoverEmptySpaceUsingExtraField();
        this.autoSortFiles = options.getAutoSortFiles();
        this.verifyLogFactory = options.getVerifyLogFactory();
        this.verifyLog = this.verifyLogFactory.get();
        this.state = ZipFileState.CLOSED;
        this.raf = null;
        if (file.exists()) {
            this.openReadOnly();
        } else {
            if (readOnly) {
                throw new IOException("File does not exist but read-only mode requested");
            }
            this.dirty = true;
        }
        this.entries = Maps.newHashMap();
        this.uncompressedEntries = Lists.newArrayList();
        this.extraDirectoryOffset = 0L;
        try {
            if (this.state != ZipFileState.CLOSED) {
                long rafSize = this.raf.length();
                if (rafSize > Integer.MAX_VALUE) {
                    throw new IOException("File exceeds size limit of 2147483647.");
                }
                this.map.extend(Ints.checkedCast((long)rafSize));
                this.readData();
            }
            if (this.eocdEntry == null) {
                this.eocdComment = new byte[0];
            }
            if (this.state != ZipFileState.CLOSED) {
                this.notify(ZFileExtension::open);
            }
        }
        catch (Zip64NotSupportedException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Failed to read zip file '" + file.getAbsolutePath() + "'.", e);
        }
        catch (VerifyException | IllegalArgumentException | IllegalStateException e) {
            throw new RuntimeException("Internal error when trying to read zip file '" + file.getAbsolutePath() + "'.", e);
        }
    }

    @Nonnull
    public Set<StoredEntry> entries() {
        HashMap entries = Maps.newHashMap();
        for (FileUseMapEntry<StoredEntry> mapEntry : this.entries.values()) {
            StoredEntry entry = mapEntry.getStore();
            assert (entry != null);
            entries.put(entry.getCentralDirectoryHeader().getName(), entry);
        }
        for (StoredEntry uncompressed : this.uncompressedEntries) {
            entries.put(uncompressed.getCentralDirectoryHeader().getName(), uncompressed);
        }
        return Sets.newHashSet(entries.values());
    }

    @Nullable
    public StoredEntry get(@Nonnull String path) {
        for (StoredEntry stillUncompressed : Lists.reverse(this.uncompressedEntries)) {
            if (!stillUncompressed.getCentralDirectoryHeader().getName().equals(path)) continue;
            return stillUncompressed;
        }
        FileUseMapEntry<StoredEntry> found = this.entries.get(path);
        if (found == null) {
            return null;
        }
        return found.getStore();
    }

    private void readData() throws IOException {
        long directoryStartOffset;
        long entryEndOffset;
        Preconditions.checkState((this.state != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"state == ZipFileState.CLOSED");
        Preconditions.checkState((this.raf != null ? 1 : 0) != 0, (Object)"raf == null");
        this.readEocd();
        this.readCentralDirectory();
        if (this.directoryEntry != null) {
            CentralDirectory directory = this.directoryEntry.getStore();
            assert (directory != null);
            entryEndOffset = 0L;
            for (StoredEntry entry : directory.getEntries().values()) {
                long start = entry.getCentralDirectoryHeader().getOffset();
                long end = start + entry.getInFileSize();
                Verify.verify((start >= 0L ? 1 : 0) != 0, (String)"start < 0", (Object[])new Object[0]);
                Verify.verify((end < this.map.size() ? 1 : 0) != 0, (String)"end >= map.size()", (Object[])new Object[0]);
                FileUseMapEntry<?> found = this.map.at(start);
                Verify.verifyNotNull(found);
                if (!found.isFree() || found.getEnd() < end) {
                    String overlappingEntryDescription;
                    Object foundEntry;
                    if (found.isFree()) {
                        Verify.verify(((found = this.map.after(found)) != null && !found.isFree() ? 1 : 0) != 0);
                    }
                    Verify.verify(((foundEntry = found.getStore()) != null ? 1 : 0) != 0);
                    IOExceptionFunction<StoredEntry, String> describe = e -> String.format("'%s' (offset: %d, size: %d)", e.getCentralDirectoryHeader().getName(), e.getCentralDirectoryHeader().getOffset(), e.getInFileSize());
                    if (foundEntry instanceof StoredEntry) {
                        StoredEntry foundStored = (StoredEntry)foundEntry;
                        overlappingEntryDescription = describe.apply((StoredEntry)foundEntry);
                    } else {
                        overlappingEntryDescription = "Central Directory / EOCD: " + found.getStart() + " - " + found.getEnd();
                    }
                    throw new IOException("Cannot read entry " + describe.apply(entry) + " because it overlaps with " + overlappingEntryDescription);
                }
                FileUseMapEntry<StoredEntry> mapEntry = this.map.add(start, end, entry);
                this.entries.put(entry.getCentralDirectoryHeader().getName(), mapEntry);
                if (end <= entryEndOffset) continue;
                entryEndOffset = end;
            }
            directoryStartOffset = this.directoryEntry.getStart();
        } else {
            Verify.verifyNotNull(this.eocdEntry);
            assert (this.eocdEntry != null);
            directoryStartOffset = this.eocdEntry.getStart();
            entryEndOffset = 0L;
        }
        long extraOffset = directoryStartOffset - entryEndOffset;
        Verify.verify((extraOffset >= 0L ? 1 : 0) != 0, (String)"extraOffset (%s) < 0", (Object[])new Object[]{extraOffset});
        this.extraDirectoryOffset = extraOffset;
    }

    private void readEocd() throws IOException {
        Preconditions.checkState((this.state != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"state == ZipFileState.CLOSED");
        Preconditions.checkState((this.raf != null ? 1 : 0) != 0, (Object)"raf == null");
        int lastToRead = 65557;
        if ((long)lastToRead > this.raf.length()) {
            lastToRead = Ints.checkedCast((long)this.raf.length());
        }
        byte[] last = new byte[lastToRead];
        this.directFullyRead(this.raf.length() - (long)lastToRead, last);
        Eocd eocd = null;
        int foundEocdSignature = -1;
        IOException errorFindingSignature = null;
        int eocdStart = -1;
        for (int endIdx = last.length - 22; endIdx >= 0 && foundEocdSignature == -1; --endIdx) {
            if (last[endIdx] != EOCD_SIGNATURE[3] || last[endIdx + 1] != EOCD_SIGNATURE[2] || last[endIdx + 2] != EOCD_SIGNATURE[1] || last[endIdx + 3] != EOCD_SIGNATURE[0]) continue;
            foundEocdSignature = endIdx;
            ByteBuffer eocdBytes = ByteBuffer.wrap(last, foundEocdSignature, last.length - foundEocdSignature);
            try {
                eocd = new Eocd(eocdBytes);
                eocdStart = Ints.checkedCast((long)(this.raf.length() - (long)lastToRead + (long)foundEocdSignature));
                if ((long)eocdStart + eocd.getEocdSize() == this.raf.length()) continue;
                this.verifyLog.log("EOCD starts at " + eocdStart + " and has " + eocd.getEocdSize() + " bytes, but file ends at " + this.raf.length() + ".");
                continue;
            }
            catch (IOException e) {
                if (errorFindingSignature != null) {
                    e.addSuppressed(errorFindingSignature);
                }
                errorFindingSignature = e;
                foundEocdSignature = -1;
                eocd = null;
            }
        }
        if (foundEocdSignature == -1) {
            throw new IOException("EOCD signature not found in the last " + lastToRead + " bytes of the file.", errorFindingSignature);
        }
        Verify.verify((eocdStart >= 0 ? 1 : 0) != 0);
        int zip64LocatorStart = eocdStart - 20;
        if (zip64LocatorStart >= 0) {
            byte[] possibleZip64Locator = new byte[4];
            this.directFullyRead((long)zip64LocatorStart, possibleZip64Locator);
            if (LittleEndianUtils.readUnsigned4Le(ByteBuffer.wrap(possibleZip64Locator)) == 117853008L) {
                throw new Zip64NotSupportedException("Zip64 EOCD locator found but Zip64 format is not supported.");
            }
        }
        this.eocdEntry = this.map.add(eocdStart, (long)eocdStart + eocd.getEocdSize(), eocd);
    }

    private void readCentralDirectory() throws IOException {
        Preconditions.checkNotNull(this.eocdEntry, (Object)"eocdEntry == null");
        Preconditions.checkNotNull((Object)this.eocdEntry.getStore(), (Object)"eocdEntry.getStore() == null");
        Preconditions.checkState((this.state != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"state == ZipFileState.CLOSED");
        Preconditions.checkState((this.raf != null ? 1 : 0) != 0, (Object)"raf == null");
        Preconditions.checkState((this.directoryEntry == null ? 1 : 0) != 0, (Object)"directoryEntry != null");
        Eocd eocd = this.eocdEntry.getStore();
        long dirSize = eocd.getDirectorySize();
        if (dirSize > Integer.MAX_VALUE) {
            throw new IOException("Cannot read central directory with size " + dirSize + ".");
        }
        long centralDirectoryEnd = eocd.getDirectoryOffset() + dirSize;
        if (centralDirectoryEnd != this.eocdEntry.getStart()) {
            String msg = "Central directory is stored in [" + eocd.getDirectoryOffset() + " - " + (centralDirectoryEnd - 1L) + "] and EOCD starts at " + this.eocdEntry.getStart() + ".";
            if (centralDirectoryEnd > this.eocdEntry.getSize()) {
                throw new IOException(msg);
            }
            this.verifyLog.log(msg);
        }
        byte[] directoryData = new byte[Ints.checkedCast((long)dirSize)];
        this.directFullyRead(eocd.getDirectoryOffset(), directoryData);
        CentralDirectory directory = CentralDirectory.makeFromData(ByteBuffer.wrap(directoryData), eocd.getTotalRecords(), this);
        if (eocd.getDirectorySize() > 0L) {
            this.directoryEntry = this.map.add(eocd.getDirectoryOffset(), eocd.getDirectoryOffset() + eocd.getDirectorySize(), directory);
        }
    }

    @Nonnull
    public InputStream directOpen(final long start, final long end) throws IOException {
        Preconditions.checkState((this.state != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"state == ZipFileState.CLOSED");
        Preconditions.checkState((this.raf != null ? 1 : 0) != 0, (Object)"raf == null");
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start < 0");
        Preconditions.checkArgument((end >= start ? 1 : 0) != 0, (Object)"end < start");
        Preconditions.checkArgument((end <= this.raf.length() ? 1 : 0) != 0, (Object)"end > raf.length()");
        return new InputStream(){
            private long mCurr;
            {
                this.mCurr = start;
            }

            @Override
            public int read() throws IOException {
                if (this.mCurr == end) {
                    return -1;
                }
                byte[] b = new byte[1];
                int r = ZFile.this.directRead(this.mCurr, b);
                if (r > 0) {
                    ++this.mCurr;
                    return b[0];
                }
                return -1;
            }

            @Override
            public int read(@Nonnull byte[] b, int off, int len) throws IOException {
                Preconditions.checkNotNull((Object)b, (Object)"b == null");
                Preconditions.checkArgument((off >= 0 ? 1 : 0) != 0, (Object)"off < 0");
                Preconditions.checkArgument((off <= b.length ? 1 : 0) != 0, (Object)"off > b.length");
                Preconditions.checkArgument((len >= 0 ? 1 : 0) != 0, (Object)"len < 0");
                Preconditions.checkArgument((off + len <= b.length ? 1 : 0) != 0, (Object)"off + len > b.length");
                long availableToRead = end - this.mCurr;
                long toRead = Math.min((long)len, availableToRead);
                if (toRead == 0L) {
                    return -1;
                }
                if (toRead > Integer.MAX_VALUE) {
                    throw new IOException("Cannot read " + toRead + " bytes.");
                }
                int r = ZFile.this.directRead(this.mCurr, b, off, Ints.checkedCast((long)toRead));
                if (r > 0) {
                    this.mCurr += (long)r;
                }
                return r;
            }
        };
    }

    void delete(@Nonnull StoredEntry entry, boolean notify) throws IOException {
        this.checkNotInReadOnlyMode();
        String path = entry.getCentralDirectoryHeader().getName();
        FileUseMapEntry<StoredEntry> mapEntry = this.entries.get(path);
        Preconditions.checkNotNull(mapEntry, (Object)"mapEntry == null");
        Preconditions.checkArgument((entry == mapEntry.getStore() ? 1 : 0) != 0, (Object)"entry != mapEntry.getStore()");
        this.dirty = true;
        this.map.remove(mapEntry);
        this.entries.remove(path);
        if (notify) {
            this.notify(ext -> ext.removed(entry));
        }
    }

    private void checkNotInReadOnlyMode() {
        if (this.readOnly) {
            throw new IllegalStateException("Illegal operation in read only model");
        }
    }

    public void update() throws IOException {
        boolean bl;
        this.checkNotInReadOnlyMode();
        this.processAllReadyEntriesWithWait();
        this.notify(ZFileExtension::beforeUpdate);
        this.processAllReadyEntriesWithWait();
        if (!this.dirty) {
            return;
        }
        this.reopenRw();
        if (this.autoSortFiles) {
            this.sortZipContents();
        } else {
            this.packIfNecessary();
        }
        this.deleteDirectoryAndEocd();
        this.map.truncate();
        if (this.coverEmptySpaceUsingExtraField) {
            for (FileUseMapEntry<StoredEntry> fileUseMapEntry : new HashSet<FileUseMapEntry<StoredEntry>>(this.entries.values())) {
                ImmutableList currentSegments;
                StoredEntry storedEntry = fileUseMapEntry.getStore();
                assert (storedEntry != null);
                FileUseMapEntry<?> before = this.map.before(fileUseMapEntry);
                if (before == null || !before.isFree()) continue;
                int localExtraSize = storedEntry.getLocalExtra().size() + Ints.checkedCast((long)before.getSize());
                Verify.verify((localExtraSize <= Short.MAX_VALUE ? 1 : 0) != 0);
                storedEntry.loadSourceIntoMemory();
                long newStart = before.getStart();
                long newSize = fileUseMapEntry.getSize() + before.getSize();
                String name = storedEntry.getCentralDirectoryHeader().getName();
                this.map.remove(fileUseMapEntry);
                Verify.verify((fileUseMapEntry == this.entries.remove(name) ? 1 : 0) != 0);
                try {
                    currentSegments = storedEntry.getLocalExtra().getSegments();
                }
                catch (IOException e) {
                    currentSegments = ImmutableList.of();
                }
                ArrayList<ExtraField.AlignmentSegment> extraFieldSegments = new ArrayList<ExtraField.AlignmentSegment>();
                int newExtraFieldSize = currentSegments.stream().filter(s -> s.getHeaderId() != 55605).peek(extraFieldSegments::add).map(ExtraField.Segment::size).reduce(0, Integer::sum);
                int spaceToFill = Ints.checkedCast((long)(before.getSize() + (long)storedEntry.getLocalExtra().size() - (long)newExtraFieldSize));
                extraFieldSegments.add(new ExtraField.AlignmentSegment(this.chooseAlignment(storedEntry), spaceToFill));
                storedEntry.setLocalExtraNoNotify(new ExtraField((ImmutableList<ExtraField.Segment>)ImmutableList.copyOf(extraFieldSegments)));
                this.entries.put(name, this.map.add(newStart, newStart + newSize, storedEntry));
                storedEntry.getCentralDirectoryHeader().setOffset(-1L);
            }
        }
        TreeMap toWriteToStore = new TreeMap(FileUseMapEntry.COMPARE_BY_START);
        for (FileUseMapEntry<StoredEntry> entry : this.entries.values()) {
            StoredEntry entryStore = entry.getStore();
            assert (entryStore != null);
            if (entryStore.getCentralDirectoryHeader().getOffset() != -1L) continue;
            toWriteToStore.put(entry, entryStore);
        }
        for (FileUseMapEntry<?> freeArea : this.map.getFreeAreas()) {
            toWriteToStore.put(freeArea, null);
        }
        for (FileUseMapEntry<?> fileUseMapEntry : toWriteToStore.keySet()) {
            StoredEntry entry = (StoredEntry)toWriteToStore.get(fileUseMapEntry);
            if (entry == null) {
                int size = Ints.checkedCast((long)fileUseMapEntry.getSize());
                this.directWrite(fileUseMapEntry.getStart(), new byte[size]);
                continue;
            }
            this.writeEntry(entry, fileUseMapEntry.getStart());
        }
        int extensionBugDetector = 10;
        do {
            this.computeCentralDirectory();
            this.computeEocd();
            bl = this.directoryEntry != null;
            this.notify(ext -> {
                ext.entriesWritten();
                return null;
            });
            if (--extensionBugDetector != 0) continue;
            throw new IOException("Extensions keep resetting the central directory. This is probably a bug.");
        } while (bl && this.directoryEntry == null);
        this.appendCentralDirectory();
        this.appendEocd();
        Verify.verifyNotNull((Object)this.raf);
        this.raf.setLength(this.map.size());
        this.dirty = false;
        this.notify(ext -> {
            ext.updated();
            return null;
        });
    }

    private void packIfNecessary() throws IOException {
        if (!this.coverEmptySpaceUsingExtraField) {
            return;
        }
        TreeSet entriesByLocation = new TreeSet(FileUseMapEntry.COMPARE_BY_START);
        entriesByLocation.addAll(this.entries.values());
        for (FileUseMapEntry fileUseMapEntry : entriesByLocation) {
            int localExtraSize;
            StoredEntry storedEntry = (StoredEntry)fileUseMapEntry.getStore();
            assert (storedEntry != null);
            FileUseMapEntry<?> before = this.map.before(fileUseMapEntry);
            if (before == null || !before.isFree() || (localExtraSize = storedEntry.getLocalExtra().size() + Ints.checkedCast((long)before.getSize())) <= Short.MAX_VALUE) continue;
            this.reAdd(storedEntry, PositionHint.LOWEST_OFFSET);
        }
    }

    private void reAdd(@Nonnull StoredEntry entry, @Nonnull PositionHint positionHint) throws IOException {
        String name = entry.getCentralDirectoryHeader().getName();
        FileUseMapEntry<StoredEntry> mapEntry = this.entries.get(name);
        Preconditions.checkNotNull(mapEntry);
        Preconditions.checkState((mapEntry.getStore() == entry ? 1 : 0) != 0);
        entry.loadSourceIntoMemory();
        this.map.remove(mapEntry);
        this.entries.remove(name);
        FileUseMapEntry<StoredEntry> positioned = this.positionInFile(entry, positionHint);
        this.entries.put(name, positioned);
        this.dirty = true;
    }

    void localHeaderChanged(@Nonnull StoredEntry entry, boolean resized) throws IOException {
        this.dirty = true;
        if (resized) {
            this.reAdd(entry, PositionHint.ANYWHERE);
        }
    }

    void centralDirectoryChanged() {
        this.dirty = true;
        this.deleteDirectoryAndEocd();
    }

    @Override
    public void close() throws IOException {
        try (Closeable ignored = this::innerClose;){
            if (!this.readOnly) {
                this.update();
            }
        }
        this.notify(ext -> {
            ext.closed();
            return null;
        });
    }

    private void deleteDirectoryAndEocd() {
        if (this.directoryEntry != null) {
            this.map.remove(this.directoryEntry);
            this.directoryEntry = null;
        }
        if (this.eocdEntry != null) {
            this.map.remove(this.eocdEntry);
            Eocd eocd = this.eocdEntry.getStore();
            Verify.verify((eocd != null ? 1 : 0) != 0);
            this.eocdComment = eocd.getComment();
            this.eocdEntry = null;
        }
    }

    private void writeEntry(@Nonnull StoredEntry entry, long offset) throws IOException {
        int r;
        Preconditions.checkArgument((entry.getDataDescriptorType() == DataDescriptorType.NO_DATA_DESCRIPTOR ? 1 : 0) != 0, (Object)"Cannot write entries with a data descriptor.");
        Preconditions.checkNotNull((Object)this.raf, (Object)"raf == null");
        Preconditions.checkState((this.state == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"state != ZipFileState.OPEN_RW");
        byte[] headerData = entry.toHeaderData();
        this.directWrite(offset, headerData);
        ProcessedAndRawByteSources source = entry.getSource();
        CloseableByteSource rawContents = source.getRawByteSource();
        byte[] chunk = new byte[0x100000];
        long writeOffset = offset + (long)headerData.length;
        InputStream is = rawContents.openStream();
        while ((r = is.read(chunk)) >= 0) {
            this.directWrite(writeOffset, chunk, 0, r);
            writeOffset += (long)r;
        }
        is.close();
        entry.replaceSourceFromZip(offset);
    }

    private void computeCentralDirectory() throws IOException {
        Preconditions.checkState((this.state == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"state != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.raf, (Object)"raf == null");
        Preconditions.checkState((this.directoryEntry == null ? 1 : 0) != 0, (Object)"directoryEntry == null");
        HashSet newStored = Sets.newHashSet();
        for (FileUseMapEntry<StoredEntry> mapEntry : this.entries.values()) {
            newStored.add(mapEntry.getStore());
        }
        this.map.truncate();
        CentralDirectory newDirectory = CentralDirectory.makeFromEntries(newStored, this);
        byte[] newDirectoryBytes = newDirectory.toBytes();
        long directoryOffset = this.map.size() + this.extraDirectoryOffset;
        this.map.extend(directoryOffset + (long)newDirectoryBytes.length);
        if (newDirectoryBytes.length > 0) {
            this.directoryEntry = this.map.add(directoryOffset, directoryOffset + (long)newDirectoryBytes.length, newDirectory);
        }
    }

    private void appendCentralDirectory() throws IOException {
        Preconditions.checkState((this.state == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"state != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.raf, (Object)"raf == null");
        if (this.entries.isEmpty()) {
            Preconditions.checkState((this.directoryEntry == null ? 1 : 0) != 0, (Object)"directoryEntry != null");
            return;
        }
        Preconditions.checkNotNull(this.directoryEntry, (Object)"directoryEntry != null");
        CentralDirectory newDirectory = this.directoryEntry.getStore();
        Preconditions.checkNotNull((Object)newDirectory, (Object)"newDirectory != null");
        byte[] newDirectoryBytes = newDirectory.toBytes();
        long directoryOffset = this.directoryEntry.getStart();
        this.directWrite(directoryOffset, newDirectoryBytes);
    }

    @Nonnull
    public byte[] getCentralDirectoryBytes() throws IOException {
        if (this.entries.isEmpty()) {
            Preconditions.checkState((this.directoryEntry == null ? 1 : 0) != 0, (Object)"directoryEntry != null");
            return new byte[0];
        }
        Preconditions.checkNotNull(this.directoryEntry, (Object)"directoryEntry == null");
        CentralDirectory cd = this.directoryEntry.getStore();
        Preconditions.checkNotNull((Object)cd, (Object)"cd == null");
        return cd.toBytes();
    }

    private void computeEocd() throws IOException {
        long dirStart;
        Preconditions.checkState((this.state == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"state != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.raf, (Object)"raf == null");
        if (this.directoryEntry == null) {
            Preconditions.checkState((boolean)this.entries.isEmpty(), (Object)"directoryEntry == null && !entries.isEmpty()");
        }
        long dirSize = 0L;
        if (this.directoryEntry != null) {
            CentralDirectory directory = this.directoryEntry.getStore();
            assert (directory != null);
            dirStart = this.directoryEntry.getStart();
            dirSize = this.directoryEntry.getSize();
            Verify.verify((directory.getEntries().size() == this.entries.size() ? 1 : 0) != 0);
        } else {
            dirStart = this.extraDirectoryOffset;
        }
        Verify.verify((this.eocdComment != null ? 1 : 0) != 0);
        Eocd eocd = new Eocd(this.entries.size(), dirStart, dirSize, this.eocdComment);
        this.eocdComment = null;
        byte[] eocdBytes = eocd.toBytes();
        long eocdOffset = this.map.size();
        this.map.extend(eocdOffset + (long)eocdBytes.length);
        this.eocdEntry = this.map.add(eocdOffset, eocdOffset + (long)eocdBytes.length, eocd);
    }

    private void appendEocd() throws IOException {
        Preconditions.checkState((this.state == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"state != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.raf, (Object)"raf == null");
        Preconditions.checkNotNull(this.eocdEntry, (Object)"eocdEntry == null");
        Eocd eocd = this.eocdEntry.getStore();
        Preconditions.checkNotNull((Object)eocd, (Object)"eocd == null");
        byte[] eocdBytes = eocd.toBytes();
        long eocdOffset = this.eocdEntry.getStart();
        this.directWrite(eocdOffset, eocdBytes);
    }

    @Nonnull
    public byte[] getEocdBytes() throws IOException {
        Preconditions.checkNotNull(this.eocdEntry, (Object)"eocdEntry == null");
        Eocd eocd = this.eocdEntry.getStore();
        Preconditions.checkNotNull((Object)eocd, (Object)"eocd == null");
        return eocd.toBytes();
    }

    private void innerClose() throws IOException {
        if (this.state == ZipFileState.CLOSED) {
            return;
        }
        Verify.verifyNotNull((Object)this.raf, (String)"raf == null", (Object[])new Object[0]);
        this.raf.close();
        this.raf = null;
        this.state = ZipFileState.CLOSED;
        if (this.closedControl == null) {
            this.closedControl = new CachedFileContents(this.file);
        }
        this.closedControl.closed(null);
    }

    public void openReadOnly() throws IOException {
        if (this.state != ZipFileState.CLOSED) {
            return;
        }
        this.state = ZipFileState.OPEN_RO;
        this.raf = new RandomAccessFile(this.file, "r");
    }

    private void reopenRw() throws IOException {
        boolean wasClosed;
        Verify.verify((!this.readOnly ? 1 : 0) != 0);
        if (this.state == ZipFileState.OPEN_RW) {
            return;
        }
        if (this.state == ZipFileState.OPEN_RO) {
            this.innerClose();
            wasClosed = false;
        } else {
            wasClosed = true;
        }
        Verify.verify((this.state == ZipFileState.CLOSED ? 1 : 0) != 0, (String)"state != ZpiFileState.CLOSED", (Object[])new Object[0]);
        Verify.verify((this.raf == null ? 1 : 0) != 0, (String)"raf != null", (Object[])new Object[0]);
        if (this.closedControl != null && !this.closedControl.isValid()) {
            throw new IOException("File '" + this.file.getAbsolutePath() + "' has been modified by an external application.");
        }
        this.raf = new RandomAccessFile(this.file, "rw");
        this.state = ZipFileState.OPEN_RW;
        for (StoredEntry entry : this.entries()) {
            this.dirty |= entry.removeDataDescriptor();
        }
        if (wasClosed) {
            this.notify(ZFileExtension::open);
        }
    }

    public void add(@Nonnull String name, @Nonnull InputStream stream) throws IOException {
        this.checkNotInReadOnlyMode();
        this.add(name, stream, true);
    }

    @Nonnull
    private StoredEntry makeStoredEntry(@Nonnull String name, @Nonnull InputStream stream, boolean mayCompress) throws IOException {
        CloseableDelegateByteSource source = this.tracker.fromStream(stream);
        long crc32 = source.hash(Hashing.crc32()).padToLong();
        boolean encodeWithUtf8 = !EncodeUtils.canAsciiEncode(name);
        SettableFuture compressInfo = SettableFuture.create();
        GPFlags flags = GPFlags.make(encodeWithUtf8);
        CentralDirectoryHeader newFileData = new CentralDirectoryHeader(name, EncodeUtils.encode(name, flags), source.size(), (Future<CentralDirectoryHeaderCompressInfo>)compressInfo, flags, this);
        newFileData.setCrc32(crc32);
        Verify.verify((newFileData.getOffset() == -1L ? 1 : 0) != 0);
        return new StoredEntry(newFileData, this, this.createSources(mayCompress, source, (SettableFuture<CentralDirectoryHeaderCompressInfo>)compressInfo, newFileData));
    }

    @Nonnull
    private ProcessedAndRawByteSources createSources(boolean mayCompress, @Nonnull CloseableByteSource source, final @Nonnull SettableFuture<CentralDirectoryHeaderCompressInfo> compressInfo, final @Nonnull CentralDirectoryHeader newFileData) throws IOException {
        if (mayCompress) {
            ListenableFuture<CompressionResult> result = this.compressor.compress(source);
            Futures.addCallback(result, (FutureCallback)new FutureCallback<CompressionResult>(){

                public void onSuccess(CompressionResult result) {
                    compressInfo.set((Object)new CentralDirectoryHeaderCompressInfo(newFileData, result.getCompressionMethod(), result.getSize()));
                }

                public void onFailure(@Nonnull Throwable t) {
                    compressInfo.setException(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
            ListenableFuture compressedByteSourceFuture = Futures.transform(result, CompressionResult::getSource, (Executor)MoreExecutors.directExecutor());
            LazyDelegateByteSource compressedByteSource = new LazyDelegateByteSource((ListenableFuture<CloseableByteSource>)compressedByteSourceFuture);
            return new ProcessedAndRawByteSources(source, compressedByteSource);
        }
        compressInfo.set((Object)new CentralDirectoryHeaderCompressInfo(newFileData, CompressionMethod.STORE, source.size()));
        return new ProcessedAndRawByteSources(source, source);
    }

    public void add(@Nonnull String name, @Nonnull InputStream stream, boolean mayCompress) throws IOException {
        this.checkNotInReadOnlyMode();
        this.processAllReadyEntries();
        this.add(this.makeStoredEntry(name, stream, mayCompress));
    }

    private void add(@Nonnull StoredEntry newEntry) throws IOException {
        this.uncompressedEntries.add(newEntry);
        this.processAllReadyEntries();
    }

    private void processAllReadyEntries() throws IOException {
        while (!this.uncompressedEntries.isEmpty()) {
            StoredEntry next = this.uncompressedEntries.get(0);
            CentralDirectoryHeader cdh = next.getCentralDirectoryHeader();
            Future<CentralDirectoryHeaderCompressInfo> compressionInfo = cdh.getCompressionInfo();
            if (!compressionInfo.isDone()) {
                return;
            }
            this.uncompressedEntries.remove(0);
            try {
                compressionInfo.get();
            }
            catch (InterruptedException e) {
                throw new IOException("Impossible I/O exception: get for already computed future throws InterruptedException", e);
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to obtain compression information for entry", e);
            }
            this.addToEntries(next);
        }
    }

    private void processAllReadyEntriesWithWait() throws IOException {
        this.processAllReadyEntries();
        while (!this.uncompressedEntries.isEmpty()) {
            StoredEntry first = this.uncompressedEntries.get(0);
            CentralDirectoryHeader cdh = first.getCentralDirectoryHeader();
            cdh.getCompressionInfoWithWait();
            this.processAllReadyEntries();
        }
    }

    private void addToEntries(@Nonnull StoredEntry newEntry) throws IOException {
        StoredEntry replaceStore;
        Preconditions.checkArgument((newEntry.getDataDescriptorType() == DataDescriptorType.NO_DATA_DESCRIPTOR ? 1 : 0) != 0, (Object)"newEntry has data descriptor");
        FileUseMapEntry<StoredEntry> toReplace = this.entries.get(newEntry.getCentralDirectoryHeader().getName());
        if (toReplace != null) {
            replaceStore = toReplace.getStore();
            assert (replaceStore != null);
            replaceStore.delete(false);
        } else {
            replaceStore = null;
        }
        FileUseMapEntry<StoredEntry> fileUseMapEntry = this.positionInFile(newEntry, PositionHint.ANYWHERE);
        this.entries.put(newEntry.getCentralDirectoryHeader().getName(), fileUseMapEntry);
        this.dirty = true;
        this.notify(ext -> ext.added(newEntry, replaceStore));
    }

    @Nonnull
    private FileUseMapEntry<StoredEntry> positionInFile(@Nonnull StoredEntry entry, @Nonnull PositionHint positionHint) throws IOException {
        FileUseMap.PositionAlgorithm algorithm;
        this.deleteDirectoryAndEocd();
        long size = entry.getInFileSize();
        int localHeaderSize = entry.getLocalHeaderSize();
        int alignment = this.chooseAlignment(entry);
        switch (positionHint) {
            case LOWEST_OFFSET: {
                algorithm = FileUseMap.PositionAlgorithm.FIRST_FIT;
                break;
            }
            case ANYWHERE: {
                algorithm = FileUseMap.PositionAlgorithm.BEST_FIT;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long newOffset = this.map.locateFree(size, localHeaderSize, alignment, algorithm);
        long newEnd = newOffset + entry.getInFileSize();
        if (newEnd > this.map.size()) {
            this.map.extend(newEnd);
        }
        return this.map.add(newOffset, newEnd, entry);
    }

    private int chooseAlignment(@Nonnull StoredEntry entry) throws IOException {
        boolean isCompressed;
        CentralDirectoryHeader cdh = entry.getCentralDirectoryHeader();
        CentralDirectoryHeaderCompressInfo compressionInfo = cdh.getCompressionInfoWithWait();
        boolean bl = isCompressed = compressionInfo.getMethod() != CompressionMethod.STORE;
        if (isCompressed) {
            return 1;
        }
        return this.alignmentRule.alignment(cdh.getName());
    }

    public void mergeFrom(@Nonnull ZFile src, @Nonnull Predicate<String> ignoreFilter) throws IOException {
        this.checkNotInReadOnlyMode();
        for (StoredEntry fromEntry : src.entries()) {
            int r;
            CentralDirectoryHeader newFileData;
            if (ignoreFilter.test(fromEntry.getCentralDirectoryHeader().getName())) continue;
            boolean replaceCurrent = true;
            String path = fromEntry.getCentralDirectoryHeader().getName();
            FileUseMapEntry<StoredEntry> currentEntry = this.entries.get(path);
            if (currentEntry != null) {
                long fromSize = fromEntry.getCentralDirectoryHeader().getUncompressedSize();
                long fromCrc = fromEntry.getCentralDirectoryHeader().getCrc32();
                StoredEntry currentStore = currentEntry.getStore();
                assert (currentStore != null);
                long currentSize = currentStore.getCentralDirectoryHeader().getUncompressedSize();
                long currentCrc = currentStore.getCentralDirectoryHeader().getCrc32();
                if (fromSize == currentSize && fromCrc == currentCrc) {
                    replaceCurrent = false;
                }
            }
            if (!replaceCurrent) continue;
            CentralDirectoryHeader fromCdr = fromEntry.getCentralDirectoryHeader();
            CentralDirectoryHeaderCompressInfo fromCompressInfo = fromCdr.getCompressionInfoWithWait();
            try {
                newFileData = fromCdr.clone();
                newFileData.setOffset(-1L);
                newFileData.resetDeferredCrc();
            }
            catch (CloneNotSupportedException e) {
                throw new IOException("Failed to clone CDR.", e);
            }
            ProcessedAndRawByteSources fromSource = fromEntry.getSource();
            InputStream fromInput = fromSource.getRawByteSource().openStream();
            long sourceSize = fromSource.getRawByteSource().size();
            if (sourceSize > Integer.MAX_VALUE) {
                throw new IOException("Cannot read source with " + sourceSize + " bytes.");
            }
            byte[] data = new byte[Ints.checkedCast((long)sourceSize)];
            for (int read = 0; read < data.length; read += r) {
                r = fromInput.read(data, read, data.length - read);
                Verify.verify((r >= 0 ? 1 : 0) != 0, (String)"There should be at least 'size' bytes in the stream.", (Object[])new Object[0]);
            }
            CloseableDelegateByteSource rawContents = this.tracker.fromSource(fromSource.getRawByteSource());
            CloseableByteSource processedContents = fromCompressInfo.getMethod() == CompressionMethod.DEFLATE ? new InflaterByteSource(rawContents) : rawContents;
            ProcessedAndRawByteSources newSource = new ProcessedAndRawByteSources(processedContents, rawContents);
            StoredEntry newEntry = new StoredEntry(newFileData, this, newSource);
            this.add(newEntry);
        }
    }

    public void touch() {
        this.checkNotInReadOnlyMode();
        this.dirty = true;
    }

    public void finishAllBackgroundTasks() throws IOException {
        this.processAllReadyEntriesWithWait();
    }

    public boolean realign() throws IOException {
        this.checkNotInReadOnlyMode();
        boolean anyChanges = false;
        for (StoredEntry entry : this.entries()) {
            anyChanges |= entry.realign();
        }
        if (anyChanges) {
            this.dirty = true;
        }
        return anyChanges;
    }

    boolean realign(@Nonnull StoredEntry entry) throws IOException {
        CentralDirectoryHeader clonedCdh;
        FileUseMapEntry<StoredEntry> mapEntry = this.entries.get(entry.getCentralDirectoryHeader().getName());
        Verify.verify((entry == mapEntry.getStore() ? 1 : 0) != 0);
        long currentDataOffset = mapEntry.getStart() + (long)entry.getLocalHeaderSize();
        int expectedAlignment = this.chooseAlignment(entry);
        long misalignment = currentDataOffset % (long)expectedAlignment;
        if (misalignment == 0L) {
            return false;
        }
        if (entry.getCentralDirectoryHeader().getOffset() == -1L) {
            this.map.remove(mapEntry);
            long newStart = this.map.locateFree(mapEntry.getSize(), entry.getLocalHeaderSize(), expectedAlignment, FileUseMap.PositionAlgorithm.BEST_FIT);
            mapEntry = this.map.add(newStart, newStart + entry.getInFileSize(), entry);
            this.entries.put(entry.getCentralDirectoryHeader().getName(), mapEntry);
            Verify.verify((boolean)this.dirty);
            return false;
        }
        CentralDirectoryHeaderCompressInfo compressInfo = entry.getCentralDirectoryHeader().getCompressionInfoWithWait();
        ProcessedAndRawByteSources source = entry.getSource();
        try {
            clonedCdh = entry.getCentralDirectoryHeader().clone();
        }
        catch (CloneNotSupportedException e) {
            Verify.verify((boolean)false);
            return false;
        }
        clonedCdh.setOffset(-1L);
        clonedCdh.resetDeferredCrc();
        CloseableDelegateByteSource rawContents = this.tracker.fromSource(source.getRawByteSource());
        CloseableByteSource processedContents = compressInfo.getMethod() == CompressionMethod.DEFLATE ? new InflaterByteSource(rawContents) : rawContents;
        ProcessedAndRawByteSources newSource = new ProcessedAndRawByteSources(processedContents, rawContents);
        StoredEntry newEntry = new StoredEntry(clonedCdh, this, newSource);
        this.add(newEntry);
        return true;
    }

    public void addZFileExtension(@Nonnull ZFileExtension extension) {
        this.checkNotInReadOnlyMode();
        this.extensions.add(extension);
    }

    public void removeZFileExtension(@Nonnull ZFileExtension extension) {
        this.checkNotInReadOnlyMode();
        this.extensions.remove(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(@Nonnull IOExceptionFunction<ZFileExtension, IOExceptionRunnable> function) throws IOException {
        for (ZFileExtension fl : Lists.newArrayList(this.extensions)) {
            IOExceptionRunnable r = function.apply(fl);
            if (r == null) continue;
            this.toRun.add(r);
        }
        if (!this.isNotifying) {
            this.isNotifying = true;
            try {
                while (!this.toRun.isEmpty()) {
                    IOExceptionRunnable r = this.toRun.remove(0);
                    r.run();
                }
            }
            finally {
                this.isNotifying = false;
            }
        }
    }

    public void directWrite(long offset, @Nonnull byte[] data, int start, int count) throws IOException {
        this.checkNotInReadOnlyMode();
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start >= 0");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count >= 0");
        if (data.length == 0) {
            return;
        }
        Preconditions.checkArgument((start <= data.length ? 1 : 0) != 0, (Object)"start > data.length");
        Preconditions.checkArgument((start + count <= data.length ? 1 : 0) != 0, (Object)"start + count > data.length");
        this.reopenRw();
        assert (this.raf != null);
        this.raf.seek(offset);
        this.raf.write(data, start, count);
    }

    public void directWrite(long offset, @Nonnull byte[] data) throws IOException {
        this.checkNotInReadOnlyMode();
        this.directWrite(offset, data, 0, data.length);
    }

    public long directSize() throws IOException {
        if (this.raf == null) {
            this.reopenRw();
            assert (this.raf != null);
        }
        return this.raf.length();
    }

    public int directRead(long offset, @Nonnull byte[] data, int start, int count) throws IOException {
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start >= 0");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count >= 0");
        Preconditions.checkArgument((start <= data.length ? 1 : 0) != 0, (Object)"start > data.length");
        Preconditions.checkArgument((start + count <= data.length ? 1 : 0) != 0, (Object)"start + count > data.length");
        return this.directRead(offset, ByteBuffer.wrap(data, start, count));
    }

    public int directRead(long offset, @Nonnull ByteBuffer dest) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        if (!dest.hasRemaining()) {
            return 0;
        }
        if (this.raf == null) {
            this.reopenRw();
            assert (this.raf != null);
        }
        this.raf.seek(offset);
        return this.raf.getChannel().read(dest);
    }

    public int directRead(long offset, @Nonnull byte[] data) throws IOException {
        return this.directRead(offset, data, 0, data.length);
    }

    public void directFullyRead(long offset, @Nonnull byte[] data) throws IOException {
        this.directFullyRead(offset, ByteBuffer.wrap(data));
    }

    public void directFullyRead(long offset, @Nonnull ByteBuffer dest) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        if (!dest.hasRemaining()) {
            return;
        }
        if (this.raf == null) {
            this.reopenRw();
            assert (this.raf != null);
        }
        FileChannel fileChannel = this.raf.getChannel();
        while (dest.hasRemaining()) {
            fileChannel.position(offset);
            int chunkSize = fileChannel.read(dest);
            if (chunkSize == -1) {
                throw new EOFException("Failed to read " + dest.remaining() + " more bytes: premature EOF");
            }
            offset += (long)chunkSize;
        }
    }

    public void addAllRecursively(@Nonnull File file) throws IOException {
        this.checkNotInReadOnlyMode();
        this.addAllRecursively(file, f -> true);
    }

    public void addAllRecursively(@Nonnull File file, @Nonnull Function<? super File, Boolean> mayCompress) throws IOException {
        this.checkNotInReadOnlyMode();
        if (file.isFile()) {
            boolean mayCompressFile = (Boolean)Verify.verifyNotNull((Object)mayCompress.apply(file), (String)"mayCompress.apply() returned null", (Object[])new Object[0]);
            try (Closer closer = Closer.create();){
                FileInputStream fileInput = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
                this.add(file.getName(), fileInput, mayCompressFile);
            }
            return;
        }
        for (File f : Files.fileTreeTraverser().preOrderTraversal((Object)file).skip(1)) {
            String path = file.toURI().relativize(f.toURI()).getPath();
            Closer closer = Closer.create();
            Throwable throwable = null;
            try {
                boolean mayCompressFile;
                InputStream stream;
                if (f.isDirectory()) {
                    stream = (InputStream)closer.register((Closeable)new ByteArrayInputStream(new byte[0]));
                    mayCompressFile = false;
                } else {
                    stream = (InputStream)closer.register((Closeable)new FileInputStream(f));
                    mayCompressFile = (Boolean)Verify.verifyNotNull((Object)mayCompress.apply(f), (String)"mayCompress.apply() returned null", (Object[])new Object[0]);
                }
                this.add(path, stream, mayCompressFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closer == null) continue;
                if (throwable != null) {
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                closer.close();
            }
        }
    }

    public long getCentralDirectoryOffset() {
        if (this.directoryEntry != null) {
            return this.directoryEntry.getStart();
        }
        if (this.entries.isEmpty()) {
            return this.extraDirectoryOffset;
        }
        return this.map.usedSize() + this.extraDirectoryOffset;
    }

    public long getCentralDirectorySize() {
        if (this.directoryEntry != null) {
            return this.directoryEntry.getSize();
        }
        if (this.entries.isEmpty()) {
            return 0L;
        }
        return 1L;
    }

    public long getEocdOffset() {
        if (this.eocdEntry == null) {
            return -1L;
        }
        return this.eocdEntry.getStart();
    }

    public long getEocdSize() {
        if (this.eocdEntry == null) {
            return -1L;
        }
        return this.eocdEntry.getSize();
    }

    @Nonnull
    public byte[] getEocdComment() {
        if (this.eocdEntry == null) {
            Verify.verify((this.eocdComment != null ? 1 : 0) != 0);
            byte[] eocdCommentCopy = new byte[this.eocdComment.length];
            System.arraycopy(this.eocdComment, 0, eocdCommentCopy, 0, this.eocdComment.length);
            return eocdCommentCopy;
        }
        Eocd eocd = this.eocdEntry.getStore();
        Verify.verify((eocd != null ? 1 : 0) != 0);
        return eocd.getComment();
    }

    public void setEocdComment(@Nonnull byte[] comment) {
        this.checkNotInReadOnlyMode();
        if (comment.length > 65535) {
            throw new IllegalArgumentException("EOCD comment size (" + comment.length + ") is larger than the maximum allowed (" + 65535 + ")");
        }
        for (int i = 0; i < comment.length - 22; ++i) {
            if (comment[i] != EOCD_SIGNATURE[3] || comment[i + 1] != EOCD_SIGNATURE[2] || comment[i + 2] != EOCD_SIGNATURE[1] || comment[i + 3] != EOCD_SIGNATURE[0]) continue;
            ByteBuffer bytes = ByteBuffer.wrap(comment, i, comment.length - i);
            try {
                new Eocd(bytes);
                throw new IllegalArgumentException("Position " + i + " of the comment contains a valid EOCD record.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.deleteDirectoryAndEocd();
        this.eocdComment = new byte[comment.length];
        System.arraycopy(comment, 0, this.eocdComment, 0, comment.length);
        this.dirty = true;
    }

    public void setExtraDirectoryOffset(long offset) {
        this.checkNotInReadOnlyMode();
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        if (this.extraDirectoryOffset != offset) {
            this.extraDirectoryOffset = offset;
            this.deleteDirectoryAndEocd();
            this.dirty = true;
        }
    }

    public long getExtraDirectoryOffset() {
        return this.extraDirectoryOffset;
    }

    public boolean areTimestampsIgnored() {
        return this.noTimestamps;
    }

    public void sortZipContents() throws IOException {
        this.checkNotInReadOnlyMode();
        this.reopenRw();
        this.processAllReadyEntriesWithWait();
        Verify.verify((boolean)this.uncompressedEntries.isEmpty());
        TreeSet sortedEntries = Sets.newTreeSet(StoredEntry.COMPARE_BY_NAME);
        for (FileUseMapEntry<StoredEntry> fmEntry : this.entries.values()) {
            StoredEntry entry = fmEntry.getStore();
            Preconditions.checkNotNull((Object)entry);
            sortedEntries.add(entry);
            entry.loadSourceIntoMemory();
            this.map.remove(fmEntry);
        }
        this.entries.clear();
        for (StoredEntry entry : sortedEntries) {
            String name = entry.getCentralDirectoryHeader().getName();
            FileUseMapEntry<StoredEntry> positioned = this.positionInFile(entry, PositionHint.LOWEST_OFFSET);
            this.entries.put(name, positioned);
        }
        this.dirty = true;
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Nonnull
    VerifyLog makeVerifyLog() {
        VerifyLog log = this.verifyLogFactory.get();
        assert (log != null);
        return log;
    }

    @Nonnull
    VerifyLog getVerifyLog() {
        return this.verifyLog;
    }

    public boolean hasPendingChangesWithWait() throws IOException {
        this.processAllReadyEntriesWithWait();
        return this.dirty;
    }

    static enum PositionHint {
        ANYWHERE,
        LOWEST_OFFSET;

    }
}

