/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.bytestorage;

import com.android.tools.build.apkzlib.bytestorage.ByteStorage;
import com.android.tools.build.apkzlib.zip.utils.CloseableByteSource;
import com.android.tools.build.apkzlib.zip.utils.CloseableDelegateByteSource;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class InMemoryByteStorage
implements ByteStorage {
    private long bytesUsed;
    private long maxBytesUsed;

    InMemoryByteStorage() {
    }

    @Override
    public CloseableByteSource fromStream(InputStream stream) throws IOException {
        byte[] data = ByteStreams.toByteArray((InputStream)stream);
        this.updateUsage(data.length);
        return new CloseableDelegateByteSource(ByteSource.wrap((byte[])data), data.length){

            @Override
            public synchronized void innerClose() throws IOException {
                super.innerClose();
                InMemoryByteStorage.this.updateUsage(-this.sizeNoException());
            }
        };
    }

    @Override
    public CloseableByteSource fromStream(ByteArrayOutputStream stream) throws IOException {
        byte[] data = stream.toByteArray();
        this.updateUsage(data.length);
        return new CloseableDelegateByteSource(ByteSource.wrap((byte[])data), data.length){

            @Override
            public synchronized void innerClose() throws IOException {
                super.innerClose();
                InMemoryByteStorage.this.updateUsage(-this.sizeNoException());
            }
        };
    }

    @Override
    public CloseableByteSource fromSource(ByteSource source) throws IOException {
        return this.fromStream(source.openStream());
    }

    private synchronized void updateUsage(long delta) {
        this.bytesUsed += delta;
        if (this.maxBytesUsed < this.bytesUsed) {
            this.maxBytesUsed = this.bytesUsed;
        }
    }

    @Override
    public synchronized long getBytesUsed() {
        return this.bytesUsed;
    }

    @Override
    public synchronized long getMaxBytesUsed() {
        return this.maxBytesUsed;
    }

    @Override
    public void close() throws IOException {
    }
}

