/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.bytestorage;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;

class LruTracker<T> {
    private final BiMap<T, Integer> objectToAccessTime = HashBiMap.create();
    private final TreeSet<Integer> accessTimes = new TreeSet(Comparator.reverseOrder());
    private int currentTime = 1;

    LruTracker() {
    }

    synchronized void track(T object) {
        Preconditions.checkState((!this.objectToAccessTime.containsKey(object) ? 1 : 0) != 0);
        this.objectToAccessTime.put(object, (Object)this.currentTime);
        this.accessTimes.add(this.currentTime);
        ++this.currentTime;
    }

    synchronized void untrack(T object) {
        Preconditions.checkState((boolean)this.objectToAccessTime.containsKey(object));
        this.accessTimes.remove(this.objectToAccessTime.get(object));
        this.objectToAccessTime.remove(object);
    }

    synchronized void access(T object) {
        this.untrack(object);
        this.track(object);
    }

    synchronized int positionOf(T object) {
        Preconditions.checkState((boolean)this.objectToAccessTime.containsKey(object));
        int lastAccess = (Integer)this.objectToAccessTime.get(object);
        return this.accessTimes.headSet(lastAccess).size();
    }

    synchronized Optional<T> last() {
        if (this.accessTimes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.objectToAccessTime.inverse().get((Object)this.accessTimes.last()));
    }
}

