/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.bytestorage;

import com.android.tools.build.apkzlib.bytestorage.SwitchableDelegateInputStream;
import com.android.tools.build.apkzlib.zip.utils.CloseableByteSource;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class SwitchableDelegateCloseableByteSource
extends CloseableByteSource {
    private CloseableByteSource delegate;
    private boolean closed;
    private final List<SwitchableDelegateInputStream> nonClosedStreams;

    SwitchableDelegateCloseableByteSource(CloseableByteSource source) {
        this.delegate = source;
        this.nonClosedStreams = new ArrayList<SwitchableDelegateInputStream>();
    }

    @Override
    protected synchronized void innerClose() throws IOException {
        this.closed = true;
        try (Closer closer = Closer.create();){
            this.nonClosedStreams.forEach(arg_0 -> ((Closer)closer).register(arg_0));
            this.nonClosedStreams.clear();
        }
        this.delegate.close();
    }

    public synchronized InputStream openStream() throws IOException {
        SwitchableDelegateInputStream stream = new SwitchableDelegateInputStream(this.delegate.openStream()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                1 var1_1 = this;
                synchronized (var1_1) {
                    SwitchableDelegateCloseableByteSource.this.nonClosedStreams.remove(this);
                }
                super.close();
            }
        };
        this.nonClosedStreams.add(stream);
        return stream;
    }

    synchronized void switchSource(CloseableByteSource source) throws IOException {
        if (source == this.delegate) {
            return;
        }
        if (this.closed) {
            source.close();
            return;
        }
        ArrayList<InputStream> switchStreams = new ArrayList<InputStream>();
        for (int i = 0; i < this.nonClosedStreams.size(); ++i) {
            switchStreams.add(source.openStream());
        }
        CloseableByteSource oldDelegate = this.delegate;
        this.delegate = source;
        try (Closer closer = Closer.create();){
            for (int i = 0; i < this.nonClosedStreams.size(); ++i) {
                SwitchableDelegateInputStream nonClosedStream = this.nonClosedStreams.get(i);
                InputStream switchStream = (InputStream)switchStreams.get(i);
                closer.register(() -> nonClosedStream.switchStream(switchStream));
            }
            closer.register((Closeable)oldDelegate);
        }
    }
}

