
package com.android.tools.build.apkzlib.sign;

import com.google.common.collect.ImmutableList;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_SigningOptions extends SigningOptions {

  private final PrivateKey key;
  private final ImmutableList<X509Certificate> certificates;
  private final boolean v1SigningEnabled;
  private final boolean v2SigningEnabled;
  private final int minSdkVersion;

  private AutoValue_SigningOptions(
      PrivateKey key,
      ImmutableList<X509Certificate> certificates,
      boolean v1SigningEnabled,
      boolean v2SigningEnabled,
      int minSdkVersion) {
    this.key = key;
    this.certificates = certificates;
    this.v1SigningEnabled = v1SigningEnabled;
    this.v2SigningEnabled = v2SigningEnabled;
    this.minSdkVersion = minSdkVersion;
  }

  @Override
  public PrivateKey getKey() {
    return key;
  }

  @Override
  public ImmutableList<X509Certificate> getCertificates() {
    return certificates;
  }

  @Override
  public boolean isV1SigningEnabled() {
    return v1SigningEnabled;
  }

  @Override
  public boolean isV2SigningEnabled() {
    return v2SigningEnabled;
  }

  @Override
  public int getMinSdkVersion() {
    return minSdkVersion;
  }

  @Override
  public String toString() {
    return "SigningOptions{"
        + "key=" + key + ", "
        + "certificates=" + certificates + ", "
        + "v1SigningEnabled=" + v1SigningEnabled + ", "
        + "v2SigningEnabled=" + v2SigningEnabled + ", "
        + "minSdkVersion=" + minSdkVersion
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SigningOptions) {
      SigningOptions that = (SigningOptions) o;
      return (this.key.equals(that.getKey()))
           && (this.certificates.equals(that.getCertificates()))
           && (this.v1SigningEnabled == that.isV1SigningEnabled())
           && (this.v2SigningEnabled == that.isV2SigningEnabled())
           && (this.minSdkVersion == that.getMinSdkVersion());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.key.hashCode();
    h *= 1000003;
    h ^= this.certificates.hashCode();
    h *= 1000003;
    h ^= this.v1SigningEnabled ? 1231 : 1237;
    h *= 1000003;
    h ^= this.v2SigningEnabled ? 1231 : 1237;
    h *= 1000003;
    h ^= this.minSdkVersion;
    return h;
  }

  static final class Builder extends SigningOptions.Builder {
    private PrivateKey key;
    private ImmutableList<X509Certificate> certificates;
    private Boolean v1SigningEnabled;
    private Boolean v2SigningEnabled;
    private Integer minSdkVersion;
    Builder() {
    }
    @Override
    public SigningOptions.Builder setKey(PrivateKey key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    public SigningOptions.Builder setCertificates(ImmutableList<X509Certificate> certificates) {
      if (certificates == null) {
        throw new NullPointerException("Null certificates");
      }
      this.certificates = certificates;
      return this;
    }
    @Override
    public SigningOptions.Builder setCertificates(X509Certificate... certificates) {
      if (certificates == null) {
        throw new NullPointerException("Null certificates");
      }
      this.certificates = ImmutableList.copyOf(certificates);
      return this;
    }
    @Override
    public SigningOptions.Builder setV1SigningEnabled(boolean v1SigningEnabled) {
      this.v1SigningEnabled = v1SigningEnabled;
      return this;
    }
    @Override
    public SigningOptions.Builder setV2SigningEnabled(boolean v2SigningEnabled) {
      this.v2SigningEnabled = v2SigningEnabled;
      return this;
    }
    @Override
    public SigningOptions.Builder setMinSdkVersion(int minSdkVersion) {
      this.minSdkVersion = minSdkVersion;
      return this;
    }
    @Override
    SigningOptions autoBuild() {
      String missing = "";
      if (this.key == null) {
        missing += " key";
      }
      if (this.certificates == null) {
        missing += " certificates";
      }
      if (this.v1SigningEnabled == null) {
        missing += " v1SigningEnabled";
      }
      if (this.v2SigningEnabled == null) {
        missing += " v2SigningEnabled";
      }
      if (this.minSdkVersion == null) {
        missing += " minSdkVersion";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SigningOptions(
          this.key,
          this.certificates,
          this.v1SigningEnabled,
          this.v2SigningEnabled,
          this.minSdkVersion);
    }
  }

}
