/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency.level2;

import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.dependency.level2.ExtractedDependency;
import com.android.builder.model.MavenCoordinates;
import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Objects;

public final class AtomDependency
extends ExtractedDependency {
    private final String atomName;
    private final int hashCode;

    public AtomDependency(File artifactFile, MavenCoordinates coordinates, String name, String projectPath, File extractedFolder, String atomName, String variant) {
        super(artifactFile, coordinates, name, projectPath, extractedFolder, variant);
        this.atomName = atomName;
        this.hashCode = this.computeHashCode();
    }

    public String getAtomName() {
        return this.atomName;
    }

    @Override
    public File getJarFile() {
        return new File(this.getExtractedFolder(), "classes.jar");
    }

    @Override
    public List<File> getAdditionalClasspath() {
        return ImmutableList.of();
    }

    public File getDexFolder() {
        return new File(this.getExtractedFolder(), "dex");
    }

    public File getAtomMetadataFile() {
        return FileUtils.join((File)this.getExtractedFolder(), (String[])new String[]{"metadata", "atom-metadata"});
    }

    public File getLibFolder() {
        return new File(this.getExtractedFolder(), "libs");
    }

    public File getJavaResFolder() {
        return new File(this.getExtractedFolder(), "resources");
    }

    public File getResourcePackage() {
        return new File(this.getExtractedFolder(), "resources.ap_");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtomDependency that = (AtomDependency)o;
        return Objects.equals(this.atomName, that.atomName);
    }

    private int computeHashCode() {
        return HashCodeUtils.hashCode(super.hashCode(), this.atomName);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("artifactFile", (Object)this.getArtifactFile()).add("coordinates", (Object)this.getCoordinates()).add("projectPath", (Object)this.getProjectPath()).add("extractedFolder", (Object)this.getExtractedFolder()).add("atomName", (Object)this.atomName).toString();
    }
}

