/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.DefaultVectorDrawablesOptions;
import com.android.builder.internal.BaseConfigImpl;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultProductFlavor
extends BaseConfigImpl
implements ProductFlavor {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private String mDimension;
    private ApiVersion mMinSdkVersion;
    private ApiVersion mTargetSdkVersion;
    private Integer mMaxSdkVersion;
    private Integer mRenderscriptTargetApi;
    private Boolean mRenderscriptSupportModeEnabled;
    private Boolean mRenderscriptSupportModeBlasEnabled;
    private Boolean mRenderscriptNdkModeEnabled;
    private Integer mVersionCode;
    private String mVersionName;
    private String mApplicationId;
    private String mTestApplicationId;
    private String mTestInstrumentationRunner;
    private Map<String, String> mTestInstrumentationRunnerArguments = Maps.newHashMap();
    private Boolean mTestHandleProfiling;
    private Boolean mTestFunctionalTest;
    private SigningConfig mSigningConfig;
    private Set<String> mResourceConfiguration;
    private DefaultVectorDrawablesOptions mVectorDrawablesOptions;
    private Boolean mWearAppUnbundled;

    public DefaultProductFlavor(String name) {
        this.mName = name;
        this.mVectorDrawablesOptions = new DefaultVectorDrawablesOptions();
    }

    public DefaultProductFlavor(String name, DefaultVectorDrawablesOptions vectorDrawablesOptions) {
        this.mName = name;
        this.mVectorDrawablesOptions = vectorDrawablesOptions;
    }

    public String getName() {
        return this.mName;
    }

    public void setDimension(String dimension) {
        this.mDimension = dimension;
    }

    public String getDimension() {
        return this.mDimension;
    }

    public ProductFlavor setApplicationId(String applicationId) {
        this.mApplicationId = applicationId;
        return this;
    }

    public String getApplicationId() {
        return this.mApplicationId;
    }

    public ProductFlavor setVersionCode(Integer versionCode) {
        this.mVersionCode = versionCode;
        return this;
    }

    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    public ProductFlavor setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    public ProductFlavor setMinSdkVersion(ApiVersion minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
        return this;
    }

    public ApiVersion getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public ProductFlavor setTargetSdkVersion(ApiVersion targetSdkVersion) {
        this.mTargetSdkVersion = targetSdkVersion;
        return this;
    }

    public ApiVersion getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public ProductFlavor setMaxSdkVersion(Integer maxSdkVersion) {
        this.mMaxSdkVersion = maxSdkVersion;
        return this;
    }

    public Integer getMaxSdkVersion() {
        return this.mMaxSdkVersion;
    }

    public Integer getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public void setRenderscriptTargetApi(Integer renderscriptTargetApi) {
        this.mRenderscriptTargetApi = renderscriptTargetApi;
    }

    public Boolean getRenderscriptSupportModeEnabled() {
        return this.mRenderscriptSupportModeEnabled;
    }

    public Boolean getRenderscriptSupportModeBlasEnabled() {
        return this.mRenderscriptSupportModeBlasEnabled;
    }

    public ProductFlavor setRenderscriptSupportModeEnabled(Boolean renderscriptSupportMode) {
        this.mRenderscriptSupportModeEnabled = renderscriptSupportMode;
        return this;
    }

    public ProductFlavor setRenderscriptSupportModeBlasEnabled(Boolean renderscriptSupportModeBlas) {
        this.mRenderscriptSupportModeBlasEnabled = renderscriptSupportModeBlas;
        return this;
    }

    public Boolean getRenderscriptNdkModeEnabled() {
        return this.mRenderscriptNdkModeEnabled;
    }

    public ProductFlavor setRenderscriptNdkModeEnabled(Boolean renderscriptNdkMode) {
        this.mRenderscriptNdkModeEnabled = renderscriptNdkMode;
        return this;
    }

    public ProductFlavor setTestApplicationId(String applicationId) {
        this.mTestApplicationId = applicationId;
        return this;
    }

    public String getTestApplicationId() {
        return this.mTestApplicationId;
    }

    public ProductFlavor setTestInstrumentationRunner(String testInstrumentationRunner) {
        this.mTestInstrumentationRunner = testInstrumentationRunner;
        return this;
    }

    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    public ProductFlavor setTestInstrumentationRunnerArguments(Map<String, String> testInstrumentationRunnerArguments) {
        this.mTestInstrumentationRunnerArguments = (Map)Preconditions.checkNotNull(testInstrumentationRunnerArguments);
        return this;
    }

    public Map<String, String> getTestInstrumentationRunnerArguments() {
        return this.mTestInstrumentationRunnerArguments;
    }

    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    public ProductFlavor setTestHandleProfiling(boolean handleProfiling) {
        this.mTestHandleProfiling = handleProfiling;
        return this;
    }

    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    public ProductFlavor setTestFunctionalTest(boolean functionalTest) {
        this.mTestFunctionalTest = functionalTest;
        return this;
    }

    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    public ProductFlavor setSigningConfig(SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    public DefaultVectorDrawablesOptions getVectorDrawables() {
        return this.mVectorDrawablesOptions;
    }

    public Boolean getWearAppUnbundled() {
        return this.mWearAppUnbundled;
    }

    public void setWearAppUnbundled(Boolean wearAppUnbundled) {
        this.mWearAppUnbundled = wearAppUnbundled;
    }

    public void addResourceConfiguration(String configuration) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.add(configuration);
    }

    public void addResourceConfigurations(String ... configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(Arrays.asList(configurations));
    }

    public void addResourceConfigurations(Collection<String> configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(configurations);
    }

    public Collection<String> getResourceConfigurations() {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        return this.mResourceConfiguration;
    }

    static ProductFlavor mergeFlavors(ProductFlavor lowestPriority, List<? extends ProductFlavor> flavors) {
        DefaultProductFlavor mergedFlavor = DefaultProductFlavor.clone(lowestPriority);
        for (ProductFlavor flavor : Lists.reverse(flavors)) {
            mergedFlavor = DefaultProductFlavor.mergeFlavors((ProductFlavor)mergedFlavor, flavor);
        }
        String applicationIdSuffix = lowestPriority.getApplicationIdSuffix();
        String versionNameSuffix = lowestPriority.getVersionNameSuffix();
        for (ProductFlavor productFlavor : flavors) {
            applicationIdSuffix = DefaultProductFlavor.mergeApplicationIdSuffix(productFlavor.getApplicationIdSuffix(), applicationIdSuffix);
            versionNameSuffix = DefaultProductFlavor.mergeVersionNameSuffix(productFlavor.getVersionNameSuffix(), versionNameSuffix);
        }
        mergedFlavor.setApplicationIdSuffix(applicationIdSuffix);
        mergedFlavor.setVersionNameSuffix(versionNameSuffix);
        return mergedFlavor;
    }

    private static DefaultProductFlavor mergeFlavors(ProductFlavor base, ProductFlavor overlay) {
        DefaultProductFlavor flavor = new DefaultProductFlavor("");
        flavor.mMinSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getMinSdkVersion(), base.getMinSdkVersion());
        flavor.mTargetSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getTargetSdkVersion(), base.getTargetSdkVersion());
        flavor.mMaxSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getMaxSdkVersion(), base.getMaxSdkVersion());
        flavor.mRenderscriptTargetApi = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptTargetApi(), base.getRenderscriptTargetApi());
        flavor.mRenderscriptSupportModeEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptSupportModeEnabled(), base.getRenderscriptSupportModeEnabled());
        flavor.mRenderscriptSupportModeBlasEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptSupportModeBlasEnabled(), base.getRenderscriptSupportModeBlasEnabled());
        flavor.mRenderscriptNdkModeEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptNdkModeEnabled(), base.getRenderscriptNdkModeEnabled());
        flavor.mVersionCode = DefaultProductFlavor.chooseNotNull(overlay.getVersionCode(), base.getVersionCode());
        flavor.mVersionName = DefaultProductFlavor.chooseNotNull(overlay.getVersionName(), base.getVersionName());
        flavor.setVersionNameSuffix(DefaultProductFlavor.mergeVersionNameSuffix(overlay.getVersionNameSuffix(), base.getVersionNameSuffix()));
        flavor.mApplicationId = DefaultProductFlavor.chooseNotNull(overlay.getApplicationId(), base.getApplicationId());
        flavor.setApplicationIdSuffix(DefaultProductFlavor.mergeApplicationIdSuffix(overlay.getApplicationIdSuffix(), base.getApplicationIdSuffix()));
        flavor.mTestApplicationId = DefaultProductFlavor.chooseNotNull(overlay.getTestApplicationId(), base.getTestApplicationId());
        flavor.mTestInstrumentationRunner = DefaultProductFlavor.chooseNotNull(overlay.getTestInstrumentationRunner(), base.getTestInstrumentationRunner());
        flavor.mTestInstrumentationRunnerArguments.putAll(base.getTestInstrumentationRunnerArguments());
        flavor.mTestInstrumentationRunnerArguments.putAll(overlay.getTestInstrumentationRunnerArguments());
        flavor.mTestHandleProfiling = DefaultProductFlavor.chooseNotNull(overlay.getTestHandleProfiling(), base.getTestHandleProfiling());
        flavor.mTestFunctionalTest = DefaultProductFlavor.chooseNotNull(overlay.getTestFunctionalTest(), base.getTestFunctionalTest());
        flavor.mSigningConfig = DefaultProductFlavor.chooseNotNull(overlay.getSigningConfig(), base.getSigningConfig());
        flavor.mWearAppUnbundled = DefaultProductFlavor.chooseNotNull(overlay.getWearAppUnbundled(), base.getWearAppUnbundled());
        flavor.addResourceConfigurations(base.getResourceConfigurations());
        flavor.addResourceConfigurations(overlay.getResourceConfigurations());
        flavor.addManifestPlaceholders(base.getManifestPlaceholders());
        flavor.addManifestPlaceholders(overlay.getManifestPlaceholders());
        flavor.addResValues(base.getResValues());
        flavor.addResValues(overlay.getResValues());
        flavor.addBuildConfigFields(base.getBuildConfigFields());
        flavor.addBuildConfigFields(overlay.getBuildConfigFields());
        flavor.setMultiDexEnabled(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexEnabled(), base.getMultiDexEnabled()));
        flavor.setMultiDexKeepFile(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexKeepFile(), base.getMultiDexKeepFile()));
        flavor.setMultiDexKeepProguard(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexKeepProguard(), base.getMultiDexKeepProguard()));
        flavor.setJarJarRuleFiles((List<File>)ImmutableList.builder().addAll((Iterable)overlay.getJarJarRuleFiles()).addAll((Iterable)base.getJarJarRuleFiles()).build());
        flavor.getVectorDrawables().setGeneratedDensities(DefaultProductFlavor.chooseNotNull(overlay.getVectorDrawables().getGeneratedDensities(), base.getVectorDrawables().getGeneratedDensities()));
        flavor.getVectorDrawables().setUseSupportLibrary(DefaultProductFlavor.chooseNotNull(overlay.getVectorDrawables().getUseSupportLibrary(), base.getVectorDrawables().getUseSupportLibrary()));
        return flavor;
    }

    static DefaultProductFlavor clone(ProductFlavor productFlavor) {
        DefaultProductFlavor flavor = new DefaultProductFlavor(productFlavor.getName());
        flavor._initWith((BaseConfig)productFlavor);
        flavor.mDimension = productFlavor.getDimension();
        flavor.mMinSdkVersion = productFlavor.getMinSdkVersion();
        flavor.mTargetSdkVersion = productFlavor.getTargetSdkVersion();
        flavor.mMaxSdkVersion = productFlavor.getMaxSdkVersion();
        flavor.mRenderscriptTargetApi = productFlavor.getRenderscriptTargetApi();
        flavor.mRenderscriptSupportModeEnabled = productFlavor.getRenderscriptSupportModeEnabled();
        flavor.mRenderscriptSupportModeBlasEnabled = productFlavor.getRenderscriptSupportModeBlasEnabled();
        flavor.mRenderscriptNdkModeEnabled = productFlavor.getRenderscriptNdkModeEnabled();
        flavor.mVersionCode = productFlavor.getVersionCode();
        flavor.mVersionName = productFlavor.getVersionName();
        flavor.setVersionNameSuffix(productFlavor.getVersionNameSuffix());
        flavor.mApplicationId = productFlavor.getApplicationId();
        flavor.mTestApplicationId = productFlavor.getTestApplicationId();
        flavor.mTestInstrumentationRunner = productFlavor.getTestInstrumentationRunner();
        flavor.mTestInstrumentationRunnerArguments = productFlavor.getTestInstrumentationRunnerArguments();
        flavor.mTestHandleProfiling = productFlavor.getTestHandleProfiling();
        flavor.mTestFunctionalTest = productFlavor.getTestFunctionalTest();
        flavor.mSigningConfig = productFlavor.getSigningConfig();
        flavor.mVectorDrawablesOptions = DefaultVectorDrawablesOptions.copyOf(productFlavor.getVectorDrawables());
        flavor.mWearAppUnbundled = productFlavor.getWearAppUnbundled();
        flavor.addResourceConfigurations(productFlavor.getResourceConfigurations());
        flavor.addManifestPlaceholders(productFlavor.getManifestPlaceholders());
        flavor.addResValues(productFlavor.getResValues());
        flavor.addBuildConfigFields(productFlavor.getBuildConfigFields());
        flavor.setMultiDexEnabled(productFlavor.getMultiDexEnabled());
        flavor.setMultiDexKeepFile(productFlavor.getMultiDexKeepFile());
        flavor.setMultiDexKeepProguard(productFlavor.getMultiDexKeepProguard());
        flavor.setJarJarRuleFiles((List<File>)ImmutableList.copyOf((Collection)productFlavor.getJarJarRuleFiles()));
        return flavor;
    }

    private static <T> T chooseNotNull(T overlay, T base) {
        return overlay != null ? overlay : base;
    }

    public static String mergeApplicationIdSuffix(String overlay, String base) {
        return Strings.nullToEmpty((String)DefaultProductFlavor.joinWithSeparator(overlay, base, Character.valueOf('.')));
    }

    public static String mergeVersionNameSuffix(String overlay, String base) {
        return Strings.nullToEmpty((String)DefaultProductFlavor.joinWithSeparator(overlay, base, null));
    }

    private static String joinWithSeparator(String overlay, String base, Character separator) {
        if (!Strings.isNullOrEmpty((String)overlay)) {
            String baseSuffix = DefaultProductFlavor.chooseNotNull(base, "");
            if (separator == null || overlay.charAt(0) == separator.charValue()) {
                return baseSuffix + overlay;
            }
            return baseSuffix + separator + overlay;
        }
        return base;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultProductFlavor that = (DefaultProductFlavor)o;
        return Objects.equal((Object)this.mDimension, (Object)that.mDimension) && Objects.equal((Object)this.mApplicationId, (Object)that.mApplicationId) && Objects.equal((Object)this.mMaxSdkVersion, (Object)that.mMaxSdkVersion) && Objects.equal((Object)this.mMinSdkVersion, (Object)that.mMinSdkVersion) && Objects.equal((Object)this.mName, (Object)that.mName) && Objects.equal((Object)this.mRenderscriptNdkModeEnabled, (Object)that.mRenderscriptNdkModeEnabled) && Objects.equal((Object)this.mRenderscriptSupportModeEnabled, (Object)that.mRenderscriptSupportModeEnabled) && Objects.equal((Object)this.mRenderscriptSupportModeBlasEnabled, (Object)that.mRenderscriptSupportModeBlasEnabled) && Objects.equal((Object)this.mRenderscriptTargetApi, (Object)that.mRenderscriptTargetApi) && Objects.equal(this.mResourceConfiguration, that.mResourceConfiguration) && Objects.equal((Object)this.mSigningConfig, (Object)that.mSigningConfig) && Objects.equal((Object)this.mTargetSdkVersion, (Object)that.mTargetSdkVersion) && Objects.equal((Object)this.mTestApplicationId, (Object)that.mTestApplicationId) && Objects.equal((Object)this.mTestFunctionalTest, (Object)that.mTestFunctionalTest) && Objects.equal((Object)this.mTestHandleProfiling, (Object)that.mTestHandleProfiling) && Objects.equal((Object)this.mTestInstrumentationRunner, (Object)that.mTestInstrumentationRunner) && Objects.equal(this.mTestInstrumentationRunnerArguments, that.mTestInstrumentationRunnerArguments) && Objects.equal((Object)this.mVersionCode, (Object)that.mVersionCode) && Objects.equal((Object)this.mVersionName, (Object)that.mVersionName) && Objects.equal((Object)this.mWearAppUnbundled, (Object)that.mWearAppUnbundled);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mName, this.mDimension, this.mMinSdkVersion, this.mTargetSdkVersion, this.mMaxSdkVersion, this.mRenderscriptTargetApi, this.mRenderscriptSupportModeEnabled, this.mRenderscriptSupportModeBlasEnabled, this.mRenderscriptNdkModeEnabled, this.mVersionCode, this.mVersionName, this.mApplicationId, this.mTestApplicationId, this.mTestInstrumentationRunner, this.mTestInstrumentationRunnerArguments, this.mTestHandleProfiling, this.mTestFunctionalTest, this.mSigningConfig, this.mResourceConfiguration, this.mWearAppUnbundled});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.mName).add("dimension", (Object)this.mDimension).add("minSdkVersion", (Object)this.mMinSdkVersion).add("targetSdkVersion", (Object)this.mTargetSdkVersion).add("renderscriptTargetApi", (Object)this.mRenderscriptTargetApi).add("renderscriptSupportModeEnabled", (Object)this.mRenderscriptSupportModeEnabled).add("renderscriptSupportModeBlasEnabled", (Object)this.mRenderscriptSupportModeBlasEnabled).add("renderscriptNdkModeEnabled", (Object)this.mRenderscriptNdkModeEnabled).add("versionCode", (Object)this.mVersionCode).add("versionName", (Object)this.mVersionName).add("applicationId", (Object)this.mApplicationId).add("testApplicationId", (Object)this.mTestApplicationId).add("testInstrumentationRunner", (Object)this.mTestInstrumentationRunner).add("testInstrumentationRunnerArguments", this.mTestInstrumentationRunnerArguments).add("testHandleProfiling", (Object)this.mTestHandleProfiling).add("testFunctionalTest", (Object)this.mTestFunctionalTest).add("signingConfig", (Object)this.mSigningConfig).add("resConfig", this.mResourceConfiguration).add("mBuildConfigFields", this.getBuildConfigFields()).add("mResValues", this.getResValues()).add("mProguardFiles", (Object)this.getProguardFiles()).add("mConsumerProguardFiles", (Object)this.getConsumerProguardFiles()).add("mManifestPlaceholders", this.getManifestPlaceholders()).add("mWearAppUnbundled", (Object)this.mWearAppUnbundled).toString();
    }
}

