/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt;

import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public abstract class AbstractAapt
implements Aapt {
    @Override
    public final ListenableFuture<Void> link(AaptPackageConfig config) throws AaptException {
        this.validatePackageConfig(config);
        return this.makeValidatedPackage(config);
    }

    protected abstract ListenableFuture<Void> makeValidatedPackage(AaptPackageConfig var1) throws AaptException;

    protected void validatePackageConfig(AaptPackageConfig packageConfig) throws AaptException {
        if (packageConfig.getManifestFile() == null) {
            throw new AaptException("Manifest file not set.", new Object[0]);
        }
        if (packageConfig.getOptions() == null) {
            throw new AaptException("aapt options not set.", new Object[0]);
        }
        if (packageConfig.getAndroidTarget() == null) {
            throw new AaptException("Android target not set.", new Object[0]);
        }
        ILogger logger = packageConfig.getLogger();
        if (logger == null) {
            throw new AaptException("Logger not set.", new Object[0]);
        }
        BuildToolInfo buildToolInfo = packageConfig.getBuildToolInfo();
        if (buildToolInfo == null) {
            throw new AaptException("Build tools not set.", new Object[0]);
        }
        if (packageConfig.getVariantType() == null) {
            throw new AaptException("Variant type not set.", new Object[0]);
        }
        if (packageConfig.getSourceOutputDir() == null && packageConfig.getResourceOutputApk() == null) {
            throw new AaptException("Neither source output dir nor resource output dir were set, but at least one must be.", new Object[0]);
        }
        if (packageConfig.getSymbolOutputDir() == null && packageConfig.getSourceOutputDir() == null || packageConfig.getLibraries().isEmpty()) {
            // empty if block
        }
        Collection<String> splits = packageConfig.getSplits();
        Set<String> resourceConfigs = packageConfig.getResourceConfigs();
        if (splits != null && !splits.isEmpty() && !resourceConfigs.isEmpty()) {
            ArrayList resConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
            ArrayList<String> splitsNotInResConfig = new ArrayList<String>(splits);
            splitsNotInResConfig.removeAll(resConfigs);
            if (!splitsNotInResConfig.isEmpty()) {
                throw new AaptException(String.format("Splits for densities \"%1$s\" were configured, yet the resConfigs settings does  not include such splits. The resulting split APKs would be empty.\n Suggestion: exclude those splits in your build.gradle : \nsplits {\n     density {\n         enable true\n         exclude \"%2$s\"\n     }\n}\nOR add them to the resConfigs list.", Joiner.on((String)",").join(splitsNotInResConfig), Joiner.on((String)"\",\"").join(splitsNotInResConfig)), new Object[0]);
            }
            resConfigs.removeAll(splits);
            if (!resConfigs.isEmpty()) {
                throw new AaptException(String.format("Inconsistent density configuration, with \"%1$s\" present on resConfig settings, while only \"%2$s\" densities are requested in splits APK density settings.\nSuggestion : remove extra densities from the resConfig : \ndefaultConfig {\n     resConfigs \"%2$s\"\n}\nOR remove such densities from the split's exclude list.\n", Joiner.on((String)",").join((Iterable)resConfigs), Joiner.on((String)"\",\"").join(splits)), new Object[0]);
            }
        }
        if (!packageConfig.getPreviousFeatures().isEmpty() && packageConfig.getBaseFeature() == null) {
            throw new AaptException("Previous features set but no base feature set.", new Object[0]);
        }
    }
}

