/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerOutput;
import com.android.builder.merge.MergeOutputWriter;
import com.android.builder.merge.StreamMergeAlgorithm;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.stream.Collectors;

public final class IncrementalFileMergerOutputs {
    private IncrementalFileMergerOutputs() {
    }

    public static IncrementalFileMergerOutput fromAlgorithmAndWriter(final StreamMergeAlgorithm algorithm, final MergeOutputWriter writer) {
        return new IncrementalFileMergerOutput(){

            @Override
            public void open() {
                writer.open();
            }

            @Override
            public void close() {
                writer.close();
            }

            @Override
            public void remove(String path) {
                writer.remove(path);
            }

            @Override
            public void create(String path, List<IncrementalFileMergerInput> inputs) {
                try (Closer closer = Closer.create();){
                    List inStreams = inputs.stream().map(i -> i.openPath(path)).peek(arg_0 -> ((Closer)closer).register(arg_0)).collect(Collectors.toList());
                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                    algorithm.merge(path, (List<InputStream>)ImmutableList.copyOf(inStreams), bytesOut);
                    writer.create(path, new ByteArrayInputStream(bytesOut.toByteArray()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void update(String path, List<String> prevInputNames, List<IncrementalFileMergerInput> inputs) {
                try (Closer closer = Closer.create();){
                    List inStreams = inputs.stream().map(i -> i.openPath(path)).peek(arg_0 -> ((Closer)closer).register(arg_0)).collect(Collectors.toList());
                    ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                    algorithm.merge(path, (List<InputStream>)ImmutableList.copyOf(inStreams), bytesOut);
                    writer.replace(path, new ByteArrayInputStream(bytesOut.toByteArray()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }
}

