/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.nio.file.Path;

public final class ClassFileEntry {
    final Path relativePath;
    final byte[] classFileContent;

    public ClassFileEntry(Path relativePath, byte[] classFileContent) {
        this.relativePath = relativePath;
        this.classFileContent = classFileContent;
    }

    public static Path withDexExtension(Path classFilePath) {
        String fileName = classFilePath.getFileName().toString();
        Preconditions.checkState((boolean)fileName.endsWith(".class"), (Object)"Dex archives: setting .DEX extension only for .CLASS files");
        return classFilePath.resolveSibling(Files.getNameWithoutExtension((String)fileName) + ".dex");
    }
}

