/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.DuplicateRelativeFileException;
import com.android.builder.merge.StreamMergeAlgorithm;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.function.Function;

public final class StreamMergeAlgorithms {
    private StreamMergeAlgorithms() {
    }

    private static void copy(InputStream input, OutputStream output) {
        try {
            ByteStreams.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static StreamMergeAlgorithm pickFirst() {
        return (path, from, to) -> {
            Preconditions.checkArgument((!from.isEmpty() ? 1 : 0) != 0, (Object)"from.isEmpty()");
            StreamMergeAlgorithms.copy((InputStream)from.get(0), to);
        };
    }

    public static StreamMergeAlgorithm concat() {
        return (path, from, to) -> from.forEach(stream -> {
            try {
                byte[] data = ByteStreams.toByteArray((InputStream)stream);
                ByteStreams.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)to);
                if (data.length > 0 && data[data.length - 1] != 10) {
                    to.write(10);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static StreamMergeAlgorithm acceptOnlyOne() {
        return (path, from, to) -> {
            Preconditions.checkArgument((!from.isEmpty() ? 1 : 0) != 0, (Object)"from.isEmpty()");
            if (from.size() > 1) {
                throw new DuplicateRelativeFileException("More than one file was found with OS independent path '" + path + "'");
            }
            StreamMergeAlgorithms.copy((InputStream)from.get(0), to);
        };
    }

    public static StreamMergeAlgorithm select(Function<String, StreamMergeAlgorithm> select) {
        return (path, from, to) -> {
            StreamMergeAlgorithm algorithm = (StreamMergeAlgorithm)select.apply(path);
            assert (algorithm != null);
            algorithm.merge(path, from, to);
        };
    }
}

