/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.utils.ILogger;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import javax.imageio.ImageIO;

public class VectorDrawableRenderer
implements ResourcePreprocessor {
    public static final int MIN_SDK_WITH_VECTOR_SUPPORT = 21;
    private final Supplier<ILogger> mLogger;
    private final int mMinSdk;
    private final File mOutputDir;
    private final Collection<Density> mDensities;

    public VectorDrawableRenderer(int minSdk, File outputDir, Collection<Density> densities, Supplier<ILogger> loggerSupplier) {
        this.mMinSdk = minSdk;
        this.mOutputDir = outputDir;
        this.mDensities = densities;
        this.mLogger = loggerSupplier;
    }

    public boolean needsPreprocessing(File resourceFile) {
        return this.mMinSdk < 21 && VectorDrawableRenderer.isXml(resourceFile) && VectorDrawableRenderer.isInDrawable(resourceFile) && VectorDrawableRenderer.getEffectiveVersion(resourceFile) < 21 && VectorDrawableRenderer.isRootVector(resourceFile);
    }

    public Collection<File> getFilesToBeGenerated(File inputXmlFile) {
        ArrayList filesToBeGenerated = Lists.newArrayList();
        FolderConfiguration originalConfiguration = VectorDrawableRenderer.getFolderConfiguration(inputXmlFile);
        DensityQualifier densityQualifier = originalConfiguration.getDensityQualifier();
        boolean validDensityQualifier = ResourceQualifier.isValid((ResourceQualifier)densityQualifier);
        if (validDensityQualifier && densityQualifier.getValue() == Density.NODPI) {
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
        } else if (validDensityQualifier && densityQualifier.getValue() != Density.ANYDPI) {
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName().replace(".xml", ".png")));
            originalConfiguration.setVersionQualifier(new VersionQualifier(21));
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
        } else {
            for (Density density : this.mDensities) {
                FolderConfiguration newConfiguration = FolderConfiguration.copyOf((FolderConfiguration)originalConfiguration);
                newConfiguration.setDensityQualifier(new DensityQualifier(density));
                filesToBeGenerated.add(new File(this.getDirectory(newConfiguration), inputXmlFile.getName().replace(".xml", ".png")));
            }
            originalConfiguration.setDensityQualifier(new DensityQualifier(Density.ANYDPI));
            originalConfiguration.setVersionQualifier(new VersionQualifier(21));
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
        }
        return filesToBeGenerated;
    }

    private File getDirectory(FolderConfiguration newConfiguration) {
        return new File(this.mOutputDir, newConfiguration.getFolderName(ResourceFolderType.DRAWABLE));
    }

    public void generateFile(File toBeGenerated, File original) throws IOException {
        Files.createParentDirs((File)toBeGenerated);
        if (VectorDrawableRenderer.isXml(toBeGenerated)) {
            Files.copy((File)original, (File)toBeGenerated);
        } else {
            VdPreview.TargetSize imageSize;
            BufferedImage image;
            this.mLogger.get().verbose("Generating PNG: [%s] from [%s]", new Object[]{toBeGenerated.getAbsolutePath(), original.getAbsolutePath()});
            FolderConfiguration folderConfiguration = VectorDrawableRenderer.getFolderConfiguration(toBeGenerated);
            Preconditions.checkState((folderConfiguration.getDensityQualifier() != null ? 1 : 0) != 0);
            Density density = folderConfiguration.getDensityQualifier().getValue();
            String xmlContent = Files.toString((File)original, (Charset)Charsets.UTF_8);
            float scaleFactor = (float)density.getDpiValue() / (float)Density.MEDIUM.getDpiValue();
            if (scaleFactor <= 0.0f) {
                scaleFactor = 1.0f;
            }
            Preconditions.checkState(((image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)(imageSize = VdPreview.TargetSize.createSizeFromScale((float)scaleFactor)), (String)xmlContent, null)) != null ? 1 : 0) != 0, (Object)"Generating the image failed.");
            ImageIO.write((RenderedImage)image, "png", toBeGenerated);
        }
    }

    private static FolderConfiguration getFolderConfiguration(File inputXmlFile) {
        String parentName = inputXmlFile.getParentFile().getName();
        FolderConfiguration originalConfiguration = FolderConfiguration.getConfigForFolder((String)parentName);
        Preconditions.checkArgument((originalConfiguration != null ? 1 : 0) != 0, (String)"Invalid resource folder name [%s].", (Object[])new Object[]{parentName});
        return originalConfiguration;
    }

    private static boolean isInDrawable(File inputXmlFile) {
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)inputXmlFile.getParentFile().getName());
        return folderType == ResourceFolderType.DRAWABLE;
    }

    private static boolean isRootVector(File resourceFile) {
        return "vector".equals(XmlUtils.getRootTagName((File)resourceFile));
    }

    private static boolean isXml(File resourceFile) {
        return Files.getFileExtension((String)resourceFile.getName()).equals("xml");
    }

    private static int getEffectiveVersion(File resourceFile) {
        FolderConfiguration configuration = VectorDrawableRenderer.getFolderConfiguration(resourceFile);
        if (configuration.getVersionQualifier() == null) {
            configuration.createDefault();
        }
        return configuration.getVersionQualifier().getVersion();
    }
}

