/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.PathUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class DxDexArchiveBuilder
extends DexArchiveBuilder {
    private final DexArchiveBuilderConfig config;
    private final WaitableExecutor executor;

    public DxDexArchiveBuilder(DexArchiveBuilderConfig config) {
        this.config = config;
        this.executor = WaitableExecutor.useGlobalSharedThreadPool();
    }

    @Override
    protected List<DexArchiveEntry> convertClassFileInput(ClassFileInput input) {
        HashMap bucketizedJobs = Maps.newHashMap();
        int i = 0;
        for (ClassFileEntry classFileEntry : input.allEntries()) {
            int bucketId = i++ % this.executor.getParallelism();
            Map jobs = bucketizedJobs.getOrDefault(bucketId, Maps.newHashMap());
            jobs.put(classFileEntry.relativePath, classFileEntry.classFileContent);
            bucketizedJobs.put(bucketId, jobs);
        }
        for (Map job : bucketizedJobs.values()) {
            this.processJobChunk(job);
        }
        try {
            List res = this.executor.waitForTasksWithQuickFail(true);
            return res.stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.config.getErrorOut().println("UNEXPECTED TOP-LEVEL EXCEPTION:");
            this.config.getErrorOut().println(Throwables.getRootCause((Throwable)e).getMessage());
            this.config.getErrorOut().print(Throwables.getStackTraceAsString((Throwable)e));
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new DexArchiveBuilderException("Unable to convert input to dex archive.", (Throwable)MoreObjects.firstNonNull((Object)e.getCause(), (Object)e));
        }
    }

    private void processJobChunk(Map<Path, byte[]> pathToContent) {
        this.executor.execute(() -> {
            ArrayList<DexArchiveEntry> res = new ArrayList<DexArchiveEntry>(pathToContent.size());
            for (Map.Entry e : pathToContent.entrySet()) {
                Path relativePath = (Path)e.getKey();
                byte[] fileBytes = (byte[])e.getValue();
                String unixClassFile = PathUtils.toSystemIndependentPath((Path)relativePath);
                DirectClassFile cf = new DirectClassFile(fileBytes, unixClassFile, true);
                cf.setAttributeFactory(StdAttributeFactory.THE_ONE);
                cf.getMagic();
                DexFile dexFile = new DexFile(this.config.getDexOptions());
                ClassDefItem classDefItem = CfTranslator.translate(this.config.getDxContext(), cf, fileBytes, this.config.getCfOptions(), this.config.getDexOptions(), dexFile);
                dexFile.add(classDefItem);
                byte[] dexClassContent = dexFile.toDex(null, false);
                res.add(new DexArchiveEntry(dexClassContent, relativePath));
            }
            return res;
        });
    }
}

