/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.apkzlib.zip.StoredEntry;
import com.android.apkzlib.zip.ZFile;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

final class JarDexArchive
implements DexArchive {
    private final ZFile zFile;

    public JarDexArchive(ZFile zFile) {
        this.zFile = zFile;
    }

    @Override
    public Path getRootPath() {
        return this.zFile.getFile().toPath();
    }

    @Override
    public void addFile(Path relativePath, InputStream inputStream) throws IOException {
        this.zFile.add(relativePath.toString(), inputStream);
    }

    @Override
    public void removeFile(Path relativePath) throws IOException {
        StoredEntry entry = this.zFile.get(relativePath.toString());
        if (entry != null) {
            entry.delete();
        }
    }

    @Override
    public List<DexArchiveEntry> getFiles() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StoredEntry entry : this.zFile.entries()) {
            byte[] content = entry.read();
            String relativePath = entry.getCentralDirectoryHeader().getName();
            builder.add((Object)new DexArchiveEntry(content, Paths.get(relativePath, new String[0])));
        }
        return builder.build();
    }

    @Override
    public void close() throws IOException {
        this.zFile.close();
    }
}

