/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.tasks;

import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.Task;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class Job<T> {
    private final String jobTitle;
    private final Task<T> task;
    private final ListenableFuture<?> resultFuture;

    public Job(String jobTile, Task<T> task, ListenableFuture<?> resultFuture) {
        this.jobTitle = jobTile;
        this.task = task;
        this.resultFuture = resultFuture;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void runTask(JobContext<T> jobContext) throws IOException {
        this.task.run(this, jobContext);
    }

    public void finished() {
        this.task.finished();
    }

    public void error(Exception e) {
        this.task.error(e);
    }

    public boolean await() throws InterruptedException {
        try {
            this.resultFuture.get();
            return true;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public void awaitRethrowExceptions() throws InterruptedException, ExecutionException {
        this.resultFuture.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("\ntitle", (Object)this.jobTitle).add("\ntask", this.task).add("\nfuture", this.resultFuture).toString();
    }
}

