/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.Symbol;
import com.android.builder.symbols.SymbolJavaType;
import com.android.builder.symbols.SymbolTable;
import com.android.builder.symbols.SymbolUtils;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class SymbolIo {
    public static final String ANDROID_ATTR_PREFIX = "android_";

    private SymbolIo() {
    }

    public static SymbolTable read(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, InOrderHandler::new);
    }

    public static SymbolTable readFromAapt(File file, String tablePackage) throws IOException {
        return SymbolIo.read(file, tablePackage, AaptHandler::new);
    }

    private static SymbolTable read(File file, String tablePackage, Function<String, StyleableIndexHandler> handlerFunction) throws IOException {
        List<String> lines = Files.readAllLines(file.toPath(), Charsets.UTF_8);
        SymbolTable.Builder table = SymbolIo.readLines(lines, 1, file.toPath(), handlerFunction);
        if (tablePackage != null) {
            table.tablePackage(tablePackage);
        }
        return table.build();
    }

    public static SymbolTable readTableWithPackage(File file) throws IOException {
        return SymbolIo.readTableWithPackage(file.toPath());
    }

    public static SymbolTable readTableWithPackage(Path file) throws IOException {
        List<String> lines = Files.readAllLines(file, Charsets.UTF_8);
        if (lines.isEmpty()) {
            throw new IOException("Internal error: Symbol file with package cannot be empty.");
        }
        SymbolTable.Builder table = SymbolIo.readLines(lines, 2, file, InOrderHandler::new);
        table.tablePackage(lines.get(0).trim());
        return table.build();
    }

    private static SymbolTable.Builder readLines(List<String> lines, int startLine, Path file, Function<String, StyleableIndexHandler> handlerFunction) throws IOException {
        int lineIndex;
        SymbolTable.Builder table = SymbolTable.builder();
        String line = null;
        try {
            SymbolFilter symbolFilter = (resType, javaType) -> resType.equals(ResourceType.STYLEABLE.getName()) && javaType.equals(SymbolJavaType.INT.getTypeName());
            int count = lines.size();
            for (lineIndex = startLine; lineIndex <= count; ++lineIndex) {
                line = lines.get(lineIndex - 1);
                SymbolData data = SymbolIo.readLine(line, null);
                if (data.resourceType == ResourceType.STYLEABLE) {
                    SymbolData subData;
                    if (data.javaType != SymbolJavaType.INT_LIST) continue;
                    String data_name = data.name + "_";
                    StyleableIndexHandler indexHandler = handlerFunction.apply(data_name);
                    while (lineIndex < count && (subData = SymbolIo.readLine(lines.get(lineIndex), symbolFilter)) != null) {
                        ++lineIndex;
                        indexHandler.handle(subData);
                    }
                    table.add(Symbol.createSymbol(data.resourceType, data.name, data.javaType, data.value, indexHandler.getChildrenNames()));
                    continue;
                }
                table.add(Symbol.createSymbol(data.resourceType, data.name, data.javaType, data.value));
            }
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new IOException(String.format("File format error reading %s line %d: '%s'", file.toString(), lineIndex, line), e);
        }
        return table;
    }

    private static SymbolData readLine(String line, SymbolFilter filter) throws IOException {
        int pos = line.indexOf(32);
        String typeName = line.substring(0, pos);
        SymbolJavaType type = SymbolJavaType.getEnum(typeName);
        int pos2 = line.indexOf(32, pos + 1);
        String className = line.substring(pos + 1, pos2);
        if (filter != null && !filter.validate(className, typeName)) {
            return null;
        }
        ResourceType resourceType = ResourceType.getEnum((String)className);
        if (resourceType == null) {
            throw new IOException("Invalid resource type " + className);
        }
        int pos3 = line.indexOf(32, pos2 + 1);
        String name = line.substring(pos2 + 1, pos3);
        String value = line.substring(pos3 + 1);
        return new SymbolData(resourceType, name, type, value);
    }

    public static void write(SymbolTable table, File file) {
        SymbolIo.write(table, file.toPath());
    }

    public static void write(SymbolTable table, Path file) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Symbol s : table.allSymbols()) {
            lines.add(s.getJavaType().getTypeName() + " " + s.getResourceType().getName() + " " + s.getName() + " " + s.getValue());
            if (s.getJavaType() != SymbolJavaType.INT_LIST) continue;
            Preconditions.checkArgument((s.getResourceType() == ResourceType.STYLEABLE ? 1 : 0) != 0, (Object)"Only resource type 'styleable' is allowed to have java type 'int[]'");
            List<String> children = s.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                lines.add(SymbolJavaType.INT.getTypeName() + " " + ResourceType.STYLEABLE.getName() + " " + s.getName() + "_" + SymbolUtils.canonicalizeValueResourceName(children.get(i)) + " " + i);
            }
        }
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            for (String line : lines) {
                os.write(line.getBytes(Charsets.UTF_8));
                os.write(10);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeSymbolTableWithPackage(Path symbolTable, Path manifest, Path outputFile) throws IOException {
        String packageName;
        Throwable throwable;
        try {
            throwable = null;
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(manifest, new OpenOption[0]));){
                packageName = AndroidManifestParser.parse((InputStream)is).getPackage();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        throwable = null;
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(outputFile, new OpenOption[0]));){
            if (packageName != null) {
                ((OutputStream)os).write(packageName.getBytes(Charsets.UTF_8));
            }
            ((OutputStream)os).write(10);
            if (!Files.exists(symbolTable, new LinkOption[0])) {
                return;
            }
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(symbolTable, new OpenOption[0]));){
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public static File exportToJava(SymbolTable table, File directory, boolean finalIds) {
        Preconditions.checkArgument((boolean)directory.isDirectory());
        Splitter splitter = Splitter.on((char)'.');
        Iterable directories = splitter.split((CharSequence)table.getTablePackage());
        File file = directory;
        for (String d : directories) {
            file = new File(file, d);
        }
        FileUtils.mkdirs((File)file);
        file = new File(file, "R.java");
        EnumSet<ResourceType> resourceTypes = EnumSet.noneOf(ResourceType.class);
        table.allSymbols().forEach(s -> resourceTypes.add(s.getResourceType()));
        String idModifiers = finalIds ? "public static final" : "public static";
        try (FileOutputStream fos = new FileOutputStream(file);
             PrintWriter pw = new PrintWriter(fos);){
            pw.println("/* AUTO-GENERATED FILE.  DO NOT MODIFY.");
            pw.println(" *");
            pw.println(" * This class was automatically generated by the");
            pw.println(" * gradle plugin from the resource data it found. It");
            pw.println(" * should not be modified by hand.");
            pw.println(" */");
            if (!table.getTablePackage().isEmpty()) {
                pw.println("package " + table.getTablePackage() + ";");
            }
            pw.println();
            pw.println("public final class R {");
            String typeName = SymbolJavaType.INT.getTypeName();
            for (ResourceType rt : resourceTypes) {
                pw.println("    public static final class " + rt + " {");
                TreeSet<Symbol> syms = new TreeSet<Symbol>(Comparator.comparing(Symbol::getName));
                table.allSymbols().forEach(sym -> {
                    if (sym.getResourceType().equals((Object)rt)) {
                        syms.add((Symbol)sym);
                    }
                });
                for (Symbol s2 : syms) {
                    String name = s2.getName();
                    pw.println("        " + idModifiers + " " + s2.getJavaType().getTypeName() + " " + name + " = " + s2.getValue() + ";");
                    if (s2.getJavaType() != SymbolJavaType.INT_LIST) continue;
                    Preconditions.checkArgument((s2.getResourceType() == ResourceType.STYLEABLE ? 1 : 0) != 0, (Object)"Only resource type 'styleable' is allowed to have java type 'int[]'");
                    List<String> children = s2.getChildren();
                    for (int i = 0; i < children.size(); ++i) {
                        pw.println("        " + idModifiers + " " + typeName + " " + name + "_" + SymbolUtils.canonicalizeValueResourceName(children.get(i)) + " = " + i + ";");
                    }
                }
                pw.println("    }");
            }
            pw.println("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }

    private static class AaptHandler
    extends BaseHandler {
        private final List<SymbolData> allDatas = Lists.newArrayList();

        public AaptHandler(String prefix) {
            super(prefix);
        }

        @Override
        public void handle(SymbolData data) {
            this.allDatas.add(data);
        }

        @Override
        public List<String> getChildrenNames() {
            this.allDatas.sort(Comparator.comparingInt(o -> Integer.parseInt(o.value)));
            return this.allDatas.stream().map(this::computeName).collect(Collectors.toList());
        }

        private String computeName(SymbolData data) {
            return this.computeItemName(data.name);
        }
    }

    private static class InOrderHandler
    extends BaseHandler {
        private final List<String> childrenNames = Lists.newArrayList();

        InOrderHandler(String prefix) {
            super(prefix);
        }

        @Override
        public void handle(SymbolData subData) {
            if (subData.name.startsWith(this.prefix)) {
                this.childrenNames.add(this.computeItemName(subData.name));
            }
        }

        @Override
        public List<String> getChildrenNames() {
            return ImmutableList.copyOf(this.childrenNames);
        }
    }

    private static abstract class BaseHandler
    implements StyleableIndexHandler {
        protected final String prefix;

        BaseHandler(String prefix) {
            this.prefix = prefix;
        }

        protected String computeItemName(String name) {
            String indexName = name.substring(this.prefix.length());
            if (indexName.startsWith(SymbolIo.ANDROID_ATTR_PREFIX)) {
                indexName = "android:" + indexName.substring(SymbolIo.ANDROID_ATTR_PREFIX.length());
            }
            return indexName;
        }
    }

    private static interface StyleableIndexHandler {
        public void handle(SymbolData var1);

        public List<String> getChildrenNames();
    }

    @FunctionalInterface
    private static interface SymbolFilter {
        public boolean validate(String var1, String var2);
    }

    private static class SymbolData {
        final ResourceType resourceType;
        final String name;
        final SymbolJavaType javaType;
        final String value;

        public SymbolData(ResourceType resourceType, String name, SymbolJavaType javaType, String value) {
            this.resourceType = resourceType;
            this.name = name;
            this.javaType = javaType;
            this.value = value;
        }
    }
}

