/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.aapt2;

import com.android.SdkConstants;
import com.android.tools.aapt2.Aapt2Exception;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

enum Aapt2JniPlatform {
    WIN_64("win64", HashCode.fromString((String)"1f7410d4db59580ec13a7ee128d65eaf514cb24bbb8677f1d21364479d1cf124"), "libwinpthread-1.dll", "libaapt2_jni.dll"),
    WIN_32("win32", HashCode.fromString((String)"12bec8c6874e011417cf06a9eb9bb2a3732d1312ac50e039afbd3058f7c5d7f2"), "libwinpthread-1.dll", "libaapt2_jni.dll"),
    MAC_64("mac64", HashCode.fromString((String)"ed9a9e2feaac7ab4c4d8e0e1d3a6764815b94ab09a15f4bc768dd26c24a5a406"), "libc++.dylib", "libaapt2_jni.dylib"),
    LINUX_64("linux64", HashCode.fromString((String)"df18054b14518e7af99e920df7af12aa88a5fafdcb14eebecdb508148b851ac5"), "libc++.so", "libaapt2_jni.so");

    private final String directoryName;
    private final HashCode cacheKey;
    private final ImmutableList<String> fileNames;

    private Aapt2JniPlatform(String directoryName, HashCode cacheKey, String ... fileNames) {
        this.directoryName = directoryName;
        this.cacheKey = cacheKey;
        this.fileNames = ImmutableList.copyOf((Object[])fileNames);
    }

    static Aapt2JniPlatform getCurrentPlatform() {
        boolean is64Bit = System.getProperty("os.arch").contains("64");
        switch (SdkConstants.CURRENT_PLATFORM) {
            case 2: {
                return is64Bit ? WIN_64 : WIN_32;
            }
            case 3: {
                if (!is64Bit) {
                    throw new Aapt2Exception("32-bit JVM is not supported");
                }
                return MAC_64;
            }
            case 1: {
                if (!is64Bit) {
                    throw new Aapt2Exception("32-bit JVM is not supported");
                }
                return LINUX_64;
            }
        }
        throw new IllegalStateException("Unknown platform");
    }

    HashCode getCacheKey() {
        return this.cacheKey;
    }

    void writeToDirectory(Path directory) throws IOException {
        for (String fileName : this.fileNames) {
            URL url = this.getResource(fileName);
            BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
            Throwable throwable = null;
            try {
                Files.copy(inputStream, directory.resolve(fileName), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)inputStream).close();
            }
        }
    }

    List<Path> getFiles(Path cacheDirectory) {
        return this.fileNames.stream().map(cacheDirectory::resolve).collect(Collectors.toList());
    }

    private URL getResource(String fileName) {
        return Resources.getResource((String)(this.directoryName + "/" + fileName));
    }
}

