/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;

public class RelativeFile {
    private final File base;
    private final File file;
    private final String osIndependentRelativePath;

    public RelativeFile(File base, File file) {
        Preconditions.checkArgument((!base.equals(file) ? 1 : 0) != 0, (Object)"base.equals(file)");
        this.base = base;
        this.file = file;
        String relativePath = FileUtils.relativePossiblyNonExistingPath((File)file, (File)base);
        this.osIndependentRelativePath = FileUtils.toSystemIndependentPath((String)relativePath);
    }

    public File getBase() {
        return this.base;
    }

    public File getFile() {
        return this.file;
    }

    public String getOsIndependentRelativePath() {
        return this.osIndependentRelativePath;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.base, this.file});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelativeFile)) {
            return false;
        }
        RelativeFile rf = (RelativeFile)obj;
        return Objects.equal((Object)this.base, (Object)rf.base) && Objects.equal((Object)this.file, (Object)rf.file);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("base", (Object)this.base).add("path", (Object)this.osIndependentRelativePath).toString();
    }
}

