/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.apkzlib.utils.CachedSupplier;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.merge.DuplicatePathInIncrementalInputException;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.ide.common.res2.FileStatus;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class LazyIncrementalFileMergerInputs {
    private LazyIncrementalFileMergerInputs() {
    }

    public static LazyIncrementalFileMergerInput fromNew(String name, Set<File> base) {
        ImmutableSet baseI = ImmutableSet.copyOf(base);
        CachedSupplier<ImmutableSet<RelativeFile>> all = new CachedSupplier<ImmutableSet<RelativeFile>>(() -> LazyIncrementalFileMergerInputs.load((Set<File>)baseI));
        CachedSupplier<ImmutableMap<RelativeFile, FileStatus>> upd = new CachedSupplier<ImmutableMap<RelativeFile, FileStatus>>(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ((ImmutableSet)all.get()).forEach(rf -> builder.put(rf, (Object)FileStatus.NEW));
            return builder.build();
        });
        return new LazyIncrementalFileMergerInput(name, upd, all);
    }

    private static ImmutableSet<RelativeFile> load(Set<File> base) {
        HashSet<String> paths = new HashSet<String>();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File b : base) {
            ImmutableSet<RelativeFile> files;
            if (b.isFile()) {
                try {
                    files = RelativeFiles.fromZip(b);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else if (b.isDirectory()) {
                files = RelativeFiles.fromDirectory(b);
            } else {
                throw new AssertionError();
            }
            for (RelativeFile rf : files) {
                String p = rf.getOsIndependentRelativePath();
                if (paths.add(p)) continue;
                throw new DuplicatePathInIncrementalInputException("Duplicate relative path '" + p + "'");
            }
            builder.addAll(files);
        }
        return builder.build();
    }

    public static LazyIncrementalFileMergerInput fromUpdates(String name, Set<File> base, Map<File, FileStatus> updates, FileCacheByPath cache, IncrementalRelativeFileSets.FileDeletionPolicy fileDeletionPolicy) {
        CachedSupplier<ImmutableSet<RelativeFile>> all = new CachedSupplier<ImmutableSet<RelativeFile>>(() -> LazyIncrementalFileMergerInputs.load(base));
        CachedSupplier<ImmutableMap<RelativeFile, FileStatus>> upd = new CachedSupplier<ImmutableMap<RelativeFile, FileStatus>>(() -> {
            try {
                HashSet<Runnable> cacheUpdates = new HashSet<Runnable>();
                ImmutableMap<RelativeFile, FileStatus> incrementalUpdates = IncrementalRelativeFileSets.makeFromBaseFiles(base, updates, cache, cacheUpdates, fileDeletionPolicy);
                cacheUpdates.forEach(Runnable::run);
                return incrementalUpdates;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return new LazyIncrementalFileMergerInput(name, upd, all);
    }
}

