/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.aapt2;

import com.android.tools.aapt2.Aapt2Exception;
import com.android.tools.aapt2.Aapt2JniLogCallback;
import com.android.tools.aapt2.Aapt2JniPlatform;
import com.android.tools.aapt2.Aapt2Result;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public final class Aapt2Jni {
    @GuardedBy(value="Aapt2Jni.class")
    private static boolean loaded;

    public Aapt2Jni(Cache cache) throws IOException {
        Aapt2Jni.loadJni(cache);
    }

    public static synchronized void loadJni(Cache cache) throws IOException {
        if (loaded) {
            return;
        }
        Aapt2JniPlatform platform = Aapt2JniPlatform.getCurrentPlatform();
        Path libs = cache.getCachedDirectory(platform.getCacheKey(), platform::writeToDirectory);
        for (Path path : platform.getFiles(libs)) {
            System.load(path.toString());
        }
        try {
            Aapt2Jni.ping();
        }
        catch (Exception e) {
            throw new Aapt2Exception("Failed to load AAPT2 jni binding", e);
        }
        loaded = true;
    }

    @CheckReturnValue
    public Aapt2Result compile(@Nonnull List<String> arguments) {
        Aapt2Result.Builder builder = Aapt2Result.builder();
        int returnCode = Aapt2Jni.nativeCompile(arguments, builder);
        return builder.setReturnCode(returnCode).build();
    }

    @CheckReturnValue
    public Aapt2Result link(@Nonnull List<String> arguments) {
        Aapt2Result.Builder builder = Aapt2Result.builder();
        int returnCode = Aapt2Jni.nativeLink(arguments, builder);
        return builder.setReturnCode(returnCode).build();
    }

    private static native void ping();

    private static native int nativeCompile(@Nonnull List<String> var0, @Nonnull Aapt2JniLogCallback var1);

    private static native int nativeLink(@Nonnull List<String> var0, @Nonnull Aapt2JniLogCallback var1);

    public static interface Cache {
        public Path getCachedDirectory(HashCode var1, Creator var2) throws IOException;
    }

    public static interface Creator {
        public void create(Path var1) throws IOException;
    }
}

