/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.dex.Constants;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.utils.LebUtils;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DexFile {
    final String name;
    private final ByteBuffer buffer;
    private final int version;

    DexFile(String name) throws IOException {
        this.name = name;
        Path path = Paths.get(name, new String[0]);
        this.buffer = ByteBuffer.wrap(Files.readAllBytes(path));
        this.version = this.parseMagic(this.buffer);
    }

    public DexFile(InputStream input) throws IOException {
        this.name = "input-stream.dex";
        this.buffer = ByteBuffer.wrap(ByteStreams.toByteArray((InputStream)input));
        this.version = this.parseMagic(this.buffer);
    }

    DexFile(byte[] bytes) {
        this.name = "mockfile.dex";
        this.buffer = ByteBuffer.wrap(bytes);
        this.version = this.parseMagic(this.buffer);
    }

    private int parseMagic(ByteBuffer buffer) {
        int version;
        int index = 0;
        for (byte prefixByte : Constants.DEX_FILE_MAGIC_PREFIX) {
            if (buffer.get(index++) == prefixByte) continue;
            throw new CompilationError("Dex file has invalid header: " + this.name);
        }
        if (buffer.get(index++) != 48 || buffer.get(index++) != 51) {
            throw new CompilationError("Dex file has invalid version number: " + this.name);
        }
        byte versionByte = buffer.get(index++);
        switch (versionByte) {
            case 56: {
                version = 38;
                break;
            }
            case 55: {
                version = 37;
                break;
            }
            case 53: {
                version = 35;
                break;
            }
            default: {
                throw new CompilationError("Dex file has invalid version number: " + this.name);
            }
        }
        if (buffer.get(index++) != 0) {
            throw new CompilationError("Dex file has invalid header: " + this.name);
        }
        return version;
    }

    int getDexVersion() {
        return this.version;
    }

    byte[] getByteArray(int size) {
        byte[] result = new byte[size];
        this.buffer.get(result);
        return result;
    }

    int getUleb128() {
        return LebUtils.parseUleb128(this);
    }

    int getSleb128() {
        return LebUtils.parseSleb128(this);
    }

    int getUleb128p1() {
        return this.getUleb128() - 1;
    }

    int getUint() {
        int result = this.buffer.getInt();
        assert (result >= 0);
        return result;
    }

    int getUshort() {
        int result = this.buffer.getShort() & 0xFFFF;
        assert (result >= 0);
        return result;
    }

    short getShort() {
        return this.buffer.getShort();
    }

    int getUint(int offset) {
        int result = this.buffer.getInt(offset);
        assert (result >= 0);
        return result;
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    void setByteOrder() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int endian = this.buffer.getInt(40);
        if (endian == 2018915346) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        } else assert (endian == 305419896);
    }

    int position() {
        return this.buffer.position();
    }

    void position(int position) {
        this.buffer.position(position);
    }

    void align(int alignment) {
        assert ((alignment & alignment - 1) == 0);
        int p = this.buffer.position();
        p += alignment - p % alignment & alignment - 1;
        this.buffer.position(p);
    }

    public byte get() {
        return this.buffer.get();
    }

    int getUbyte() {
        int result = this.buffer.get() & 0xFF;
        assert (result >= 0);
        return result;
    }

    int end() {
        return this.buffer.capacity();
    }
}

