/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class AppInfoWithSubtyping
extends AppInfo {
    private Set<DexType> missingClasses = Sets.newIdentityHashSet();
    private final Hashtable<DexType, ImmutableSet<DexType>> subtypeMap = new Hashtable();

    public AppInfoWithSubtyping(DexApplication application) {
        super(application);
        this.populateSubtypeMap(application.getFullClassMap(), application.dexItemFactory);
    }

    protected AppInfoWithSubtyping(AppInfoWithSubtyping previous) {
        super(previous);
        this.missingClasses.addAll(previous.missingClasses);
        this.subtypeMap.putAll(previous.subtypeMap);
    }

    protected AppInfoWithSubtyping(AppInfoWithSubtyping previous, GraphLense lense) {
        super(previous, lense);
        this.populateSubtypeMap(previous.app.getFullClassMap(), this.dexItemFactory);
    }

    public Set<DexType> getMissingClasses() {
        return Collections.unmodifiableSet(this.missingClasses);
    }

    public ImmutableSet<DexType> subtypes(DexType type) {
        assert (type.isClassType());
        ImmutableSet<DexType> subtypes = this.subtypeMap.get(type);
        return subtypes == null ? ImmutableSet.of() : subtypes;
    }

    private void populateSuperType(Hashtable<DexType, Set<DexType>> map, DexType superType, DexClass baseClass, Function<DexType, DexClass> definitions) {
        Set set;
        if (superType != null && (set = map.computeIfAbsent(superType, ignore -> new HashSet())).add(baseClass.type)) {
            this.populateAllSuperTypes(map, superType, baseClass, definitions);
        }
    }

    private void populateAllSuperTypes(Hashtable<DexType, Set<DexType>> map, DexType holder, DexClass baseClass, Function<DexType, DexClass> definitions) {
        DexClass holderClass = definitions.apply(holder);
        if (holderClass != null) {
            this.populateSuperType(map, holderClass.superType, baseClass, definitions);
            if (holderClass.superType != null) {
                holderClass.superType.addDirectSubtype(holder);
            } else assert (this.dexItemFactory.objectType == holder);
            for (DexType inter : holderClass.interfaces.values) {
                this.populateSuperType(map, inter, baseClass, definitions);
                inter.addInterfaceSubtype(holder);
            }
        } else {
            if (!baseClass.isLibraryClass()) {
                this.missingClasses.add(holder);
            }
            if (holder != this.dexItemFactory.objectType) {
                this.dexItemFactory.objectType.addDirectSubtype(holder);
            }
        }
    }

    private void populateSubtypeMap(Map<DexType, DexClass> classes, DexItemFactory dexItemFactory) {
        dexItemFactory.clearSubtypeInformation();
        dexItemFactory.objectType.tagAsSubtypeRoot();
        Hashtable<DexType, Set<DexType>> map = new Hashtable<DexType, Set<DexType>>();
        for (Map.Entry<DexType, DexClass> entry : classes.entrySet()) {
            this.populateAllSuperTypes(map, entry.getKey(), entry.getValue(), classes::get);
        }
        for (Map.Entry<DexType, DexClass> entry : map.entrySet()) {
            this.subtypeMap.put(entry.getKey(), (ImmutableSet<DexType>)ImmutableSet.copyOf((Collection)((Collection)((Object)entry.getValue()))));
        }
        assert (DexType.validateLevelsAreCorrect(classes::get, dexItemFactory));
    }

    public Set<DexEncodedMethod> lookupVirtualTargets(DexMethod method) {
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        DexClass root = this.definitionFor(method.holder);
        if (root == null) {
            return null;
        }
        DexEncodedMethod topMethod = this.lookupVirtualTarget(method.holder, method);
        if (topMethod != null) {
            result.add(topMethod);
        } else if (!this.holderIsAbstract(method)) {
            return Collections.emptySet();
        }
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set != null) {
            for (DexType type : set) {
                DexEncodedMethod t;
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface() || (t = clazz.findVirtualTarget(method)) == null) continue;
                result.add(t);
            }
        }
        return result;
    }

    public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method) {
        assert (method != null);
        DexClass holder = this.definitionFor(method.holder);
        if (holder == null || holder.isLibraryClass()) {
            return null;
        }
        if (method.isSingleVirtualMethodCached()) {
            return method.getSingleVirtualMethodCache();
        }
        DexEncodedMethod result = null;
        DexEncodedMethod topMethod = this.lookupVirtualTarget(method.holder, method);
        if (topMethod != null) {
            result = topMethod;
        } else if (!this.holderIsAbstract(method)) {
            return null;
        }
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set != null) {
            for (DexType type : set) {
                DexEncodedMethod t;
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface() || (t = clazz.findVirtualTarget(method)) == null) continue;
                if (result != null) {
                    return null;
                }
                result = t;
            }
        }
        method.setSingleVirtualMethodCache(result);
        return result;
    }

    private boolean holderIsAbstract(Descriptor desc) {
        DexClass holder = this.definitionFor(desc.getHolder());
        return holder.accessFlags.isAbstract();
    }

    public Set<DexEncodedMethod> lookupInterfaceTargets(DexMethod method) {
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set != null) {
            for (DexType type : set) {
                DexEncodedMethod targetMethod;
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface() || (targetMethod = this.lookupVirtualTarget(type, method)) == null) continue;
                result.add(targetMethod);
            }
        }
        return result;
    }

    public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method) {
        assert (method != null);
        DexClass holder = this.definitionFor(method.holder);
        if (holder == null || holder.isLibraryClass()) {
            return null;
        }
        DexEncodedMethod result = null;
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set != null) {
            for (DexType type : set) {
                DexEncodedMethod t;
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface() || (t = this.lookupVirtualTarget(type, method)) == null) continue;
                if (result != null) {
                    return null;
                }
                result = t;
            }
        }
        return result;
    }

    @Override
    public boolean hasSubtyping() {
        return true;
    }

    @Override
    public AppInfoWithSubtyping withSubtyping() {
        return this;
    }
}

