/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import java.util.ArrayList;
import java.util.List;

public class DexAnnotation
extends DexItem {
    private static final String ANNOTATION_DEFAULT_DESCRIPTOR = "Ldalvik/annotation/AnnotationDefault;";
    private static final String ENCLOSING_CLASS_DESCRIPTOR = "Ldalvik/annotation/EnclosingClass;";
    private static final String ENCLOSING_METHOD_DESCRIPTOR = "Ldalvik/annotation/EnclosingMethod;";
    private static final String INNER_CLASS_DESCRIPTOR = "Ldalvik/annotation/InnerClass;";
    private static final String MEMBER_CLASSES_DESCRIPTOR = "Ldalvik/annotation/MemberClasses;";
    private static final String METHOD_PARAMETERS_DESCRIPTOR = "Ldalvik/annotation/MethodParameters;";
    private static final String SIGNATURE_DESCRIPTOR = "Ldalvik/annotation/Signature;";
    private static final String SOURCE_DEBUG_EXTENSION = "Ldalvik/annotation/SourceDebugExtension;";
    private static final String THROWS_DESCRIPTOR = "Ldalvik/annotation/Throws;";
    public static final int VISIBILITY_BUILD = 0;
    public static final int VISIBILITY_RUNTIME = 1;
    public static final int VISIBILITY_SYSTEM = 2;
    public final int visibility;
    public final DexEncodedAnnotation annotation;

    public DexAnnotation(int visibility, DexEncodedAnnotation annotation) {
        this.visibility = visibility;
        this.annotation = annotation;
    }

    public int hashCode() {
        return this.visibility + this.annotation.hashCode() * 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DexAnnotation) {
            DexAnnotation o = (DexAnnotation)other;
            return this.visibility == o.visibility && this.annotation.equals(o.annotation);
        }
        return false;
    }

    public String toString() {
        return this.visibility + " " + this.annotation;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.annotation.collectIndexedItems(indexedItems);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
    }

    public static DexAnnotation createEnclosingClassAnnotation(DexType enclosingClass, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(ENCLOSING_CLASS_DESCRIPTOR, factory, new DexValue.DexValueType(enclosingClass));
    }

    public static DexAnnotation createEnclosingMethodAnnotation(DexMethod enclosingMethod, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(ENCLOSING_METHOD_DESCRIPTOR, factory, new DexValue.DexValueMethod(enclosingMethod));
    }

    public static boolean isEnclosingClassAnnotation(DexAnnotation annotation) {
        return annotation.annotation.type.toDescriptorString().equals(ENCLOSING_CLASS_DESCRIPTOR);
    }

    public static boolean isEnclosingMethodAnnotation(DexAnnotation annotation) {
        return annotation.annotation.type.toDescriptorString().equals(ENCLOSING_METHOD_DESCRIPTOR);
    }

    public static boolean isEnclosingAnnotation(DexAnnotation annotation) {
        return DexAnnotation.isEnclosingClassAnnotation(annotation) || DexAnnotation.isEnclosingMethodAnnotation(annotation);
    }

    public static boolean isInnerClassesAnnotation(DexAnnotation annotation) {
        return annotation.annotation.type.toDescriptorString().equals(MEMBER_CLASSES_DESCRIPTOR) || annotation.annotation.type.toDescriptorString().equals(INNER_CLASS_DESCRIPTOR);
    }

    public static DexAnnotation createInnerClassAnnotation(String clazz, int access, DexItemFactory factory) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.createType(INNER_CLASS_DESCRIPTOR), new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("accessFlags"), DexValue.DexValueInt.create(access)), new DexAnnotationElement(factory.createString("name"), clazz == null ? DexValue.DexValueNull.NULL : new DexValue.DexValueString(factory.createString(clazz)))}));
    }

    public static DexAnnotation createMemberClassesAnnotation(List<DexType> classes, DexItemFactory factory) {
        DexValue[] values = new DexValue[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            values[i] = new DexValue.DexValueType(classes.get(i));
        }
        return DexAnnotation.createSystemValueAnnotation(MEMBER_CLASSES_DESCRIPTOR, factory, new DexValue.DexValueArray(values));
    }

    public static DexAnnotation createSourceDebugExtensionAnnotation(DexValue value, DexItemFactory factory) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.createType(SOURCE_DEBUG_EXTENSION), new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("value"), value)}));
    }

    public static DexAnnotation createMethodParametersAnnotation(DexValue[] names, DexValue[] accessFlags, DexItemFactory factory) {
        assert (names.length == accessFlags.length);
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.createType(METHOD_PARAMETERS_DESCRIPTOR), new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("names"), new DexValue.DexValueArray(names)), new DexAnnotationElement(factory.createString("accessFlags"), new DexValue.DexValueArray(accessFlags))}));
    }

    public static DexAnnotation createAnnotationDefaultAnnotation(DexType type, List<DexAnnotationElement> defaults, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(ANNOTATION_DEFAULT_DESCRIPTOR, factory, new DexValue.DexValueAnnotation(new DexEncodedAnnotation(type, defaults.toArray(new DexAnnotationElement[defaults.size()]))));
    }

    public static DexAnnotation createSignatureAnnotation(String signature, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(SIGNATURE_DESCRIPTOR, factory, DexAnnotation.compressSignature(signature, factory));
    }

    public static DexAnnotation createThrowsAnnotation(DexValue[] exceptions, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(THROWS_DESCRIPTOR, factory, new DexValue.DexValueArray(exceptions));
    }

    private static DexAnnotation createSystemValueAnnotation(String desc, DexItemFactory factory, DexValue value) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.createType(desc), new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("value"), value)}));
    }

    public static boolean isThrowingAnnotation(DexAnnotation annotation) {
        return annotation.annotation.type.toDescriptorString().equals(THROWS_DESCRIPTOR);
    }

    public static boolean isSignatureAnnotation(DexAnnotation annotation) {
        return annotation.annotation.type.toDescriptorString().equals(SIGNATURE_DESCRIPTOR);
    }

    public static boolean isSourceDebugExtension(DexAnnotation annotation) {
        return annotation.annotation.type.toDescriptorString().equals(SOURCE_DEBUG_EXTENSION);
    }

    private static DexValue compressSignature(String signature, DexItemFactory factory) {
        int length = signature.length();
        ArrayList<DexValue> parts = new ArrayList<DexValue>();
        int at = 0;
        while (at < length) {
            int endAt;
            char c = signature.charAt(at);
            if (c == 'L') {
                for (endAt = at + 1; endAt < length; ++endAt) {
                    c = signature.charAt(endAt);
                    if (c != ';' && c != '<') continue;
                    ++endAt;
                    break;
                }
            } else {
                while (endAt < length && (c = signature.charAt(endAt)) != 'L') {
                    ++endAt;
                }
            }
            parts.add(DexAnnotation.toDexValue(signature.substring(at, endAt), factory));
            at = endAt;
        }
        return new DexValue.DexValueArray(parts.toArray(new DexValue[parts.size()]));
    }

    private static DexValue toDexValue(String string, DexItemFactory factory) {
        return new DexValue.DexValueString(factory.createString(string));
    }
}

