/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexItem;
import java.util.Arrays;

public class DexAnnotationSet
extends DexItem {
    private static final int UNSORTED = 0;
    private static final DexAnnotationSet THE_EMPTY_ANNOTATIONS_SET = new DexAnnotationSet(new DexAnnotation[0]);
    public final DexAnnotation[] annotations;
    private int sorted = 0;

    public DexAnnotationSet(DexAnnotation[] annotations) {
        this.annotations = annotations;
    }

    public static DexAnnotationSet empty() {
        return THE_EMPTY_ANNOTATIONS_SET;
    }

    public int hashCode() {
        return Arrays.hashCode(this.annotations);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DexAnnotationSet) {
            DexAnnotationSet o = (DexAnnotationSet)other;
            return Arrays.equals(this.annotations, o.annotations);
        }
        return false;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        DexAnnotationSet.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.annotations);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
        DexAnnotationSet.collectAll((MixedSectionCollection)mixedItems, (DexItem[])this.annotations);
    }

    public boolean isEmpty() {
        return this.annotations.length == 0;
    }

    public void sort() {
        if (this.sorted != 0) {
            assert (this.sorted == this.sortedHashCode());
            return;
        }
        Arrays.sort(this.annotations, (a, b) -> a.annotation.type.compareTo(b.annotation.type));
        for (DexAnnotation annotation : this.annotations) {
            annotation.annotation.sort();
        }
        this.sorted = this.hashCode();
    }

    private int sortedHashCode() {
        int hashCode = this.hashCode();
        return hashCode == 0 ? 1 : hashCode;
    }
}

