/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.Resource;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import java.util.Arrays;

public class DexProgramClass
extends DexClass {
    private DexEncodedArray staticValues;

    public DexProgramClass(DexType type, Resource.Kind origin, DexAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, DexAnnotationSet classAnnotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods) {
        super(sourceFile, interfaces, accessFlags, superType, type, staticFields, instanceFields, directMethods, virtualMethods, classAnnotations, origin);
        assert (classAnnotations != null);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addClass(this)) {
            this.type.collectIndexedItems(indexedItems);
            if (this.superType != null) {
                this.superType.collectIndexedItems(indexedItems);
            } else assert (this.type.toDescriptorString().equals("Ljava/lang/Object;"));
            if (this.sourceFile != null) {
                this.sourceFile.collectIndexedItems(indexedItems);
            }
            if (this.annotations != null) {
                this.annotations.collectIndexedItems(indexedItems);
            }
            if (this.interfaces != null) {
                this.interfaces.collectIndexedItems(indexedItems);
            }
            DexProgramClass.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.staticFields);
            DexProgramClass.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.instanceFields);
            DexProgramClass.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.directMethods);
            DexProgramClass.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.virtualMethods);
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        if (this.hasAnnotations()) {
            mixedItems.setAnnotationsDirectoryForClass(this, new DexAnnotationDirectory(this));
        }
    }

    @Override
    public void addDependencies(MixedSectionCollection collector) {
        if (this.hasMethodsOrFields()) {
            collector.add(this);
            DexProgramClass.collectAll((MixedSectionCollection)collector, (DexItem[])this.directMethods);
            DexProgramClass.collectAll((MixedSectionCollection)collector, (DexItem[])this.virtualMethods);
            DexProgramClass.collectAll((MixedSectionCollection)collector, (DexItem[])this.staticFields);
            DexProgramClass.collectAll((MixedSectionCollection)collector, (DexItem[])this.instanceFields);
        }
        if (this.annotations != null) {
            this.annotations.collectMixedSectionItems(collector);
        }
        if (this.interfaces != null) {
            this.interfaces.collectMixedSectionItems(collector);
        }
        this.annotations.collectMixedSectionItems(collector);
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString();
    }

    @Override
    public boolean isProgramClass() {
        return true;
    }

    @Override
    public DexProgramClass asProgramClass() {
        return this;
    }

    public boolean hasMethodsOrFields() {
        int numberOfMethods;
        int numberOfFields = this.staticFields().length + this.instanceFields().length;
        return numberOfFields + (numberOfMethods = this.directMethods().length + this.virtualMethods().length) > 0;
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty() || this.hasAnnotations(this.virtualMethods) || this.hasAnnotations(this.directMethods) || this.hasAnnotations(this.staticFields) || this.hasAnnotations(this.instanceFields);
    }

    public boolean hasInternalizableAnnotation() {
        return !this.annotations.isEmpty() && !this.hasAnnotations(this.virtualMethods) && !this.hasAnnotations(this.directMethods) && !this.hasAnnotations(this.staticFields) && !this.hasAnnotations(this.instanceFields);
    }

    private boolean hasAnnotations(DexEncodedField[] fields) {
        return fields != null && Arrays.stream(fields).anyMatch(DexEncodedField::hasAnnotation);
    }

    private boolean hasAnnotations(DexEncodedMethod[] methods) {
        return methods != null && Arrays.stream(methods).anyMatch(DexEncodedMethod::hasAnnotation);
    }

    public void setStaticValues(DexEncodedArray staticValues) {
        this.staticValues = staticValues;
    }

    public DexEncodedArray getStaticValues() {
        return this.staticValues;
    }

    public void addVirtualMethod(DexEncodedMethod virtualMethod) {
        assert (!virtualMethod.accessFlags.isStatic());
        assert (!virtualMethod.accessFlags.isPrivate());
        assert (!virtualMethod.accessFlags.isConstructor());
        this.virtualMethods = Arrays.copyOf(this.virtualMethods, this.virtualMethods.length + 1);
        this.virtualMethods[this.virtualMethods.length - 1] = virtualMethod;
    }

    public void addStaticMethod(DexEncodedMethod staticMethod) {
        assert (staticMethod.accessFlags.isStatic());
        assert (!staticMethod.accessFlags.isPrivate());
        assert (!staticMethod.accessFlags.isConstructor());
        this.directMethods = Arrays.copyOf(this.directMethods, this.directMethods.length + 1);
        this.directMethods[this.directMethods.length - 1] = staticMethod;
    }
}

