/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import java.util.List;

abstract class FieldInstruction
extends Instruction {
    protected final MemberType type;
    protected final DexField field;

    protected FieldInstruction(MemberType type, DexField field, Value dest, Value object) {
        super(dest, object);
        assert (type != null);
        assert (field != null);
        this.type = type;
        this.field = field;
    }

    protected FieldInstruction(MemberType type, DexField field, Value dest, List<Value> values) {
        super(dest, values);
        assert (type != null);
        assert (field != null);
        this.type = type;
        this.field = field;
    }

    public MemberType getType() {
        return this.type;
    }

    public DexField getField() {
        return this.field;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfo info, DexType holder) {
        DexType fieldHolder = this.field.getHolder();
        DexEncodedField target = info.lookupInstanceTarget(fieldHolder, this.field);
        DexClass fieldClass = info.definitionFor(fieldHolder);
        if (target != null && fieldClass != null && !fieldClass.isLibraryClass()) {
            DexAccessFlags flags = target.accessFlags;
            if (flags.isPublic()) {
                return Inliner.Constraint.ALWAYS;
            }
            if (flags.isPrivate() && fieldHolder == holder) {
                return Inliner.Constraint.PRIVATE;
            }
            if (flags.isProtected() && fieldHolder.isSamePackage(holder)) {
                return Inliner.Constraint.PACKAGE;
            }
        }
        return Inliner.Constraint.NEVER;
    }
}

