/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Format22c;
import com.android.tools.r8.code.Iput;
import com.android.tools.r8.code.IputBoolean;
import com.android.tools.r8.code.IputByte;
import com.android.tools.r8.code.IputChar;
import com.android.tools.r8.code.IputObject;
import com.android.tools.r8.code.IputShort;
import com.android.tools.r8.code.IputWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.util.List;

public class InstancePut
extends FieldInstruction {
    public InstancePut(MemberType type, List<Value> values, DexField field) {
        super(type, field, null, values);
    }

    public Value value() {
        return (Value)this.inValues.get(0);
    }

    public Value object() {
        return (Value)this.inValues.get(1);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format22c instruction;
        int valueRegister = builder.allocatedRegister(this.value(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        switch (this.type) {
            case SINGLE: {
                instruction = new Iput(valueRegister, objectRegister, this.field);
                break;
            }
            case WIDE: {
                instruction = new IputWide(valueRegister, objectRegister, this.field);
                break;
            }
            case OBJECT: {
                instruction = new IputObject(valueRegister, objectRegister, this.field);
                break;
            }
            case BOOLEAN: {
                instruction = new IputBoolean(valueRegister, objectRegister, this.field);
                break;
            }
            case BYTE: {
                instruction = new IputByte(valueRegister, objectRegister, this.field);
                break;
            }
            case CHAR: {
                instruction = new IputChar(valueRegister, objectRegister, this.field);
                break;
            }
            case SHORT: {
                instruction = new IputShort(valueRegister, objectRegister, this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        InstancePut o = other.asInstancePut();
        return o.field == this.field && o.type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        InstancePut o = other.asInstancePut();
        int result = this.field.slowCompareTo(o.field);
        if (result != 0) {
            return result;
        }
        return this.type.ordinal() - o.type.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "InstancePut instructions define no values.";
        return 0;
    }

    @Override
    public boolean isInstancePut() {
        return true;
    }

    @Override
    public InstancePut asInstancePut() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.field.toSourceString();
    }
}

