/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.MoveType;

public enum MemberType {
    SINGLE,
    WIDE,
    OBJECT,
    BOOLEAN,
    BYTE,
    CHAR,
    SHORT;


    public static MoveType moveTypeFor(MemberType type) {
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case SINGLE: {
                return MoveType.SINGLE;
            }
            case WIDE: {
                return MoveType.WIDE;
            }
            case OBJECT: {
                return MoveType.OBJECT;
            }
        }
        return null;
    }

    public static MemberType fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'C': {
                return CHAR;
            }
            case 'F': 
            case 'I': {
                return SINGLE;
            }
            case 'D': 
            case 'J': {
                return WIDE;
            }
            case 'V': {
                throw new InternalCompilerError("No member type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static MemberType fromDexType(DexType type) {
        return MemberType.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }
}

