/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Format12x;
import com.android.tools.r8.code.NotInt;
import com.android.tools.r8.code.NotLong;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Unop;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;

public class Not
extends Unop {
    public final NumericType type;

    public Not(NumericType type, Value dest, Value source) {
        super(dest, source);
        this.type = type;
    }

    @Override
    public boolean canBeFolded() {
        return this.source().isConstant();
    }

    @Override
    public ConstInstruction fold(IRCode code) {
        assert (this.canBeFolded());
        if (this.type == NumericType.INT) {
            int result = ~this.source().getConstInstruction().asConstNumber().getIntValue();
            Value value = code.createValue(MoveType.SINGLE, this.getDebugInfo());
            return new ConstNumber(ConstType.INT, value, result);
        }
        assert (this.type == NumericType.LONG);
        long result = this.source().getConstInstruction().asConstNumber().getLongValue() ^ 0xFFFFFFFFFFFFFFFFL;
        Value value = code.createValue(MoveType.WIDE, this.getDebugInfo());
        return new ConstNumber(ConstType.LONG, value, result);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format12x instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int src = builder.allocatedRegister(this.source(), this.getNumber());
        switch (this.type) {
            case INT: {
                instruction = new NotInt(dest, src);
                break;
            }
            case LONG: {
                instruction = new NotLong(dest, src);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean identicalNonValueParts(Instruction other) {
        return other.asNot().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asNot().type.ordinal();
    }

    @Override
    public boolean isNot() {
        return true;
    }

    @Override
    public Not asNot() {
        return this;
    }
}

