/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.FixedRegisterValue;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LongInterval;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Value {
    public static final Value UNDEFINED = new Value(-1, MoveType.OBJECT, null);
    protected final int number;
    protected final MoveType type;
    public Instruction definition = null;
    private LinkedList<Instruction> users = new LinkedList();
    private Set<Instruction> uniqueUsers = null;
    private LinkedList<Phi> phiUsers = new LinkedList();
    private Set<Phi> uniquePhiUsers = null;
    private Value nextConsecutive = null;
    private Value previousConsecutive = null;
    private LiveIntervals liveIntervals;
    private int needsRegister = -1;
    private boolean neverNull = false;
    private boolean isThis = false;
    private boolean isArgument = false;
    private LongInterval valueRange;
    private final DebugData debugData;

    public Value(int number, MoveType type, DebugInfo debugInfo) {
        this.number = number;
        this.type = type;
        this.debugData = debugInfo == null ? null : new DebugData(debugInfo);
    }

    public boolean isFixedRegisterValue() {
        return false;
    }

    public FixedRegisterValue asFixedRegisterValue() {
        return null;
    }

    public int getNumber() {
        return this.number;
    }

    public int requiredRegisters() {
        return this.type.requiredRegisters();
    }

    public DebugInfo getDebugInfo() {
        return this.debugData == null ? null : new DebugInfo(this.debugData.local, this.debugData.previousLocalValue);
    }

    public DebugLocalInfo getLocalInfo() {
        return this.debugData == null ? null : this.debugData.local;
    }

    public Value getPreviousLocalValue() {
        return this.debugData == null ? null : this.debugData.previousLocalValue;
    }

    public void replacePreviousLocalValue(Value value) {
        this.debugData.previousLocalValue = value == null || value.isUninitializedLocal() ? null : value;
    }

    public List<Instruction> getDebugLocalStarts() {
        return this.debugData.localStarts;
    }

    public List<Instruction> getDebugLocalEnds() {
        return this.debugData.localEnds;
    }

    public void addDebugLocalStart(Instruction start) {
        assert (start != null);
        this.debugData.localStarts.add(start);
    }

    public void addDebugLocalEnd(Instruction end) {
        assert (end != null);
        this.debugData.localEnds.add(end);
    }

    public void linkTo(Value other) {
        assert (this.nextConsecutive == null || this.nextConsecutive == other);
        assert (other.previousConsecutive == null || other.previousConsecutive == this);
        other.previousConsecutive = this;
        this.nextConsecutive = other;
    }

    public void replaceLink(Value newArgument) {
        assert (this.isLinked());
        if (this.previousConsecutive != null) {
            this.previousConsecutive.nextConsecutive = newArgument;
            newArgument.previousConsecutive = this.previousConsecutive;
            this.previousConsecutive = null;
        }
        if (this.nextConsecutive != null) {
            this.nextConsecutive.previousConsecutive = newArgument;
            newArgument.nextConsecutive = this.nextConsecutive;
            this.nextConsecutive = null;
        }
    }

    public boolean isLinked() {
        return this.nextConsecutive != null || this.previousConsecutive != null;
    }

    public Value getStartOfConsecutive() {
        Value current = this;
        while (current.getPreviousConsecutive() != null) {
            current = current.getPreviousConsecutive();
        }
        return current;
    }

    public Value getNextConsecutive() {
        return this.nextConsecutive;
    }

    public Value getPreviousConsecutive() {
        return this.previousConsecutive;
    }

    public Set<Instruction> uniqueUsers() {
        if (this.uniqueUsers != null) {
            return this.uniqueUsers;
        }
        this.uniqueUsers = ImmutableSet.copyOf(this.users);
        return this.uniqueUsers;
    }

    public Set<Phi> uniquePhiUsers() {
        if (this.uniquePhiUsers != null) {
            return this.uniquePhiUsers;
        }
        this.uniquePhiUsers = ImmutableSet.copyOf(this.phiUsers);
        return this.uniquePhiUsers;
    }

    public Set<Instruction> debugUsers() {
        if (this.debugData == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.debugData.debugUsers);
    }

    public int numberOfUsers() {
        int size = this.users.size();
        if (size <= 1) {
            return size;
        }
        return this.uniqueUsers().size();
    }

    public int numberOfPhiUsers() {
        int size = this.phiUsers.size();
        if (size <= 1) {
            return size;
        }
        return this.uniquePhiUsers().size();
    }

    public int numberOfDebugUsers() {
        return this.debugData == null ? 0 : this.debugData.debugUsers.size();
    }

    public int numberOfAllUsers() {
        return this.numberOfUsers() + this.numberOfPhiUsers() + this.numberOfDebugUsers();
    }

    public void addUser(Instruction user) {
        this.users.add(user);
        this.uniqueUsers = null;
    }

    public void removeUser(Instruction user) {
        this.users.remove(user);
        this.uniqueUsers = null;
    }

    public void clearUsers() {
        this.users.clear();
        this.uniqueUsers = null;
        this.phiUsers.clear();
        this.uniquePhiUsers = null;
        if (this.debugData != null) {
            this.debugData.debugUsers.clear();
        }
    }

    public void addPhiUser(Phi user) {
        this.phiUsers.add(user);
        this.uniquePhiUsers = null;
    }

    public void removePhiUser(Phi user) {
        this.phiUsers.remove(user);
        this.uniquePhiUsers = null;
    }

    public void addDebugUser(Instruction user) {
        if (this.isUninitializedLocal()) {
            return;
        }
        this.debugData.debugUsers.add(user);
    }

    public boolean isUninitializedLocal() {
        return this.definition != null && this.definition.isDebugLocalUninitialized();
    }

    public boolean isInitializedLocal() {
        return !this.isUninitializedLocal();
    }

    public void removeDebugUser(Instruction user) {
        this.debugData.debugUsers.remove(user);
    }

    public boolean hasUsersInfo() {
        return this.users != null;
    }

    public void clearUsersInfo() {
        this.users = null;
        this.uniqueUsers = null;
        this.phiUsers = null;
        this.uniquePhiUsers = null;
        if (this.debugData != null) {
            this.debugData.debugUsers = null;
        }
    }

    public void replaceUsers(Value newValue) {
        if (this == newValue) {
            return;
        }
        for (Instruction instruction : this.uniqueUsers()) {
            instruction.inValues.replaceAll(v -> {
                if (v == this) {
                    newValue.addUser(instruction);
                    return newValue;
                }
                return v;
            });
        }
        for (Phi phi : this.uniquePhiUsers()) {
            phi.getOperands().replaceAll(v -> {
                if (v == this) {
                    newValue.addPhiUser(phi);
                    return newValue;
                }
                return v;
            });
        }
        if (this.debugData != null) {
            for (Instruction instruction : this.debugUsers()) {
                instruction.getDebugValues().replaceAll(v -> {
                    if (v == this) {
                        newValue.addDebugUser(instruction);
                        return newValue;
                    }
                    return v;
                });
                if (instruction.getPreviousLocalValue() != this) continue;
                newValue.addDebugUser(instruction);
                instruction.replacePreviousLocalValue(newValue);
            }
        }
        this.clearUsers();
    }

    public void setLiveIntervals(LiveIntervals intervals) {
        assert (this.liveIntervals == null);
        this.liveIntervals = intervals;
    }

    public LiveIntervals getLiveIntervals() {
        return this.liveIntervals;
    }

    public boolean needsRegister() {
        assert (this.needsRegister >= 0);
        assert (!this.hasUsersInfo() || this.needsRegister > 0 == this.internalComputeNeedsRegister());
        return this.needsRegister > 0;
    }

    public void setNeedsRegister(boolean value) {
        assert (this.needsRegister == -1 || this.needsRegister > 0 == value);
        this.needsRegister = value ? 1 : 0;
    }

    public void computeNeedsRegister() {
        assert (this.needsRegister < 0);
        this.setNeedsRegister(this.internalComputeNeedsRegister());
    }

    public boolean internalComputeNeedsRegister() {
        if (!this.isConstant()) {
            return true;
        }
        if (this.numberOfPhiUsers() > 0) {
            return true;
        }
        for (Instruction user : this.uniqueUsers()) {
            if (!user.needsValueInRegister(this)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRegisterConstraint() {
        for (Instruction instruction : this.uniqueUsers()) {
            if (instruction.maxInValueRegister() == 65535) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        boolean hasLocalInfo;
        StringBuilder builder = new StringBuilder();
        builder.append("v");
        builder.append(this.number);
        boolean isConstant = this.definition != null && this.definition.isConstNumber();
        boolean bl = hasLocalInfo = this.getLocalInfo() != null;
        if (isConstant || hasLocalInfo) {
            builder.append("(");
            if (isConstant) {
                ConstNumber constNumber = this.getConstInstruction().asConstNumber();
                if (constNumber.outType() == MoveType.SINGLE) {
                    builder.append((int)constNumber.getRawValue());
                } else {
                    builder.append(constNumber.getRawValue());
                }
            }
            if (isConstant && hasLocalInfo) {
                builder.append(", ");
            }
            if (hasLocalInfo) {
                builder.append(this.getLocalInfo());
            }
            builder.append(")");
        }
        if (this.valueRange != null) {
            builder.append(this.valueRange);
        }
        return builder.toString();
    }

    public MoveType outType() {
        return this.type;
    }

    public ConstInstruction getConstInstruction() {
        assert (this.isConstant());
        return this.definition.getOutConstantConstInstruction();
    }

    public boolean isConstant() {
        return this.definition.isOutConstant() && this.getLocalInfo() == null;
    }

    public boolean isPhi() {
        return false;
    }

    public Phi asPhi() {
        return null;
    }

    public void markNeverNull() {
        assert (!this.neverNull);
        this.neverNull = true;
    }

    public boolean isNeverNull() {
        return this.neverNull;
    }

    public boolean canBeNull() {
        return !this.neverNull;
    }

    public void markAsArgument() {
        assert (!this.isArgument);
        assert (!this.isThis);
        this.isArgument = true;
    }

    public boolean isArgument() {
        return this.isArgument;
    }

    public void markAsThis() {
        assert (this.isArgument);
        assert (!this.isThis);
        this.isThis = true;
        this.markNeverNull();
    }

    public boolean isThis() {
        return this.isThis;
    }

    public void setValueRange(LongInterval range) {
        this.valueRange = range;
    }

    public boolean hasValueRange() {
        return this.valueRange != null || this.isConstant();
    }

    public boolean isValueInRange(int value) {
        if (this.isConstant()) {
            return value == this.getConstInstruction().asConstNumber().getIntValue();
        }
        return this.valueRange != null && this.valueRange.containsValue(value);
    }

    public LongInterval getValueRange() {
        if (this.isConstant()) {
            if (this.type == MoveType.SINGLE) {
                int value = this.getConstInstruction().asConstNumber().getIntValue();
                return new LongInterval(value, value);
            }
            assert (this.type == MoveType.WIDE);
            long value = this.getConstInstruction().asConstNumber().getLongValue();
            return new LongInterval(value, value);
        }
        return this.valueRange;
    }

    public boolean isDead(InternalOptions options) {
        return this.numberOfAllUsers() == 0 || this.isDead(new HashSet<Value>(), options);
    }

    protected boolean isDead(Set<Value> active, InternalOptions options) {
        if (this.numberOfDebugUsers() != 0) {
            return false;
        }
        active.add(this);
        for (Instruction instruction : this.uniqueUsers()) {
            if (!instruction.canBeDeadCode(null, options)) {
                return false;
            }
            Value outValue = instruction.outValue();
            assert (outValue != null);
            if (active.contains(outValue) || outValue.isDead(active, options)) continue;
            return false;
        }
        for (Phi phi : this.uniquePhiUsers()) {
            if (active.contains(phi) || phi.isDead(active, options)) continue;
            return false;
        }
        return true;
    }

    private static class DebugData {
        final DebugLocalInfo local;
        Value previousLocalValue;
        Set<Instruction> debugUsers = new HashSet<Instruction>();
        List<Instruction> localStarts = new ArrayList<Instruction>();
        List<Instruction> localEnds = new ArrayList<Instruction>();

        DebugData(DebugInfo info) {
            this(info.local, info.previousLocalValue);
        }

        DebugData(DebugLocalInfo local, Value previousLocalValue) {
            assert (previousLocalValue == null || !previousLocalValue.isUninitializedLocal());
            this.local = local;
            this.previousLocalValue = previousLocalValue;
        }
    }

    public static class DebugInfo {
        private final DebugLocalInfo local;
        private final Value previousLocalValue;

        public DebugInfo(DebugLocalInfo local, Value previousLocalValue) {
            assert (local != null);
            this.local = local;
            this.previousLocalValue = previousLocalValue;
        }
    }
}

