/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.shaking.Enqueuer;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CallGraph {
    private final Map<DexEncodedMethod, Node> nodes = new LinkedHashMap<DexEncodedMethod, Node>();
    private final Map<DexEncodedMethod, Set<DexEncodedMethod>> breakers = new HashMap<DexEncodedMethod, Set<DexEncodedMethod>>();
    private List<Node> leaves = null;
    private Set<DexEncodedMethod> singleCallSite = Sets.newIdentityHashSet();
    private Set<DexEncodedMethod> doubleCallSite = Sets.newIdentityHashSet();

    public static CallGraph build(DexApplication application, AppInfoWithSubtyping appInfo, GraphLense graphLense) {
        CallGraph graph = new CallGraph();
        for (DexClass dexClass : application.classes()) {
            dexClass.forEachMethod(method -> {
                Node node = graph.ensureMethodNode((DexEncodedMethod)method);
                InvokeExtractor extractor = new InvokeExtractor(appInfo, graphLense, node, graph);
                method.registerReachableDefinitions(extractor);
            });
        }
        assert (CallGraph.allMethodsExists(application, graph));
        graph.fillCallSiteSets(appInfo);
        graph.fillInitialLeaves();
        return graph;
    }

    public boolean hasSingleCallSite(DexEncodedMethod method) {
        return this.singleCallSite.contains(method);
    }

    public boolean hasDoubleCallSite(DexEncodedMethod method) {
        return this.doubleCallSite.contains(method);
    }

    private void fillCallSiteSets(AppInfoWithSubtyping appInfo) {
        assert (this.singleCallSite.isEmpty());
        Enqueuer.AppInfoWithLiveness liveAppInfo = appInfo.withLiveness();
        if (liveAppInfo == null) {
            return;
        }
        for (Node value : this.nodes.values()) {
            if (appInfo.withLiveness().pinnedItems.contains(value.method)) continue;
            if (value.invokeCount == 1) {
                this.singleCallSite.add(value.method);
                continue;
            }
            if (value.invokeCount != 2) continue;
            this.doubleCallSite.add(value.method);
        }
    }

    private void fillInitialLeaves() {
        assert (this.leaves == null);
        this.leaves = new ArrayList<Node>();
        for (Node node : this.nodes.values()) {
            if (!node.isLeaf()) continue;
            this.leaves.add(node);
        }
    }

    private static boolean allMethodsExists(DexApplication application, CallGraph graph) {
        for (DexProgramClass clazz : application.classes()) {
            clazz.forEachMethod(method -> {
                assert (graph.nodes.get(method) != null);
            });
        }
        return true;
    }

    private List<DexEncodedMethod> removeLeaves() {
        ArrayList<DexEncodedMethod> result = new ArrayList<DexEncodedMethod>();
        ArrayList<Node> newLeaves = new ArrayList<Node>();
        for (Node leaf : this.leaves) {
            assert (this.nodes.containsKey(leaf.method) && this.nodes.get((Object)leaf.method).callees.isEmpty());
            this.remove(leaf, newLeaves);
            result.add(leaf.method);
        }
        this.leaves = newLeaves;
        return result;
    }

    public Leaves pickLeaves() {
        boolean cyclesBroken = false;
        Map<Object, Object> brokenCalls = Collections.emptyMap();
        if (this.isEmpty()) {
            return null;
        }
        List<DexEncodedMethod> leaves = this.removeLeaves();
        if (leaves.size() == 0) {
            brokenCalls = this.breakCycles();
            cyclesBroken = true;
            leaves = this.removeLeaves();
        }
        assert (leaves.size() > 0);
        for (DexEncodedMethod leaf : leaves) {
            assert (!leaf.isProcessed());
        }
        return new Leaves(leaves, cyclesBroken, brokenCalls);
    }

    private Map<DexEncodedMethod, Set<DexEncodedMethod>> breakCycles() {
        Set<DexEncodedMethod> calls;
        IdentityHashMap<DexEncodedMethod, Set<DexEncodedMethod>> brokenCalls = new IdentityHashMap<DexEncodedMethod, Set<DexEncodedMethod>>();
        int minDegree = this.nodes.size();
        for (Node node : this.nodes.values()) {
            if (!node.isBridge() && node.callDegree() <= 1) {
                assert (node.callDegree() == 1);
                calls = this.removeAllCalls(node);
                this.leaves.add(node);
                brokenCalls.put(node.method, calls);
                continue;
            }
            minDegree = Integer.min(minDegree, node.callDegree());
        }
        if (this.leaves.size() > 0) {
            return brokenCalls;
        }
        for (Node node : this.nodes.values()) {
            if (node.callDegree() > minDegree) continue;
            assert (node.callDegree() == minDegree);
            calls = this.removeAllCalls(node);
            this.leaves.add(node);
            brokenCalls.put(node.method, calls);
        }
        assert (this.leaves.size() > 0);
        return brokenCalls;
    }

    private synchronized Node ensureMethodNode(DexEncodedMethod method) {
        return this.nodes.computeIfAbsent(method, k -> new Node(method));
    }

    private synchronized void addCall(Node caller, Node callee) {
        assert (caller != null);
        assert (callee != null);
        if (caller != callee) {
            caller.addCallee(callee);
            callee.addCaller(caller);
        } else {
            caller.isSelfRecursive = true;
        }
        callee.invokeCount++;
    }

    private Set<DexEncodedMethod> removeAllCalls(Node node) {
        Set calls = Sets.newIdentityHashSet();
        for (Node call : node.callees) {
            calls.add(call.method);
            call.callers.remove(node);
        }
        node.callees.clear();
        return calls;
    }

    private void remove(Node node, List<Node> leaves) {
        assert (node != null);
        for (Node caller : node.callers) {
            boolean removed = caller.callees.remove(node);
            if (caller.isLeaf()) {
                leaves.add(caller);
            }
            assert (removed);
        }
        this.nodes.remove(node.method);
    }

    public boolean isEmpty() {
        return this.nodes.size() == 0;
    }

    public void dump() {
        this.nodes.forEach((m, n) -> System.out.println(n + "\n"));
    }

    private static class InvokeExtractor
    extends UseRegistry {
        AppInfoWithSubtyping appInfo;
        GraphLense graphLense;
        Node caller;
        CallGraph graph;

        InvokeExtractor(AppInfoWithSubtyping appInfo, GraphLense graphLense, Node caller, CallGraph graph) {
            this.appInfo = appInfo;
            this.graphLense = graphLense;
            this.caller = caller;
            this.graph = graph;
        }

        private void processInvoke(DexEncodedMethod source, Invoke.Type type, DexMethod method) {
            DexEncodedMethod definition = this.appInfo.lookup(type, method = this.graphLense.lookupMethod(method, source));
            if (definition != null) {
                assert (!source.accessFlags.isBridge() || definition != this.caller.method);
                DexType definitionHolder = definition.method.getHolder();
                assert (definitionHolder.isClassType());
                if (!this.appInfo.definitionFor(definitionHolder).isLibraryClass()) {
                    Node callee = this.graph.ensureMethodNode(definition);
                    this.graph.addCall(this.caller, callee);
                    if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
                        Set<DexEncodedMethod> possibleTargets = definitionHolder.isInterface() ? this.appInfo.lookupInterfaceTargets(definition.method) : this.appInfo.lookupVirtualTargets(definition.method);
                        for (DexEncodedMethod possibleTarget : possibleTargets) {
                            DexClass possibleTargetClass;
                            if (possibleTarget == definition || (possibleTargetClass = this.appInfo.definitionFor(possibleTarget.method.getHolder())) == null || possibleTargetClass.isLibraryClass()) continue;
                            callee = this.graph.ensureMethodNode(possibleTarget);
                            this.graph.addCall(this.caller, callee);
                        }
                    }
                }
            }
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            this.processInvoke(this.caller.method, Invoke.Type.VIRTUAL, method);
            return false;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            this.processInvoke(this.caller.method, Invoke.Type.DIRECT, method);
            return false;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            this.processInvoke(this.caller.method, Invoke.Type.STATIC, method);
            return false;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            this.processInvoke(this.caller.method, Invoke.Type.INTERFACE, method);
            return false;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            this.processInvoke(this.caller.method, Invoke.Type.SUPER, method);
            return false;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return false;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return false;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return false;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return false;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return false;
        }
    }

    public class Leaves {
        private final List<DexEncodedMethod> leaves;
        private final boolean brokeCycles;
        private final Map<DexEncodedMethod, Set<DexEncodedMethod>> cycleBreakingCalls;

        private Leaves(List<DexEncodedMethod> leaves, boolean brokeCycles, Map<DexEncodedMethod, Set<DexEncodedMethod>> cycleBreakingCalls) {
            this.leaves = leaves;
            this.brokeCycles = brokeCycles;
            this.cycleBreakingCalls = cycleBreakingCalls;
            assert (brokeCycles == (cycleBreakingCalls.size() != 0));
        }

        public int size() {
            return this.leaves.size();
        }

        public List<DexEncodedMethod> getLeaves() {
            return this.leaves;
        }

        public boolean hasBrokeCycles() {
            return this.brokeCycles;
        }

        public Map<DexEncodedMethod, Set<DexEncodedMethod>> getCycleBreakingCalls() {
            return this.cycleBreakingCalls;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Leaves: ");
            builder.append(this.leaves.size());
            builder.append("\n");
            builder.append(this.brokeCycles ? "Call cycles broken" : "No call cycles broken");
            return builder.toString();
        }
    }

    private class Node {
        public final DexEncodedMethod method;
        private int invokeCount = 0;
        private boolean isSelfRecursive = false;
        public final Set<Node> callees = new LinkedHashSet<Node>();
        public final Set<Node> callers = new LinkedHashSet<Node>();

        private Node(DexEncodedMethod method) {
            this.method = method;
        }

        public boolean isBridge() {
            return this.method.accessFlags.isBridge();
        }

        private void addCallee(Node method) {
            this.callees.add(method);
        }

        private void addCaller(Node method) {
            this.callers.add(method);
        }

        boolean isSelfRecursive() {
            return this.isSelfRecursive;
        }

        boolean isLeaf() {
            return this.callees.isEmpty();
        }

        int callDegree() {
            return this.callees.size();
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MethodNode for: ");
            builder.append(this.method.qualifiedName());
            builder.append(" (");
            builder.append(this.callees.size());
            builder.append(" callees, ");
            builder.append(this.callers.size());
            builder.append(" callers");
            if (this.isBridge()) {
                builder.append(", bridge");
            }
            if (this.isSelfRecursive()) {
                builder.append(", recursive");
            }
            builder.append(", invoke count " + this.invokeCount);
            builder.append(").\n");
            if (this.callees.size() > 0) {
                builder.append("Callees:\n");
                for (Node call : this.callees) {
                    builder.append("  ");
                    builder.append(call.method.qualifiedName());
                    builder.append("\n");
                }
            }
            if (this.callers.size() > 0) {
                builder.append("Callers:\n");
                for (Node caller : this.callers) {
                    builder.append("  ");
                    builder.append(caller.method.qualifiedName());
                    builder.append("\n");
                }
            }
            return builder.toString();
        }
    }
}

