/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.optimize.InvokeSingleTargetExtractor;
import java.util.IdentityHashMap;
import java.util.Map;

public class BridgeMethodAnalysis {
    private final GraphLense lense;
    private final AppInfoWithSubtyping appInfo;
    private final Map<DexMethod, DexMethod> bridgeTargetToBridgeMap = new IdentityHashMap<DexMethod, DexMethod>();

    public BridgeMethodAnalysis(GraphLense lense, AppInfoWithSubtyping appInfo) {
        this.lense = lense;
        this.appInfo = appInfo;
    }

    public GraphLense run() {
        for (DexClass dexClass : this.appInfo.classes()) {
            this.identifyBridgeMethods(dexClass.virtualMethods());
            this.identifyBridgeMethods(dexClass.directMethods());
        }
        return new BridgeLense(this.lense, this.bridgeTargetToBridgeMap);
    }

    private void identifyBridgeMethods(DexEncodedMethod[] dexEncodedMethods) {
        for (DexEncodedMethod method : dexEncodedMethods) {
            DexEncodedMethod targetMethod;
            if (!method.accessFlags.isBridge()) continue;
            InvokeSingleTargetExtractor targetExtractor = new InvokeSingleTargetExtractor();
            method.getCode().registerReachableDefinitions(targetExtractor);
            DexMethod target = targetExtractor.getTarget();
            InvokeSingleTargetExtractor.InvokeKind kind = targetExtractor.getKind();
            if (target == null || target.proto.parameters.values.length != method.method.proto.parameters.values.length) continue;
            assert (!method.accessFlags.isPrivate() && !method.accessFlags.isConstructor());
            target = this.lense.lookupMethod(target, method);
            if (kind == InvokeSingleTargetExtractor.InvokeKind.STATIC) {
                assert (method.accessFlags.isStatic());
                targetMethod = this.appInfo.lookupStaticTarget(target);
                if (targetMethod == null) continue;
                this.addForwarding(method, targetMethod);
                continue;
            }
            if (kind != InvokeSingleTargetExtractor.InvokeKind.VIRTUAL || (targetMethod = this.appInfo.lookupSingleVirtualTarget(target)) == null) continue;
            this.addForwarding(method, targetMethod);
        }
    }

    private void addForwarding(DexEncodedMethod method, DexEncodedMethod target) {
        this.bridgeTargetToBridgeMap.put(target.method, method.method);
        target.markForceInline();
    }

    private static class BridgeLense
    extends GraphLense {
        private final GraphLense previousLense;
        private final Map<DexMethod, DexMethod> bridgeTargetToBridgeMap;

        private BridgeLense(GraphLense previousLense, Map<DexMethod, DexMethod> bridgeTargetToBridgeMap) {
            this.previousLense = previousLense;
            this.bridgeTargetToBridgeMap = bridgeTargetToBridgeMap;
        }

        @Override
        public DexType lookupType(DexType type, DexEncodedMethod context) {
            return this.previousLense.lookupType(type, context);
        }

        @Override
        public DexMethod lookupMethod(DexMethod method, DexEncodedMethod context) {
            DexMethod previous = this.previousLense.lookupMethod(method, context);
            DexMethod target = this.bridgeTargetToBridgeMap.get(previous);
            if (target == null || context.accessFlags.isBridge() && target == context.method) {
                return previous;
            }
            return target;
        }

        @Override
        public DexField lookupField(DexField field, DexEncodedMethod context) {
            return this.previousLense.lookupField(field, context);
        }

        @Override
        public boolean isContextFree() {
            return false;
        }
    }
}

